

/*   Copyright (C) 1990 Riet Oolman

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


/* file: unification.h
   author: H. Oolman
   last changed: 13-7-1990
   purpose: functions for unification of two types
   modifications:
   updated for new version of type checker
   p2c translated, tmc access procs.
*/

/* t1 (tag UNKNOWN or SOME) should be changed to t2. This is done by
   indirection. Therefore care must be taken to let all occurrences of t1 with
   the same number have the same record. On inspecting
   a type, these INDIRs should always be skipped */
extern Void becomes PP((typcrec *t1, typcrec *t2));

/* see if typename n does not occur as a real subpart of type t (this is not
   allowed) */
extern boolean occurs PP((long n, typcrec *t));

/* change unknown parts of t1 and t2 (as little as possible) such that t2
   after that can be enlarged to t1 (t2<t1)
   val: expression that causes the compat to be done */
extern Void compat PP((typcrec *t1, typcrec *t2, val val));

/* change unknown parts of t1 and t2 (as little as possible) such that
   ti < upper (smallest upper bound)
   val: the expression that caused this to be called */
extern typcrec *upper PP((typcrec *t1, typcrec *t2, val val));

/* if mustendemp then ty must be a (tuple) type ending in the empty
   type; if mustconn ty may only be a type fit for connections. Error
   if conditions not fullfilled.
   UNKNOWNs in ty are restricted (in their mustendemp and mustconn fields)
   to the demands
   Result: can be restricted without errors
   val: the expression that caused this to be called */
extern boolean restrictable PP((int mustendemp, int mustconn, typcrec *ty,
				val val));

/* ty must be composed of a number of the same parts; the result
  is the smallest type larger than each part
  val: the expression that caused this to be called */
extern typcrec *uppercomps PP((typcrec *ty, val val));

