

/*   Copyright (C) 1990 Riet Oolman

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


/* file: errorenv.h
   author: H. Oolman
   last modified: 13-7-1990
   modifications: p2c translated, tmc access procs */

/* error messages (warning if iswarn), in which a name may occur are stored.
   erval: expression with the erroneous type
   They may become
   invalid yet, so are not yet printed. It is assumed that 'UNKNOWN' types
   for parts of expressions are not filled in !! (since these would have to be
   changed back to) */
extern Void error PP((long ernm, typcrec *tyfst, typcrec *tysnd,
		      symbol name, val erval, int iswarn));

/* for printing an origin without \n at the end: */
extern Void myprint_orig();

/* prints error messages concerning type errors
   unparsval: unparses valptr's; differs for full and kernel check
   errorlist: errors to be printed */
extern Void printerrors PP((_PROCEDURE unparsval, errorrec *errorlist));

/* replace name nm with extended name nm_ext */
extern Void addext PP((symbol nm, long ext));

/* test if the first elt. in env. is a marker */
#define ismark(e) ((e)->name0->length == 0)

/* mark point where piece of curenv added in front may be chopped off,
   by element with empty name (assumption: no normal name has length 0) */
extern Void mark_ PP((envrec **curenv));

/* remove leading part of curenv upto and including first marker. Check
   for unknown names first though, and if 'uniq' replace the name with its
   uniquely extended version */
extern Void release_ PP((envrec **curenv, int uniq));

/* name-type environment with nothing in it */
#define emptyenv NULL

/* add name n with type t in curenv;
   generate unique string (number) as extension;
*/
extern Void update PP((envrec **curenv, symbol n, typcrec *t));

/* deliver type associated with name s in curenv.
   s afterwards points at name in curenv, if found.
   s not present <=> lookup=nil */
extern typcrec *lookup PP((envrec *curenv, symbol *s));

/* is s in list slist? */
extern boolean isin PP((symbol s, symbol slist));

/* add s to the list slist */
extern Void addcopy PP((symbol s, symbol *slist));

/* s  is not allowed already to occur in slist, otherwise added */
extern Void addunequal PP((symbol s, symbol *slist));

