

/*   Copyright (C) 1990 Riet Oolman

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


/* file: check.ds.h
   author: H. Oolman
   last changed: 25-10-'90
   purpose: internal representation of Glass types
            data structure definitions for some types used internally in the
            type-checking algorithm
   modifications:
   updated by hand for new version of type-checker
   p2c translated, tmc access procs.
*/

typedef enum {
  kindSINGLEARROW, kindINT, kindFLOAT, kindBOOL, kindSTRING, kindSYSTY, kindEMPTYT, 
  kindLOC, kindBASETY, kindCT, kindALL, kindAPS, kindUNKNOWN, kindSOME, kindINDIR
} typckind;

typedef struct typcrec {
  typckind kind;
  union {
    struct { /* SINGLEARROW; for -> */
      struct typcrec *tcarg, *tcres;
    } U0;
    struct { /* SYSTY; for system types */
      struct dirgraphrec *sysdirs; /* directions */
      struct typcrec *syscomp; /* interface/input composition */
    } U5;
    struct { /* LOC; for local type var. */
      symbol locname;
      long inst; 
/* instance nr (needed if type namings are written out to distinguish type vars. */
    } U7;
    struct { /* BASETY; declared as basetype */
      symbol btname;
      long bnr; /* seq. nr. (because of locally decld. basetypes */
      orig bor; /* origin of declaration */
    } U8;
    struct { /* CT; for $ */
      struct typcrec *tcfirst, *tcrest;
    } U9;
    struct { /* for declared type with 0 or more type vars. */
      struct nminstrec *locs;
      struct typcrec *tcall;
    } U10;
    struct { /* UNKNOWN; for something arbitrary, may be replaced, 
		all instances point to same record for  overwriting */
      long unknm; /* to distinguish different arbitrary types */
      boolean mustendemp, /* true: for types allowed for b in a:b */
	      mustconn; /* true: for connection types */
    } U12;
    struct { /* SOME; for list types, may be replaced,
		all instances point to same record for  overwriting */
      struct typcrec *tcpart; /* composing type */
      long somnr; /* to distinguish different list types */
    } U13;
    struct typcrec *tcind; /* INDIR; for overwriting, always equivalent to
			      tcind type */
  } UU;
} typcrec;

#define SINGLEARROW UU.U0 
#define SYSTY UU.U5 
#define LOC UU.U7 
#define BASETY UU.U8 
#define CT UU.U9 
#define ALL UU.U10 
#define UNKNOWN UU.U12 
#define SOME UU.U13 
#define INDIR UU

typedef enum { kindCd, kindOd, kindSd } dirgraphkind;

typedef struct dirgraphrec {
  dirgraphkind kind;
  union {
    struct {
      struct dirgraphrec *dgfirst, *dgrest;
    } U0;
    struct dirrec *basedir;
    struct {
      struct dirgraphrec *dgpart, *dglast;
    } U2;
  } UU;
} dirgraphrec;

#define Cd UU.U0
#define Od UU
#define Sd UU.U2

typedef enum { kindINTO, kindOUT, kindNON } dirkind;

typedef struct dirrec {
  dirkind kind;
  union {
    int empty_union;   /* Pascal variant record was empty */
  } UU;
} dirrec;

typedef struct nminstrec {
  struct nminstrec *next;
  symbol nm;
  long inst;
} nminstrec;


typedef struct envrec {
  struct envrec *next;
  symbol name0;
  typcrec *typc0;
  long uniqext;
} envrec;

typedef struct errorrec {
  long erno;
  symbol nesting;
  /* function names (nested) in which this happens */
  orig orig;   /* origin of the nested name above */
  typcrec *tyf, *tys;
  symbol sym;   /* if a name wanted in error message */
  val errval;
  struct errorrec *next;
} errorrec;
