"vwin4th.st .. VWin4th load file.
  VWin4th is Copyright, 1993 by Jack J. Woehr
  All Rights Reserved.
  Jax, P.O. Box 51, Golden, CO 80402-0051
  jax@well.sf.ca.us
  JAX on GEnie
  72203.1320@compuserve.com
  SYSOP, RealTime Control & Forth Board (RCFB)
  (303) 278-0364
"!

"The Forth Dictionary"!
Smalltalk at: #FORTH put: Dictionary new.!

"An expedient, since many class definitions reference Task"!
Object
	subclass: #Task
	instanceVariableNames: 'dataStack returnStack instructionPointer dataSpace '
	classVariableNames: 'DataPointer '
	poolDictionaries: 'FORTH '   !

Smalltalk at: #Stack ifAbsent: [
(File pathName: 'jaxvwin\vwin4th\stack.cls') fileIn; close].!

Smalltalk at: #ForthPrimitive ifAbsent: [
(File pathName: 'jaxvwin\vwin4th\frthprmt.cls') fileIn; close].!

Smalltalk at: #Constant ifAbsent: [
(File pathName: 'jaxvwin\vwin4th\constant.cls') fileIn; close].!

Smalltalk at: #Variable ifAbsent: [
(File pathName: 'jaxvwin\vwin4th\variable.cls') fileIn; close].!

Smalltalk at: #CreateDoes ifAbsent: [
(File pathName: 'jaxvwin\vwin4th\createds.cls') fileIn; close].!

Smalltalk at: #ColonDefinition ifAbsent: [
(File pathName: 'jaxvwin\vwin4th\clndfntn.cls') fileIn; close].!

Smalltalk at: #ForthDataSpace ifAbsent: [
(File pathName: 'jaxvwin\vwin4th\frthdtsp.cls') fileIn; close].!

"An extra method for String to check for a legal Forth number"! 
!String methods !

isForthNumber
	"answer true if legal Forth number"
	" doesn't handle hex yet"
	| i |
	i := self size.
	i timesRepeat: [
		(((self at: i) isDigit) or: [
				((i = 1) and: [(self at: i) = $-]) or: [
					(self at: i) = $. ]])					
			ifFalse: [ ^false ].
			i := (i - 1)].
		^true.! !

Smalltalk at: #InputStream ifAbsent: [
(File pathName: 'jaxvwin\vwin4th\inptstrm.cls') fileIn; close].!

"Smalltalk at: #SearchOrder ifAbsent: [
(File pathName: 'jaxvwin\vwin4th\srchordr.cls') fileIn; close]."!

Smalltalk at: #Interpreter ifAbsent: [
(File pathName: 'jaxvwin\vwin4th\intrprtr.cls') fileIn; close].!

"Now time to file in the rest of Task"
(File pathName: 'jaxvwin\vwin4th\task.cls') fileIn; close.!

Task dataPointer: 1.!

Smalltalk at: #ForthMenuPolicy ifAbsent: [
(File pathName: 'jaxvwin\vwin4th\frthmnpl.cls') fileIn; close].!

Smalltalk at: #ForthPane ifAbsent: [
(File pathName: 'jaxvwin\vwin4th\forthpan.cls') fileIn; close].!

Smalltalk at: #ForthWindow ifAbsent: [
(File pathName: 'jaxvwin\vwin4th\frthwndw.cls') fileIn; close].!

" Begin to build system."!

"Set up a System variable"!
FORTH at: #STATE put: (Variable new).!

"Start compiling Forth primitives"!

FORTH at: #DROP put:
(ForthPrimitive new
    method: #forthDrop;
     immediacy: false).!

FORTH at: #DUP put:
(ForthPrimitive new
    method: #forthDup;
    immediacy: false).!

FORTH at: #OVER put:
(ForthPrimitive new
    method: #forthOver;
    immediacy: false).!

FORTH at: #ROT put:
(ForthPrimitive new
    method: #forthRot;
    immediacy: false).!

FORTH at: #SWAP put:
(ForthPrimitive new
    method: #forthSwap;
    immediacy: false).!

FORTH at: #PAUSE put:
(ForthPrimitive new
    method: #forthPause;
    immediacy: false).!
 
FORTH at: #HERE put:
(ForthPrimitive new
    method: #forthHere;
    immediacy: false).!

FORTH at: #DEPTH put:
(ForthPrimitive new
    method: #forthDepth;
    immediacy: false).!

FORTH at: #NOOP put:
(ForthPrimitive new
    method: #forthNoop;
    immediacy: false).!

FORTH at: #!! put:
(ForthPrimitive new
    method: #forthStore;
    immediacy: false).!

FORTH at: #@ put:
(ForthPrimitive new
    method: #forthFetch;
    immediacy: false).!

" C@ and C!! are the same as @ and !! respectively.
  Smalltalk doesn't like the syntax #C!! #C@ so we have to resort to circumlocution here."!

FORTH at: ('C!!' asSymbol) put:
(ForthPrimitive new
    method: #forthStore;
    immediacy: false).!

FORTH at: ('C@' asSymbol) put:
(ForthPrimitive new
    method: #forthFetch;
    immediacy: false).!

FORTH at: #EMIT put:
(ForthPrimitive new
    method: #forthEmit;
    immediacy: false).!

" Smalltalk doesn't like #. or #: #; so circumlocution here."!

FORTH at: ('.' asSymbol) put:
(ForthPrimitive new
    method: #forthDot;
    immediacy: false).!

FORTH at: (':' asSymbol) put:
(ForthPrimitive new
    method: #forthColon;
    immediacy: false).!

FORTH at: (';' asSymbol) put:
(ForthPrimitive new
    method: #forthSemiColon;
    immediacy: true).!

FORTH at: #CONSTANT put:
(ForthPrimitive new
    method: #forthConstant;
    immediacy: false).!

FORTH at: #VARIABLE put:
(ForthPrimitive new
    method: #forthVariable;
    immediacy: false).!

FORTH at: #CREATE put:
(ForthPrimitive new
    method: #forthCreate;
    immediacy: false).!


" Open a ForthWindow for fun."!

MyForthWindow := ForthWindow windowLabeled: 'Forth' frame: (100@100 extent: 200).!