CHEAD n_number_quest, 0
n_number_quest: move.l  D5,D0           ;( adr -- n #longs )
                addi.l  #obase,D0
                move.l  0(A3,D0.l),-(SP) ;save BASE
                move.l  (A6),-(SP)      ;save address
                moveq   #0,D1
                movea.l (A6)+,A0        ;address to a0
                adda.l  A3,A0           ;calculate abs. address
                movea.l A0,A1           ;copy for error handling
                addq.l  #1,A0           ;countbyte
                clr.l   -(A6)           ;0 on the stack
check_char:     addq.l  #4,A6           ;DROP
                moveq   #0,D0
                move.b  (A0)+,D0        ;fetch first character
                move.l  D0,-(A6)        ;push it on the stack
                move.l  D0,-(A6)        ;DUP
                bsr     digit_quest     ;a valid numbercharacter?
                tst.l   (A6)+           ;( char1 digit )/ ( char )
                beq.s   nnum1           ;no numeral? possible: -,$,&,.
                move.l  (A6)+,(A6)      ;( digit ) is accumulator
                move.l  A0,-(A6)        ;( akku adr )
                bra.s   do_conversion
nnum1:          cmpi.l  #'-',(A6)       ;is it negative
                bne.s   not_neg
                bset    #0,D1           ;set a flag
                bra.s   check_char
not_neg:        cmpi.l  #'$',(A6)       ;is it HEX
                bne.s   not_hex
                move.l  D5,D0
                addi.l  #obase,D0
                move.l  #16,0(A3,D0.l)  ;set BASE to hex
                bra.s   check_char
not_hex:        cmpi.l  #'&',(A6)       ;is it decimal
                bne.s   not_dec
                move.l  D5,D0
                addi.l  #obase,D0
                move.l  #10,0(A3,D0.l)  ;set BASE to decimal
                bra.s   check_char
not_dec:        cmpi.l  #'.',(A6)       ;is it a dot?
                bne.s   number_err      ;no?, then it isn't a number
                clr.l   (A6)
                move.l  A0,-(A6)        ;( akku adr )
                bra.s   do_conv_after_dot
number_err:     move.l  (SP)+,(A6)      ;restore address
                clr.l   -(A6)           ;FALSE
                bra     nnum_out
do_conversion:  move.l  D5,D0
                addi.l  #odpl,D0
                move.l  #-1,0(A3,D0.l)  ;clear DPL
                move.l  D1,-(SP)        ;save d1
                move.l  (A6),D0
                sub.l   A3,D0           ;make pointer rel. again
                move.l  D0,(A6)
                bsr     convert         ;do conversion
                move.l  (SP)+,D1
                movea.l (A6),A0         ;address of first not-numeral
                adda.l  A3,A0           ;make it absolut
                moveq   #0,D0
                move.b  (A0)+,D0        ;fetch not-numeral
                move.l  A0,(A6)         ;abs. address remains on stack
                tst.b   D0              ;end of string?
                beq.s   nnum3           ;then leave succuessfully
                cmp.b   #32,D0          ;is it a blank
                beq.s   nnum3           ;then, end of string, too
                cmp.b   #'.',D0         ;is it a dot?
                beq.s   do_conv_after_dot ;then there's something to do
                bra.s   nnum_err        ;otherwise error
nnum3:          move.l  #1,(A6)         ;it is ONE long
                btst    #0,D1           ;did we find a '-'?
                beq.s   nnum2
                neg.l   4(A6)           ;then negate the number
nnum2:          addq.l  #4,SP           ;drop saved address
                bra.s   nnum_out        ;and finish
nnum_err:       clr.l   (A6)            ;FALSE
                move.l  (SP)+,4(A6)     ;put back address
                bra.s   nnum_out        ;and finish
do_conv_after_dot:
                move.l  A0,-(SP)        ;remember actual address
                move.l  D1,-(SP)        ;save d1
                move.l  (A6),D0
                sub.l   A3,D0           ;make pointer rel. again
                move.l  D0,(A6)
                bsr     convert
                move.l  (A6),D0
                add.l   A3,D0           ;make pointer rel. again
                move.l  D0,(A6)
                move.l  (SP)+,D1        ;restore d1
                movea.l (SP)+,A1        ;addr of dot
                moveq   #0,D0
                movea.l (A6),A0         ;fetch actual address
                move.b  (A0),D0         ;fetch first character
                beq.s   nnum5           ;end of string
                cmp.b   #32,D0          ;when blank, too
                bne.s   nnum_err        ;otherwise error
nnum5:          suba.l  A1,A0           ;calculate position of dot
                move.l  D5,D0
                addi.l  #odpl,D0
                move.l  A0,0(A3,D0.l)   ;set DPL
                move.l  #1,(A6)         ;there was ONe long
                btst    #0,D1           ;did we find a '-'??
                beq.s   nnum4           ;no
                neg.l   4(A6)           ;negate
nnum4:          addq.l  #4,SP           ;drop saved address
nnum_out:       move.l  D5,D0
                addi.l  #obase,D0
                move.l  (SP)+,0(A3,D0.l) ;restore base
xn_number_quest: rts                     ;finish
