/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/Flag_.h"
#include "inc/RunSpc.h"
#include "inc/Status_.h"
#include "inc/Str.h"
#include "inc/TClass_.h"


boolean
Data_Exists(FilHdr)
   tp_FilHdr FilHdr;
{
   return (!FilHdr_Purged(FilHdr));
   }/*Data_Exists*/;


/*private*/ boolean
TransData_Exists(FilHdr)
   tp_FilHdr FilHdr;
{
   return (!FilHdr_TransPurged(FilHdr));
   }/*TransData_Exists*/;


Restore(SignalPtr, FilHdr, IsTrans)
   tp_Signal *SignalPtr;
   tp_FilHdr FilHdr;
   boolean IsTrans;
{
   tp_Status Status;

   FORBIDDEN(FilHdr == ERROR);
   FORBIDDEN(!IsUpToDate(FilHdr));
   *SignalPtr = NIL;
   if (IsSource(FilHdr) || IsStruct(FilHdr)) {
      return; }/*if*/;
   MakeNewest(FilHdr);
   Status = FilHdr_Status(FilHdr);
   /*select*/{
      if (IsAtmc(FilHdr)) {
	 if (Status >= STAT_Error && !Data_Exists(FilHdr)) {
	    Restore_FilHdr(SignalPtr, FilHdr); }/*if*/;
      }else{
	 if (Status > STAT_Error && IsTrans && !TransData_Exists(FilHdr)) {
	    Restore_Elms(SignalPtr, FilHdr); }/*if*/; };}/*select*/;
   }/*Restore*/;


Restore_FilHdr(SignalPtr, NeededFilHdr)
   tp_Signal *SignalPtr;
   tp_FilHdr NeededFilHdr;
{
   tps_FileName FileName;
   tp_FilHdr FilHdr;
   tp_Tool Tool;
   tps_RunSpc _RunSpc; tp_RunSpc RunSpc = &_RunSpc;
   tp_Status Status, DepStatus;
   tp_Date MaxSonModDate;

   FilHdr_DataFileName(FileName, NeededFilHdr);
   FORBIDDEN(Exists(FileName));

   FilHdr = Copy_FilHdr(NeededFilHdr);
   if (IsDrvDirElm(FilHdr)) FilHdr = FilHdr_BaseFilHdr(FilHdr);
   if (IsStructMem(FilHdr)) FilHdr = FilHdr_BaseFilHdr(FilHdr);

   switch (Tool_TClass(FilHdr_Tool(FilHdr))) {
      case TC_Browser: case TC_User: case TC_Hook: case TC_Compound:
      case TC_Cat: case TC_CopyCheck: case TC_Expand: case TC_CmdRef:
      case TC_ExpandHooks: {
	 Restore_Inps(SignalPtr, FilHdr); break;}/*case*/;
      default: {
	 *SignalPtr = NIL; };}/*switch*/;

   if (*SignalPtr != NIL) {
      Ret_FilHdr(FilHdr);
      return; }/*if*/;

   Tool = FilHdr_Tool(FilHdr);
   FilHdr_RunSpc(RunSpc, FilHdr);
   Status = FilHdr_Status(FilHdr);
   if (Status < STAT_OK) {
      GetInps(SignalPtr, &DepStatus, &MaxSonModDate, FilHdr);
      FORBIDDEN(*SignalPtr != NIL);
      Status = Get_ToolStatus(Tool, DepStatus); }/*if*/;
   /*select*/{
      if (IsSystem_Tool(Tool)) {
	 Exec(SignalPtr, RunSpc, Status, TRUE);
      }else{
	 Run(SignalPtr, RunSpc, Status, TRUE); };}/*select*/;
   Ret_RunSpc(RunSpc);
   Ret_FilHdr(FilHdr);
   }/*Restore_FilHdr*/;


Restore_Inps(SignalPtr, FilHdr)
   tp_Signal *SignalPtr;
   tp_FilHdr FilHdr;
{
   tp_LocInp LocInp;
   tp_FilInp FilInp;
   tp_InpKind InpKind;
   tp_FilHdr InpFilHdr;
   tp_Prms Prms;

   *SignalPtr = NIL;
   LocInp = FilHdr_LocInp(FilHdr);
   while (LocInp != 0) {
      FilInp = LocInp_FilInp(LocInp);
      InpFilHdr = FilInp_FilHdr(FilInp);
      InpKind = FilInp_InpKind(FilInp);
      if (!(InpKind_IsName(InpKind) || InpKind_IsPntr(InpKind))) {
	 Deref_Pntrs(&InpFilHdr, &Prms, InpFilHdr, FALSE); }/*if*/;
      FORBIDDEN(InpFilHdr == ERROR);
      if (NeedsData(InpFilHdr, InpKind)) {
	 Restore(SignalPtr, InpFilHdr, InpKind_IsTrans(InpKind)); }/*if*/;
      if (FilHdr_FilTyp(InpFilHdr) == CmdRefFilTyp) {
	 Make_CmdRef_ElmData(InpFilHdr); }/*if*/;
      Ret_FilHdr(InpFilHdr);
      LocInp = FilInp_Next(FilInp); Ret_FilInp(FilInp);
      if (*SignalPtr != NIL) {
	 return; }/*if*/; }/*while*/;
   }/*Restore_Inps*/;


Restore_Elms(SignalPtr, FilHdr)
   tp_Signal *SignalPtr;
   tp_FilHdr FilHdr;
{
   tp_LocElm LocElm, NextLocElm;
   tp_FilElm FilElm;
   tp_FilHdr ElmFilHdr;

   *SignalPtr = NIL;
   if (FilHdr_Flag(FilHdr, FLAG_Restore)) {
      return; }/*if*/;

   Set_Flag(FilHdr, FLAG_Restore);
   LocElm = FilHdr_LocElm(FilHdr);
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      FORBIDDEN(ElmFilHdr == ERROR);
      NextLocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm);
      Restore(SignalPtr, ElmFilHdr, TRUE);
      Ret_FilHdr(ElmFilHdr);
      if (*SignalPtr != NIL) {
	 goto done; }/*if*/;
      LocElm = NextLocElm; }/*while*/;
   Clear_TransPurged(FilHdr);
done:;
   Clr_Flag(FilHdr, FLAG_Restore);
   }/*Restore_Elms*/;


Make_CmdRef_ElmData(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_LocElm LocElm;
   tp_FilElm FilElm;
   tp_FilHdr ElmFilHdr;

   LocElm = FilHdr_LocElm(FilHdr);
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      Make_ElmData(ElmFilHdr);
      Ret_FilHdr(ElmFilHdr);
      LocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm); }/*while*/;
   }/*Make_CmdRef_ElmData*/;


Make_ElmData(FilHdr)
   tp_FilHdr FilHdr;
{
   tps_FileName FileName;
   tp_FilDsc FilDsc;

   FORBIDDEN(FilHdr_Status(FilHdr) <= STAT_Error);

   if (!IsRef(FilHdr) || Data_Exists(FilHdr)) {
      return; }/*if*/;

   FilHdr_DataFileName(FileName, FilHdr);
   FilDsc = FileName_WFilDsc(FileName);
   FORBIDDEN(FilDsc == ERROR);
   WriteFlat(FilDsc, FilHdr);
   Close(FilDsc);
   Clear_Purged(FilHdr);
   Set_Size(FilHdr, FileSize(FileName));
   MakeReadOnly(FileName);
   }/*Make_ElmData*/;


