/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include <stdio.h>
#include "inc/GMC.h"
#include "inc/Str.h"


tp_FilDsc	StdInFD;
tp_FilDsc	StdOutFD;
tp_FilDsc	StdErrFD;


Init_IO()
{
   StdInFD = (tp_FilDsc)stdin;
   StdOutFD = (tp_FilDsc)stdout;
   StdErrFD = (tp_FilDsc)stderr;
   }/*Init_IO*/;


boolean
GetIsTTY()
{
   return (isatty(0) == 1);
   }/*GetIsTTY*/;


tp_FilDsc
FileName_WFilDsc(FileName)
   tp_FileName FileName;
{
   FILE * FilDscFILE;

   if (FileName == ERROR) return ERROR;
   FilDscFILE = fopen(FileName, "w");
   if (FilDscFILE == NULL) {
      return ERROR; }/*if*/;
   return (tp_FilDsc)FilDscFILE;
   }/*FileName_WFilDsc*/;


tp_FilDsc
FileName_AFilDsc(FileName)
   tp_FileName FileName;
{
   FILE * FilDscFILE;

   if (FileName == ERROR) return ERROR;
   FilDscFILE = fopen(FileName, "a");
   if (FilDscFILE == NULL) {
      return ERROR; }/*if*/;
   return (tp_FilDsc)FilDscFILE;
   }/*FileName_AFilDsc*/;


tp_FilDsc
FileName_RFilDsc(FileName)
   tp_FileName FileName;
{
   FILE * FilDscFILE;

   if (FileName == ERROR) return ERROR;
   FilDscFILE = fopen(FileName, "r");
   if (FilDscFILE == NULL) {
      return ERROR; }/*if*/;
   return (tp_FilDsc)FilDscFILE;
   }/*FileName_RFilDsc*/;


tp_FilDsc
FileName_RWFilDsc(FileName)
   tp_FileName FileName;
{
   FILE * FilDscFILE;

   if (FileName == ERROR) return ERROR;
   /*select*/{
      if (Exists(FileName)) {
	 FilDscFILE = fopen(FileName, "r+");
      }else{
	 FilDscFILE = fopen(FileName, "w+"); };}/*select*/;
   if (FilDscFILE == NULL) {
      return ERROR; }/*if*/;
   return (tp_FilDsc)FilDscFILE;
   }/*FileName_RWFilDsc*/;


Flush(FilDsc)
   tp_FilDsc FilDsc;
{
   int status;

   status = fflush((FILE *)FilDsc);
   if (status == EOF) fatal_err("bad fflush call");
   }/*Flush*/;


Flush_StdIO()
{
   Flush(StdOutFD); Flush(StdErrFD);
   }/*Flush_StdIO*/;


Rewind(FilDsc)
   tp_FilDsc FilDsc;
{
   if (FilDsc == ERROR) fatal_err("bad arg to Rewind");
   rewind((FILE *)FilDsc);
   }/*Rewind*/;


Unwind(FilDsc)
   tp_FilDsc FilDsc;
{
   int status;

   if (FilDsc == ERROR) fatal_err("bad arg to Unwind");
   status = fseek((FILE *)FilDsc, (long)0, 2);
   if (status == -1) fatal_err("bad fseek call");
   }/*Unwind*/;


Close(FilDsc)
   tp_FilDsc FilDsc;
{
   int status;

   if (FilDsc == ERROR) fatal_err("bad arg to Close");
   status = fclose((FILE *)FilDsc);
   if (status == EOF) fatal_err("bad fclose");
   }/*Close*/;


boolean
EndOfFile(FilDsc)
   tp_FilDsc FilDsc;
{
   if (FilDsc == ERROR) fatal_err("bad FilDsc to EndOfFile");
   return feof((FILE *)FilDsc);
   }/*EndOfFile*/;


Write(FilDsc, Str)
   tp_FilDsc FilDsc;
   tp_Str Str;
{
   if (FilDsc == ERROR || Str == ERROR) fatal_err("bad arg to Write");
   fputs(Str, (FILE *)FilDsc);
   }/*Write*/;


Writech(FilDsc, ch)
   tp_FilDsc FilDsc;
   char ch;
{
   if (FilDsc == ERROR) fatal_err("bad arg to Writech");
   (void)putc(ch, (FILE *)FilDsc);
   }/*Writech*/;


WriteInt(FilDsc, Int)
   tp_FilDsc FilDsc;
   int Int;
{
   if (FilDsc == ERROR) fatal_err("bad arg to Write");
   (void)fprintf((FILE *)FilDsc, "%d", Int);
   }/*WriteInt*/;


Writeln(FilDsc, Str)
   tp_FilDsc FilDsc;
   tp_Str Str;
{
   if (FilDsc == ERROR || Str == ERROR) fatal_err("bad arg to Writeln");
   fputs(Str, (FILE *)FilDsc);
   fputs("\n", (FILE *)FilDsc);
   }/*Writeln*/;


int
Readch(FilDsc)
   tp_FilDsc FilDsc;
{
   return getc((FILE *)FilDsc);
   }/*Readch*/;


tp_Str
Readln(StrBuf, FilDsc)
   tp_Str StrBuf;
   tp_FilDsc FilDsc;
{
   tp_Str OutStr;

   if (FilDsc == ERROR) return ERROR;
   OutStr = fgets(StrBuf, MAX_Str, (FILE *)FilDsc);
   if (OutStr == NULL) {
      return ERROR; }/*if*/;
   StrBuf[strlen(StrBuf)-1] = 0;
   return StrBuf;
   }/*Readln*/;


tp_Str
ReadLine(StrBuf, FilDsc)
   tp_Str StrBuf;
   tp_FilDsc FilDsc;
{
   tp_Str OutStr;
   int Length;

   if (FilDsc == ERROR) return ERROR;
   OutStr = fgets(StrBuf, MAX_Str, (FILE *)FilDsc);
   if (OutStr == NULL) {
      return ERROR; }/*if*/;
   Length = strlen(StrBuf);
   while (Length > 1 && StrBuf[Length-2] == '\\') {
      OutStr = fgets(&StrBuf[Length], MAX_Str, (FILE *)FilDsc);
      if (OutStr == NULL) {
	 return ERROR; }/*if*/;
      Length = strlen(StrBuf); }/*while*/;
   StrBuf[strlen(StrBuf)-1] = 0;
   return StrBuf;
   }/*ReadLine*/;


tp_Str
BackReadLine(StrBuf, FilDsc)
   tp_Str StrBuf;
   tp_FilDsc FilDsc;
{
   tp_Str Str;
   FILE *stream;
   char Char, PrevChar;
   long offset;

   if (StrBuf==ERROR || FilDsc==ERROR) fatal_err("bad arg to BackReadLine");
   stream = (FILE *)FilDsc;
   offset = ftell(stream);
   if (offset == 0) {
      return ERROR; }/*if*/;
   offset -= 1;
   (void) fseek(stream, offset, 0);
   Char = (char)getc(stream);
   FORBIDDEN(Char != '\n');
   Char = 0;
   while (offset > 0 && Char != '\n') {
      offset -= 1;
      (void) fseek(stream, offset, 0);
      Char = (char)getc(stream);
      if (offset > 0 && Char == '\n') {
	 (void) fseek(stream, offset-1, 0);
	 PrevChar = (char)getc(stream);
	 if (PrevChar == '\\') {
	    Char = PrevChar;
	    offset -= 1; }/*if*/; }/*if*/; }/*while*/;
   if (Char == '\n') offset += 1;
   (void) fseek(stream, offset, 0);
   Str = ReadLine(StrBuf, FilDsc);
   FORBIDDEN(Str == ERROR);
   (void) fseek(stream, offset, 0);
   return Str;
   }/*BackReadLine*/;


Equal(FilDsc1, FilDsc2)
   tp_FilDsc FilDsc1, FilDsc2;
{
   int ichar1, ichar2;

   if (FilDsc1 == ERROR || FilDsc2 == ERROR) fatal_err("bad args to Equal");
   ichar1 = getc((FILE *)FilDsc1);
   ichar2 = getc((FILE *)FilDsc2);
   while (ichar1 == ichar2 && ichar1 != EOF) {
      ichar1 = getc((FILE *)FilDsc1);
      ichar2 = getc((FILE *)FilDsc2); }/*while*/;
   return (ichar1 == ichar2);
   }/*Equal*/;


FileCopy(OutFD, InFD)
   tp_FilDsc OutFD, InFD;
{
   int ichar;

   if (OutFD == ERROR || InFD == ERROR) fatal_err("bad args to FileCopy");
   ichar = getc((FILE *)InFD);
   while (ichar != EOF) {
      (void)fputc((char)ichar, (FILE *)OutFD);
      ichar = getc((FILE *)InFD); }/*while*/;
   }/*FileCopy*/;
