
/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include <stdio.h>
#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/ElmInf.h"
#include "inc/FilHdr.h"
#include "inc/HdrInf.h"
#include "inc/Parm.h"
#include "inc/InpInf.h"
#include "inc/Signal_.h"
#include "inc/Str.h"


tp_FilDsc	InfoFD;
boolean		Locked = FALSE;

tp_Loc		LocLockDate;
tp_Loc		LocDataNum;
tp_Loc		LocUseCount;
tp_Loc		LocCurrentDate;
tp_Loc		LocMaxSize;
tp_Loc		LocHogSize;
tp_Loc		LocCurSize;
tp_Loc		LocFreeLocElm;
tp_Loc		LocLastLoc;

tp_Date		LockDate;

int		DataNum;
int		OldDataNum;

boolean		InUse = FALSE;
int		UseCount;
int		OldUseCount;

tp_Date		CurrentDate;
tp_Date		OldCurrentDate;

int		MaxSize;
int		OldMaxSize;
int		HogSize;
int		OldHogSize;
int		CurSize;
int		OldCurSize;

tp_LocElm	FreeLocElm;
tp_LocElm	OldFreeLocElm;

tp_Loc		LastLoc = 0;
tp_Loc		OldLastLoc = 0;

tp_LocHdr	RootLocHdr;
tp_LocHdr	HogLocHdr;

tp_LocStr	LocNilStr = 1;


Validate_InfoRead()
{
   FORBIDDEN(!Locked);
   Flush(InfoFD);
   }/*Validate_InfoRead*/;


WriteWord(Word, Loc)
   int Word;
   tp_Loc Loc;
{
   int status, count;

   status = fseek((FILE *)InfoFD, Loc, 0);
   FORBIDDEN(status == -1);
   count = fwrite((char *)&Word, sizeof(Word), 1, (FILE *)InfoFD);
   FORBIDDEN(count != 1);
   }/*WriteWord*/;


/*private*/ int
ReadWord(Loc)
   tp_Loc Loc;
{
   int status, count;
   int Word;

   Validate_InfoRead();
   status = fseek((FILE *)InfoFD, Loc, 0);
   FORBIDDEN(status == -1);
   count = fread((char *)&Word, sizeof(Word), 1, (FILE *)InfoFD);
   FORBIDDEN(count != 1);
   return Word;
   }/*ReadWord*/;


WriteLockDate(Date)
   tp_Date Date;
{
   FORBIDDEN(Date == ERROR);
   WriteWord((int)Date, LocLockDate);
   }/*WriteLockDate*/;


/*private*/ tp_Date
ReadLockDate()
{
   return (tp_Date)ReadWord(LocLockDate);
   }/*ReadLockDate*/;


WriteDataNum(Num)
   int Num;
{
   WriteWord((int)Num, LocDataNum);
   }/*WriteDataNum*/;


/*private*/ int
ReadDataNum()
{
   return (int)ReadWord(LocDataNum);
   }/*ReadDataNum*/;


WriteUseCount(Count)
   int Count;
{
   WriteWord((int)Count, LocUseCount);
   }/*WriteUseCount*/;


/*private*/ int
ReadUseCount()
{
   return (int)ReadWord(LocUseCount);
   }/*ReadUseCount*/;


WriteCurrentDate(Date)
   tp_Date Date;
{
   FORBIDDEN(Date == ERROR);
   WriteWord((int)Date, LocCurrentDate);
   }/*WriteCurrentDate*/;


/*private*/ tp_Date
ReadCurrentDate()
{
   return (tp_Date)ReadWord(LocCurrentDate);
   }/*ReadCurrentDate*/;


WriteMaxSize(MaxSize)
   int MaxSize;
{
   WriteWord((int)MaxSize, LocMaxSize);
   }/*WriteMaxSize*/;


/*private*/ int
ReadMaxSize()
{
   return (int)ReadWord(LocMaxSize);
   }/*ReadMaxSize*/;


WriteHogSize(HogSize)
   int HogSize;
{
   WriteWord((int)HogSize, LocHogSize);
   }/*WriteHogSize*/;


/*private*/ int
ReadHogSize()
{
   return (int)ReadWord(LocHogSize);
   }/*ReadHogSize*/;


WriteCurSize(CurSize)
   int CurSize;
{
   WriteWord((int)CurSize, LocCurSize);
   }/*WriteCurSize*/;


/*private*/ int
ReadCurSize()
{
   return (int)ReadWord(LocCurSize);
   }/*ReadCurSize*/;


WriteFreeLocElm(FreeLocElm)
   tp_LocElm FreeLocElm;
{
   WriteWord((int)FreeLocElm, LocFreeLocElm);
   }/*WriteFreeLocElm*/;


/*private*/ tp_LocElm
ReadFreeLocElm()
{
   return (tp_LocElm)ReadWord(LocFreeLocElm);
   }/*ReadFreeLocElm*/;


WriteLastLoc(LastLoc)
   tp_Loc LastLoc;
{
   WriteWord((int)LastLoc, LocLastLoc);
   }/*WriteLastLoc*/;


/*private*/ tp_Loc
ReadLastLoc()
{
   return (tp_Loc)ReadWord(LocLastLoc);
   }/*ReadLastLoc*/;


tp_Loc
Alloc(Size)
   int Size;
{
   tp_Loc Loc;

   FORBIDDEN(LastLoc == 0);
   Loc = LastLoc;
   LastLoc += Size;
   return Loc;
   }/*Alloc*/;


tp_LocStr
WriteStr(Str)
   tp_Str Str;
{
   tp_LocStr LocStr;
   int Length, status, count;

   if (Str == NIL) {
      return LocNilStr; }/*if*/;
   Length = strlen(Str);
   LocStr = (tp_LocStr)Alloc(sizeof(Length) + Length*sizeof(char));
   status = fseek((FILE *)InfoFD, LocStr, 0);
   FORBIDDEN(status == -1);
   count = fwrite((char *)&Length, sizeof(Length), 1, (FILE *)InfoFD);
   FORBIDDEN(count != 1);
   if (Length > 0) {
      count = fwrite(Str, sizeof(char), Length, (FILE *)InfoFD);
      FORBIDDEN(count != Length); }/*if*/;
   return LocStr;
   }/*WriteStr*/;


tp_Str
ReadStr(LocStr)
   tp_LocStr LocStr;
{
   int status, count, Length;
   tps_Str Str;

   if (LocStr == LocNilStr) {
      return NIL; }/*if*/;
   Validate_InfoRead();
   status = fseek((FILE *)InfoFD, LocStr, 0);
   FORBIDDEN(status == -1);
   count = fread((char *)&Length, sizeof(Length), 1, (FILE *)InfoFD);
   FORBIDDEN(count != 1);
   FORBIDDEN(Length > MAX_Str);
   if (Length > 0) {
      count = fread(Str, sizeof(char), Length, (FILE *)InfoFD);
      FORBIDDEN(count != Length); }/*if*/;
   Str[Length] = 0;
   return Sym_Str(Str_Sym(Str));
   }/*ReadStr*/;
      
   
WritePrmInf(PrmInf, LocPrm)
   tp_PrmInf PrmInf;
   tp_LocPrm LocPrm;
{
   int status, count;

   FORBIDDEN(PrmInf == ERROR || LocPrm == ERROR);
   status = fseek((FILE *)InfoFD, LocPrm, 0);
   FORBIDDEN(status == -1);
   count = fwrite((char *)PrmInf, sizeof(*PrmInf), 1, (FILE *)InfoFD);
   FORBIDDEN(count != 1);
   }/*WritePrmInf*/;


ReadPrmInf(PrmInf, LocPrm)
   tp_PrmInf PrmInf;
   tp_LocPrm LocPrm;
{
   int status, count;

   FORBIDDEN(LocPrm == ERROR);
   Validate_InfoRead();
   status = fseek((FILE *)InfoFD, LocPrm, 0);
   FORBIDDEN(status == -1);
   count = fread((char *)PrmInf, sizeof(*PrmInf), 1, (FILE *)InfoFD);
   FORBIDDEN(count != 1);
   }/*ReadPrmInf*/;


WriteHdrInf(HdrInf, LocHdr)
   tp_HdrInf HdrInf;
   tp_LocHdr LocHdr;
{
   int status, count;

   FORBIDDEN(HdrInf == ERROR || LocHdr == ERROR);
   FORBIDDEN(HdrInf->LocHdr != LocHdr);
   status = fseek((FILE *)InfoFD, LocHdr, 0);
   FORBIDDEN(status == -1);
   count = fwrite((char *)HdrInf, sizeof(*HdrInf), 1, (FILE *)InfoFD);
   FORBIDDEN(count != 1);
   }/*WriteHdrInf*/;


ReadHdrInf(HdrInf, LocHdr)
   tp_HdrInf HdrInf;
   tp_LocHdr LocHdr;
{
   int status, count;

   FORBIDDEN(HdrInf == ERROR || LocHdr == ERROR);
   Validate_InfoRead();
   status = fseek((FILE *)InfoFD, LocHdr, 0);
   FORBIDDEN(status == -1);
   count = fread((char *)HdrInf, sizeof(*HdrInf), 1, (FILE *)InfoFD);
   FORBIDDEN(count != 1);
   FORBIDDEN(HdrInf->LocHdr != LocHdr);
   }/*ReadHdrInf*/;


WriteInpInf(InpInf, LocInp)
   tp_InpInf InpInf;
   tp_LocInp LocInp;
{
   int status, count;

   FORBIDDEN(InpInf == ERROR || LocInp == ERROR);
   status = fseek((FILE *)InfoFD, LocInp, 0);
   FORBIDDEN(status == -1);
   count = fwrite((char *)InpInf, sizeof(*InpInf), 1, (FILE *)InfoFD);
   FORBIDDEN(count != 1);
   }/*WriteInpInf*/;


ReadInpInf(InpInf, LocInp)
   tp_InpInf InpInf;
   tp_LocInp LocInp;
{
   int status, count;

   FORBIDDEN(InpInf == ERROR || LocInp == ERROR);
   Validate_InfoRead();
   status = fseek((FILE *)InfoFD, LocInp, 0);
   FORBIDDEN(status == -1);
   count = fread((char *)InpInf, sizeof(*InpInf), 1, (FILE *)InfoFD);
   FORBIDDEN(count != 1);
   }/*ReadInpInf*/;


WriteElmInf(ElmInf, LocElm)
   tp_ElmInf ElmInf;
   tp_LocElm LocElm;
{
   int status, count;

   FORBIDDEN(ElmInf == ERROR || LocElm == ERROR);
   status = fseek((FILE *)InfoFD, LocElm, 0);
   FORBIDDEN(status == -1);
   count = fwrite((char *)ElmInf, sizeof(*ElmInf), 1, (FILE *)InfoFD);
   FORBIDDEN(count != 1);
   }/*WriteElmInf*/;


ReadElmInf(ElmInf, LocElm)
   tp_ElmInf ElmInf;
   tp_LocElm LocElm;
{
   int status, count;

   FORBIDDEN(ElmInf == ERROR || LocElm == ERROR);
   Validate_InfoRead();
   status = fseek((FILE *)InfoFD, LocElm, 0);
   FORBIDDEN(status == -1);
   count = fread((char *)ElmInf, sizeof(*ElmInf), 1, (FILE *)InfoFD);
   FORBIDDEN(count != 1);
   }/*ReadElmInf*/;


Init_Info()
{
   tps_FileName InfoFileName;
   tp_Loc Initial_LastLoc;
   tps_HdrInf _NewRootHdrInf; tp_HdrInf NewRootHdrInf = &_NewRootHdrInf;
   tp_Signal Signal;

   Get_InfoFileName(InfoFileName);

   LocLockDate = 0;
   LocDataNum = LocLockDate + sizeof(LocLockDate);
   LocUseCount = LocDataNum + sizeof(LocDataNum);
   LocCurrentDate = LocUseCount + sizeof(LocUseCount);
   LocMaxSize = LocCurrentDate + sizeof(LocCurrentDate);
   LocHogSize = LocMaxSize + sizeof(LocMaxSize);
   LocCurSize = LocHogSize + sizeof(LocHogSize);
   LocFreeLocElm = LocCurSize + sizeof(LocCurSize);
   LocLastLoc = LocFreeLocElm + sizeof(LocFreeLocElm);
   RootLocHdr = LocLastLoc + sizeof(LocLastLoc);
   HogLocHdr = RootLocHdr + sizeof(tps_HdrInf);
   Initial_LastLoc = HogLocHdr + sizeof(tps_HdrInf);

   if (!Exists(InfoFileName) || Empty(InfoFileName)) {
      InfoFD = FileName_WFilDsc(InfoFileName);

      FORBIDDEN(sizeof(tp_Date) != sizeof(int));
      WriteLockDate((tp_Date)1);

      WriteUseCount(0);

      WriteDataNum(0);

      FORBIDDEN(sizeof(tp_Date) != sizeof(int));
      WriteCurrentDate((tp_Date)1);

      WriteMaxSize((int)5000000);
      WriteHogSize((int)100000);

      FORBIDDEN(sizeof(int) != sizeof(int));
      WriteCurSize(0);

      FORBIDDEN(sizeof(tp_LocElm) != sizeof(int));
      WriteFreeLocElm((tp_LocElm)0);

      FORBIDDEN(sizeof(tp_Loc) != sizeof(int));

      WriteLastLoc(Initial_LastLoc);

      Init_HdrInf(NewRootHdrInf);
      Make_RootHdrInf(NewRootHdrInf, RootLocHdr);
      WriteHdrInf(NewRootHdrInf, RootLocHdr);
      Make_RootHdrInf(NewRootHdrInf, HogLocHdr);
      WriteHdrInf(NewRootHdrInf, HogLocHdr);

      Close(InfoFD); }/*if*/;

   InfoFD = FileName_RWFilDsc(InfoFileName);
   Lock_Info(&Signal);
   Set_InfoInUse();
   }/*Init_Info*/;


Close_Info()
{
   tp_Signal Signal;

   Clear_InfoInUse();
   Unlock_Info(&Signal);
   while (Signal != NIL) Unlock_Info(&Signal);
   Close(InfoFD);
   }/*Close_Info*/;


Lock_Info(SignalPtr)
   tp_Signal *SignalPtr;
{
   tp_Date NewLockDate;
   boolean Succeed;

   FORBIDDEN(Locked);
   TryLock(&Succeed, InfoFD);
   if (!Succeed) {
      if (LogLevel >= 2) {
	 Writeln(LogFD, "Odin database is currently in use - waiting ...");
	 }/*if*/;
      Lock(InfoFD); }/*if*/;
   Locked = TRUE;
   NewLockDate = ReadLockDate();
   if (NewLockDate != LockDate) {
      if (LogLevel >= 2 && LockDate != 0) {
	 Writeln(LogFD, "Odin database modified - restoring cache"); }/*if*/;
      LockDate = NewLockDate;
      DataNum = OldDataNum = ReadDataNum();
      UseCount = OldUseCount = ReadUseCount();
      CurrentDate = OldCurrentDate = ReadCurrentDate();
      MaxSize = OldMaxSize = ReadMaxSize();
      HogSize = OldHogSize = ReadHogSize();
      CurSize = OldCurSize = ReadCurSize();
      FreeLocElm = OldFreeLocElm = ReadFreeLocElm();
      LastLoc = OldLastLoc = ReadLastLoc();
      Update_FilHdrs();
      Update_FilElms();
      Update_FilInps(); }/*if*/;
   if (Signalled) Do_Sig();
   if (Interrupted) {
      *SignalPtr = SIGNAL_Interrupt;
      Interrupted = FALSE; }/*if*/;
   }/*Lock_Info*/;


Unlock_Info(SignalPtr)
   tp_Signal *SignalPtr;
{
   FORBIDDEN(!Locked);
   *SignalPtr = NIL;
   if (Signalled) Do_Sig();
   if (Interrupted) {
      *SignalPtr = SIGNAL_Interrupt;
      Interrupted = FALSE;
      return; }/*if*/;

   LockDate += 1;
   WriteLockDate(LockDate);

   if (DataNum != OldDataNum) {
      WriteDataNum(DataNum);
      OldDataNum = DataNum; }/*if*/;
   if (UseCount != OldUseCount) {
      WriteUseCount(UseCount);
      OldUseCount = UseCount; }/*if*/;
   if (CurrentDate != OldCurrentDate) {
      WriteCurrentDate(CurrentDate);
      OldCurrentDate = CurrentDate; }/*if*/;
   if (MaxSize != OldMaxSize) {
      WriteMaxSize(MaxSize);
      OldMaxSize = MaxSize; }/*if*/;
   if (HogSize != OldHogSize) {
      WriteHogSize(HogSize);
      OldHogSize = HogSize; }/*if*/;
   if (CurSize != OldCurSize) {
      WriteCurSize(CurSize);
      OldCurSize = CurSize; }/*if*/;
   if (FreeLocElm != OldFreeLocElm) {
      WriteFreeLocElm(FreeLocElm);
      OldFreeLocElm = FreeLocElm; }/*if*/;
   if (LastLoc != OldLastLoc) {
      WriteLastLoc(LastLoc);
      OldLastLoc = LastLoc; }/*if*/;
   if (ModFilHdr) WriteFilHdrs();
   if (ModFilElm) WriteFilElms();
   if (ModFilInp) WriteFilInps();
   Unlock(InfoFD);
   Locked = FALSE;
   }/*Unlock_Info*/;


Set_InfoInUse()
{
   FORBIDDEN(InUse);
   InUse = TRUE;
   UseCount += 1;
   }/*Set_InfoInUse*/;


Clear_InfoInUse()
{
   FORBIDDEN(!InUse);
   InUse = FALSE;
   UseCount -= 1;
   Free_FilHdrs();
   Free_FilInps();
   Free_FilElms();
   }/*Clear_InfoInUse*/;


boolean
OtherInfoUsers()
{
   FORBIDDEN(UseCount == 0);
   return (UseCount > 1);
   }/*OtherInfoUsers*/;


