/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/FilTyp.h"
#include "inc/FTClass_.h"
#include "inc/TClass_.h"


tp_FTClass
FilTyp_FTClass(FilTyp)
   tp_FilTyp FilTyp;
{
   if (FilTyp == ERROR) return ERROR;
   return FilTyp->FTClass;
   }/*FilTyp_FTClass*/;


tp_FTName
FilTyp_FTName(FilTyp)
   tp_FilTyp FilTyp;
{
   if (FilTyp == ERROR) return ERROR;
   return FilTyp->FTName;
   }/*FilTyp_FTName*/;


tp_MemEdg
FilTyp_MemEdg(FilTyp)
   tp_FilTyp FilTyp;
{
   FORBIDDEN(FilTyp == 0);
   return FilTyp->MemEdg;
   }/*FilTyp_MemEdg*/;


tp_CastEdg
FilTyp_CastEdg(FilTyp)
   tp_FilTyp FilTyp;
{
   FORBIDDEN(FilTyp == ERROR);
   return FilTyp->CastEdg;
   }/*FilTyp_CastEdg*/;


tp_PrmFTLst
FilTyp_ImHoPrmFTLst(FilTyp)
   tp_FilTyp FilTyp;
{
   FORBIDDEN(FilTyp == ERROR);
   return FilTyp->ImHoPrmFTLst;
   }/*FilTyp_ImHoPrmFTLst*/;


tp_Tool
FilTyp_Tool(FilTyp)
   tp_FilTyp FilTyp;
{
   if (FilTyp == ERROR) return ERROR;
   FORBIDDEN(FilTyp->Tool == 0);
   return FilTyp->Tool;
   }/*FilTyp_Tool*/;


boolean
IsAtmc_FilTyp(FilTyp)
   tp_FilTyp FilTyp;
{
   FORBIDDEN(FilTyp == ERROR);
   if (FilTyp->FTClass == FTC_Atmc || FilTyp->FTClass == FTC_Generic
       || FilTyp->FTClass == FTC_Hook) {
      return TRUE; }/*if*/;
   return (FilTyp == DfltAtmFilTyp
	   || FilTyp == ViewFilTyp
	   || FilTyp == GenericFilTyp);
   }/*IsAtmc_FilTyp*/;


boolean
IsImplicit_FilTyp(FilTyp)
   tp_FilTyp FilTyp;
{
   FORBIDDEN(FilTyp == ERROR);
   return (FilTyp->FTClass == FTC_Implicit);
   }/*IsImplicit_FilTyp*/;


boolean
IsPntr_FilTyp(FilTyp)
   tp_FilTyp FilTyp;
{
   FORBIDDEN(FilTyp == ERROR);
   return (FilTyp->FTClass == FTC_Pntr);
   }/*IsPntr_FilTyp*/;


IsCmpd_FilTyp(FilTyp)
   tp_FilTyp FilTyp;
{
   tp_FTClass FTClass;

   FORBIDDEN(FilTyp == ERROR);
   FTClass = FilTyp->FTClass;
   if (FTClass == FTC_Cmpd || FTClass == FTC_DrvDir) {
      return TRUE; }/*if*/;
   return (FilTyp == DfltCpdFilTyp);
   }/*IsCmpd_FilTyp*/;


boolean
IsDrvDir_FilTyp(FilTyp)
   tp_FilTyp FilTyp;
{
   FORBIDDEN(FilTyp == ERROR);
   return (FilTyp->FTClass == FTC_DrvDir);
   }/*IsDrvDir_FilTyp*/;


boolean
IsStruct_FilTyp(FilTyp)
   tp_FilTyp FilTyp;
{
   FORBIDDEN(FilTyp == ERROR);
   return (FilTyp->FTClass == FTC_Struct);
   }/*IsStruct_FilTyp*/;


boolean
IsAtomic_FilTyp(PntrFilTyp)
   tp_FilTyp PntrFilTyp;
{
   tp_FilTyp FilTyp;

   FORBIDDEN(PntrFilTyp == ERROR);
   FilTyp = PntrFilTyp;
   while (IsPntr_FilTyp(FilTyp)) FilTyp = FilTyp->ElmFilTyp;
   return IsAtmc_FilTyp(FilTyp);
   }/*IsAtomic_FilTyp*/;


boolean
IsCompound_FilTyp(PntrFilTyp)
   tp_FilTyp PntrFilTyp;
{
   tp_FilTyp FilTyp;

   FORBIDDEN(PntrFilTyp == ERROR);
   FilTyp = PntrFilTyp;
   while (IsPntr_FilTyp(FilTyp)) FilTyp = FilTyp->ElmFilTyp;
   return IsCmpd_FilTyp(FilTyp);
   }/*IsCompound_FilTyp*/;


boolean
IsStructure_FilTyp(PntrFilTyp)
   tp_FilTyp PntrFilTyp;
{
   tp_FilTyp FilTyp;

   FORBIDDEN(PntrFilTyp == ERROR);
   FilTyp = PntrFilTyp;
   while (IsPntr_FilTyp(FilTyp)) FilTyp = FilTyp->ElmFilTyp;
   return IsStruct_FilTyp(FilTyp);
   }/*IsStructure_FilTyp*/;


boolean
IsGeneric_FilTyp(FilTyp)
   tp_FilTyp FilTyp;
{
   return FilTyp->FTClass == FTC_Generic;
   }/*IsGeneric_FilTyp*/;


boolean
IsHook_FilTyp(FilTyp)
   tp_FilTyp FilTyp;
{
   return FilTyp->FTClass == FTC_Hook;
   }/*IsHook_FilTyp*/;


boolean
CanImHo_FilTyp(FilTyp)
   tp_FilTyp FilTyp;
{
   boolean result;

   result = (IsCmpd_FilTyp(FilTyp) || IsPntr_FilTyp(FilTyp));
   FORBIDDEN(result != (FilTyp->ElmFilTyp != NIL));
   return result;
   }/*CanImHo_FilTyp*/;



