/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/FilHdr.h"
#include "inc/FKind_.h"
#include "inc/Flag_.h"
#include "inc/ModKind_.h"
#include "inc/Status_.h"
#include "inc/Signal_.h"
#include "inc/Str.h"


Increment_CurrentDate()
{
   CurrentDate += 1;
   }/*Increment_CurrentDate*/;


Set_Verify(NewVerify)
   boolean NewVerify;
{
   if (NewVerify) {
      Clear_FreeFilHdrs();
      Increment_CurrentDate(); }/*if*/;
   Verify = NewVerify;
   }/*Set_Verify*/;


boolean
IsSource(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return IsSource_FKind(FilHdr->HdrInf.FKind);
   }/*IsSource*/;


boolean
IsSource_FKind(FKind)
   tp_FKind FKind;
{
   switch (FKind) {
      case FK_Src: case FK_Link: {
	 return TRUE; }/*case*/;
      case FK_User: case FK_DrvDirElm: case FK_Homo: case FK_ImHo: case FK_PntrHo:
      case FK_RplPntr: case FK_DirElms: case FK_InpPntr: case FK_Instance: {
	 return FALSE; }/*case*/;
      default: {
	 FatalError("unknown FKind"); };}/*switch*/;
   /* NOTREACHED */
   }/*IsSource_FKind*/;


boolean
IsGeneric(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return (FilHdr->HdrInf.FKind == FK_User
	   && IsGeneric_FilTyp(FilHdr->FilTyp));
   }/*IsGeneric*/;


boolean
IsInstance(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return (FilHdr->HdrInf.FKind == FK_Instance);
   }/*IsInstance*/;


boolean
IsAtmc(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_FKind FKind;

   FORBIDDEN(FilHdr == ERROR);
   FKind = FilHdr->HdrInf.FKind;
   if (FKind != FK_Src && FKind != FK_Link
       && FKind != FK_User && FKind != FK_DrvDirElm && FKind != FK_RplPntr) {
      return FALSE; }/*if*/;
   return IsAtmc_FilTyp(FilHdr->FilTyp);
   }/*IsAtmc*/;


boolean
IsLink_FKind(FKind)
   tp_FKind FKind;
{
   FORBIDDEN(FKind == ERROR);
   return (FKind == FK_Link);
   }/*IsLink_FKind*/;


boolean
IsLink(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return IsLink_FKind(FilHdr->HdrInf.FKind);
   }/*IsLink*/;


boolean
IsDirElms(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return (FilHdr->HdrInf.FKind == FK_DirElms);
   }/*IsDirElms*/;


boolean
IsPntr(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_FKind FKind;

   FORBIDDEN(FilHdr == ERROR);
   FKind = FilHdr->HdrInf.FKind;
   if (FKind == FK_PntrHo || FKind == FK_RplPntr || FKind == FK_InpPntr
       || FKind == FK_Instance) {
      return TRUE; }/*if*/;
   if (FKind != FK_User && FKind != FK_DrvDirElm) {
      return FALSE; }/*if*/;
   return IsPntr_FilTyp(FilHdr->FilTyp);
   }/*IsPntr*/;


boolean
IsCmpd(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_FKind FKind;

   FORBIDDEN(FilHdr == ERROR);
   FKind = FilHdr->HdrInf.FKind;
   if (FKind == FK_DirElms || FKind == FK_Homo || FKind == FK_ImHo) {
      return TRUE; }/*if*/;
   return (IsCmpd_FilTyp(FilHdr->FilTyp));
   }/*IsCmpd*/;


boolean
IsCompound(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_FKind FKind;

   FORBIDDEN(FilHdr == ERROR);
   FKind = FilHdr->HdrInf.FKind;
   if (FKind == FK_Homo || FKind == FK_ImHo || FKind == FK_DirElms) {
      return TRUE; }/*if*/;
   return (IsCompound_FilTyp(FilHdr->FilTyp));
   }/*IsCompound*/;


boolean
IsStruct(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   if (FilHdr->HdrInf.FKind != FK_User) {
      return FALSE; }/*if*/;
   return IsStruct_FilTyp(FilHdr->FilTyp);
   }/*IsStruct*/;


boolean
IsStructMem(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   if (FilHdr->HdrInf.FKind != FK_User && FilHdr->HdrInf.FKind != FK_RplPntr) {
      return FALSE; }/*if*/;
   return IsStructMem_FilTyp(FilHdr->FilTyp);
   }/*IsStructMem*/;


boolean
IsDrvDir(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   if (FilHdr->HdrInf.FKind != FK_User) {
      return FALSE; }/*if*/;
   return IsDrvDir_FilTyp(FilHdr->FilTyp);
   }/*IsDrvDir*/;


boolean
IsDrvDirElm(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return (FilHdr->HdrInf.FKind == FK_DrvDirElm);
   }/*IsDrvDirElm*/;


boolean
HasKey_FKind(FKind)
   tp_FKind FKind;
{
   FORBIDDEN(FKind == ERROR);
   return (FKind == FK_DrvDirElm || IsSource_FKind(FKind));
   }/*HasKey_FKind*/;


boolean
IsStructure(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   if (FilHdr->HdrInf.FKind != FK_User) {
      return FALSE; }/*if*/;
   return (IsStructure_FilTyp(FilHdr->FilTyp));
   }/*IsStructure*/;


boolean
IsOdinRef(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return (IsCmpd(FilHdr) || IsPntr(FilHdr));
   }/*IsOdinRef*/;


boolean
IsRef(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return (IsCmpd(FilHdr) || IsPntr(FilHdr) || IsLink(FilHdr));
   }/*IsRef*/;


tp_LocHdr
FilHdr_LocHdr(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr == ERROR) return ERROR;
   return FilHdr->HdrInf.LocHdr;
   }/*FilHdr_LocHdr*/;


Set_FKind(FilHdr, FKind)
   tp_FilHdr FilHdr;
   tp_FKind FKind;
{
   FORBIDDEN(FilHdr == ERROR);
   if (FilHdr->HdrInf.FKind == FKind) {
      return; }/*if*/;
   if (FilHdr->HdrInf.FKind != NIL) {
      FORBIDDEN(!IsSource_FKind(FilHdr->HdrInf.FKind));
      FORBIDDEN(!IsSource_FKind(FKind));
      if (IsLink(FilHdr) && !IsLink_FKind(FKind)) {
	 Set_LocElm(FilHdr, (tp_LocElm)NIL); }/*if*/; }/*if*/;
   FilHdr->HdrInf.FKind = FKind;
   SetModified(FilHdr);
   }/*Set_FKind*/;


tp_FKind
FilHdr_FKind(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr == ERROR) return ERROR;
   return FilHdr->HdrInf.FKind;
   }/*FilHdr_FKind*/;


tp_FilTyp
FilHdr_FilTyp(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr == ERROR) return ERROR;
   return FilHdr->FilTyp;
   }/*FilHdr_FilTyp*/;


tp_Prms
FilHdr_Prms(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr == ERROR) return ERROR;
   FORBIDDEN(FilHdr->Prms == 0);
   return FilHdr->Prms;
   }/*FilHdr_Prms*/;


tp_FilHdr
FilHdr_CheckFilHdr(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_FilHdr CheckFilHdr;

   FORBIDDEN(FilHdr == ERROR);
   if (FilHdr->HdrInf.CheckLocHdr == 0) {
      Ret_FilHdr(FilHdr);
      return ERROR; }/*if*/;
   CheckFilHdr = LocHdr_FilHdr(FilHdr->HdrInf.CheckLocHdr);
   Ret_FilHdr(FilHdr);
   return CheckFilHdr;
   }/*FilHdr_CheckFilHdr*/;


tp_FilHdr
FilHdr_NonTestFilHdr(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   if (FilHdr->HdrInf.CheckLocHdr == 0) {
      return FilHdr; }/*if*/;
   return FilHdr_Head(FilHdr);
   }/*FilHdr_NonTestFilHdr*/;


boolean
IsOrigin_FilHdr(FilHdr, SrcFilHdr)
   tp_FilHdr FilHdr;
   tp_FilHdr SrcFilHdr;
{
   FORBIDDEN(FilHdr == ERROR || SrcFilHdr == ERROR);
   return (FilHdr->HdrInf.LocHdr == SrcFilHdr->HdrInf.OriginLocHdr);
   }/*IsOrigin_FilHdr*/;


tp_Ident
FilHdr_Ident(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   return FilHdr->Ident;
   }/*FilHdr_Ident*/;


Deref(FilHdrPtr, PrmsPtr, FilHdr)
   tp_FilHdr *FilHdrPtr;
   tp_Prms *PrmsPtr;
   tp_FilHdr FilHdr;
{
   tp_FilElm FilElm;

   FilElm = LocElm_FilElm(FilHdr_LocElm(FilHdr));
   FORBIDDEN(FilElm == NIL || FilElm_Next(FilElm) != NIL);
   *FilHdrPtr = FilElm_FilHdr(FilElm);
   *PrmsPtr = FilElm_Prms(FilElm);
   Ret_FilElm(FilElm);
   Ret_FilHdr(FilHdr);
   }/*Deref*/;


Deref_Pntrs(FilHdrPtr, PrmsPtr, FilHdr, LinkFlag)
   tp_FilHdr *FilHdrPtr;
   tp_Prms *PrmsPtr;
   tp_FilHdr FilHdr;
   boolean LinkFlag;
{
   tp_Prms Prms;

   FORBIDDEN(FilHdr == ERROR);
   if (FilHdr_Flag(FilHdr, FLAG_DeRef)) {
      FilHdr_Error("<%s> is circular.\n", FilHdr);
      Ret_FilHdr(FilHdr);
      *FilHdrPtr = (tp_FilHdr)NIL;
      *PrmsPtr = (tp_Prms)NIL;
      return; }/*if*/;
   if (!(IsPntr(FilHdr) || (LinkFlag && IsLink(FilHdr)))
       || (FilHdr_Status(FilHdr) <= STAT_Error)) {
      *FilHdrPtr = FilHdr;
      *PrmsPtr = DfltPrms;
      return; }/*if*/;
   Set_Flag(FilHdr, FLAG_DeRef);
   Deref(FilHdrPtr, &Prms, Copy_FilHdr(FilHdr));
   Deref_Pntrs(FilHdrPtr, PrmsPtr, *FilHdrPtr, LinkFlag);
   *PrmsPtr = Union_Prms(*PrmsPtr, Prms);
   Clr_Flag(FilHdr, FLAG_DeRef);
   Ret_FilHdr(FilHdr);
   }/*Deref_Pntrs*/;


Test_SrcFilHdr(SignalPtr, FilHdr, IncrementFlag)
   tp_Signal *SignalPtr;
   tp_FilHdr FilHdr;
   boolean IncrementFlag;
{
   tp_FilHdr LinkFilHdr;
   tp_Prms Prms;

   Update_SrcFilHdr(SignalPtr, FilHdr, IncrementFlag);
   if (IsLink(FilHdr)) {
      Deref(&LinkFilHdr, &Prms, Copy_FilHdr(FilHdr));
      Test_SrcFilHdr(SignalPtr, LinkFilHdr, IncrementFlag);
      Ret_FilHdr(LinkFilHdr);
      if (!IsElmUpToDate(FilHdr)) {
	 Update_SrcFilHdr(SignalPtr, FilHdr, IncrementFlag); }/*if*/; }/*if*/;
   }/*Test_SrcFilHdr*/;


Update_SrcFilHdr(SignalPtr, FilHdr, IncrementFlag)
   tp_Signal *SignalPtr;
   tp_FilHdr FilHdr;
   boolean IncrementFlag;
{
   tp_Prms Prms;
   boolean Changed;
   tp_HdrInf HdrInf;
   tps_FileName FileName, LinkFileName;
   int SysModTime;
   tp_FilHdr BaseFilHdr, LinkFilHdr;
   tp_Date OldDate;
   tp_FilElm FilElm;
   tp_Signal Signal;
   int Tag;

   FORBIDDEN(FilHdr == ERROR);
   FORBIDDEN(!IsSource(FilHdr));

   *SignalPtr = NIL;
   OldDate = CurrentDate;
   Changed = FALSE;
   HdrInf = &(FilHdr->HdrInf);
   BaseFilHdr = Copy_FilHdr(FilHdr);
   if (HdrInf->LocHdr != RootLocHdr) {
      BaseFilHdr = FilHdr_BaseFilHdr(BaseFilHdr);
      if (!IsUpToDate(BaseFilHdr)) {
	 Update_SrcFilHdr(&Signal, BaseFilHdr, IncrementFlag);
	 if (Signal != NIL) {
	    *SignalPtr = Signal; }/*if*/; }/*if*/;
      if (IsLink(BaseFilHdr)) {
	 Deref(&LinkFilHdr, &Prms, Copy_FilHdr(BaseFilHdr));
	 LinkFilHdr = ExtendFilHdr
	    (LinkFilHdr, FK_Src, FilHdr->FilTyp, DfltPrms, FilHdr->Ident);
	 Changed = TRUE;
	 if (HdrInf->LocElm != NIL) {
	    FilElm = LocElm_FilElm(HdrInf->LocElm);
	    if (FilElm_LocHdr(FilElm) == LinkFilHdr->HdrInf.LocHdr) {
	       Changed = FALSE; }/*if*/;
	    Ret_FilElm(FilElm); }/*if*/;
	 if (Changed) {
	    Set_LocElm(FilHdr, Make_LocElm(LinkFilHdr, DfltPrms, FilHdr));
	    }/*if*/;
	 Update_SrcFilHdr(&Signal, LinkFilHdr, IncrementFlag);
	 if (Signal != NIL) {
	    *SignalPtr = Signal; }/*if*/;
	 if (HdrInf->FKind != FK_Link) {
	    Changed = TRUE;
	    Set_FKind(FilHdr, FK_Link); }/*if*/;
	 Ret_FilHdr(LinkFilHdr);
	 Set_Status(FilHdr, STAT_OK);
	 goto done; }/*if*/; }/*if*/;
   FilHdr_DataFileName(FileName, FilHdr);
   if (!Link_Exists(FileName)) {
      if (HdrInf->Status != STAT_NoFile) {
	 Changed = TRUE;
	 Set_FKind(FilHdr, FK_Src);
	 HdrInf->Status = STAT_NoFile;
	 HdrInf->SysModTime = 0;
	 HdrInf->OriginLocHdr = 0;
	 if (!IsUpToDate(BaseFilHdr)) {
	    Update_SrcFilHdr(&Signal, BaseFilHdr, IncrementFlag);
	    if (Signal != NIL) {
	       *SignalPtr = Signal; }/*if*/; }/*if*/; }/*if*/;
      goto done; }/*if*/;
   if (!CanRead(FileName)) {
      if (HdrInf->Status != STAT_NoRead) {
	 Changed = TRUE;
	 Set_FKind(FilHdr, FK_Src);
	 HdrInf->Status = STAT_NoRead;
	 if (!IsUpToDate(BaseFilHdr)) {
	    Update_SrcFilHdr(&Signal, BaseFilHdr, IncrementFlag);
	    if (Signal != NIL) {
	       *SignalPtr = Signal; }/*if*/; }/*if*/; }/*if*/;
      goto done; }/*if*/;
   SysModTime = ModTime(FileName);
   if (HdrInf->Status != STAT_OK || HdrInf->SysModTime != SysModTime) {
      Changed = TRUE;
      /* this is expensive, but probably neccessary */
      if (HdrInf->Status == STAT_NoFile) {
	 if (!IsUpToDate(BaseFilHdr)) {
	    Update_SrcFilHdr(&Signal, BaseFilHdr, IncrementFlag);
	    if (Signal != NIL) {
	       *SignalPtr = Signal; }/*if*/; }/*if*/; }/*if*/;
      HdrInf->Status = STAT_OK;
      HdrInf->ElmNameStatus = STAT_Unknown;
      HdrInf->ElmStatus = STAT_Unknown;
      HdrInf->SysModTime = SysModTime;
      HdrInf->OriginLocHdr = 0;
      if (IsLink_FileName(FileName)) {
	 FileName_LinkFileName(LinkFileName, FileName);
	 Push_CWDFilHdr(FilHdr_DirFilHdr(Copy_FilHdr(FilHdr)));
	 LinkFilHdr = HostFN_FilHdr(LinkFileName);
	 Pop_CWDFilHdr();
	 Set_LocElm(FilHdr, Make_LocElm(LinkFilHdr, DfltPrms, FilHdr));
	 if (!IsUpToDate(LinkFilHdr)) {
	    Update_SrcFilHdr(&Signal, LinkFilHdr, IncrementFlag);
	    if (Signal != NIL) {
	       *SignalPtr = Signal; }/*if*/; }/*if*/;
	 Set_FKind(FilHdr, FK_Link);
	 Ret_FilHdr(LinkFilHdr);
	 goto done; }/*if*/;
      Set_FKind(FilHdr, FK_Src); }/*if*/;
done:;
   Ret_FilHdr(BaseFilHdr);
   if (Changed) {
      if (IncrementFlag && CurrentDate == OldDate) Increment_CurrentDate();
      Set_ModDate(FilHdr);
      SetModified(FilHdr);
      /*select*/{
	 if (HdrInf->Purged) {
	    /* New FilHdr, no need to broadcast */
	    HdrInf->Purged = FALSE;
	    HdrInf->TransPurged = FALSE;
	 }else{
	    Broadcast(FilHdr);
	    *SignalPtr = SIGNAL_SourceMod; };}/*select*/; }/*if*/;
   FilHdr->VerifyDate = CurrentDate;
   if (!IsElmUpToDate(FilHdr)) {
      Tag = 1;
      GetElms(&Signal, FilHdr, TRUE, &Tag);
      if (Signal != NIL) *SignalPtr = Signal;
/*      FORBIDDEN(Signal != NIL); */
      }/*if*/;
   }/*Update_SrcFilHdr*/;


FilHdr_Error(Str, FilHdr)
   tp_Str Str;
   tp_FilHdr FilHdr;
{
   tps_Str ObjName;

   FilHdr_OdinName(ObjName, FilHdr);
   SystemError(SystemErrorFD(), Str, ObjName);
   }/*FilHdr_Error*/;


boolean
IsUpToDate(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   if (Verify && FilHdr->VerifyDate < CurrentDate) {
      return FALSE; }/*if*/;
   return (FilHdr->HdrInf.Status > STAT_Unknown);
   }/*IsUpToDate*/;


boolean
IsElmNameUpToDate(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   if (!IsRef(FilHdr)) {
      return TRUE; }/*if*/;
   if (FilHdr->HdrInf.Status <= STAT_Error) {
      return TRUE; }/*if*/;
   if (Verify && FilHdr->ElmNameVerifyDate < CurrentDate) {
      return FALSE; }/*if*/;
   return (FilHdr->HdrInf.ElmNameStatus > STAT_Unknown);
   }/*IsElmNameUpToDate*/;


boolean
IsElmUpToDate(FilHdr)
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);
   if (!IsRef(FilHdr)) {
      return TRUE; }/*if*/;
   if (FilHdr->HdrInf.Status <= STAT_Error) {
      return TRUE; }/*if*/;
   if (Verify && FilHdr->ElmVerifyDate < CurrentDate) {
      return FALSE; }/*if*/;
   return (FilHdr->HdrInf.ElmStatus > STAT_Unknown);
   }/*IsElmUpToDate*/;


tp_FilHdr
FilHdr_BaseFilHdr(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_LocHdr BaseLocHdr;
   tp_FilHdr BaseFilHdr;

   FORBIDDEN(FilHdr == ERROR);

   BaseLocHdr = FilHdr->HdrInf.Father;
   FORBIDDEN(BaseLocHdr == ERROR);
   BaseFilHdr = LocHdr_FilHdr(BaseLocHdr);
   Ret_FilHdr(FilHdr);
   return BaseFilHdr;
   }/*FilHdr_BaseFilHdr*/;


tp_FilHdr
FilHdr_SrcFilHdr(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_LocHdr SrcLocHdr;

   while (!IsSource(FilHdr)) {
      SrcLocHdr = FilHdr->HdrInf.Father;
      FORBIDDEN(SrcLocHdr == ERROR);
      Ret_FilHdr(FilHdr);
      FilHdr = LocHdr_FilHdr(SrcLocHdr); }/*while*/;

   return FilHdr;
   }/*FilHdr_SrcFilHdr*/;


tp_FilHdr
FilHdr_DirElmsFilHdr(FilHdr)
   tp_FilHdr FilHdr;
{
   return
      Get_Drv(FilHdr, FK_DirElms, FilHdr_FilTyp(FilHdr), DfltPrms, DfltIdent);
   }/*FilHdr_DirElmsFilHdr*/;


tp_FilHdr
FilHdr_HomoFilHdr(FilHdr, Prms, FilTyp)
   tp_FilHdr FilHdr;
   tp_Prms Prms;
   tp_FilTyp FilTyp;
{
   return Get_Drv(FilHdr, FK_Homo, FilTyp, Prms, DfltIdent);
   }/*FilHdr_HomoFilHdr*/;


boolean
CanImHo_FKind(FKind)
   tp_FKind FKind;
{
   FORBIDDEN(FKind == ERROR);
   return (FKind == FK_Homo || FKind == FK_ImHo || FKind == FK_PntrHo
	   || FKind == FK_DirElms || FKind == FK_InpPntr);
   }/*CanImHo_FKind*/;


tp_FilHdr
FilHdr_InstanceFilHdr(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_FilElm FilElm;
   tp_FilHdr InstanceFilHdr;

   if (!IsGeneric(FilHdr)) {
      return FilHdr; }/*if*/;
   FilElm = LocElm_FilElm(FilHdr_ElmLink(FilHdr));
   InstanceFilHdr = FilElm_CmpdFilHdr(FilElm);
   Ret_FilElm(FilElm); Ret_FilHdr(FilHdr);
   FORBIDDEN(FilHdr_FKind(InstanceFilHdr) != FK_Instance);
   return InstanceFilHdr;
   }/*FilHdr_InstanceFilHdr*/;


tp_Str
FilHdr_Key(StrBuf, FilHdr)
   tp_Str StrBuf;
   tp_FilHdr FilHdr;
{
   FORBIDDEN(FilHdr == ERROR);

   if (!HasKey_FKind(FilHdr->HdrInf.FKind)) {
      return NIL; }/*if*/;
   return FilHdr_Label(StrBuf, FilHdr);
   }/*FilHdr_Key*/;


tp_Label
FilHdr_Label(StrBuf, FilHdr)
   tp_Str StrBuf;
   tp_FilHdr FilHdr;
{
   tp_FilHdr LabelFilHdr;

   FORBIDDEN(FilHdr == ERROR);

   LabelFilHdr = FilHdr_InstanceFilHdr(Copy_FilHdr(FilHdr));
   (void)strcpy(StrBuf, LabelFilHdr->Ident);
   if (LabelFilHdr->FilTyp != NullFilTyp) {
      (void)strcat(StrBuf, FilTyp_FTName(LabelFilHdr->FilTyp)); }/*if*/;
   Ret_FilHdr(LabelFilHdr);
   return StrBuf;
   }/*FilHdr_Label*/;


