/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"


typedef struct _tps_CWDFilHdrS *	tp_CWDFilHdrS;
typedef struct _tps_CWDFilHdrS {
   tp_FilHdr FilHdr;
   tp_CWDFilHdrS Next;
   }				tps_CWDFilHdrS;

tp_CWDFilHdrS	CWDFilHdrS = NIL;
tp_CWDFilHdrS	FreeCWDFilHdrS = NIL;
int		num_CWDFilHdrS = 0;


Init_CWD()
{
   tps_FileName CWDirName;
   GetWorkingDir(CWDirName);
   Push_CWDFilHdr(HostFN_FilHdr(CWDirName));
   }/*Init_CWD*/;


tp_FilHdr
Top_CWDFilHdr()
{
   FORBIDDEN(CWDFilHdrS == NIL);
   return Copy_FilHdr(CWDFilHdrS->FilHdr);
   }/*Top_CWDFilHdr*/;


Push_CWDFilHdr(CWDFilHdr)
   tp_FilHdr CWDFilHdr;
{
   tp_CWDFilHdrS NewCWDFilHdrS;

   FORBIDDEN(CWDFilHdr == ERROR);
   /*select*/{
      if (FreeCWDFilHdrS == 0) {
	 NewCWDFilHdrS = (tp_CWDFilHdrS)malloc(sizeof(tps_CWDFilHdrS));
	 num_CWDFilHdrS += 1;
      }else{
	 NewCWDFilHdrS = FreeCWDFilHdrS;
	 FreeCWDFilHdrS = FreeCWDFilHdrS->Next; };}/*select*/;
   NewCWDFilHdrS->FilHdr = CWDFilHdr;
   NewCWDFilHdrS->Next = CWDFilHdrS;
   CWDFilHdrS = NewCWDFilHdrS;
   }/*Push_CWDFilHdr*/;


Pop_CWDFilHdr()
{
   tp_CWDFilHdrS OldFreeCWDFilHdrS;

   FORBIDDEN(CWDFilHdrS == NIL);
   Ret_FilHdr(CWDFilHdrS->FilHdr);
   OldFreeCWDFilHdrS = FreeCWDFilHdrS;
   FreeCWDFilHdrS = CWDFilHdrS;
   CWDFilHdrS = CWDFilHdrS->Next;
   FreeCWDFilHdrS->Next = OldFreeCWDFilHdrS;
   }/*Pop_CWDFilHdr*/;


Set_Dir(DirName)
   tp_Str DirName;
{
   tp_FilHdr FilHdr;
   tps_FileName NewDirName;
   boolean Abort;

   FilHdr = HostFN_FilHdr(DirName);
   if (FilHdr == ERROR) {
      return; }/*if*/;

   FilHdr_HostFN(NewDirName, FilHdr);
   ChangeDir(&Abort, NewDirName);
   if (Abort) {
      SystemError(SystemErrorFD(), "<%s> is not a directory.\n", NewDirName);
      Ret_FilHdr(FilHdr);
      return; }/*if*/;
   Pop_CWDFilHdr();
   Push_CWDFilHdr(FilHdr);
   }/*Set_Dir*/;



