static char rcsid[] = "$Id: menunote.c,v 1.6 1991/07/04 17:23:13 waite Exp $";

/* menunote.c

   Copyright (C) 1987 Free Software Foundation, Inc.

   This file is part of GNU Info.

   GNU Info is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.  No author or distributor accepts
   responsibility to anyone for the consequences of using it or for
   whether it serves any particular purpose or works at all, unless he
   says so in writing.  Refer to the GNU Emacs General Public License
   for full details.

   Everyone is granted permission to copy, modify and redistribute
   GNU Info, but only under the conditions described in the GNU Emacs
   General Public License.   A copy of this license is supposed to
   have been given to you along with GNU Emacs so you can know your
   rights and responsibilities.  It should be in a file named COPYING.
   Among other things, the copyright notice and this notice must be
   preserved on all copies.
*/

#include <curses.h>
#include "info.h"
#include "node.h"

extern COMP_ENTRY *completion_list;
extern boolean scan_list();
extern void add_completion(), free_completion_list();
extern COMP_ENTRY *reverse_list();

char *visible_footnote = 0;	/* The default prompt string for the Follow Reference command. ams: not any more! */

/* Number of items that the current menu has. */
int the_menu_size = 0;

/* The node that last made a menus completion list. */
char menus_nodename[NODENAME_LEN];
char menus_filename[NODENAME_LEN];

/* Build a completion list of menuname/nodename for each
   line in this node that is a menu item. */
boolean
build_menu ()
{
  extern int nodetop;

  int pointer = nodetop;
  char menuname[NODENAME_LEN];
  char nodename[NODENAME_LEN];

  extern int search_forward(), skip_whitespace();
  extern void set_search_constraints();

  if (strcmp (menus_nodename, current_info_node) == 0 &&
      strcmp (menus_filename, current_info_file) == 0)
    return (the_menu_size != 0);

  (void)strcpy (menus_nodename, current_info_node);
  (void)strcpy (menus_filename, current_info_file);
  free_completion_list ();

  set_search_constraints (info_file, nodebot);
  the_menu_size = 0;
  if ((pointer = search_forward (MENU_HEADER, nodetop)) < 0)
    return (false);

  /* There is a menu here.  Look for members of it. */
  pointer += strlen (MENU_HEADER);

  while (true)
    {
      int ndx, infilename;

      pointer = search_forward (MENU_ID, pointer);
      if (pointer < 0)
	break;			/* no more menus in this node. */
      pointer = (skip_whitespace (pointer + strlen (MENU_ID)));
      ndx = 0;
      /* skip over the leading character, ie. ignore leadings ':'s */
      menuname[ndx++] = info_file[pointer++];
      while ((menuname[ndx] = info_file[pointer]) && menuname[ndx] != ':')
	{
	  ndx++, pointer++;
	}
      menuname[ndx] = '\0';
      pointer++;
      if (info_file[pointer] == ':')
	{
	  (void)strcpy (nodename, menuname);
	}
      else
	{
	  pointer = skip_whitespace (pointer);
	  ndx = 0;
	  infilename = 0;
	  while ((nodename[ndx] = info_file[pointer]) &&
		 nodename[ndx] != '\t' &&
		 (infilename || (nodename[ndx] != '.' &&
				 nodename[ndx] != ',')))
	    {
	      /* assumes we don't have multiple sets of () */
	      if (nodename[ndx] == '(') infilename++;
	      else if (nodename[ndx] == ')') infilename--;
	      ndx++, pointer++;
	    }
	  nodename[ndx] = '\0';
	}
      add_completion (menuname, nodename);
      the_menu_size++;
    }
  if (the_menu_size)
    completion_list = reverse_list (completion_list);
  return (the_menu_size != 0);
}

boolean
get_menu (item)
     int item;
{
  /* Select ITEMth item from the list built by build_menu. */

  COMP_ENTRY *temp = completion_list;

  if (!build_menu ())
    return (false);
  if (item > the_menu_size)
    return (false);
  else
    {
      while (--item && temp)
	temp = temp->next;
      return (get_node ((char *)NULL, temp->data, false));
    }
}

boolean
find_menu_node (string, nodename)
     char *string, *nodename;
{
  /* Scan through the ?already? built menu list looking
     for STRING.  If you find it, put the corresponding nodes
     name in NODENAME. */

  return (scan_list (string, nodename));
}

int
find_footnote_ref (from)
     int from;
{
  /* Find a reference to "*Note".  Return the offset of
     the start of that reference, or -1. */

  extern char *info_file;
  extern int search_forward();

  while (true)
    {
      from = search_forward (FOOTNOTE_HEADER, from);
      if (from < 0)
	return (from);
      else
	from += strlen (FOOTNOTE_HEADER);
      if (info_file[from] == ' ' ||
	  info_file[from] == '\n' ||
	  info_file[from] == '\t')
	return (from);
    }
}

boolean
build_notes ()
{
  /* Build an array of (footnote.nodename) for each footnote in this node. */

  int pointer;
  char notename[NODENAME_LEN];
  char nodename[NODENAME_LEN];

  extern char *info_file;
  extern int forward_lines();
  extern void set_search_constraints(), clean_up();
  extern int skip_whitespace(), skip_whitespace_and_cr();

  set_search_constraints (info_file, nodebot);

  if ((find_footnote_ref (nodetop)) < 0) return (false);
  pointer = nodetop;

  menus_filename[0] = menus_nodename[0] = '\0';
  visible_footnote = "";
  free_completion_list ();

  while (true)
    {
      int ndx;

      pointer = find_footnote_ref (pointer);
      if (pointer < 0)
	break;			/* no more footnotes in this node. */

      pointer = skip_whitespace_and_cr (pointer);
      ndx = 0;
      while ((notename[ndx] = info_file[pointer]) && notename[ndx] != ':')
	{
	  ndx++, pointer++;
	}
      notename[ndx] = '\0';
      clean_up (notename);
      pointer++;
      if (info_file[pointer] == ':')
	{
	  (void)strcpy (nodename, notename);
	}
      else
	{
	  pointer = skip_whitespace_and_cr (pointer);
	  ndx = 0;
	  while ((nodename[ndx] = info_file[pointer]) &&
		 nodename[ndx] != '\t' &&
		 nodename[ndx] != '.' &&
		 nodename[ndx] != ',')
	    {
	      ndx++, pointer++;
	    }
	  nodename[ndx] = '\0';
          clean_up (nodename);
	}
      /* Add the notename/nodename to the list. */
      add_completion (notename, nodename);
      the_menu_size++;

      /* Remember this identifier as the default if it is the first one in the
         page. */
      if (!(*visible_footnote) &&
	  pointer > pagetop &&
      pointer < forward_lines (LINES-3, pointer))
	visible_footnote = completion_list->identifier;
    }
  if (the_menu_size)
    completion_list = reverse_list (completion_list);
  return (the_menu_size != 0);
}

boolean
find_note_node (string, nodename)
     char *string, *nodename;
{
  /* Scan through the ?already? built footnote list looking
     for STRING.  If found, place the corresponding node name
     in NODENAME. */

  return (scan_list (string, nodename));
}
