#ifndef KEYARRAY_H
#define KEYARRAY_H 
/* $Id: keyarray.h,v 1.1 1993/01/05 05:12:41 waite Exp $ */
/* Copyright 1992, The Regents of the University of Colorado
 * Permission is granted to use any portion of this file for any purpose,
 * commercial or otherwise, provided that this notice remains unchanged.
 */

#include "deftbl.h"

typedef struct KeyArrayStart {
  int size;
  DefTableKey Key[1];
} *KeyArray;

#define NoKeyArray (KeyArray)0
#define KeyArraySize(b) (b?b->size:0)


extern KeyArray NewKeyArray(/* int n; */);
/* Create a array of definition table keys
 *    On entry-
 *       n=number of keys in the array
 *    On exit-
 *       NewKeyArray is an array of n "NoKey" values,
 *          indexed by the integers 0 through n-1 inclusive
 ***/


extern void StoreKeyInArray(/* KeyArray b; int i; DefTableKey k; */);
/* Store a definition table key into an array of keys
 *    On entry-
 *       b is the array into which the key is to be stored
 *       k is the key to be stored
 *    If i is a valid index for b then on exit-
 *       element i of b contains k
 *    Else on exit-
 *       b is unchanged
 ***/


extern DefTableKey FetchKeyFromArray(/* KeyArray b; int i; */);
/* Fetch a definition table key from an array of keys
 *    On entry-
 *       b is the array from which the key is to be fetched
 *       i is the index of the element to be fetched
 *    If i is a valid index for b then on exit-
 *       FetchKeyFromArray=key i of array b
 *    Else on exit-
 *       FetchKeyFromArray=NoKey
 ***/
#endif
