# $Id: Makefile.cpp,v 1.2 1993/01/07 20:35:57 kadhim Exp $
# Copyright 1992, The Regents of the University of Colorado

SHELL	= /bin/sh

# Default master cache location
DESTDIR	= ELISYS

# Relative pathname for the current directory
DIR	= Tool/parser

SYS	= dfltparse.c gsdescr.h
AUX	= parser.dg syntax.tnf
SRC	= 
CMD	= bnfOut.cmd concrete.cmd infoOut.cmd parserOut.cmd

TIDY	= *.o *.a core a.out ERRS ELI
CLEAN	= $(TIDY)

all:	$(SYS) $(AUX) $(SRC) $(CMD)
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done

install:
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/parser; \
		rm -f $(DESTDIR)/Tool/parser/$$f; \
		cp $$f $(DESTDIR)/Tool/parser/$$f; \
		chmod 644 $(DESTDIR)/Tool/parser/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/Tool/parser/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for f in $(SYS); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/parser; \
		rm -f $(DESTDIR)/Tool/parser/$$f; \
		cp $$f $(DESTDIR)/Tool/parser/$$f; \
		chmod 644 $(DESTDIR)/Tool/parser/$$f; \
	done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp $(SRC) $(AUX)

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)
