/* $Id: replincl.c,v 2.3 1992/01/29 13:20:10 cogito Exp $ */
/* $Log: replincl.c,v $
 * Revision 2.3  1992/01/29  13:20:10  cogito
 * Call of init_did_table modified
 *
 * Revision 2.2  1991/07/16  11:14:38  cogito
 * 'expand_opts->exp_opts= (ExpList) NULL;' added
 *
 * Revision 2.1  91/06/10  14:15:40  cogito
 * rewritten to achieve compatibility with new expand
 *  */
static char rcs_id[]= "$Id: replincl.c,v 2.3 1992/01/29 13:20:10 cogito Exp $";

/***********************************************\
*						*
*	Version : 1.schrott			*
*						*
*	Module  : replincl.c			*
*						*
*	Contains the main-function		*
*	to replace the				*
*	INCLUDING-shorthands			*
*						*
\***********************************************/


/***********************************************\
* includes					*
\***********************************************/

#include <stdio.h>
#include "LIGA.h"

#include "option_enums.h"
#include "option_types.h"
#include "opt_input.h"

#include "replincl.h"


/***********************************************\
* functions					*
\***********************************************/

int main ();


/***********************************************\
* main						*
\***********************************************/

int main (argc, argv)
int argc;
char **argv;
{
	/* Initialize I/O-Files */
	argv++;
	for (;argc>1;argc--,argv++)
	{
		if ((*argv)[0]=='-')
		{
			switch((*argv)[1])
			{
			    case 'c':
				argv++;
				argc--;
				expand_optionfile= fopen (*argv, "r");
				if (expand_optionfile < (FILE *) 0)
				{
					fprintf (stderr, "can't open Option file %s\n", *argv);
					exit (2);
				} /* if */
				break;
			    case 'i': 
				argv++;argc--;
				In=fopen(*argv,"r");
				if (In<(FILE *)0)
				{
					fprintf(stderr,"\nCan't open Inputfile %s\n",*argv);
					exit (2);
				} /* if */
				break;
			    case 'o': 
				argv++;argc--;
				Out=fopen(*argv,"w");
				if (Out<(FILE *)0)
				{
					fprintf(stderr,"\nCan't open Outputfile %s\n",*argv);
					exit (2);
				} /* if */
				break;
			    case 'p': 
				argv++;argc--;
				Prot=fopen(*argv,"w");
				if (Prot<(FILE *)0)
				{
					fprintf(stderr,"\nCan't open Protfile %s\n",*argv);
					exit (2);
				} /* if */
				break;
			    default: 
				fprintf(stderr,"\nUsage : replincl [-i in][-o out][-p list]\n\n");
				exit(3);
			} /* switch */
		} /* if */
		else
		{
			fprintf(stderr,"\nUsage : replincl [-i in][-o out][-p list]\n\n");
			exit(1);
		} /* else */
	} /* for */
	
	fprintf(Prot,"\n\n*** THIS IS REPLINCL, A DEPENDENCY-TOOL OF LIGA ***\n\n");

	/* read files for option handling */
	expand_opts= (OptCollect) malloc (sizeof (struct _optcollect));
	expand_opts->exp_opts= (ExpList) NULL;   /* inserted by kalle */
	OptionInput (expand_opts, expand_optionfile);
	fclose (expand_optionfile);

	IS=ligain(In);

	eval_exp_opt(IS);

        /* Create the table of dids */
        init_did_table(IS->defseq);

	if (!EXP_INCL)
	{
		/* remove all attributes and assignments generated for transport */
		remove_includings();
	} /* if */
	else
	{
		/* replace INCLUDING constructs by attribute accesses */
		replace_includings();
	} /* else */

	ligaout(Out,IS);
	return (0);
} /* main() */

