/* $Id: write.c,v 2.3 1991/09/25 13:38:35 cogito Exp $ */
/* $Log: write.c,v $
 * Revision 2.3  1991/09/25  13:38:35  cogito
 * Corrected an error of the last modification.
 *
 * Revision 2.2  1991/09/23  14:27:41  mjung
 * Added Errormessages using message. Protocoll-file is unchanged.
 *
 * Revision 2.1  1991/06/10  13:26:26  cogito
 * sources for ORDER combined with GORTO
 * */
static char rcs_id[]= "$Id: write.c,v 2.3 1991/09/25 13:38:35 cogito Exp $";

/****************************************************************
*								*
*       Module  : write.c					*
*								*
*       Version : 1.0						*
*								*
*       Author  : Jiyang Liu					*
*								*
*       Contents: routines for writing the computed attributes	*
*		  back into the IDL data structure.		*
*								*
****************************************************************/

	/*
	 * Angepasst zur Anbindung an GORTO (Graphical Order Tool).
	 * Alle Aenderungen sind mit #ifdef GORTO gekennzeichnet.
	 *
	 *		15.06.90	Volker Niepel
	 */

#ifndef GORTO
#include "order.h"
#else
#include "Gorto.h"
#endif
#include "printerr.h"

/********************
* global variables  *
********************/

extern AttrEval ISexp;
SEQAttribution attribution_order;

/********************
* functions         *
********************/

void init_Attribution();
void add_attribution();
void cp_attributionNodes();
void add_visit();
void add_cond();
void write_dataStruct();

/********************************************************
*    	void init_Attribution()                         *
********************************************************/

void
init_Attribution()
{
   initializeSEQAttribution(attribution_order);

} /* init_Attribution()  */


/********************************************************
*       void add_attribution()                          *
********************************************************/

void
add_attribution(pid)
int pid;

{
  Attribution attribution;

  attribution = NAttribution;
  attribution->prodid = pid;
  initializeSEQAttrrule(attribution->attrrules);
  appendrearSEQAttribution(attribution_order, attribution);

} /* add_attribution() */

/********************************************************
*       void cp_attributionNodes()                      *
********************************************************/

void
cp_attributionNodes()
{
   SEQAttribution remAttribution;
   Attribution attribution;

   foreachinSEQAttribution(ISexp->attrrules, remAttribution, attribution)
     add_attribution(attribution->prodid);

} /* cp_attributionNodes() */

/********************************************************
*       void add_visit()				*
********************************************************/

void
add_visit(attribution, vselmptr)
Attribution attribution;
VSPTR vselmptr;

{

Attrrule attrRule;

attrRule.VVisit = NVisit;   /* allocating space for it */
attrRule.VVisit->symbno = vselmptr->vsinfo.visit.vssno;
attrRule.VVisit->ord = vselmptr->vsinfo.visit.vsord;
appendrearSEQAttrrule(attribution->attrrules, attrRule);

} /* add_visit() */


/********************************************************
*       void add_cond()                                 *
********************************************************/

void
add_cond(attribution, vselmptr)
Attribution attribution;
VSPTR vselmptr;

{

Attrrule attrRule;

attrRule.VCall = vselmptr->vsinfo.cond.idldef;

appendrearSEQAttrrule(attribution->attrrules, attrRule);

} /* add_cond() */

/********************************************************
*       void write_dataStruct()                         *
*       write the computed attributions back into       *
*       the IDL data structure ISexp			*
********************************************************/

void
write_dataStruct()
{

SEQAttribution  remattribution;
Attribution     attribution, locattribution;
SEQAttrrule     remattrrule;
Attrrule        attrrule;
Expr            attracc;
VSPTR 		rulevisitseq, vselmptr;
int 		index;


init_Attribution();   	/* initialize attribution_order */
cp_attributionNodes();  /* cp attribution node for each prod in attribution_order */

index = 0;
foreachinSEQAttribution(ISexp->attrrules, remattribution, attribution) {

   index += 1;
   if (attribution != NULL) {

      rulevisitseq = ref_tab[attribution->prodid].entry.prod.visitseq;
      ithinSEQAttribution(attribution_order, index, locattribution);

      for (vselmptr = rulevisitseq; vselmptr != NULL; vselmptr = vselmptr->next) 
         switch (vselmptr->vscls) {

         case VSVISIT: 	add_visit(locattribution, vselmptr);
 			break;

         case VSASSIG:	foreachinSEQAttrrule(attribution->attrrules, remattrrule, attrrule) 
			   if ((typeof(attrrule) == KCall) &&
			       (strcmp(attrrule.VCall->name, "assign") == 0)) {
				
                              retrievefirstSEQExpr(attrrule.VCall->params, attracc);
			      if ((attracc.VAttracc->symbno == vselmptr->vsinfo.assig.sno) &&
				  (attracc.VAttracc->attrid == vselmptr->vsinfo.assig.aid)) 
                                 
   				 appendrearSEQAttrrule(locattribution->attrrules, attrrule);
                           }
                        break;

         case VSCOND:	add_cond(locattribution, vselmptr);
 			break;

	 case VSPOP:
	 case VSPUSH:   break;

 	 default:	err_setpos(0,0);
	                err_print_error("Unknown Visit Class");
	                fprintf(Prot, "*** ERROR *** UNKNOWN VISIT CLASS\n");
                        break;
         } /* switch */
      
   } /* if attribution   */

} /* foreach */

return;

}  /* write_dataStruct() */
