/* $Id: SymbMenu.c,v 1.4 1992/11/20 15:17:33 cogito Exp $ */
static char rcs_id[]= "$Id: SymbMenu.c,v 1.4 1992/11/20 15:17:33 cogito Exp $";

/*======================================================================*
 *									*
 *	FILE:		Symb/SymbMenu.c					*
 *									*
 *	CONTENTS:	Implementation of the symbol menu		*
 *									*
 *	AUTHOR:		Volker Niepel					*
 *									*
 *======================================================================*/

       /************************ WARNING ************************ 
	*							*
 	*	This file depends on the Athena Widget Set	*
 	*	of X Version 11, Release 4			*
	*							*
	*********************************************************/

#include "Misc.h"
#include "Create.h"
#include "Visit.h"
#include "Graph.h"
#include "Popup.h"
#include "Symb.h"

#include <X11/StringDefs.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>


/************************************************************************
 *			Widgets of the symbol menu			*
 ************************************************************************/

PRIVATE Widget	SymbMenu, 		/* Surrounding simple menu widget */
		ItemClose,		/* Close item */
		ItemCloseAll,		/* Close all item */
		ItemFreeAttr,		/* Free attribute partition item */
		ItemForcePart,		/* Force partition item */
		ItemProductions,	/* Select production item */
		ItemLifetime;		/* Show attribute lifetime item	*/

PRIVATE SYMBENTRY *symb;

		
/************************************************************************
 *		  	     SymbMenuPopupCB				*
 ************************************************************************/

/*ARGSUSED*/
PRIVATE SymbMenuPopupCB (w, client_data, call_data)
	Widget  w;
	caddr_t client_data;
	caddr_t call_data;
{
	Arg args[1];

	XtSetArg (args[0], XtNleftBitmap, None);

	if (DidOfGraphMenu < 0 || DidOfGraphMenu > max_entry ||
	    ref_tab[DidOfGraphMenu].etag != SYMB)
	{
		XtSetSensitive (ItemClose,       False);
		XtSetSensitive (ItemFreeAttr,    False);
		XtSetSensitive (ItemForcePart,   False);
		XtSetSensitive (ItemProductions, False);
		XtSetSensitive (ItemLifetime,    False);
	}
	else
	{
		symb = & SE(DidOfGraphMenu);

		XtSetSensitive (ItemClose,       True);
		XtSetSensitive (ItemFreeAttr,    SymbMarkedAttr.symb == symb);
		XtSetSensitive (ItemForcePart,   True);
		XtSetSensitive (ItemProductions, True);
		XtSetSensitive (ItemLifetime,    SymbMarkedAttr.symb == symb);

		if (symb->state & S_FORCED)
			XtSetArg (args[0], XtNleftBitmap, CheckMarkBitmap);
	}
	XtSetValues (ItemForcePart, args, 1);
}


/************************************************************************
 *				FreeAttrCB				*
 ************************************************************************/

/*ARGSUSED*/
PRIVATE void FreeAttrCB (w, client_data, call_data)
	Widget	w;
	caddr_t	client_data;
	caddr_t	call_data;
{
	UnarrangeAttr (SymbMarkedAttr.ae);
	SymbMarkedAttr.symb = NULL;
	SymbMarkedAttr.ae   = NULL;
	SymbRecomputePartition (symb);
}


/************************************************************************
 *			       SymbForceCB				*
 ************************************************************************/

/*ARGSUSED*/
PRIVATE void SymbForceCB (w, client_data, call_data)
	Widget	w;
	caddr_t	client_data;
	caddr_t	call_data;
{
	if (symb->state & S_FORCED)
	{
		ATTRENTRY *ae;

		for (ae = symb->first_attr; ae != NULL; ae = ae->next)
			UnarrangeAttr (ae);
		symb->state &= ~(S_ARRANGED|S_FORCED);
	}
	else
	{
		ArrangeForced (symb);
		symb->state |= S_FORCED;
	}
	SymbRecomputePartition (symb);
}


/************************************************************************
 *				LifetimeCB				*
 ************************************************************************/

/*ARGSUSED*/
PRIVATE void LifetimeCB (w, client_data, call_data)
	Widget	w;
	caddr_t	client_data;
	caddr_t	call_data;
{
      /* Mark the last use of this attribute in all productions */
	VisitMarkLifetime (symb, SymbMarkedAttr.ae);

      /* Try to show the last BmNF use */
	if (SymbMarkedAttr.ae->life_node == NULL)
		Message (DidOfGraphMenu, Res.no_bmnf_msg);
	else
		VisitCreateNew (SymbMarkedAttr.ae->life_node->pid);
}


/************************************************************************
 *			      SymbCreateMenu				*
 ************************************************************************/

PUBLIC void SymbCreateMenu (father)
	Widget father;
{
	int	n = 0;
	Arg	args[1];
	Widget	line;

	SymbMenu = CreateMenu ("symbolMenu", father);
	XtAddCallback (SymbMenu, XtNpopupCallback,
			SymbMenuPopupCB, (caddr_t) NULL);

	CreateMItem (ItemClose,    "close",    SymbMenu, SymbCloseCB,    NULL);
	CreateMItem (ItemCloseAll, "closeAll", SymbMenu, SymbCloseAllCB, NULL);
	CreateMLine (line,         "line",     SymbMenu);

	CreateMItem (ItemFreeAttr,  "freeAttr", SymbMenu, FreeAttrCB,  NULL);
	CreateMItem (ItemForcePart, "force",    SymbMenu, SymbForceCB, NULL);
	CreateMLine (line,          "line",     SymbMenu);

	CreateMItem (ItemProductions, "productions",SymbMenu, SymbProdCB, NULL);
	CreateMItem (ItemLifetime,    "lifetime",   SymbMenu, LifetimeCB, NULL);
}
