/* $Id: Reftab.c,v 1.3 1991/12/18 16:02:28 cogito Exp $ */
static char rcs_id[]= "$Id: Reftab.c,v 1.3 1991/12/18 16:02:28 cogito Exp $";

/*======================================================================*
 *									*
 *	FILE:		Main/Reftab.c					*
 *									*
 *	CONTENTS:	Computation of the additions to ref_tab		*
 *									*
 *	AUTHOR:		Volker Niepel					*
 *									*
 *======================================================================*/

#include "Misc.h"
#include "Prod.h"
#include "Symb.h"
#include "Visit.h"
#include "Main.h"


/************************************************************************
 *			     ComputeSymbolOrd				*
 ************************************************************************/

/* Computes the <ord> entries of all symbol instances of the symbol <symb>.
 */

PRIVATE void ComputeSymbolOrd (symb)
	SYMBENTRY *symb;
{
	SLNODE *nd, *last;

	last = NULL;
	for (nd = symb->hddown; nd != NULL; last = nd, nd = nd->down)
	{
		if (last != NULL && last->pid == nd->pid)
		{
			if (last->ord == 0) last->ord = 1;
			nd->ord = last->ord + 1;
		}
		else
			nd->ord = 0;
	}
}


/************************************************************************
 *			  ComputeRefTabAdditions			*
 ************************************************************************/

/* Initializes additional fields in ref_tab that have been added to 
 * the original order implementation.
 */

PUBLIC void ComputeRefTabAdditions ()
{
	static Boolean first_time = True;
	int max_segments = 0;
	int i, segments;

      /* Compute Attribute Additions */
	for (i=0; i<=max_entry; i++)
		if (ref_tab[i].etag == ATTR)
		{
			ATTRENTRY *ae = & AE(i);

			if (first_time) ae->state = 0;
		}

      /* Compute Symbol Additions */
	for (i=0; i<=max_entry; i++)
		if (ref_tab[i].etag == SYMB)
		{
			SYMBENTRY *symb = & SE(i);

			if (first_time)
				ComputeSymbolOrd (symb);
			else
			{
				symb->state &= ~S_CHANGED;
				SymbUpdateState (symb);
			}
			ProdSortAttributes (symb);
			ProdComputeAttrSpaces (symb);
			SymbMarkCriticalPath (symb);
			ProdComputeAttrSizes (symb);
			ProdComputeSymbolSize (symb);
			segments = symb->attr_num * 3 + 1;
			if (segments > max_segments)
				max_segments = segments;
		}

      /* Compute Production Additions */
	for (i=0; i<=max_entry; i++)
		if (ref_tab[i].etag == PROD)
		{
			PRODENTRY *prod = & PE(i);

			ProdComputeSize (prod);
			if (prod->state & S_VISIT_SEQ) VisitComputeSize (prod);
			if (first_time)
			{
				prod->par      = NULL;
				prod->geometry = NULL;
			}
		}

	if (first_time)
		InitDrawing (max_segments);
	else			
	{
		ProdUpdateList ();
		SymbUpdateList ();
	}
	first_time = False;
}
