/* $Id: PopupUtil.c,v 1.3 1991/12/18 16:02:28 cogito Exp $ */
static char rcs_id[]= "$Id: PopupUtil.c,v 1.3 1991/12/18 16:02:28 cogito Exp $";

/*======================================================================*
 *									*
 *	FILE:		Popup/PopupUtil.c				*
 *									*
 *	DESCRIPTION:	Utilities for Popup windows			*
 *									*
 *	AUTHOR:		Volker Niepel					*
 *									*
 *======================================================================*/

#include "Misc.h"
#include "Main.h"
#include "Popup.h"
#include <X11/StringDefs.h>


/************************************************************************
 *                          GetPopupPositions				*
 ************************************************************************/

/* Computes the x and y positions of a popup window.
 */

PUBLIC void GetPopupPositions (did, x_return, y_return)
	int		did;
	Position	*x_return;
	Position	*y_return;
{
	Widget	w;
	int	x, y;
	Window	child;

      /* Determine the x and y positions of the window and store them in
         the corresponding production entry in ref_tab. The Coordinates
         are determined by using a raw Xlib Call, since this gives the
         correct result in all cases, especially when using a re-parenting
         window manager. */
	if (did == 0)				w = Toplevel;
	else if (ref_tab[did].etag == PROD)	w = PE(did).par->widget;
	else					w = SE(did).sar->widget;

	XTranslateCoordinates (dpy, XtWindow (w),
				RootWindowOfScreen (XtScreen (w)),
				0, 0, &x, &y, &child);

      /* Set the return values */
	*x_return = x + 20;
	*y_return = y + 10;
}
