/* $Id: ligaconsts.h,v 1.6 1992/07/10 13:32:08 cogito Exp $ */
/* $Log: ligaconsts.h,v $
 * Revision 1.6  1992/07/10  13:32:08  cogito
 * SHIELDFCT introduced for expand
 *
 * Revision 1.5  1991/12/16  10:06:34  cogito
 * some modifications for the new Lido2 frontend
 *
 * Revision 1.4  1991/10/29  15:49:37  cogito
 * macro IDFCT added
 *
 * Revision 1.3  1991/09/24  11:19:13  cogito
 * added name of 'WITH' function
 *
 * Revision 1.2  1991/09/11  10:03:03  cogito
 * *** empty log message ***
 * */

/***********************************************************************\
*									*
*	File:		ligaconsts.h					*
*	Contents:	global constants to be used by all LIGA passes	*
*	Author:		Hans-Detlef Siewert				*
*	Creation date:	01 Mar 1991					*
*	Last change:	24 Sep 1991					*
*									*
\***********************************************************************/

#ifndef _ligaconsts_h
#define _ligaconsts_h

/*
** CONSTANTS
*/

/* symbol classes */
#define	SYMBNONT	(0)	/* nonterminal */
#define	SYMBTERM	(1)	/* terminal */

/* attribute classes */
#define	ATCLSYNT	(0)
#define	ATCLINH		(1)
#define	ATCLUNKN	(2)

/* predefined definition-ids */
#define	DIDNON		(0)
#define	FIRSTDID	(1)
#define	DIDVOID		(FIRSTDID)	/* VOID */
#define	DIDVOLI		(FIRSTDID+1)	/* VOID_LIST */
#define	DIDINT		(FIRSTDID+2)
#define	DIDBOOL		(FIRSTDID+3)
#define	DIDSYMB		(FIRSTDID+4)
#define	DIDBIG		(FIRSTDID+5)

/* names of predefined types */
#define	TNVOID		"VOID"
#define	TNVOLI		"VOID_LIST"
#define	TNINT		"INT"
#define	TNBOOL		"BOOL"
#define	TNSYMB		"SYMB"
#define	TNBIG		"BIG"

/* values for fields of Attrdef structure */
	/* storeOfAttrdef */
#define	STORGLVA	(0)	/* store in global variable */
#define	STORGLST	(1)	/* store in global stack */
#define	STORTRAT	(2)	/* store in tree node */
#define	STORUNKN	(3)	/* unknown storage */

	/* genOfAttrdef */
#define	GENORIG		(0)	/* original attribute */
#define	GENINCL		(1)	/* generated while expanding INCLUDING */
#define	GENCONST	(2)	/* generated while expanding CONSTITUENT(S) */
#define	GENCHAIN	(3)	/* generated while expanding CHAIN */

/* special function names */
#define	ASSIGNFCT	"assign"
#define	PUSHFCT		"PUSH"
#define	POPFCT		"POP"
#define	TOPFCT		"TOP"
#define	DEPFCT		"DEP"
#define	ORDERFCT	"ORDER"
#define	IFFCT		"IF"
#define	SWAPFCT		"SWAP"
#define	CLOBFCT		"CLOBBER"
#define	VOIDFCT		"$VOID"
#define	WITHFCT		"$WITH"
#define IDFCT		"$ID"
#define SHIELDFCT	"$SHIELD"
/* !!! assign PUSH POP TOP SWAP CLOBBER must be made internal by a $ */
#endif

/***********************\
* end of ligaconsts.h	*
\***********************/

