/* $Id: GlobDef.c,v 3.2 1992/09/16 15:28:56 cogito Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include "HEAD.h"

int IFid;
int DEPid;
int ORDid;

/*	keys for predefined chain symbols
*/
DefTableKey GramKey;
DefTableKey THISKey;
DefTableKey HEADKey;
DefTableKey TAILKey;
DefTableKey VOIDKey;
DefTableKey SYNTKey;
DefTableKey INHKey;

POSITION nullpos;

int IsPreDefSym (k)
	DefTableKey	k;
{
return ((k == THISKey) || (k == HEADKey) || (k == TAILKey) ||
	(k == VOIDKey) || (k == SYNTKey) || (k == INHKey));
}/* IsPreDefSym */

DefTableKey Declare (scope, id, kind, attrscope, pos)
	Environment	scope;
	int		id;
	int		kind;
	Environment	attrscope;
	POSITION *	pos;
/*
On Exit:
	scope has an entry for id, its key is the result
	of the call.
	If the entry is new, its kind is set, otherwise
	it is checked and possibly set to MultDef.
	For SymDef and RuleDef the attribute scope 
	other properties are initialized.
*/
{	DefTableKey		k;
	int		haskind;
	int		did;
	Environment	sc;

if (scope == NoEnv)
	message (DEADLY, "no scope for definition", 0, pos);

k = DefineIdn (scope, id);

haskind = (int)GetDefKind (k, unDef);
if (haskind == kind) return (k);
if (haskind == unDef) {
	SetDefKind (k, kind, kind);
	did = GenDid ();
	SetDid (k, did, did);
	SetCoord (k, pos, pos);
} else	SetDefKind (k, MultDef, MultDef);
switch (kind) {
case SymDef:
	if (NoEnv == GetAttrScope (k, NoEnv)) {
		sc = NewScope (attrscope);
		SetAttrScope (k, sc, sc);
	}
	SetLowAttrib (k, nullSEQAttrrule (), nullSEQAttrrule ());
	SetUpAttrib (k, nullSEQAttrrule (), nullSEQAttrrule ());
	break;
case RuleDef:
	SetAttrib (k, nullSEQAttrrule (), nullSEQAttrrule ());
	break;
case TypeDef:
	;
default:;
}
return (k);
}/* Declare */


Environment EnvPreDefs (attrscope)
	Environment	attrscope;
/*
On Exit:
	The entries for the predefined types are made.
	The identifiers IFid, DEPid, ORDid are coded.
*/
{	Environment	e;
	DefTableKey	k;
	int	id;
	int	idtoken = 4; /* token class is not relevant here */

e = NewEnv ();

nullpos.line = 0;
nullpos.col = 0;

mkidn(IFFCT, strlen (IFFCT), &idtoken, &IFid);
mkidn(DEPFCT, strlen (DEPFCT), &idtoken, &DEPid);
mkidn(ORDERFCT, strlen (ORDERFCT), &idtoken, &ORDid);

mkidn(TNNODE, strlen (TNNODE), &idtoken, &id);
k = DefineIdn (e, id);
SetDid (k, DIDNODE, DIDNODE);
SetDefKind (k, TypeDef, TypeDef);

mkidn(TNBIG, strlen (TNBIG), &idtoken, &id);
k = DefineIdn (e, id);
SetDid (k, DIDBIG, DIDBIG);
SetDefKind (k, TypeDef, TypeDef);

mkidn(TNSYMB, 4, &idtoken, &id);
k = DefineIdn (e, id);
SetDid (k, DIDSYMB, DIDSYMB);
SetDefKind (k, TypeDef, TypeDef);

mkidn(TNBOOL, 4, &idtoken, &id);
k = DefineIdn (e, id);
SetDid (k, DIDBOOL, DIDBOOL);
SetDefKind (k, TypeDef, TypeDef);

mkidn(TNINT, 3, &idtoken, &id);
k = DefineIdn (e, id);
SetDid (k, DIDINT, DIDINT);
SetDefKind (k, TypeDef, TypeDef);

mkidn(TNVOLI, 9, &idtoken, &id);
k = DefineIdn (e, id);
SetDid (k, DIDVOLI, DIDVOLI);
SetDefKind (k, TypeDef, TypeDef);

mkidn(TNVOID, 4, &idtoken, &id);
k = DefineIdn (e, id);
VOIDKey  = k;
SetDid (k, DIDVOID, DIDVOID);
SetDefKind (k, TypeDef, TypeDef);

mkidn("THIS", 4, &idtoken, &id);
k = Declare (e, id, SymDef, attrscope, &nullpos);
SetDefinedSym (k, true, true);
THISKey = k;

mkidn("HEAD", 4, &idtoken, &id);
k = Declare (e, id, SymDef, attrscope, &nullpos);
SetDefinedSym (k, true, true);
HEADKey  = k;

mkidn("TAIL", 4, &idtoken, &id);
k = Declare (e, id, SymDef, attrscope, &nullpos);
SetDefinedSym (k, true, true);
TAILKey = k;

mkidn("SYNT", 4, &idtoken, &id);
k = Declare (e, id, SymDef, attrscope, &nullpos);
SetAttrClass (k, ATCLSYNT, ATCLSYNT);
SetDefinedSym (k, true, true);
SYNTKey = k;

mkidn("INH", 3, &idtoken, &id);
k = Declare (e, id, SymDef, attrscope, &nullpos);
SetAttrClass (k, ATCLINH, ATCLINH);
SetDefinedSym (k, true, true);
INHKey = k;

k = NewKey ();
GramKey = k;

return (e);
}/*EnvPreDefs*/

void CheckChainSym (symkey, defocc, coord)
	DefTableKey		symkey;
	int		defocc;
	POSITION	*coord;
{
if (defocc) {
	if (symkey == TAILKey)
		message (ERROR, "TAIL must not be defined", 0, coord);
} else {
	if (symkey == HEADKey)
		message (ERROR, "HEAD must not be applied", 0, coord);
}
}/*CheckChainSym*/
