static char RCSid[] = "$Id: csm.c,v 1.2 1992/03/03 12:53:51 uwe Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */

#include <stdio.h>
#include "csm.h"
#include "err.h"
#include "csmtbl.h"


#ifndef NOPRINT

/***/
#if defined(__cplusplus) || defined(__STDC__)
char *
prtstcon(FILE *d, char *p)
#else
char *
prtstcon(d, p)
FILE *d; char *p;
#endif
/* Print a sequence of characters as a string constant without quotes
 *    On exit-
 *       The string pointed to by p has been added to the current
 *          line of d as a string constant without quotes
 *       prtstcon addresses the character following the terminator
 ***/
{
	char c;

	while ((c = *p++ & 0377) != '\0') {
		if (c >= '\177') fprintf(d, "\\%3o", c);
		else if (c == '\\') fprintf(d, "\\\\");
		else if (c == '"') fprintf(d, "\\\"");
		else if (c >= ' ') (void)putc(c, d);
		else switch (c) {
		case '\n': fprintf(d, "\\n"); break;
		case '\t': fprintf(d, "\\t"); break;
		case '\b': fprintf(d, "\\b"); break;
		case '\r': fprintf(d, "\\r"); break;
		case '\f': fprintf(d, "\\f"); break;
		default: fprintf(d, "\\%03o", c); }
	}
	return(p);
}

/**/
#if defined(__cplusplus) || defined(__STDC__) 
void
prtptr(FILE *d, char *p)
#else
void
prtptr(d, p)
FILE *d; char *p;
#endif
/* Print a string pointer
 *    On exit-
 *       The expression defining p has been added to the current
 *          line of file d
 **/
{
	int i;

	for (i = 0; i < numpage; i++) {
		if (p >= page[i] && p < page[i]+used[i]) break;
	}
	fprintf(d, "pg%d+%d", i, p-page[i]);
}

#ifdef SAVE
/***/
#if defined(__cplusplus) || defined(__STDC__) 
void
savestr(FILE *d)
#else
void
savestr(d)
FILE *d;
#endif
/* Save the current string table state
 *    On exit-
 *       File d is a symbolic encoding of the current state, suitable
 *          for inclusion in the string table module
 ***/
{
	char *p;
	int k;

	fprintf(d, "#define MAXSTR %d\n", MAXSTR);
	fprintf(d, "#define PGSIZE %d\n", PGSIZE);
	fprintf(d, "#define MAXPAGE %d\n\n", MAXPAGE);

	for (k = 0; k < numpage; k++) {
		p = page[k];
		fprintf(d, "static char pg%d[PGSIZE]={\"", k);
		while (p < page[k]+used[k]) {
			p = prtstcon(d, p);
			if (p < page[k]+used[k]) fprintf(d, "\\0\\\n");
		}
		fprintf(d, "\"};\n\n");
	}

	fprintf(d, "char *string[MAXSTR]={\n");
	for (k = 0; k < numstr; k++) {
		(void)putc('\t', d); prtptr(d, string[k]);
		if (k < numstr-1) fprintf(d, ",\n");
	}
	fprintf(d, "};\n\n");

	fprintf(d, "int numstr = %d;\n\n", numstr);

	fprintf(d, "static char *page[MAXPAGE]={\n");
	for (k = 0; k < numpage-1; k++) fprintf(d, "\tpg%d,\n", k);
	fprintf(d, "\tpg%d};\n\n", k);

	fprintf(d, "static int used[MAXPAGE]={\n");
	for (k = 0; k < numpage-1; k++) fprintf(d, "\t%d,\n", used[k]);
	fprintf(d, "\t%d};\n\n", used[k]);

	fprintf(d, "static int numpage = %d;\n\n", numpage);
}
#endif

/***/
#if defined(__cplusplus) || defined(__STDC__) 
void
dmpstr(FILE *d)
#else
void
dmpstr(d)
FILE *d;
#endif
/* Dump the string table
 *    On exit-
 *       The string table contents have been written to d
 ***/
{
	int i;

	if (numstr == 0) fprintf(d,"\n String Table is empty");
	else {
		fprintf(d,"\n String Table Contents-\n");
		for (i = 0; i < numstr; i++) {
			fprintf(d, " \"");
			(void) prtstcon(d, string[i]);
			fprintf(d, "\"\n");
		}
	}
	fprintf(d,"\n\n");
}

#endif

/***/
#if defined(__cplusplus) || defined(__STDC__) 
int
stostr(char *c, int l)
#else
int
stostr(c, l)
char *c; int l;
#endif
/* Store a string in the string table
 *    On entry-
 *       c points to the string to be stored
 *       l>0 = length of the string to be stored
 *    On exit-
 *       stostr=string table index of the stored string
 ***/
{
	register char *p, *cr;
	register int lr;
	int k;

	if (numstr == MAXSTR) {
		message(DEADLY,"Max number of strings exceeded",0,&curpos);
	}
	string[numstr] = NULL;

	k = -1;
	do {
		if (++k == numpage) { /* Need a new page */
			if (numpage++ == MAXPAGE) {
				message(DEADLY,"String table overflow",0,&curpos);
			}
			if ((page[k] = (char *)malloc(PGSIZE)) == NULL) {
				message(DEADLY,"Failure storing string",0,&curpos);
			}
			used[k] = 0;
		}
		if (used[k]+l < PGSIZE) { /* Enough space on this page */
			string[numstr] = (p = page[k] + used[k]);
			used[k] += l+1;
			cr = c;
			for (lr = l; lr; lr--) *p++ = *cr++;
			*p = '\0';
		}
	} while (string[numstr] == NULL);
	return(numstr++);
}
