#include <stdio.h>

#if defined(__STDC__) || defined(__cplusplus)
void expand_tabs(FILE *infile, FILE *outfile)
#else
void expand_tabs(infile, outfile)
FILE *infile;
FILE *outfile;
#endif
{
    int c;
    int column = 0;
    
    while ((c = getc(infile)) != EOF)
    {
	if (c == '\t')  
	{
	    do 
	    {
		putc (' ', outfile);
		column++;
	    } while (column % 8 != 0);
	}	
	else 	
	{	
	    putc(c, outfile);
	    if (c != '\n')
	        column++;
	    else
	        column = 0;
	}
    }
}

    
	

#if defined(__STDC__) || defined(__cplusplus)
int main(int argc, char **argv)
#else
int main(argc, argv)
int argc;
char **argv;
#endif
{
    if (argc <= 1) 
    {
	expand_tabs (stdin, stdout);
	return 0;
    }
    else
    {
	FILE *infile;
	
	if (!(infile = fopen(argv[1], "r"))) 
	{
	    fprintf (stderr, "%s: cannot open %s\n", argv[0], argv[1]);
	    return 1;
	}
	else
	{
	    expand_tabs (infile, stdout);
	    fclose (infile);
	    return 0;
	}
    }
}

	
    
