# $Id: Makefile.cpp,v 1.22 1992/10/29 14:27:01 waite Exp $
# Copyright (c) 1991, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

# Default master cache location
DESTDIR	= ELISYS

# Relative pathname for the current directory
DIR	= Tool/eli

COFLAGS	= -q

SRC	= deftbl.c deftbl.h envmod.c envmod.h err.c err.h loaded.c \
	obstack.c obstack.h prop.c prop.h rdsymb.c rdsymb.h \
	symbinfo.c symbinfo.h system.h idn.c idn.h idntbl.h \
	csm.c csm.h csmtbl.h
OBJ	= deftbl.o envmod.o err.o loaded.o obstack.o prop.o rdsymb.o \
	symbinfo.o idn.o csm.o
EXE	= loaded.exe
SYS	= driver.c
XCMD	= definition.cmd exe.view.cmd includes.cmd driver.cmd \
	genlib.cmd usedcode.cmd
GENCMD	= mkfile.cmd exe.cmd cpp_specs.cmd
CMD	= $(GENCMD) $(XCMD)
CPPCMD	= mkfile.cmd.cpp exe.cmd.cpp cpp_specs.cmd.cpp
SRCCMD	= $(CPPCMD) $(XCMD)
AUX	= eli.dg specs.tnf
RCS 	= $(SRC) $(SRCCMD) $(AUX) $(SYS)

#if defined(_AIX)
LIBS	= -lld
#else
#if defined(sgi)
LIBS    = -lmld
#else
#ifdef hpux
LIBS	= -lBSD
#endif
#endif
#endif

TIDY	= core a.out ERRS *.o
CLEAN	= $(TIDY) $(EXE)

all:	$(EXE) $(SRCCMD) $(AUX)
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done

install:
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 644 $(DESTDIR)/$(DIR)/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for f in $(EXE); do \
		echo install -c -m 755 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 755 $(DESTDIR)/$(DIR)/$$f; \
	done
	@for f in $(SYS); do \
		echo install -c -m 644 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 644 $(DESTDIR)/$(DIR)/$$f; \
	done

executable:
	rm -rf $(TIDY) Makefile.cpp $(AUX) $(CPPCMD) $(SRC) Makefile

SourceDistr: $(RCS)

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

loaded.exe:	$(OBJ)
	$(CC) $(CFLAGS) -o loaded.exe $(OBJ) $(LIBS)

csm.o:		csm.h err.h csmtbl.h
deftbl.o:	err.h deftbl.h
envmod.o:	system.h err.h deftbl.h envmod.h
err.o:		system.h err.h
idn.o:		err.h idn.h csm.h idntbl.h
loaded.o:	system.h symbinfo.h obstack.h
obstack.o:	obstack.h
prop.o:		deftbl.h prop.h
rdsymb.o:	symbinfo.h system.h
symbinfo.o:	system.h deftbl.h prop.h envmod.h obstack.h rdsymb.h \
	idn.h
