static char rcsid[] = "$Id: cpp_specs.c,v 1.6 1992/10/30 19:51:44 waite Exp $";
/* Copyright 1991, The Regents of the University of Colorado */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/***/
#if defined(__cplusplus) || defined(__STDC__)
int
main(int argc, char **argv)
#else
int
main(argc,argv)
int argc; char **argv;
#endif
/* Creates a set of file names
 *    On entry-
 *       stdin=cpp-processed .specs file
 *    On exit-
 *       stdout=sequence of complete path names for specified files
 ***/
{
   char line[BUFSIZ], dir[BUFSIZ], *p, *q, *r;

   if (argc != 2) {
      (void)fprintf(stderr, "Usage: %s cache", argv[0]);
      exit(1);
   }

   *dir = '\0';
   while (fgets(line, BUFSIZ, stdin)) {
      p = line + strlen(line) - 1;
      if (*p != '\n') {
         (void)fprintf(stderr, "%s: \"%s\" too long\n", argv[0], line);
         exit(1);
      }
      *p = '\0';
      for (p = line; *p && (*p == ' ' || *p == '\t'); p++) ;
      for (q = p; *q; q++) if (*q != ' ' && *q != '\t') r = q;
      if (p == q) continue;
      r[1] = '\0';
      if (*line == '#') {
         if (line[2] < '0' || line[2] > '9') continue;
         while (*r != '/') r--; r[1] = '\0';
         for (p = line+3; *p && *p != '"'; p++) ;
         if (*p) (void)strcpy(dir, p+1);
         continue;
      }
      if (*p == '/') (void)puts(p);
      else if (*p == '$') (void)printf("%s%s\n", argv[1], p+1);
      else (void)printf("%s%s\n", dir, p);
   }

   return 0;
}
