/*
** $Id: filter.c,v 1.2 90/10/23 14:41:31 cogito Exp $
*/
static char rcs_id[]= "$Id: filter.c,v 1.2 90/10/23 14:41:31 cogito Exp $";

/***********************************************************************
 **
 **   Filename   :  filter.c
 **
 **   Author     :  Ursula Stellmacher
 **
 **   Date       :  12.11.88
 **
 **   Last change:  12.11.88
 **
 **   Task       : contains functions for deleting and appending the empty string

 **
 **********************************************************************/



#include <stdio.h>
#include "comar.h"
#include "errandio.h"
#include "filter.h"


/***********************************************************************
 **
 **  function   : get_did 
 **
 **  task       : yields the DID for a given SID
 **
 **  return     : INT (DID) 
 **
**********************************************************************/

PRIVATE int get_did ( root , sid )
 
p_comar root;
int sid;
 
{
     SEQdef_entry sdef;
     def_entry def;
	      
     foreachinSEQdef_entry( root->definitions , sdef , def )
     {
       /*
        * ' ' is  a terminal
        */

         if ( typeof( def ) == Kp_term )
         {
             if ( def.Vp_term->sid == sid )
	     {
	        return(def.Vp_term->did);
	     }
	 }
     }
     return(0);                  
	  
} /* end of get_did */

/***********************************************************************
 **
 **  function   : recappendEmpty 
 **
 **  task       : inserts the string '' recursivly in all empty lists
 **
 **  return     : void 
 **
**********************************************************************/

PRIVATE void recappendEmpty ( root , seq )

p_comar root;
SEQunit *seq;
 
{
    SEQunit sunit;
    unit unit1,newunit;
    int did;

    /*
     * insertion of the empty string
     */

     if ( lengthSEQunit( *seq ) == 0 )
     {
       	newunit.Vp_elunit = Np_elunit;
        newunit.Vp_elunit->did = get_did( root , S_EMPTY );

        appendfrontSEQunit( *seq , newunit );
      }
      else
      {
	 foreachinSEQunit( *seq , sunit , unit1 )
         {
             switch ( typeof( unit1 ) )
             {
	        case Kp_alt    : recappendEmpty( root , &(unit1.Vp_alt->rhs1) );
	                         recappendEmpty( root , &(unit1.Vp_alt->rhs2) );
			         break;
                case Kp_opt    : recappendEmpty( root , &(unit1.Vp_opt->rhs) );
                                 break;

                case Kp_plus   : recappendEmpty( root , &(unit1.Vp_plus->rhs) );
	                         break;

                case Kp_star   : recappendEmpty( root , &(unit1.Vp_star->rhs) );
				 break;

                case Kp_delrep : recappendEmpty( root , &(unit1.Vp_delrep->rhs) );
				 recappendEmpty( root , &(unit1.Vp_delrep->sep) );
				 break;

                case Kp_elunit : break;

            } /* end of switch */
        }
    }
} /* end of recappendEmpty */

/***********************************************************************
 **  function   : appendEmpty 
 **
 **  task       : generates an element for the empty string and inserts
 **               it in all empty lists
 **
 **  return     : void 
 **
**********************************************************************/

PUBLIC void appendEmpty(root)

p_comar root;

{
   SEQdef_entry sdef;
   def_entry def;
   def_entry newdef;

   int did;

   did = get_did( root , S_EMPTY );

   if ( did == 0 )
   {
     /*
      * No element for the empty string occurs in the definition
      * table. It will be inserted.
      */

       newdef.Vp_term = Np_term;
       retrievelastSEQdef_entry( root->definitions , def );
       newdef.Vp_term->did = def.IDLclassCommon->did + 1;
       newdef.Vp_term->sid = S_EMPTY;
       appendrearSEQdef_entry( root->definitions , newdef );
    }
    foreachinSEQdef_entry( root->definitions , sdef , def )
    {
       if ( typeof( def ) == Kp_prod )
       {
	  recappendEmpty( root , &(def.Vp_prod->rhs) );
       }
    }
} /* end of appendEmpty */


/***********************************************************************
 **
 **  function   : get_sid 
 **
 **  task       : yields the SID for a given DID
 **
 **  return     : int (SID) 
 **
 **********************************************************************/

PRIVATE int get_sid ( root , did )

p_comar root;
int did;
 
{
     SEQdef_entry sdef;
     def_entry def;
    

     foreachinSEQdef_entry( root->definitions , sdef , def )
     {
	/*
	 * '' is terminal
         */

    	if ( typeof( def ) == Kp_term )
    	{
           if ( def.Vp_term->did == did )
           {
              return(def.Vp_term->sid);
           }
        }
    }
    return(0);			

} /* end of get_sid */


/***********************************************************************
 **
 **  function   : recremoveEmpty 
 **
 **  task       : deletes recursively the empty entries
 **
 **  return     : void 
 **
 **********************************************************************/

PRIVATE void recremoveEmpty ( root , seq )

p_comar root;
SEQunit *seq;

{
    SEQunit sunit;
    unit unit1;
       

    foreachinSEQunit( *seq , sunit , unit1 )
    {
    	switch ( typeof( unit1 ) )
    	{
           case Kp_alt    : recremoveEmpty( root , &(unit1.Vp_alt->rhs1) );
                            recremoveEmpty( root , &(unit1.Vp_alt->rhs2) );
			    break;
                     
           case Kp_opt    : recremoveEmpty( root , &(unit1.Vp_opt->rhs) );
			    break; 
                    		
           case Kp_plus   : recremoveEmpty( root , &(unit1.Vp_plus->rhs) );
			    break;
      
           case Kp_star   : recremoveEmpty( root , &(unit1.Vp_star->rhs) );
			    break;
  
           case Kp_delrep : recremoveEmpty( root , &(unit1.Vp_delrep->rhs) );
                            recremoveEmpty( root , &(unit1.Vp_delrep->sep) );
			    break;
           
           case Kp_elunit : if ( get_sid( root , unit1.Vp_elunit->did ) == S_EMPTY )
                            {
			     /*
			      * deleting of the empty entries
			      */

                       	         removeSEQunit( *seq , unit1 );
                            }
			    break;
        }
  }                   
                             
} /* end of recremoveEmpty */


/***********************************************************************
 **  function   : removeEmpty 
 **
 **  task       :  deletes the empty entries
 **
 **  return     : void 
 **
 **********************************************************************/

PUBLIC void removeEmpty ( root )

p_comar root;

{
      SEQdef_entry sdef;
      def_entry def;

          foreachinSEQdef_entry( root->definitions , sdef , def )
          {
             if ( typeof( def ) == Kp_prod )
       	     {
       	         recremoveEmpty(  root , &(def.Vp_prod->rhs)  );
       	     }
          }	       	                 
} /* end of removeEmpty */
