/*
** $Id: ccomar.c,v 1.3 90/11/14 10:23:21 cogito Exp Locker: cogito $
*/
static char rcs_id[]= "$Id: ccomar.c,v 1.3 90/11/14 10:23:21 cogito Exp Locker: cogito $";

/* ccomar.c - COMAR internal data structures and creation functions
              based on IDL near to Plummer's implementation
 *
 *	Author: Karl Prott
 *              University of Paderborn
 * Last Change: 16.02.90	From: Kalle
 */


#include <stdio.h>
#include <string.h>

#include "ccomar.h"
#include "comar_func.h"                                                                                      
/* SECTION 2. COMAR structure definitions. */

/* return maximum SID in COMAR structure */
SID cmr_get_maxsid(c)
p_comar    c;
{
    symb_entry symb;

    if (c == (p_comar)NULL)
	return(CMR_UNKERR);
    if ( emptySEQsymb_entry(c->symbols) )
        return(0);
    retrievelastSEQsymb_entry(c->symbols,symb);
    return(symb.IDLclassCommon->sid);
}


/* return maximum DID in COMAR structure */
DID cmr_get_maxdid(c)
p_comar    c;
{
    def_entry  def;

    if (c == (p_comar)NULL)
	return(CMR_UNKERR);
    if ( emptySEQdef_entry(c->definitions) )
        return(0);
    retrievelastSEQdef_entry(c->definitions,def);
    return(def.IDLclassCommon->did);
}




/* SECTION 3. Creating and initializing new COMAR components. */

/* Return new empty COMAR structure */
p_comar cmr_new_structure()
{ 
  p_comar      c ;
  int         tag;

  c = Np_comar;
  initializeSEQsymb_entry(c->symbols);
  initializeSEQdef_entry(c->definitions);

  /* initialize symbol part with pre-defined symbols */
  cmr_new_symb_entry(c,P_NAME,"#");
  cmr_new_symb_entry(c,P_STRING,"");
  return(c);
}		/* cmr_new_structure */


/* Symbol part: */

SID cmr_new_symb_entry(c, tag, str)
p_comar c;
int tag;
String str;
{
  SID             sid ;
  SEQsymb_entry travel;
  symb_entry     symb ;

  foreachinSEQsymb_entry(c->symbols,travel,symb)
  {
    if ( typeof(symb) == tag   &&  ! strcmp(symb.IDLclassCommon->str, str) )
      return(symb.IDLclassCommon->sid);
  }
  
  sid = cmr_get_maxsid(c)+1;
  if (tag == P_STRING)
    symb.Vp_string = Np_string;
  else symb.Vp_name = Np_name;
  symb = Mksymb_entry(sid,str,symb);
  appendrearSEQsymb_entry(c->symbols, symb);
  return(sid);
}		/* cmr_new_symb_entry */




/* Definition part: */

DID cmr_new_def_entry(c, tag, sid)
p_comar   c;
int     tag;
SID     sid;
{
  DID           did;
  def_entry     def;
  SEQprop_entry prop;

  did = cmr_get_maxdid(c)+1;
  switch(tag)
    { case  P_TERM : def.Vp_term = Np_term;
                      break;
      case P_NTERM : def.Vp_nterm = Np_nterm;
                      break;
      case P_OTHER : def.Vp_other = Np_other;
                      break;
      default       : 
        fprintf(stderr,"COMAR:unknown tag in the call of cmr_new_def_entry.");
                      exit(1);
    }
  initializeSEQprop_entry(prop);
  def = Mkdef_entry(did,sid,prop,def);
  appendrearSEQdef_entry(c->definitions, def);
  return(did);
}		/* cmr_new_def_entry */


DID cmr_new_prod(c, sid, lhs, rhs)
p_comar   c;
SID     sid;
DID     lhs;
SEQunit rhs;
{
  DID           did;
  def_entry     def;
  SEQprop_entry prop;

  did = cmr_get_maxdid(c)+1;
  initializeSEQprop_entry(prop);
  def.Vp_prod = Mkp_prod(lhs,rhs);
  def = Mkdef_entry(did,sid,prop,def);
  appendrearSEQdef_entry(c->definitions, def);
  return(did);
}		/* cmr_new_prod */


/* Property part: */

DID cmr_new_prop(c, did, sid) 
p_comar c;
DID did;
SID sid;
{
  SEQdef_entry  travel;
  def_entry   def;
  prop_entry  prop;

  foreachinSEQdef_entry(c->definitions,travel,def)
  { if (def.IDLclassCommon->did == did)
      { if (cmr_get_prop(c,did,sid) == NULL)
          { prop.Vp_prop = Np_prop;
	    prop = Mkprop_entry(did,sid,prop);
            appendfrontSEQprop_entry(def.IDLclassCommon->prop, prop);
          }
        return(did);
      }
  }
    return(CMR_UNKERR);
}		/* cmr_new_prop */


DID cmr_new_prop_val(c, did, sid, val) 
p_comar	c;
DID 	did;
SID 	sid;
Gen_val	val;
{
  SEQdef_entry  travel;
  def_entry   def;
  prop_entry  prop;
  value	valhelp;

  valhelp.IDLinternal = (int)val;
  foreachinSEQdef_entry(c->definitions,travel,def)
  { if (def.IDLclassCommon->did == did)
      { if (cmr_get_prop_val(cmr_get_prop(c,did,sid)) == NULL)
          { prop.Vp_prop_val = Mkp_prop_val(valhelp);
	    prop = Mkprop_entry(did,sid,prop);
            appendfrontSEQprop_entry(def.IDLclassCommon->prop, prop);
          }
        return(did);
      }
  }
  return(CMR_UNKERR);
}		/* cmr_new_prop_val */



/* SECTION 4. Building COMAR subtrees "bottom-up". */


/* SECTION 5. Manipulating COMAR lists. */

/* List management: */

/* Return concatenation of second list to end of first */
pGenList cmr_cat_lists(list1, list2)
pGenList list1, list2;
{
    pGenList  travel;

    if (list1 == NULL)  return(list2); 
    if (list2 == NULL)  return(list1); 
 
    for (travel = list2; travel != NULL; travel = travel->next)
    {   list1 = IDLListAddRear(list1,IDLListRetrieveFirst(travel));   }

    return(list1);
}               /* cmr_cat_items */

/* THIS ROUTINE WAS INSERTED BY PA ON DECEMBER 2nd and implemented with IDL
 * by Kalle.
 */
/* returns lists2 with list1 spliced in after! item in lists2 addressed by p 
 */
pGenList cmr_splice_lists(list1, list2, p)
pGenList list1, list2;
Gen_class   p;
{
  pGenList  travel, breakpoint;

  for (travel=list2;
       travel!=(pGenList)NULL && travel->value!=(int)p;
       travel=travel->next
      );
  if ( travel != (pGenList)NULL )
  {
    breakpoint = travel->next;
    travel->next = list1;
    for (travel=list1; travel->next!=(pGenList)NULL; travel=travel->next)
    ;
    travel->next = breakpoint;
  }

  return(list2);
}


/* THIS ROUTINE WAS INSERTED BY PA ON DECEMBER 10th and implemented with IDL
 * by Kalle.
 */
/* splits list after specified item and returns splitted list */
pGenList cmr_split_list(list, p)
pGenList list;
Gen_class   p;
{
  pGenList  travel, breakpoint;

  for (travel=list;
       travel!=(pGenList)NULL && travel->value!=(int)p;
       travel=travel->next
      );
  if ( travel == (pGenList)NULL ) return((pGenList)NULL);
  breakpoint = travel->next;
  travel->next = (pGenList)NULL;

  return(breakpoint);
}



/* SECTION 6. Deleting COMAR components and subtrees. */

/* Delete all elements of an arbitrary list  */
p_comar cmr_del_list(list)
pGenList  list;
{
  pGenList  travel;

  for (travel=list; travel!=NULL; travel=travel->next)
     cmr_del_subtr(travel->value);

  return( (p_comar)NULL );
}

/* Delete an arbitrary subtree */
p_comar  cmr_del_subtr(tree)
Gen_class tree;
{
  unit	t;
  prop_entry p;
  value	v;

    t.IDLinternal = (int)tree;
    p.IDLinternal = (int)tree;
    v.IDLinternal = (int)tree;

    switch(typeof(t))
    {
	case P_ALT:
            cmr_del_list(t.Vp_alt->rhs1);
            cmr_del_list(t.Vp_alt->rhs2);
            Dp_alt(t.Vp_alt);
	    break;
	case P_OPT:
            cmr_del_list(t.Vp_opt->rhs);
            Dp_opt(t.Vp_opt);
	    break;
	case P_PLUS:
            cmr_del_list(t.Vp_plus->rhs);
            Dp_plus(t.Vp_plus);
	    break;
	case P_STAR:
            cmr_del_list(t.Vp_star->rhs);
            Dp_star(t.Vp_star);
	    break;
	case P_DELREP:
            cmr_del_list(t.Vp_delrep->rhs);
            cmr_del_list(t.Vp_delrep->sep);
            Dp_delrep(t.Vp_delrep);
	    break;
	case P_ELUNIT:
            Dp_elunit(t.Vp_elunit);
	    break;
	case P_PROP:
            Dp_prop(p.Vp_prop);
	    break;
	case P_PROP_VAL:
	    cmr_del_subtr( p.Vp_prop_val->val.IDLinternal );
            Dp_prop_val(p.Vp_prop_val);
	    break;
	case P_SVAL:
            Dp_sval(v.Vp_sval);
	    break;
	case P_NVAL:
            Dp_nval(v.Vp_nval);
	    break;
	case P_DVAL:
            Dp_dval(v.Vp_dval);
	    break;
	case P_LVAL:
	    cmr_del_list(v.Vp_lval->list);
            Dp_lval(v.Vp_lval);
	    break;
	}
      return( (p_comar)NULL );
}	 	/* cmr_del_subtr */


/* Delete definition given by did. */
p_comar cmr_del_def_entry(c, did)
p_comar c; 
DID did;
{
    SEQdef_entry t;
    def_entry  def;

    foreachinSEQdef_entry(c->definitions,t,def)
    { if (def.IDLclassCommon->did == did)
        { cmr_del_list(def.IDLclassCommon->prop);
          if ( typeof(def) == P_PROD )  cmr_del_list(def.Vp_prod->rhs);
            removeSEQdef_entry(c->definitions,def);
          break;
        }
    }

    return(c);

}		/* cmr_del_def_entry */


/* Delete property identified by sid, held by did. */
p_comar cmr_del_prop_entry(c, did, sid)
p_comar c; 
DID did; 
SID sid;
{
    SEQdef_entry t1;     SEQprop_entry t2;
    def_entry  def;      prop_entry  prop;  

    foreachinSEQdef_entry(c->definitions,t1,def)
    { if (def.IDLclassCommon->did == did)
        { foreachinSEQprop_entry(def.IDLclassCommon->prop,t2,prop)
          { if (prop.IDLclassCommon->sid == sid)
              { if (typeof(prop) == P_PROP_VAL)  
                  cmr_del_subtr( prop.Vp_prop_val->val.IDLinternal );
                removeSEQprop_entry(def.IDLclassCommon->prop,prop);
                break;
              }
          }
          break;
        }
    }

    return(c);

}		/* cmr_del_prop_entry */



/* SECTION 7. Fetching COMAR attributes of COMAR components. */

/* return tag of any COMAR node */
int cmr_get_tag(item)
Gen_class item;
{
  unit	help;	/* Here 'unit' represents all possible union-types  */
		/* 'symb_entry', 'def_entry', 'prop_entry', 'value' */
		/* and 'unit' */
  help.IDLinternal = (int)item;
  return(typeof(help));
}


/* return COMAR attributes of symb_entry identified by SID */
String cmr_get_symb_entry_sym(c, sid)
p_comar  c; 
SID sid;
{
  symb_entry symb;

  ithinSEQsymb_entry(c->symbols,sid,symb);
  if (symb.IDLclassCommon == NULL) return(NULL);
  return(symb.IDLclassCommon->str);
}


int cmr_get_symb_entry_tag(c, sid)
p_comar  c; 
SID sid;
{
  symb_entry symb;

  ithinSEQsymb_entry(c->symbols,sid,symb);
  if (symb.IDLclassCommon == NULL) return(CMR_UNKERR);
  return(typeof(symb));
}


/* return SID of symb_entry identified by SYM */
SID cmr_get_symb_entry_sid(c, str)
p_comar  c; 
String str;
{
  SEQsymb_entry travel;
  symb_entry     symb ;

  foreachinSEQsymb_entry(c->symbols,travel,symb)
  { if (symb.IDLclassCommon->str == str)
      return(symb.IDLclassCommon->sid);
  }
  return(CMR_UNKERR);
}


/* return COMAR attributes of def_entry identified by DID */
SID cmr_get_def_entry_sid(c, did)
p_comar  c; 
DID did;
{
  SEQdef_entry travel;
  def_entry     def ;

  foreachinSEQdef_entry(c->definitions,travel,def)
  { if (def.IDLclassCommon->did == did)
      return(def.IDLclassCommon->sid);
  }
  return(CMR_UNKERR);
}


int cmr_get_def_entry_tag(c, did)
p_comar  c; 
DID did;
{
  SEQdef_entry travel;
  def_entry     def ;

  foreachinSEQdef_entry(c->definitions,travel,def)
  { if (def.IDLclassCommon->did == did)
      return(typeof(def));
  }
  return(CMR_UNKERR);
}


DID cmr_get_prod_lhs(c, did)
p_comar  c; 
DID did;
{
  SEQdef_entry travel;
  def_entry     def ;

  foreachinSEQdef_entry(c->definitions,travel,def)
  { if (def.IDLclassCommon->did == did)
      if  (typeof(def) == P_PROD)
        return(def.Vp_prod->lhsdid);
      else return(CMR_UNKERR);
    else;
  }
  return(CMR_UNKERR);
}


/* return elem did of an elunit subtree node */
DID cmr_get_elunit_elem(elu)
Gen_unit elu; 
{
  unit elunit;

  elunit.IDLinternal = (int)elu;
  if (typeof(elunit) == P_ELUNIT ) 
    return(elunit.Vp_elunit->did);
  else return(CMR_UNKERR);
}


/* return units of a production definition */
SEQunit  cmr_get_prod_units(c, did)
p_comar  c; 
DID did;
{
  SEQdef_entry travel;
  def_entry     def ;

  foreachinSEQdef_entry(c->definitions,travel,def)
  { if (def.IDLclassCommon->did == did)
      if  (typeof(def) == P_PROD)
        return(def.Vp_prod->rhs);
      else return(NULL);
  }
  return(NULL);
}


/* return list of all properties of definition identified by did. */
SEQprop_entry  cmr_get_prop_entries(c, did)
p_comar  c; 
DID did;
{
  SEQdef_entry travel;
  def_entry     def ;

  foreachinSEQdef_entry(c->definitions,travel,def)
  { if (def.IDLclassCommon->did == did)
      return(def.IDLclassCommon->prop);
  }
  return(NULL);
}


/* return ptr. to 1st property of def.; modifications will be permanent */
Gen_prop cmr_get_first_prop(c, did)
p_comar  c; 
DID did;
{
  SEQdef_entry travel;
  def_entry      def ;
  prop_entry    prop ;

  foreachinSEQdef_entry(c->definitions,travel,def)
  { 
    if (def.IDLclassCommon->did == did)
     { 
       if emptySEQprop_entry(def.IDLclassCommon->prop)
         return(NULL);
       else { 
              retrievefirstSEQprop_entry(def.IDLclassCommon->prop,prop);
              return(prop.Vp_prop);
            }
     }
  }
  return(NULL);
}


/* return ptr. to next property of def; modifications will be permanent */
Gen_prop cmr_get_next_prop(c, did, p)
p_comar  c; 
DID did; 
Gen_prop p;
{
  SEQdef_entry travel  ; def_entry    def ;
  SEQprop_entry travel2; prop_entry  prop2;
  Boolean   found;
  prop_entry  prop;

  prop.IDLinternal = (int)p;
  found = FALSE;
  foreachinSEQdef_entry(c->definitions,travel,def)
  { if (def.IDLclassCommon->did == did)
       { foreachinSEQprop_entry(def.IDLclassCommon->prop,travel2,prop2)
         { if (found)
             return(prop2.Vp_prop);
           else if (typeof(prop) == typeof(prop2) && 
                   (prop.IDLclassCommon->sid == prop2.IDLclassCommon->sid))
                  found = TRUE;
         }
         return(NULL);
       }
  }
  return(NULL);
}


/* the next four functions are taken from newcomar */

Gen_prop cmr_get_prop(c, did, sid)
p_comar  c;
DID did;
SID sid;
{
  SEQdef_entry  travel1;  def_entry     def ;
  SEQprop_entry travel2;  prop_entry    prop;

  foreachinSEQdef_entry(c->definitions,travel1,def)
  { 
   if (def.IDLclassCommon->did == did)
      { 
        foreachinSEQprop_entry(def.IDLclassCommon->prop,travel2,prop)
        { 
         if (prop.IDLclassCommon->sid == sid)
            return(prop.Vp_prop);
        }
        return(NULL);
      }
  }
  return(NULL);
}		/* cmr_get_prop */


SID cmr_get_prop_sid(prop)
Gen_prop	prop;
{
  prop_entry p;


  p.IDLinternal = (int)prop;
  if ( typeof(p) != P_PROP && typeof(p) != P_PROP_VAL )
    return(CMR_UNKERR);
  else  return(p.IDLclassCommon->sid);
}


int cmr_get_prop_tag(prop)
Gen_prop	prop;
{
  prop_entry p;

  p.IDLinternal = (int)prop;
  if ( typeof(p) != P_PROP && typeof(p) != P_PROP_VAL )
    return(CMR_UNKERR);
  else  return( typeof(p) );
}


Gen_val cmr_get_prop_val(prop)
Gen_prop	prop;
{
  prop_entry p;

  p.IDLinternal = (int)prop;
  if ( typeof(p) != P_PROP_VAL )
    return(NULL);
  else  return( p.Vp_prop_val->val.Vp_sval );
}




/* SECTION 8. Storing new attribute values to COMAR attributes. */

/* Set SID of def_entry identified by DID */
p_comar  cmr_set_def_entry_sid(c, did, sid)
p_comar  c; 
DID did; 
SID sid;
{
  SEQdef_entry travel;
  def_entry     def ;

  foreachinSEQdef_entry(c->definitions,travel,def)
  { if (def.IDLclassCommon->did == did)
      { def.IDLclassCommon->sid = sid;
        return(c);
      }
  }
  return(NULL);
}


/* Set components of a production definition */

p_comar  cmr_set_prod_lhs(c, did, lhs)
p_comar  c; 
DID did, lhs;
{
  SEQdef_entry travel;
  def_entry     def ;

  foreachinSEQdef_entry(c->definitions,travel,def)
  { if (def.IDLclassCommon->did == did)
      { if ( typeof(def) == P_PROD )
          { def.Vp_prod->lhsdid = lhs;
            return(c);
          }
        else return(NULL);
      }
  }
  return(NULL);
}


p_comar  cmr_set_prod_units(c, did, units)
p_comar  c; 
DID did; 
SEQunit units;
{
  SEQdef_entry travel;
  def_entry     def ;

  foreachinSEQdef_entry(c->definitions,travel,def)
  { if (def.IDLclassCommon->did == did)
      { if ( typeof(def) == P_PROD )
          { cmr_del_list(def.Vp_prod->rhs);
            def.Vp_prod->rhs = units;
            return(c);
          }
        else return(NULL);
      }
  }
  return(NULL);
}


/* set subtree of subtree node of specified type */

p_alt  cmr_set_alt_units1(un, units1)
Gen_unit  un;
SEQunit units1;
{
  unit  alt;

  alt.IDLinternal = (int)un;
  if ( typeof(alt) != P_ALT ) return(NULL);
  cmr_del_list(alt.Vp_alt->rhs1);
  alt.Vp_alt->rhs1 = units1;
  return(alt.Vp_alt);
}


p_alt  cmr_set_alt_units2(un, units2)
Gen_unit  un;
SEQunit units2; 
{
  unit  alt;

  alt.IDLinternal = (int)un;
  if ( typeof(alt) != P_ALT ) return(NULL);
  cmr_del_list(alt.Vp_alt->rhs2);
  alt.Vp_alt->rhs2 = units2;
  return(alt.Vp_alt);
}


p_opt  cmr_set_opt_units(un, units)
Gen_unit  un;
SEQunit units;
{
  unit	opt;

  opt.IDLinternal = (int)un;
  if ( typeof(opt) != P_OPT ) return(NULL);
  cmr_del_list(opt.Vp_opt->rhs);
  opt.Vp_opt->rhs = units;
  return(opt.Vp_opt);
}


p_plus  cmr_set_plus_units(un, units)
Gen_unit  un;
SEQunit units; 
{
  unit	plus;

  plus.IDLinternal = (int)un;
  if ( typeof(plus) != P_PLUS ) return(NULL);
  cmr_del_list(plus.Vp_plus->rhs);
  plus.Vp_plus->rhs = units;
  return(plus.Vp_plus);
}


p_star  cmr_set_star_units(un, units)
Gen_unit  un;
SEQunit units;
{
  unit	star;

  star.IDLinternal = (int)un;
  if ( typeof(star) != P_STAR ) return(NULL);
  cmr_del_list(star.Vp_star->rhs);
  star.Vp_star->rhs = units;
  return(star.Vp_star);
}


p_delrep  cmr_set_delrep_units1(un, units1)
Gen_unit  un;
SEQunit units1;
{
  unit	delrep;

  delrep.IDLinternal = (int)un;
  if ( typeof(delrep) != P_DELREP ) return(NULL);
  cmr_del_list(delrep.Vp_delrep->rhs);
  delrep.Vp_delrep->rhs = units1;
  return(delrep.Vp_delrep);
}


p_delrep  cmr_set_delrep_units2(un, units2)
Gen_unit  un;
SEQunit units2;
{
  unit	delrep;

  delrep.IDLinternal = (int)un;
  if ( typeof(delrep) != P_DELREP ) return(NULL);
  cmr_del_list(delrep.Vp_delrep->sep);
  delrep.Vp_delrep->sep = units2;
  return(delrep.Vp_delrep);
}


p_elunit  cmr_set_elunit_elem(un, elem)
Gen_unit  un;
DID elem;
{
  unit	elunit;

  elunit.IDLinternal = (int)un;
  if ( typeof(elunit) != P_ELUNIT ) return(NULL);
  elunit.Vp_elunit->did = elem;
  return(elunit.Vp_elunit);
}


p_comar  cmr_set_prop_val(c, did, sid, v)
p_comar  c; 
DID did; 
SID sid; 
Gen_val v;
{
  prop_entry  prop;
  value val;

  val.IDLinternal = (int)v;
  if ( (prop.Vp_prop = cmr_get_prop(c,did,sid)) != NULL )
    if ( typeof(prop) == P_PROP_VAL )
      { 
        cmr_del_subtr(prop.Vp_prop_val->val.IDLinternal);
        prop.Vp_prop_val->val = val;
        return(c);
      }
  return(NULL);
}		/* cmr_set_prop_val */


p_sval cmr_set_sval_sid(v, sid)
Gen_val v;
SID sid;
{
  value sval;

  sval.IDLinternal = (int)v;
  if ( typeof(sval) != P_SVAL ) return(NULL);
  sval.Vp_sval->sid = sid;
  return(sval.Vp_sval);
}


p_nval cmr_set_nval_val(v, val)
Gen_val v;
int val;
{
  value nval;

  nval.IDLinternal = (int)v;
  if ( typeof(nval) != P_NVAL ) return(NULL);
  nval.Vp_nval->val = val;
  return(nval.Vp_nval);
}


p_dval cmr_set_dval_did(v, did)
Gen_val v;
DID did;
{
  value dval;

  dval.IDLinternal = (int)v;
  if ( typeof(dval) != P_DVAL ) return(NULL);
  dval.Vp_dval->did = did;
  return(dval.Vp_dval);
}


p_lval cmr_set_lval_list(v, list)
Gen_val v;
SEQvalue  list;
{
  value lval;

  lval.IDLinternal = (int)v;
  if ( typeof(lval) != P_LVAL ) return(NULL);
  cmr_del_list(lval.Vp_lval->list);
  lval.Vp_lval->list = list;
  return(lval.Vp_lval);
}


