/*
** $Id: lr0forpurdom.h,v 1.2 90/10/23 13:36:29 cogito Exp $
*/

/***************************************************************************/
/* File: lr0forpurdom.h	First Edit: 19.04.89	  Last Edit: 24.04.89      */
/*									   */
/* Author: Karl-Josef Prott,	University at Paderborn, Germany	   */
/*									   */
/* Last Change:	??.04.89	From: Karl-Josef Prott			   */
/***************************************************************************/

/* This file is only written for "purdom.c" to export 
 * macros, variables and functions also used by "purdom.c".
 * They are very special and not of global interest.
 */

/* global variables */
extern	unsigned short	*ADDED;		/* dynamic boolean array indexed by
				 	 * nonterminals  */
extern	Indextype	*ADDEDSTACK;	/* stack of indices i with
					 * ADDED[i] == TRUE */
extern	Indextype	TOP;		/* auxiliary to stack ADDEDSTACK */

extern	unsigned short	MAXITEMNO;	/* maximum number of items in a
					 * state: main it. + derived it. */


/********** macro- and function-declarations **********/

/* routines for ADDED and ADDEDSTACK */
#define	topadded()	(ADDEDSTACK[TOP])
#define pushadded(el)	(ADDEDSTACK[++TOP] = el)
#define popadded()	(--TOP)
#define emptyadded()	(!TOP)

extern	void	createadded(/*  */);
extern	void	freeadded(/*  */);

