
#include <stdio.h>
#ifndef MACH
#include <malloc.h>
#else
extern void *malloc(unsigned);
extern void free(void *);
#endif
#include "ptg_gen.h"

#if defined(__STDC__) || defined (__cplusplus)
static void _PrPTGNULL(_PPTG0 n)
#else
static void _PrPTGNULL(n)
_PPTG0 n;
#endif
{(void)n; /* function printing nothing */}

struct _SPTG0   _PTGNULL = { _PrPTGNULL };

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOut (PTGNode r)
#else
PTGNode PTGOut (r)
PTGNode r;
#endif
{
  f = stdout;
  if (r) {
     (* (r->_print)) (r);
     fputs("\n", f);
  }
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFile (char *fn, PTGNode r)
#else
PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
#endif
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: PTGOutFile: output file '%s' can't be opened.\n",fn);
	exit(1);
  }
  if (r) {
    (* (r->_print)) (r);
    fputs("\n", f);
  }
  fclose(f);
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFPtr(FILE *fptr, PTGNode r)
#else
PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
#endif
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: PTGOutFPtr: output file not open.\n");
    exit(1);
  }
  if (r) {
    (* (r->_print)) (r);
    fputs("\n", f);
  }
  return (r);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGTOPT_RDS(_PPTG0 n)
#else
static void _PrPTGTOPT_RDS(n)
_PPTG0 n;
#endif
{
  fputs ("/* the Row Displacement Scheme is performed for the terminal-table */\n\
\n\
#define SIGMAP(row , col) (sigmap[row][col >> 3] >> (col & 0x0007)) & 0x01\n\
\n\
#define GET_TTABENTRY( RorS, Act, term ) \\\n\
\t{\\\n\
\t  register    U_SHORT j;\\\n\
\t  j = conv[ term ]; \\\n\
\t  if( SIGMAP( sigrowind[RorS], sigcolind[j] ) )  { \\\n\
\t    j = ttab[ trowptr[RorS] + j ]; \\\n\
\t    Act  = j & ACTIONMASK; \\\n\
\t    RorS = j & OPERANDMASK; \\\n\
\t  }\\\n\
\t  else \\\n\
\t    Act  = 0; \\\n\
\t}\n\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNOPT_RDS(_PPTG0 n)
#else
static void _PrPTGNOPT_RDS(n)
_PPTG0 n;
#endif
{
  fputs ("/* the Row Displacement Scheme is performed for the nonterminal-table */\n\
\n\
#define GET_NTABENTRY(RorS, Act, State, lhsnt) \\\n\
\t{\\\n\
\t  register      U_SHORT j;\\\n\
\t  j = ntab[ nrowptr[State] + lhsnt ]; \\\n\
\t  Act = j & ACTIONMASK; \\\n\
\t  RorS = j & OPERANDMASK; \\\n\
\t}\n\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGTOPT_RCSA(_PPTG0 n)
#else
static void _PrPTGTOPT_RCSA(n)
_PPTG0 n;
#endif
{
  fputs ("/* The simple Row Column Scheme is performed for the terminal-table */\n\
\n\
#define GET_TTABENTRY( RorS, Act, term ) \\\n\
\t{ \\\n\
\t  register unsigned int\ti,j,k; \\\n\
\t  Act  = 0; \\\n\
\t  k = tbase[(RorS) + 1];\\\n\
\t  for( i = tbase[RorS]; i < k; i++ ) { \\\n\
\t       if((ttab[i] & 0x0000FFFF) == term )  { \\\n\
\t           j = ttab[i] >> 16; \\\n\
\t           Act  = j & ACTIONMASK; \\\n\
\t           RorS = j & OPERANDMASK; \\\n\
\t           break; \\\n\
\t       } \\\n\
\t  }\\\n\
\t}\n\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNOPT_RCSA(_PPTG0 n)
#else
static void _PrPTGNOPT_RCSA(n)
_PPTG0 n;
#endif
{
  fputs ("/* the simple Row Column Scheme is performed for the nonterminal-table */\n\
\n\
#define GET_NTABENTRY( RorS, Act, State, lhsnt ) \\\n\
\t{ \\\n\
\t  register unsigned int i,j,k; \\\n\
\t  k = nbase[State + 1];\\\n\
\t  for( i = nbase[State]; i < k; i++ ) {\\\n\
\t      if((ntab[i] & 0x0000FFFF) == lhsnt )  { \\\n\
\t          j = ntab[i] >> 16; \\\n\
\t          Act  = j & ACTIONMASK; \\\n\
\t          RorS = j & OPERANDMASK; \\\n\
\t          break; \\\n\
\t      } \\\n\
\t  } \\\n\
\t}\n\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGTOPT_GCS(_PPTG0 n)
#else
static void _PrPTGTOPT_GCS(n)
_PPTG0 n;
#endif
{
  fputs ("/* the Graph Colouring Scheme is performed for the terminal-table */\n\
\n\
#define SIGMAP(row, col) (sigmap[row][col >> 3] >> (col & 0x0007)) & 0x01\n\
\n\
#define GET_TTABENTRY( RorS, Act, term ) \\\n\
        {\\\n\
          register      U_SHORT j;\\\n\
          j = conv[ term ]; \\\n\
          if( SIGMAP( sigrowind[RorS], sigcolind[ j ] ) )  { \\\n\
              j = ttab[ trowptr[ RorS ] ][ tcolptr[ j ] ]; \\\n\
              Act  = j & ACTIONMASK; \\\n\
              RorS = j & OPERANDMASK; \\\n\
          } \\\n\
          else \\\n\
              Act  = 0; \\\n\
        }\n\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNOPT_GCS(_PPTG0 n)
#else
static void _PrPTGNOPT_GCS(n)
_PPTG0 n;
#endif
{
  fputs ("/* the Graph Colouring Scheme is performed for the nonterminal-table */\n\
\n\
#define GET_NTABENTRY( RorS, Act, State, lhsnt) \\\n\
\t{\\\n\
\t  register      U_SHORT j;\\\n\
\t  j = ntab[ nrowptr[State] ][ ncolptr[lhsnt] ]; \\\n\
\t  Act  = j & ACTIONMASK; \\\n\
\t  RorS = j & OPERANDMASK; \\\n\
\t}\n\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGTOPT_LES(_PPTG0 n)
#else
static void _PrPTGTOPT_LES(n)
_PPTG0 n;
#endif
{
  fputs ("/* the Line Elimination Scheme is performed for the terminal-table */\n\
\n\
#define SIGMAP(row , col) (sigmap[row][col >> 3] >> (col & 0x0007)) & 0x01\n\
\n\
#define GET_TTABENTRY( RorS, Act, term ) \\\n\
\t{\\\n\
\t  register      U_SHORT j;\\\n\
\t  j = conv[term]; \\\n\
\t  if( SIGMAP( sigrowind[RorS], sigcolind[j] ) )  { \\\n\
\t       if( tdecrow[RorS] < tdeccol[j] ) \\\n\
\t           j = trowval[RorS]; \\\n\
\t       else if( tdecrow[RorS] > tdeccol[j] ) \\\n\
\t           j = tcolval[j]; \\\n\
\t       else \\\n\
\t           j = ttab[ trowval[RorS] ][ tcolval[j] ]; \\\n\
\t       Act  = j & ACTIONMASK; \\\n\
\t       RorS = j & OPERANDMASK; \\\n\
\t  } \\\n\
\t  else \\\n\
\t       Act  = 0; \\\n\
\t}\n\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNOPT_LES(_PPTG0 n)
#else
static void _PrPTGNOPT_LES(n)
_PPTG0 n;
#endif
{
  fputs ("/* the Line Elimination Scheme is performed for the nonterminal-table */\n\
\n\
#define GET_NTABENTRY( RorS, Act, State, lhsnt) \\\n\
\t{\\\n\
\t  register      U_SHORT j;\\\n\
\t  if( ndecrow[State] < ndeccol[lhsnt] ) \\\n\
\t      j = nrowval[State]; \\\n\
\t  else if( ndecrow[State] > ndeccol[lhsnt] ) \\\n\
\t      j = ncolval[lhsnt]; \\\n\
\t  else \\\n\
\t      j = ntab[ nrowval[State] ][ ncolval[lhsnt] ]; \\\n\
\t  Act  = j & ACTIONMASK; \\\n\
\t  RorS = j & OPERANDMASK;\\\n\
\t}\n\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGTOPT_SDS(_PPTG0 n)
#else
static void _PrPTGTOPT_SDS(n)
_PPTG0 n;
#endif
{
  fputs ("/* the Significant Distance Scheme is performed for the terminal-table */\n\
\n\
#define GET_TTABENTRY( RorS, Act, term ) \\\n\
\t{\\\n\
\t  register      U_SHORT j;\\\n\
\t  j = conv[ term ]; \\\n\
\t  if( j < tfirstptr[RorS]  ||  j > tlastptr[RorS] ) \\\n\
\t    Act  = 0; \\\n\
\t  else { \\\n\
\t    j = ttab[ trowptr[RorS] + j ]; \\\n\
\t    Act  = j & ACTIONMASK; \\\n\
\t    RorS = j & OPERANDMASK; \\\n\
\t  }\\\n\
\t}\n\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNOPT_SDS(_PPTG0 n)
#else
static void _PrPTGNOPT_SDS(n)
_PPTG0 n;
#endif
{
  fputs ("/* the Significant Distance Scheme is performed for the nonterminal-table */\n\
\n\
#define GET_NTABENTRY( RorS, Act, State, lhsnt) \\\n\
\t{\\\n\
\t  register      U_SHORT j;\\\n\
\t  j = ntab[ nrowptr[State] + lhsnt ]; \\\n\
\t  Act  =  j & ACTIONMASK; \\\n\
\t  RorS =  j & OPERANDMASK; \\\n\
\t}\n\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGTOPT_RCSB(_PPTG0 n)
#else
static void _PrPTGTOPT_RCSB(n)
_PPTG0 n;
#endif
{
  fputs ("/* the Row Column Scheme is performed for the terminal-table */\n\
/* with merging of equal rows                                */\n\
\n\
#define GET_TTABENTRY( RorS, Act, term ) \\\n\
\t{\\\n\
\t  register unsigned int i,j,k; \\\n\
\t  Act  = 0; \\\n\
\t  k = tbase[trpt[RorS] + 1]; \\\n\
\t  for( i = tbase[trpt[RorS]]; i < k; i++ ) { \\\n\
\t      if((ttab[i] & 0x0000FFFF) == term )  { \\\n\
\t          j = ttab[i] >> 16; \\\n\
\t          Act  = j & ACTIONMASK; \\\n\
\t          RorS = j & OPERANDMASK; \\\n\
\t          break; \\\n\
\t      } \\\n\
\t  }\\\n\
\t}\n\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNOPT_RCSB(_PPTG0 n)
#else
static void _PrPTGNOPT_RCSB(n)
_PPTG0 n;
#endif
{
  fputs ("/* the Row Column Scheme is performed for the nonterminal-table */\n\
/* with merging of equal rows                                   */\n\
\n\
#define GET_NTABENTRY( RorS, Act, State, lhsnt ) \\\n\
\t{ \\\n\
\t  register unsigned int i,j,k; \\\n\
\t  k = nbase[nrpt[State] + 1]; \\\n\
\t  for( i = nbase[nrpt[State]]; i < k; i++ ) { \\\n\
\t      if((ntab[i] & 0x0000FFFF) == lhsnt )  { \\\n\
\t          j = ntab[i] >> 16; \\\n\
\t          Act  = j & ACTIONMASK; \\\n\
\t          RorS = j & OPERANDMASK; \\\n\
\t          break; \\\n\
\t      } \\\n\
\t  } \\\n\
\t}\n\n", f);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGTOPT_RDS()
#else
PTGNode PTGTOPT_RDS()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGTOPT_RDS;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNOPT_RDS()
#else
PTGNode PTGNOPT_RDS()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNOPT_RDS;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGTOPT_RCSA()
#else
PTGNode PTGTOPT_RCSA()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGTOPT_RCSA;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNOPT_RCSA()
#else
PTGNode PTGNOPT_RCSA()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNOPT_RCSA;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGTOPT_GCS()
#else
PTGNode PTGTOPT_GCS()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGTOPT_GCS;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNOPT_GCS()
#else
PTGNode PTGNOPT_GCS()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNOPT_GCS;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGTOPT_LES()
#else
PTGNode PTGTOPT_LES()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGTOPT_LES;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNOPT_LES()
#else
PTGNode PTGNOPT_LES()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNOPT_LES;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGTOPT_SDS()
#else
PTGNode PTGTOPT_SDS()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGTOPT_SDS;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNOPT_SDS()
#else
PTGNode PTGNOPT_SDS()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNOPT_SDS;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGTOPT_RCSB()
#else
PTGNode PTGTOPT_RCSB()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGTOPT_RCSB;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNOPT_RCSB()
#else
PTGNode PTGNOPT_RCSB()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNOPT_RCSB;
  return ((PTGNode) n);
}


