/***************************************************************************/
/* filename : optim_help.c                         first edit  :  3.03.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 13.07.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
static char rcsid[] = "$Id: optim_help.c,v 1.1 1992/01/10 14:38:40 cogito Exp $";


/************************* MACRO - DEFINITIONS *****************************/


#define IS_DGD( entry )                  entry & 0x4000
#define SET_DGD( entry )                 entry | 0x4000

/*************************** INCLUDE - FILES *******************************/

typedef short *readtype[];

#include<stdio.h>

#include<malloc.h>

#include "over.h"

#include "over_types.h"

#include "determ.h"

#include "errors.h"

#include "out.h"

#include "clearing.h"

#include "reach.h"



/***************************** FUNCTIONS ***********************************/

static void Ins_Red();



static void Proof_Red_Paths( reach_ptr,help_ptr,state,unused,extra_info )

   reach      *reach_ptr;  /* a vector in which all reduction paths are
			      saved, which could be reached after the
			      optimization techniques are applied          */
   struct rp   *help_ptr;  /* pointer to all reduction situations of one
			      rule                                         */
   short           state;  /* the reduction situation which is still to be
			      investigated                                 */
   char          *unused,  /* vector to decide, if there exist reduction
			      situations which are not to be considered    */
	      extra_info;  /* if extra_info == 1, then extra information
			      about begin and end of function is printed
			      out                                          */

/* This function tests to see if a given reduction situation consists of
   reduction paths which have a new reduction situation as "continuation
   state". If it applies, then control will be passed to function
   Ins_Red.
*/


   {
     short     st,  /* loop index                                          */
	    *redp;  /* pointer to a reduction situation                    */

     if( extra_info )
	printf("begin of function Proof_Red_Paths()\n");

     redp = help_ptr[state].rep.pt_rp;

     for( st=0;st<redp[0];st++ )
	if( IS_SHRED_NTACT( redp[st*2+3] ) )
	    Ins_Red( reach_ptr,help_ptr,OPERAND( redp[st*2+3] ),state,
			      redp[st*2+2],1,2,unused,extra_info );

     if( extra_info )
	printf("end of function Proof_Red_Paths()\n");

   } /* end of function Proof_Red_Paths() */





static struct reach_elem *Gen_Reach_Elem( reach_ptr,help_ptr,production,
					  state,eq_state,sit,kind,unused,
					  extra_info )

   reach      *reach_ptr;  /* a vector in which all reduction paths are
			      saved, which could be reached after the
			      optimization techniques are applied          */
   struct rp   *help_ptr;  /* pointer to all reduction situations of one
			      rule                                         */
   short             sit,  /* There exist two different situations. One
			      ( sit == 1 ) is a direct jump to another
			      reduction situation and the other ( sit == 2 )
			      is the default case.                         */
		    kind,  /* Every reduction situation can be categorized
			      into three different kinds.
			      three different kinds.
			      First ( kind == 0 ), a reduce entry at T -
			      table,
			      second ( kind == 1 ), a shift/reduce entry at
			      T - table and
			      third  ( kind == 2 ), a shift/reduce entry at
			      N - table. This three cases are distinguished
			      by the variable 'kind'                       */
		eq_state,  /* the state in which the reduction takes place */
	      production,  /* the production, which will be reduce in
			      eq_state                                     */
		   state;  /* the reduction situation which is still to be
			      investigated                                 */
   char          *unused,  /* vector to decide, if there exist reduction
			      situations which are not considered          */
	      extra_info;  /* if extra_info == 1, then extra information
			      about begin and end of function is printed
			      out                                          */

/* If a reduction situation is found that exists after the optimization
   techniques are applied, then a call to this function takes place.
   Here a new element of the reached reduction code will be generated and
   control will be passed to function Proof_Red_Paths.
*/

   {
     struct reach_elem  *gen_ptr;  /* help pointer to generate storage
				      space for the reduction situation    */

     if( extra_info )
	printf("begin of function Gen_Reach_Elem()\n");

     if( (gen_ptr = (struct reach_elem*) malloc(
				     sizeof( struct reach_elem ) )) == NULL )
	   Error_Message( _GEN_REACH_ELEM,MODULE_OPTIM_HELP,
                          NO_SPACE_FOR_STRUCTURE,ABORT," gen_ptr" );

     gen_ptr->state_nr = eq_state;
     gen_ptr->kind     = kind;
     if( sit == 1 )
	{
          /* is direct goto */
	  gen_ptr->pointer   = NULL;
	  unused[production] = TRUE;
	} /* end of if( sit == 1 ) */
     else
	{
	  gen_ptr->pointer = help_ptr[state].rep.pt_rp;
	  Proof_Red_Paths( reach_ptr,help_ptr,state,unused,extra_info );
	} /* end of else ( if( sit == 1 ) ) */

     if( extra_info )
	printf("end of function Gen_Reach_Elem()\n");

     return( gen_ptr );

   } /* end of function Gen_Reach_Elem() */





static void Ins_Red( reach_ptr,help_ptr,production,state,eq_state,sit,kind,
		     unused,extra_info )


   reach      *reach_ptr;  /* a vector in which all reduction paths are
			      saved, which could be reached after the
			      optimization techniques are applied          */
   struct rp   *help_ptr;  /* pointer to all reduction situations of one
			      rule                                         */
   short             sit,  /* There exist two different situations. One
			      ( sit == 1 ) is a direct jump to another
			      reduction situation and the other ( sit == 2 )
			      is the default case.                         */
		    kind,  /* Every reduction situation can be categorized
			      into three different kinds.
			      First ( kind == 0 ), a reduce entry at T -
			      table,
			      second ( kind == 1 ), a shift/reduce entry at
			      T - table and
			      third  ( kind == 2 ), a shift/reduce entry at
			      N - table. This three cases are distinguished
			      by the variable 'kind'                       */
		eq_state,  /* the state in which the reduction takes place */
	      production,  /* the production, which will be reduced in
			      eq_state                                     */
		   state;  /* the reduction situation which is still to be
			      investigated                                 */
   char          *unused,  /* vector to decide, if there exist reduction
			      situations which are not considered          */
	      extra_info;  /* if extra_info == 1, then extra information
			      about begin and end of function is printed
			      out                                          */

/* This functon controls the reached reduction code list. In this list,
   all relevant data of a reduction situation will be saved. A new element
   will be inserted in the right order.
*/

   {
     struct reach_elem  *help_elem_ptr,  /* this pointer is used to search
					    a reduction situation          */
			      *gen_ptr;  /* help pointer to generate storage
					    space for the reduction situ-
					    ation                          */
     char                        found;  /* variable to decide, if a
					    searched reduction situation is
					    found                          */

     if( extra_info )
	printf("begin of function Ins_Red()\n");

     if( reach_ptr[production] == NULL )
	{ /* insert */
	  reach_ptr[production] = Gen_Reach_Elem( reach_ptr,help_ptr,
						  production,state,
						  eq_state,sit,kind,unused,
						  extra_info );
	  reach_ptr[production]->next = NULL;
	} /* end of if( reach_ptr[p... */
     else
	if( (OPERAND( reach_ptr[production]->state_nr ) != eq_state) ||
	    (reach_ptr[production]->kind != kind)         )
	   if( (OPERAND( reach_ptr[production]->state_nr ) < eq_state)        ||
	       ((OPERAND( reach_ptr[production]->state_nr ) == eq_state) &&
		(reach_ptr[production]->kind < kind)          )    )
	      { /* insert */
		gen_ptr = Gen_Reach_Elem( reach_ptr,help_ptr,production,
					  state,eq_state,sit,kind,unused,
					  extra_info );
		gen_ptr->next = reach_ptr[production];
		reach_ptr[production] = gen_ptr;
	      } /* end of if( reach_ptr[p... */
	   else /* search */
	      {
		found = FALSE;
		help_elem_ptr = reach_ptr[production];
		while( (help_elem_ptr->next != NULL) && !found )
		   if( (OPERAND( help_elem_ptr->next->state_nr ) < eq_state)     ||
		       ((OPERAND( help_elem_ptr->next->state_nr ) == eq_state) &&
			(help_elem_ptr->next->kind <= kind)         )  )
		      found = TRUE;
		   else
		      help_elem_ptr = help_elem_ptr->next;
		if( !found )
		   { /* insert */
		     gen_ptr = Gen_Reach_Elem( reach_ptr,help_ptr,production,
					       state,eq_state,sit,kind,unused,
					       extra_info );
		     gen_ptr->next = NULL;
		     help_elem_ptr->next = gen_ptr;
		   } /* end of if( !found ) */
		else
		   if( (OPERAND( help_elem_ptr->next->state_nr ) < eq_state)      ||
		       ((OPERAND( help_elem_ptr->next->state_nr ) == eq_state) &&
			(help_elem_ptr->next->kind < kind)          )  )
		      { /* insert */
			gen_ptr = Gen_Reach_Elem( reach_ptr,help_ptr,
						  production,state,
						  eq_state,sit,kind,unused,
						  extra_info );
			gen_ptr->next = help_elem_ptr->next;
			help_elem_ptr->next = gen_ptr;
		      } /* end of if( (help_elem... */
	      } /* end of else ( if( reach_ptr[p... ) */

     if( extra_info )
	printf("end of function Ins_Red()\n");

   } /* end of function Ins_Red() */







reach *Reachebility_Test( quick_data,changed_data,extra_info )

   readtype        *quick_data;  /* internal interface vector              */
   struct inter  *changed_data;  /* vector which stores the changes, which
				    have arisen from the optimization
				    techniques                             */
   char             extra_info;  /* if extra_info == 1, then extra informa-
				    tion about begin and end of function
				    is printed out                        */

/* This function tests if a reduction situation could be reached after
   the optimization techniques are applied. Then control will be passed
   to function Ins_Red.
*/

   {
     reach                 *reach_ptr;  /* a vector in which all reduction
					   paths are saved, which could be
					   reached after the optimization
					   techniques are applied          */
     struct reach_elem  *help_elem_ptr;  /* this pointer is used to search
					    a reduction situation          */
     struct rp               *help_ptr;  /* pointer to all reduction
					    situations of one rule         */
     short                         nop,  /* number of productions          */
				  prod,  /* loop index                     */
				 state,  /* loop index                     */
				 count,  /* number of reduction situations
					    of one rule                   */
                                 *redp,
                                    st,
			   state_count;  /* number of reduction situations
					    of one rule                   */
     char                        found,  /* variable to decide, if one
					    reduction situation is found   */
				 shift,  /* loop index                     */
			       *unused;  /* vector to decide, if there exist
					    reduction situations which are
					    not considered                 */



     if( extra_info )
	printf("begin of function Reachebility_Test()\n");

     nop = *((*quick_data)[5]);


     if( ((reach_ptr = (reach*) calloc( nop,sizeof( reach ) )) == NULL) ||
	 ((unused    = (char*)  calloc( nop,sizeof( char )  )) == NULL) )
	Error_Message( _REACHEBILITY_TEST,MODULE_OPTIM_HELP,NO_SPACE_FOR_VECTOR, 
                       ABORT," unused" );

     for( prod=0;prod<nop;prod++ )
	{
	  reach_ptr[prod] = NULL;
	  unused[prod] = FALSE;
	} /* end of for( prod=0;pro... */

     for( shift=0;shift<2;shift++ )
	for( prod=0;prod<nop;prod++ )
	   {
	     if( shift )
		count = changed_data->ttsred_paths[prod].number_of_states;
	     else
		count = changed_data->ttred_paths[prod].number_of_states;
	     for( state=0;state<count;state++ )
		{
		  if( shift )
		     help_ptr = changed_data->ttsred_paths[prod].pointer;
		  else
		     help_ptr = changed_data->ttred_paths[prod].pointer;
		  if( !(IS_DEL( help_ptr[state].state )) )
		     if( IS_DGD( help_ptr[state].state ) )
			{
			  if( IS_SHRED_NTACT( *(help_ptr[state].rep.
						pt_rp+3) ) )
			     {
                               redp = help_ptr[state].rep.pt_rp;
                               for( st=0;st<redp[0];st++ )
                                  if( IS_SHRED_NTACT( redp[st*2+3] ) )
	                             Ins_Red( reach_ptr,help_ptr,
                                              OPERAND( redp[st*2+3] ),state,
			                      redp[st*2+2],1,2,unused,
                                              extra_info );
			     } /* end of if( IS_SHRED_N... */
			} /* end of if( IS_DGD( hel... */
		     else
			{
			  Ins_Red( reach_ptr,help_ptr,prod,state,
				   OPERAND( help_ptr[state].state ),2,shift,
				   unused,extra_info );
			} /* end of else ( if( IS_DGD( hel... ) */

		     

		} /* end of for( state=0;st... */
	   } /* end of for( prod=0;pro... */

      found = TRUE;
      while( found )
	 {
	   found = FALSE;
	   for( prod=0;prod<nop;prod++ )
	      if( unused[prod] )
		 {
		   unused[prod] = FALSE;
		   help_elem_ptr = reach_ptr[prod];
		   while( help_elem_ptr != NULL )
		      {
			if( help_elem_ptr->pointer == NULL )
			  {
			    help_ptr = changed_data->ntred_paths[prod].pointer;
			    state_count = changed_data->
					   ntred_paths[prod].number_of_states;
			    state = 0;
			    while( (OPERAND( help_ptr[state].state ) !=
				   OPERAND( help_elem_ptr->state_nr )        )  &&
				   (state < state_count)                )
				       state++;
			    if( state == state_count )
			       Error_Message( _REACHEBILITY_TEST,
                                              MODULE_OPTIM_HELP,
                                              NOT_FIND_ELEMENT,ABORT,
                                              " help_elem_ptr->state_nr" );
			    found = TRUE;
                            if( IS_DGD( help_ptr[state].state ) )
                               help_elem_ptr->state_nr = 
                                     SET_DGD( help_elem_ptr->state_nr );
			    help_elem_ptr->pointer = help_ptr[state].rep.pt_rp;
			    Proof_Red_Paths( reach_ptr,help_ptr,state,
					     unused,extra_info );
			  } /* end of if( help_elem_p... */
			help_elem_ptr = help_elem_ptr->next;
		      } /* end of while( help_ele... */
		 } /* end of if( unused[prod] )... */
	 } /* end of while( found ) */


     if( extra_info )
	printf("end of function Reachebility_Test()\n");

     return( reach_ptr );

   } /* end of function Reachebility_Test() */





static void Search_Equal_Code( out_list,new_out_list,used,eq_pos,lower_bound,
			       upper_bound,extra_info )

   struct equality      *out_list,  /* vector which stores the code of a
				       list of comparisons                 */
		    *new_out_list;  /* the modified code discribed above   */
   short              upper_bound,  /* the length of the list              */
		      lower_bound,  /* the first element of the list       */
			   eq_pos,  /* all list elements will be compared
				       with the element at position eq_pos */
			    *used;  /* variable to decide if an element has
				       been compared yet                   */
   char                extra_info;  /* if extra_info == 1, then extra infor-
				       mation about begin and end of func-
				       tion is printed out                */



/* If code compression should be applied then the jump mark that are
   most common in the current code block are searched. This function determines
   for a given comparison and the corresponding action, how often it exist
   in this comparrison code block.
*/



   {
     short      pos,  /* loop index                                        */
	    out_pos=  /* loop index                                        */
		  0;

     if( extra_info )
	printf("begin of function Search_Equal_Code()\n");

     for( pos=lower_bound;pos<upper_bound;pos++ )
	{
	  if( !used[pos] )
	     if( !(IS_SHRED_NTACT( out_list[eq_pos].eq_elem )) )
		{
		  if( !(IS_SHRED_NTACT( out_list[pos].eq_elem )) )
		     if( (out_list[eq_pos].action.goto_action) ==
			 (out_list[pos].action.goto_action)   )
			{
			  used[eq_pos]++;
			  used[pos] = 1;
			} /* end of if( (out_list[e... */
		} /* end of if( !(IS_SHRED... */
	     else
		if( (IS_SHRED_NTACT( out_list[pos].eq_elem )) )
		   if( out_list[pos].action.new_red_sit->
		       pcc == NULL )
		      if( (out_list[eq_pos].action.new_red_sit->
			   scan) ==
			  (out_list[pos].action.new_red_sit->
			   scan) )
			 if( (out_list[eq_pos].action.new_red_sit->
			      pop) ==
			     (out_list[pos].action.new_red_sit->
			      pop) )
			    if( (out_list[eq_pos].action.new_red_sit->
				 old_sem) ==
				(out_list[pos].action.new_red_sit->
				 old_sem) )
			       if( (out_list[eq_pos].action.
				    new_red_sit->sem) ==
				   (out_list[pos].action.
				    new_red_sit->sem) )
				  if( (out_list[eq_pos].action.
				       new_red_sit->mark) ==
				      (out_list[pos].action.
				       new_red_sit->mark) )
				     if( (out_list[eq_pos].action.
				          new_red_sit->state) ==
				         (out_list[pos].action.
				          new_red_sit->state) )
				        if( (out_list[eq_pos].action.
				             new_red_sit->kind) ==
				            (out_list[pos].action.
				             new_red_sit->kind) )
				           {
				             used[eq_pos]++;
				             used[pos] = 1;
				           } /* end of if( (out_list[e... */

	  if( !used[pos] && (new_out_list != NULL) )
	     {
	       new_out_list[out_pos].eq_elem = out_list[pos].eq_elem;
	       if( IS_SHRED_NTACT( out_list[pos].eq_elem ) )
		  {
		    new_out_list[out_pos].action.new_red_sit =
			      out_list[pos].action.new_red_sit;
		    out_list[pos].action.new_red_sit = NULL;
		  } /* end of if( IS_SHRED_NT... */
	       else
		  new_out_list[out_pos].action.goto_action =
			      out_list[pos].action.goto_action;

	       out_pos++;
	     } /* end of if( !used[pos] ... */
	  else
	     if( new_out_list != NULL )
		used[pos] = 0;

	} /* end of for( pos=lower_... */
     if( new_out_list != NULL )
	used[eq_pos] = 0;

     if( extra_info )
	printf("end of function Search_Equal_Code()\n");

   } /* end of function Search_Equal_Code() */






struct equality *Code_Compression( out_list,upper_bound,used,shift,
					  extra_info )

   struct equality     *out_list;  /* vector which stores the code of a
				       list of comparisons                 */
   short            *upper_bound,  /* the length of the list               */
			   *used;  /* variable to decide, if an element has
				      been compared yet                    */
   char               extra_info,  /* if extra_info == 1, then extra infor-
				      mation about begin and end of func-
				      tion is printed out                */
			  *shift;  /* used to decide if it is a shift
				      situation                            */


/* When you have a look to the generated code, you see that in one state
   comparison often yields to a jump to the same mark. If this mark is
   a reduction mark, than the default case should not be a jump to the
   error recovery, it could be a jump to this reduction mark. So a lot of
   comparisons would be saved. This function searches for these kind of
   comparisons and compresses the code.
*/




   {
     short                     loop,  /* loop index                        */
				max,  /* stores the highest number of equal
					 code elements                     */
				pos;  /* stores the corresponding position
					 of the first element              */
     char                     equal;  /* used to decide, if two elements
					 are equal                         */
     struct equality  *new_out_list;  /* vector which stores the code of a
					 list of comparisons               */


     if( extra_info )
	printf("begin of function Code_Compression( )\n");


     for( loop=0;loop<*upper_bound-1;loop++ )
	if( !used[loop] )
	   {
	     equal = TRUE;
	     if( IS_SHRED_NTACT( out_list[loop].eq_elem ) )
		{
		  if( out_list[loop].action.new_red_sit->pcc != NULL )
		     equal = FALSE;
		  else
		     if( out_list[loop].action.new_red_sit->scan )
			equal = FALSE;
		     else
			used[loop] = 1;
		} /* end of if( IS_SHRED_NT... */
	     else
		if( IS_ACCEPTACT( out_list[loop].eq_elem ) )
		   equal = FALSE;
		else
		   if( *shift )
		      equal = FALSE;
		   else
		      used[loop] = 1;

	     if( equal )
		Search_Equal_Code( out_list,NULL,used,loop,loop+1,
				   *upper_bound,extra_info );

	   } /* end of if( !used[loop] ) */

     max = 0;
     for( loop=0;loop<*upper_bound;loop++ )
	{
	   if( used[loop] > max )
	      {
		max = used[loop];
		pos = loop;
	      } /* end of if( used[loop]... */
	   used[loop] = 0;
	} /* end of for( loop=0;loo... */
     if( ((max>0) && *shift) ||
	 (max>1)               )
	{
	  *shift = TRUE; /* means, that out_list is changed */

	  if( (new_out_list = (struct equality*) calloc( *upper_bound-max+1,
			       sizeof( struct equality ) )) == NULL )
		  Error_Message( _CODE_COMPRESSION,MODULE_OPTIM_HELP,
                                 NO_SPACE_FOR_VECTOR,ABORT," new_out_list" );

	  Search_Equal_Code( out_list,new_out_list,used,pos,0,*upper_bound,
			     extra_info );

	  new_out_list[*upper_bound-max].eq_elem = out_list[pos].eq_elem;
	  if( IS_SHRED_NTACT( out_list[pos].eq_elem ) )
	     {
	       new_out_list[*upper_bound-max].action.new_red_sit =
		    out_list[pos].action.new_red_sit;
	       out_list[pos].action.new_red_sit = NULL;
	     } /* end of if( IS_SHRED_NT... */
	  else
	     new_out_list[*upper_bound-max].action.goto_action =
		  out_list[pos].action.goto_action;
	  free( out_list );

	  *upper_bound = *upper_bound-max+1;
	  if( extra_info )
	     printf("end of function Code_Compression( )\n");
	  return( new_out_list );
	} /* end of if( ((max>0) &&... */
     else
	{
	  *shift = FALSE; /* means, that out_list is not changed */
	  if( extra_info )
	     printf("end of function Code_Compression( )\n");
	  return( out_list );
	} /* end of else ( if( ((max>0) &&... ) */

   } /* end of function Code_Compression( ) */








struct pcc_elem *Find_Pcc_Elem( pcc_list,prod,state,kind,extra_info )

   struct pcc_elem   *pcc_list;  /* the list of pcc - elements ( see modul
				    High_Optim )                           */
   short                  prod,  /* the production which will be reduced
				    in state                               */
			  kind,  /* the kind of reduction situation ( see
				    above )                                */
			 state;  /* the state in which the production will
				    be reduced                             */
   char             extra_info;  /* if extra_info == 1, then extra informa-
				    tion about begin and end of function
				    is printed out                        */



/* Because pop count conflicts are very seldom, the solution of the pop
   count conflicts are saved in a list structure. If you find a reduction,
   where a pop count conflict exists, then this function searches for the
   solution of the pop count conflict in this list.
*/



   {
     struct pcc_elem  *help_pcc_ptr;  /* this pointer is used to find a
					 pcc - element                     */
     char                     found=  /* used to decide if a searched pcc  */
			      FALSE;  /* element is found                  */

     if( extra_info )
	printf("begin of function Find_Pcc_Elem( )\n");


     help_pcc_ptr = pcc_list;

     while( (help_pcc_ptr != NULL) && !found )
	if( (help_pcc_ptr->prod  == prod)   &&
	    (help_pcc_ptr->state == state)  &&
	    (help_pcc_ptr->kind  == kind)   )
	   found = TRUE;
	else
	   help_pcc_ptr = help_pcc_ptr->next;

     if( !found )
	Error_Message( _FIND_PCC_ELEM,MODULE_OPTIM_HELP,NOT_FIND_ELEMENT,ABORT,
                       " prod,state and kind" );


     if( extra_info )
	printf("end of function Find_Pcc_Elem( )\n");

     return( help_pcc_ptr );

   } /* end of function Find_Pcc_Elem( ) */






static void Gen_Eq_Elem( rep_vc,mark,kind,state,rep_prod,rep_kind,
			 rep_state,nop,extra_info )

   rep_code    *rep_vc;  /* vector which saves the information about
			    shared reduce code and " Unit - Marks "        */
   short          mark,  /* the production of a reduction situation        */
		 state,  /* the corresponding state of the reduction
			    situation                                      */
		  kind,  /* the corresponding kind of the reduction
			    situation  ( kind is described above )         */
	      rep_prod,  /* the representation production of the deleted
			    reduction code                                 */
	     rep_state,  /* the representation state of the deleted reduc-
			    tion code                                      */
	      rep_kind,  /* the representation kind of the deleted reduc-
			    tion code                                      */
		   nop;  /* number of productions                          */
   char     extra_info;  /* if extra_info == 1, then extra information
			    about begin and end of function is printed
			    out                                            */

/* If there exist reduction code blocks which are equal or have only
   one action, then it is possible that they will be deleted. All
   jumps to these code blocks must be changed. So the relevant data would
   be saved here.
*/


   {
     struct eq_code   *one_elem,  /* needed to generate a reduce element   */
		     *help_elem;  /* used to search an element in the data
				     structure                             */
     short                 prod;  /* loop index                            */
     char                 found=  /* used to decide if a searched element  */
			  FALSE;  /* is found                              */


     if( extra_info )
	printf("begin of function Gen_Eq_Elem( )\n");

     if( (one_elem = (struct eq_code*) malloc(
				sizeof( struct eq_code ) )) == NULL )
	Error_Message( _GEN_EQ_ELEM,MODULE_OPTIM_HELP,NO_SPACE_FOR_STRUCTURE,
                       ABORT," one_elem" );


     if( rep_vc[mark] == NULL )
	{
	  one_elem->next = NULL;
	  rep_vc[mark]   = one_elem;
	} /* end of if( rep_vc[m... */
     else
	if( (rep_vc[mark]->state > state)      ||
	    ((rep_vc[mark]->state == state) &&
	     (rep_vc[mark]->kind > kind )    )  )
	   {
	     one_elem->next = rep_vc[mark];
	     rep_vc[mark]   = one_elem;
	   } /* end of if( (rep_vc[ma... */
	else
	   {
	     help_elem = rep_vc[mark];
	     while( (help_elem->next != NULL) && !found )
		{
		  if( (help_elem->next->state > state)       ||
		      ((help_elem->next->state == state) &&
		       (help_elem->next->kind > kind)     )   )
		     {
		       one_elem->next  = help_elem->next;
		       help_elem->next = one_elem;
		       found = TRUE;
		     } /* end of if( (help_elem->nex... */
		  else
		     help_elem = help_elem->next;
		} /* end of while( (help_elem... */

	   } /* end of else ( if( (rep_vc[mar... ) */

     one_elem->state     = state;
     one_elem->kind      = kind;


     help_elem = rep_vc[rep_prod];
     found     = FALSE;

     while( (help_elem != NULL) && !found )
	if( (help_elem->state == rep_state) &&
	    (help_elem->kind  == rep_kind)   )
	   {
	     rep_state = help_elem->rep_state;
	     rep_kind  = help_elem->rep_kind;
	     rep_prod  = help_elem->rep_prod;
	     found     = TRUE;
	   } /* end of if( (help_elem-... */
	else
	   help_elem = help_elem->next;

     one_elem->rep_prod  = rep_prod;
     one_elem->rep_kind  = rep_kind;
     one_elem->rep_state = rep_state;
     for( prod=0;prod<nop;prod++ )
	{
	  help_elem = rep_vc[prod];
	  while( help_elem != NULL )
	     {
	       if( (help_elem->rep_prod  == mark)  &&
		   (help_elem->rep_state == state) &&
		   (help_elem->rep_kind  == kind)   )
		  {
		    help_elem->rep_state = rep_state;
		    help_elem->rep_kind  = rep_kind;
		    help_elem->rep_prod  = rep_prod;
		  } /* end of if( (help_elem-... */
		help_elem = help_elem->next;
	     } /* end of while( help_ele... */
	} /* end of for( prod=0;pro... */

     if( extra_info )
	printf("end of function Gen_Eq_Elem( )\n");

   } /* end of function Gen_Eq_Elem( ) */






char Not_Equal_Code( rep_vc,red_ptr,red_help_ptr,nop,extra_info )


   rep_code                   *rep_vc;  /* vector, which saves the infor-
					   mation about shared reduce code
					   and " Unit - Marks "            */
   struct red_out_code  *red_help_ptr,  /* pointer to one reduction code
					   element                         */
			     *red_ptr;  /* pointer to the structure, which
					   saves the reduce code           */
   short                          nop;  /* number of productions           */
   char                    extra_info;  /* if extra_info == 1, then extra
					   information about begin and end
					   of function is printed out     */

/* If the user chose the reduction code generation by individual reduce
   code, then it is possible that identical code blocks would be generated.
   This function searches for these code blocks and eliminate one of each
   identical code block pair.

*/

   {
     struct red_out_code  *help_ptr;  /* used to find elements in the
					   structure pointed to            */
     char                     found=  /* used to decide if a searched      */
			      FALSE;  /* element is found                  */
     short                     elem=  /* loop index                        */
				  0,
                              bound;

     if( extra_info )
	printf("begin of function Not_Equal_Code( )\n");

     help_ptr = red_ptr;
     while( (help_ptr != NULL) && !found )
	if( (help_ptr->number == red_help_ptr->number) )
	   {
	     found = TRUE;
             bound = help_ptr->number;
	     while( (elem<bound) && found )
	        if( (IS_SHRED_NTACT( help_ptr->eq_list[elem].eq_elem ))     &&
                    (IS_SHRED_NTACT( red_help_ptr->eq_list[elem].eq_elem )) )
		   if( (help_ptr->eq_list[elem].action.
				    new_red_sit->pcc == NULL) &&
		       (red_help_ptr->eq_list[elem].action.
				    new_red_sit->pcc == NULL) &&
		       (help_ptr->eq_list[elem].action.
					 new_red_sit->scan ==
			red_help_ptr->eq_list[elem].action.
					   new_red_sit->scan) &&
		       (help_ptr->eq_list[elem].action.
					 new_red_sit->pop ==
			red_help_ptr->eq_list[elem].action.
					   new_red_sit->pop) &&
		       (help_ptr->eq_list[elem].action.
					 new_red_sit->sem ==
			red_help_ptr->eq_list[elem].action.
					   new_red_sit->sem) &&
		       (help_ptr->eq_list[elem].action.
				     new_red_sit->old_sem ==
			red_help_ptr->eq_list[elem].action.
				       new_red_sit->old_sem) &&
		       (help_ptr->eq_list[elem].action.
				     new_red_sit->state ==
			red_help_ptr->eq_list[elem].action.
				       new_red_sit->state) &&
		       (help_ptr->eq_list[elem].action.
				     new_red_sit->kind ==
			red_help_ptr->eq_list[elem].action.
				       new_red_sit->kind) &&
		       (help_ptr->eq_list[elem].action.
				     new_red_sit->mark ==
			red_help_ptr->eq_list[elem].action.
				       new_red_sit->mark)   )
		      elem++;
		   else
		      {
			found = FALSE;
			help_ptr = help_ptr->next;
		      } /* end of else ( if( (help_ptr->... ) */
	        else
	           if( !(IS_SHRED_NTACT( help_ptr->eq_list[elem].eq_elem ))     &&
                       !(IS_SHRED_NTACT( red_help_ptr->eq_list[elem].eq_elem )) )
	              if( help_ptr->eq_list[elem].action.goto_action ==
		          red_help_ptr->eq_list[elem].action.goto_action )
                         elem++;
	              else
                         {
                           found = FALSE;
		           help_ptr = help_ptr->next;
                          } /* end of else ( if( help_ptr-... ) */
                   else
                      {
                        found = FALSE;
		        help_ptr = help_ptr->next;
                      } /* end of else ( if( !(IS_SHRED_NTA... ) */
           } /* end of if( (help_ptr->nu... */
	else
           help_ptr = help_ptr->next;

     if( found )
	{
	  Gen_Eq_Elem( rep_vc,OPERAND( red_help_ptr->mark ),
		       red_help_ptr->kind,red_help_ptr->state,
		       help_ptr->mark,help_ptr->kind,help_ptr->state,nop,
		       extra_info );

	  if( extra_info )
	     printf("end of function Not_Equal_Code( )\n");
	  return( FALSE );
	} /* end of if( found ) */

     if( extra_info )
	printf("end of function Not_Equal_Code( )\n");
     return( TRUE );
   } /* end of function Not_Equal_Code( ) */




char Unit_Assignment( rep_vc,red_help_ptr,nop,extra_info )

   rep_code                   *rep_vc;  /* vector which saves the infor-
					   mation about shared reduce code
					   and " Unit - Marks "            */
   struct red_out_code  *red_help_ptr;  /* pointer to one reduction code
					   element                         */
   short                          nop;  /* number of productions           */
   char                    extra_info;  /* if extra_info == 1, then extra
					   information about begin and end
					   of function is printed out     */


/* Even though all optimization techniques are applied, it is possible that
   reduction marks exist where only one action lead through. It is
   clearly better, when all jumps to these marks are deleted and the
   corresponding action implemented directly. This function searchs
   for these kind of marks and saves the data in a special structure.
*/

   {

     if( extra_info )
	printf("begin of function Unit_Assignment( )\n");

     if( red_help_ptr->number == 1 )
	if( !(IS_SHRED_NTACT( red_help_ptr->eq_list->eq_elem )) )
	   {
	     Gen_Eq_Elem( rep_vc,OPERAND( red_help_ptr->mark ),
			  red_help_ptr->kind,red_help_ptr->state,
			  0,-1,
			  red_help_ptr->eq_list->action.goto_action,nop,
			  extra_info );

             if( extra_info )
		   printf("end of function Unit_Assignment( )\n");
	     return( FALSE );
	   } /* end of if( !(IS_SHRED... */
	else
	   if( !(red_help_ptr->eq_list->action.
				  new_red_sit->pop)               &&
	       !(IS_SEM( red_help_ptr->eq_list->action.
					  new_red_sit->sem ))     &&
	       !(IS_SEM( red_help_ptr->eq_list->action.
					  new_red_sit->old_sem )) &&
	       (((IS_REDUCEACT( red_help_ptr->eq_list->
				  action.new_red_sit->sem )) &&
		 !(red_help_ptr->eq_list->action.
					 new_red_sit->scan)  )  ||
		(!(IS_REDUCEACT( red_help_ptr->eq_list->
			     action.new_red_sit->sem )) )  )      &&
	       (red_help_ptr->eq_list->action.
				  new_red_sit->pcc == NULL)        )
	      {
		Gen_Eq_Elem( rep_vc,OPERAND( red_help_ptr->mark ),
			     red_help_ptr->kind,red_help_ptr->state,
			     red_help_ptr->eq_list->action.
				 new_red_sit->mark,
			     red_help_ptr->eq_list->action.
				 new_red_sit->kind,
			     red_help_ptr->eq_list->action.
				 new_red_sit->state,
			     nop,extra_info );

		if( extra_info )
		   printf("end of function Unit_Assignment( )\n");
		return( FALSE );
	      } /* end of if( !(red_help... */

     if( extra_info )
	printf("end of function Unit_Assignment( )\n");
     return( TRUE );
   } /* end of function Unit_Assignment( ) */





static void Find_Eq_Mark( out_list,pos,rep_vc,scan_mark,extra_info )

   struct equality   *out_list;  /* pointer to a structure, which saves
				    the code of a list of comparisons      */
   short                   pos;  /* position in this list, which is still 
                                    to be investigated                     */
   rep_code            *rep_vc;  /* vector, which saves the information
				    about shared reduce code and " Unit
				    - Marks "                              */
   char             *scan_mark,
                    extra_info;  /* if extra_info == 1, then extra infor-
				    mation about begin and end of function
				    is printed out                        */

/* The equal reduction code blocks are saved in a list. If there exists a
   jump to a reduction mark in the code which will be printed out, then I
   first look if the mark is changed. If so, then a jump to the reduction 
   mark will be changed to a jump to the representation mark.
*/

   {
     struct eq_code  *code_ptr;  /* used to find an element in the list
				    described above                        */
     char                found=  /* used to decide, if a searched element  */
			 FALSE;  /* is found                               */

     if( extra_info )
	printf("begin of function Find_Eq_Mark( )\n");

     code_ptr = rep_vc[OPERAND( out_list[pos].action.new_red_sit->mark )];

     while( (code_ptr != NULL) && !found )
	if( (code_ptr->state == out_list[pos].action.new_red_sit->state) &&
	    (code_ptr->kind  == out_list[pos].action.new_red_sit->kind)   )
	   found = TRUE;
	else
	   if( ((code_ptr->state == out_list[pos].action.new_red_sit->
								state) &&
	       (code_ptr->kind  > out_list[pos].action.new_red_sit->
								 kind)  ) ||
	       (code_ptr->state > out_list[pos].action.new_red_sit->state) )
	      code_ptr = NULL;
	   else
	      code_ptr = code_ptr->next;

     if( found )
	if( code_ptr->rep_kind == -1 )
	   {
	     out_list[pos].action.new_red_sit->sem =
		  SET_NO_REDUCEACT( out_list[pos].action.new_red_sit->sem );
	     out_list[pos].action.new_red_sit->mark = code_ptr->rep_state;
             if( (out_list[pos].action.new_red_sit->scan) &&
                 !(IS_SEM( out_list[pos].action.new_red_sit->sem ))    &&
                 !(IS_SEM( out_list[pos].action.new_red_sit->old_sem )) )
                scan_mark[out_list[pos].action.new_red_sit->mark] = TRUE;
	   } /* end of if( code_ptr->r... */
	else
	   {
	     out_list[pos].action.new_red_sit->kind  = code_ptr->rep_kind;
	     out_list[pos].action.new_red_sit->state = code_ptr->rep_state;
	     out_list[pos].action.new_red_sit->mark  = code_ptr->rep_prod;
	   } /* end of else ( if( code_ptr->r... ) */

     if( extra_info )
	printf("end of function Find_Eq_Mark( )\n");

   } /* end of function Find_Eq_Mark( ) */



void Change_Red_Eq_Marks( rep_vc,red_ptr,scan_mark,extra_info )

   rep_code                *rep_vc;  /* vector, which saves the informa-
					tion about shared reduce code and
					" Unit - Marks "                   */
   struct red_out_code    *red_ptr;  /* pointer to the structure, which
					saves the reduce code              */
   char                 *scan_mark,
                        extra_info;  /* if extra_info == 1, then extra
					information about begin and end of
					function is printed out           */


/* If there exist a reduction mark, where you jump to another reduction
   mark, it is possible that this mark is deleted because there exist
   an mark with equal code or it was an unit action mark. So this
   function proofs if the jump mark is deleted and determine the new
   action.
*/

   {
     struct red_out_code  *help_ptr;  /* used to find an element in the
					 list, where red_ptr pointed to    */
     short                     elem;  /* loop index                        */

     if( extra_info )
	printf("begin of function Change_Red_Eq_Marks( )\n");

     help_ptr = red_ptr;

     while( help_ptr != NULL )
	{
	  for( elem=0;elem<help_ptr->number;elem++ )
	     if( IS_SHRED_NTACT( help_ptr->eq_list[elem].eq_elem ) )
                if( IS_REDUCEACT( help_ptr->eq_list[elem].action.
                                  new_red_sit->sem ) )
		Find_Eq_Mark( help_ptr->eq_list,elem,rep_vc,scan_mark,
                              extra_info );
	  help_ptr = help_ptr->next;
	} /* end of while( help_ptr... */

     if( extra_info )
	printf("end of function Change_Red_Eq_Marks( )\n");

   } /* end of function Change_Red_Eq_Marks( ) */






void Change_Pars_Eq_Marks( rep_vc,pars_ptr,scan_mark,extra_info )

   rep_code               *rep_vc;  /* vector, which saves the informa-
				       tion about shared reduce code and
				       " Unit - Marks "                   */
   struct parser_code   *pars_ptr;  /* pointer to the structure, which
				       saves the parser code              */
   char                *scan_mark,
                       extra_info;  /* if extra_info == 1, then extra
				       information about begin and end of
				       function is printed out            */

/* This is the same function as Change_Red_Eq_Marks, but here only
   T - table state marks are investigated.
*/

   {
     struct parser_code  *help_ptr;  /* used to find an element in the
					 list, where red_ptr pointed to    */
     short                    elem;  /* loop index                         */

     if( extra_info )
	printf("begin of function Change_Pars_Eq_Marks( )\n");

     help_ptr = pars_ptr;

     while( help_ptr != NULL )
	{
	  for( elem=0;elem<help_ptr->number;elem++ )
	     if( IS_SHRED_NTACT( help_ptr->eq_list[elem].eq_elem ) )
                if( IS_REDUCEACT( help_ptr->eq_list[elem].action.
                                  new_red_sit->sem ) )
		    Find_Eq_Mark( help_ptr->eq_list,elem,rep_vc,scan_mark,
                                  extra_info );
	  help_ptr = help_ptr->next;
	} /* end of while( help_ptr... */

     if( extra_info )
	printf("end of function Change_Pars_Eq_Marks( )\n");

   } /* end of function Change_Pars_Eq_Marks( ) */

