/***************************************************************************/
/* filename : error_out.c                          first edit  :  2.03.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 10.07.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.2 $ */
static char rcsid[] = "$Id: error_out.c,v 1.2 1992/11/27 16:06:29 cogito Exp $";


/*************************** INCLUDE - FILES *******************************/

typedef short *readtype[];

#include<stdio.h>

#include<malloc.h>

#include "over.h"

#include "over_types.h"

#include "out.h"

#include "errors.h"

#include "error_out.h"

/************************* MACRO - DEFINITIONS *****************************/

#define IS_F_REDACT( entry )       entry & 0x2000
#define IS_R_REDACT( entry )       entry & 0x4000
#define SET_ACCEPTACT( entry )     entry | 0x8000

/******************************** FUNCTIONS *******************************/

static void Determ_Sem_Para( quick_data,error_out_data,extra_info )

   readtype              *quick_data;  /* interface vector to optimization */
   struct error_out  *error_out_data;  /* pointer to a structure, which
					  stores all relevant data of the
					  error_code                       */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */


/* To get better error recovery, the user could select some terminals as
   semantic brackets. This function looks for this selection and saves
   the chosen terminals in a list structure.
*/

   {
     short  *attribute_list,  /* list of all terminals and theire attri-
                                 butes ( skip - symbol, semantic - paran-
                                 theses or list - separator )              */
			not,  /* number of terminals                       */
			pos,  /* actual position in the list               */
		       loop;  /* loop index                                */

     if( extra_info )
        printf("begin of function Determ_Sem_Para()\n");


     attribute_list = (*quick_data)[11];
     not            = *((*quick_data)[0]);

     error_out_data->numb_of_para = 0;
     for( loop=0;loop<not;loop++ )
	if( IS_BRACSYMBOL( attribute_list[loop] ) )
	  error_out_data->numb_of_para++;

     if( error_out_data->numb_of_para > 0 )
	{
	  if( (error_out_data->par_set = (short *)
		calloc( error_out_data->numb_of_para,sht )) == NULL )
	    Error_Message( _DETERM_SEM_PARA,MODULE_ERROR_OUT,NO_SPACE_FOR_VECTOR,
                           ABORT," error_out_data->par_set" );
	  pos = 0;
	  for( loop=0;loop<not;loop++ )
	     if( IS_BRACSYMBOL( attribute_list[loop] ) )
		error_out_data->par_set[pos++] = loop;
	} /* end of if( error_out_dat... */
     else
	error_out_data->par_set = NULL;

    if( extra_info )
        printf("end of function Determ_Sem_Para()\n");

   } /* end of function Determ_Sem_Para() */







static short *Build_Rsymbol( quick_data,error_out_data,extra_info )

   readtype              *quick_data;  /* interface vector to optimization */
   struct error_out  *error_out_data;  /* pointer to a structure, which
					  stores all relevant data of the
					  error_code                       */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out       */


/* By the implementation of the error recovery in PGS, two functions,
   fsymbol and rsymbol are used to get the next error token. Fsymbol
   is given by the abstract parser and rsymbol is built here.
*/



   {
     short         *fsymbol,  /* For each state a terminal symbol, the    */
		   *rsymbol,  /* error token, is saved.                   */
	    *attribute_list,  /* list of all terminals and theire attri-
                                 butes ( skip - symbol, semantic - paran-
                                 theses or list - separator )              */ 		      *ttab,  /* a representation of the t - table         */
			not,  /* number of terminals                       */
			nos,  /* number of states                          */
		 term_count,  /* loop index                                */
		      state;  /* loop index                                */

     char             found;  /* used to decide if a while loop should 
                                 break or not                              */


     if( extra_info )
	printf("begin of function Build_Rsymbol( )\n");

     attribute_list = (*quick_data)[11];
     fsymbol        = (*quick_data)[10];
     nos            = *((*quick_data)[9]);
     not            = *((*quick_data)[0]);
     ttab           = (*quick_data)[1];

     error_out_data->fsymbol_equal_rsymbol = TRUE;

     if( (rsymbol = (short *) calloc( nos,sht )) == NULL )
	Error_Message( _BUILD_RSYMBOL,MODULE_ERROR_OUT,NO_SPACE_FOR_VECTOR,ABORT,
                       " rsymbol" );

     for( state=0;state<nos;state++ )
	{
	  term_count = 0;
	  found = FALSE;
	  while( (term_count<not) && !found )
	     {
	       if( ttab[state*not+term_count] != ERROR_ENTRY )
		  if( (IS_SEPASYMBOL( attribute_list[term_count] )) &&
		      (fsymbol[state] != term_count) )
		     {
		       found = TRUE;
		       rsymbol[state] = term_count;
		       error_out_data->fsymbol_equal_rsymbol = FALSE;
		     } /* end of if( IS_SEPASYMB... */
	       term_count++;
	     } /* end of while( (term_co... */
	  if( !found )
	     rsymbol[state] = fsymbol[state];
	} /* end of for( state=0;st... */

     if( extra_info )
	printf("end of function Build_Rsymbol( )\n");

     return( rsymbol );

   } /* end of function function Build_Rsymbol( ) */







static void Proof_Equal_Transitions( error_out_data,extra_info )


   struct error_out  *error_out_data;  /* pointer to a structure, which
					  stores all relevant data of the
					  error_code                       */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */


/* This function tests if some states should share code in vector
   anchor set.
*/


   {
     short         nos,  /* number of states                               */
                 state,  /* loop index                                     */
                 count,  /* loop index                                     */
                  term;  /* loop index                                     */
     char        equal;  /* used to decide if two states are equal or not  */
     int    save_trans;  /* saves the number of shift or shift/reduce 
                            transitions in the T - table                   */


     if( extra_info )
	printf("begin of function Proof_Equal_Transitions( )\n");

     nos = error_out_data->nos;
     save_trans = error_out_data->number_of_shift_trans;
     for( state=0;state<nos;state++ )
        if( (error_out_data->address_list[state].addr.list != NULL) &&
            !(IS_REP( error_out_data->address_list[state].number )) )
           for( count=state+1;count<nos;count++ )
              if( (error_out_data->address_list[count].addr.list != NULL)  &&
                  (error_out_data->address_list[state].number ==
                   error_out_data->address_list[count].number )            &&
                  !(IS_REP( error_out_data->address_list[count].number )) ) 
                {
                   equal = TRUE;
                   term = 0;
                   while( equal && term < error_out_data->
                                          address_list[state].number )
                      if( error_out_data->address_list[state].addr.
                             list[term]   !=
                          error_out_data->address_list[count].addr.
                             list[term] )
                         equal = FALSE;
                      else
                         term++;
                   if( equal )
                      {
                        free( error_out_data->address_list[count].addr.
                              list );
                        error_out_data->address_list[count].addr.rep = state;
                        error_out_data->number_of_shift_trans -=
                            error_out_data->address_list[count].number;
                        error_out_data->address_list[count].number = 
                           SET_REP( error_out_data->address_list[count].
                                    number );
                      } /* end of if( equal ) */
                } /* end of if( (error_out_dat... */

     if( (save_trans - error_out_data->number_of_shift_trans) > nos )
        error_out_data->share_address = TRUE;
     else
        {
          error_out_data->share_address = FALSE; 
          error_out_data->number_of_shift_trans = save_trans;
        } /* end of else ( if( (save_trans - e... ) */

     if( extra_info )
	printf("end of function Proof_Equal_Transitions( )\n");

   }  /* end of function Proof_Equal_Transitions() */






static void Build_Anchor_Set( quick_data,error_out_data,rsymbol,extra_info )

   readtype              *quick_data;  /* interface vector to optimization */
   struct error_out  *error_out_data;  /* pointer to a structure, which
					  stores all relevant data of the
					  error_code                       */
   short                    *rsymbol;  /* For each state a terminal symbol, 
                                          the error token, is saved.       */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */

/* I need the folowing information for the automatic error correction.
   If there exists an error token in a state s which have a shift or
   shift/reduce transition, then save all terminals which have a shift
   or shift/reduce transition in state s.
*/

   {
     short            *ttab,  /* a representation of the T - table         */
		   *fsymbol,  /* For each state a terminal symbol, the    
		                 error token, is saved.                    */
	    *attribute_list,  /* list of all terminals and their attri-
                                 butes ( skip - symbol, semantic - paran-
                                 theses or list - separator )              */
			not,  /* number of terminals                       */
			nos,  /* number of nonterminals                    */
		      state,  /* loop index                                */
		       term,  /* loop index                                */
		   sh_trans,  /* all saved shift or shift - reduce transi-
                                 tions                                     */
                state_trans;  /* all shift or shift/reduce transitions in
                                 one state                                 */


     if( extra_info )
	printf("begin of function Build_Anchor_Set(  )\n");

     attribute_list = (*quick_data)[11];
     fsymbol        = (*quick_data)[10];
     nos            = *((*quick_data)[9]);
     not            = *((*quick_data)[0]);
     ttab           = (*quick_data)[1];

     if( (error_out_data->address_list = (struct shift_trans*) calloc(
				nos,sizeof( struct shift_trans ) )) == NULL ) 
	Error_Message( _BUILD_ANCHOR_SET,MODULE_ERROR_OUT,NO_SPACE_FOR_VECTOR,
                       ABORT," error_out_data->address_list" );

     error_out_data->number_of_shift_trans = 0;


     sh_trans = 0;
     for( state=0;state<nos;state++ )
	if( IS_SHIFTACT( ttab[state*not+fsymbol[state]] )   ||
	    IS_SHIFTACT( ttab[state*not+rsymbol[state]] )   ||
            IS_ACCEPTACT( ttab[state*not+fsymbol[state]] )  ||
	    IS_ACCEPTACT( ttab[state*not+rsymbol[state]] )  ||
	    IS_SHREDACT( ttab[state*not+fsymbol[state]] )   ||
	    IS_SHREDACT( ttab[state*not+rsymbol[state]] )    )
	   {
             state_trans = 0;
	     for( term=0;term<not;term++ )
		if( (IS_SHREDACT( ttab[state*not+term] ))  ||
                    (IS_ACCEPTACT( ttab[state*not+term] )) ||
		    (IS_SHIFTACT( ttab[state*not+term] ))   )
		   if( !(IS_SKIPSYMBOL( attribute_list[term] )) )
                      {
		        sh_trans++;
                        state_trans++;
                      }
             error_out_data->number_of_shift_trans += state_trans;
             error_out_data->address_list[state].number = state_trans;
             if( (error_out_data->address_list[state].addr.list = (short*) 
                     calloc( state_trans,sizeof( short ) )) == NULL ) 
	        Error_Message( _BUILD_ANCHOR_SET,MODULE_ERROR_OUT,
                               NO_SPACE_FOR_VECTOR,ABORT,
                               " error_out_data->address_list[state].addr.list" );

             state_trans = 0;
	     for( term=0;term<not;term++ )
		if( (IS_SHREDACT( ttab[state*not+term] ))  ||
                    (IS_ACCEPTACT( ttab[state*not+term] )) ||
		    (IS_SHIFTACT( ttab[state*not+term] ))   )
		   if( !(IS_SKIPSYMBOL( attribute_list[term] )) )
		      error_out_data->address_list[state].addr.list[
                              state_trans++] = term;
	   } /* end of if( IS_SHIFTACT... */


     Proof_Equal_Transitions( error_out_data,extra_info );

     if( extra_info )
	printf("end of function Build_Anchor_Set(  )\n");


   } /* end of function Build_Anchor_Set(  ) */






static struct equality *Find_Eq_List_Transition( optim_out_data,search_ptr,
						 pos,symbol,extra_info )


   struct optim_out    *optim_out_data;  /* internal interface pointer to 
                                            a structure which consits of 
                                            some pointer to different code
                                            blocks                         */
   struct parser_code      *search_ptr;  /* pointer to the parser code     */
   short                        symbol,  /* the error symbol               */
				  *pos;  /* position in vector eq_list     */
   char                     extra_info;  /* if extra_info == 1, then extra
					    information about begin and end
					    of function is printed out    */



/* For each state a block of code is built in the parser. The error 
   recovery needed only a little part of each code block. This function
   determines this part.
*/


   {
     struct equality  *help_ptr;  /* used to find the elements             */
     char                 found=  /* used to decide if the correct part is */
			  FALSE,  /* found or not                          */
			   part;  /* if part = TRUE, then the current code
                                     block is a part of another state      */
     short               number,  /* number of elemnts in vector eq_list   */
			   loop;  /* loop index                            */

     if( extra_info )
	printf("begin of function Find_Eq_List_Transition( )\n");

     while( !found )
	{
	  number = search_ptr->number;
	  help_ptr = search_ptr->eq_list;
	  for( loop=0;loop<number;loop++ )
	      if( OPERAND( help_ptr[loop].eq_elem ) == symbol )
		 {
		   found = TRUE;
		   *pos  = loop;
		 } /* end of if( OPERAND( h... */
	  if( !found )
	     if( search_ptr->goto_default >= 0 )
		{
		  number = OPERAND( search_ptr->goto_default );
		  search_ptr = optim_out_data->parser;
		  part = FALSE;
		  /* find Q_x mark */
		  while( (search_ptr != NULL) && !found )
		     if( (search_ptr->mark == number) && part )
			found = TRUE;
		     else
			{
			  if( (search_ptr->goto_default == -1) ||
                              (search_ptr->goto_default == -5)  )
			     part = TRUE;
			  else
			     part = FALSE;
			  search_ptr = search_ptr->next;
			} /* end of else ( while( (search_... ) */
		  if( !found )
		     Error_Message( _FIND_EQ_LIST_TRANSITION,
                                    MODULE_ERROR_OUT,
                                    NOT_FIND_ELEMENT,ABORT," number" );
		  found = FALSE;
		} /* end of if( search_ptr-... */
	     else
		if( search_ptr->goto_default == -4 )
		    {
                      found = TRUE;
		      *pos  = search_ptr->number-1;
		    } /* end of else ( if( search_ptr-... ) */
		else
		   if( search_ptr->goto_default == -3 )
		      {
			number   = optim_out_data->sim_act_code->number;
			help_ptr = optim_out_data->sim_act_code->eq_list;
			for( loop=0;loop<number;loop++ )
			   if( OPERAND( help_ptr[loop].eq_elem ) == symbol )
			      {
				found = TRUE;
				*pos  = loop;
			      } /* end of if( OPERAND( he... */
			if( !found )
			   Error_Message( _FIND_EQ_LIST_TRANSITION,
                                          MODULE_ERROR_OUT,
                                          NOT_FIND_ELEMENT,ABORT," symbol");
		      } /* end of if( search_ptr-... */
		   else
		      if( (search_ptr->goto_default == -1) ||
                          (search_ptr->goto_default == -5)  )
			 search_ptr = search_ptr->next;
		      else
			 Error_Message( _FIND_EQ_LIST_TRANSITION,
                                        MODULE_ERROR_OUT,
                                        NOT_FIND_ELEMENT,ABORT," symbol");
	} /* end of while( !found ) */

     if( extra_info )
	printf("end of function Find_Eq_List_Transition( )\n");

     return( help_ptr );

   } /* end of function Find_Eq_List_Transition( ) */










static short Count_Red_Code( red_code_list,extra_info )

   struct red_out_code  *red_code_list;  /* the list of the complete 
                                            reduction code                 */
   char                     extra_info; /* if extra_info == 1, then extra
					   information about begin and end
					   of function is printed out     */

/* This function counts how many reduction marks exist in the error
   recovery.
*/


   {
     struct red_out_code   *help_ptr;  /* used to control the count        */
     short                  number=1;  /* count the number of reduction 
                                          marks                            */

     if( extra_info )
        printf("begin of function Count_Red_Code()\n");

     help_ptr = red_code_list;
     while( help_ptr != NULL )
        {
          number++;
          help_ptr = help_ptr->next;
        } /* end of while( help_pt... */

     if( extra_info )
        printf("end of function Count_Red_Code()\n");

     return( number );

   } /* end of function Count_Red_Code() */





struct red_out_code *Find_Red_Code( help_ptr,mark,state,kind,pos,
                                           extra_info )

   struct red_out_code   *help_ptr;  /* pointer to the reduction code      */
   short                      mark,  /* Reduction code elements are defin- */
                             state,  /* ed by these three components. They */
                              kind,  /* are used to find the searched ele-
                                        ment                               */
                              *pos;  /* position of the searched element 
                                        in the reduction code list         */
   char                 extra_info; /* if extra_info == 1, then extra
				       information about begin and end
				       of function is printed out         */

/* Searched the given reduction mark in the reduction list.
*/

   {
     char   found=FALSE;  /* used to decide if the elemnt is found or not  */

     if( extra_info )
        printf("begin of function Find_Red_Code()\n");

     *pos = 1;

     while( (help_ptr != NULL) && !found )
        {
          if( (help_ptr->mark  == mark)  &&
              (help_ptr->state == state) && 
              (help_ptr->kind  == kind)  )
             found = TRUE;
          else
             {
               (*pos)++;
               help_ptr = help_ptr->next;
             } /* end of else ( if( (help_ptr->m... ) */
        } /* end of while( (help_ptr !... */
     if( help_ptr == NULL )
        Error_Message( _FIND_RED_CODE,MODULE_ERROR_OUT,NOT_FIND_ELEMENT,ABORT,
                       " mark,state and kind" );

     if( extra_info )
        printf("end of function Find_Red_Code()\n");

     return( help_ptr );

   } /* end of function Find_Red_Code() */







static void Build_Error_Automaton( quick_data,error_out_data,optim_out_data,
				   rsymbol,extra_info )


   readtype              *quick_data;  /* interface vector to optimization */
   struct error_out  *error_out_data;  /* pointer to a structure, which
					  stores all relevant data of the
					  error_code                       */
   struct optim_out  *optim_out_data;  /* internal interface pointer to a 
                                          structure which consits of some   
                                          pointer to different code blocks */
   short                    *rsymbol;  /* For each state a terminal symbol, 
                                          the error token, is saved.       */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */



/* This function builds all relevant data structures for the error automaton.
   The information will be saved in vectors, which could be printed out
   easily.
*/


   {
     struct red_out_code  *help_red_ptr;  /* pointer to the reduction code 
                                             list                          */
     struct parser_code  *help_pars_ptr,  /* pointer to the parser code 
                                             list                          */
			    *search_ptr;  /* used to find parser code 
                                             elements                      */
     struct equality          *help_ptr;  /* help pointer for equal lists  */
     short                          sit,  /* used to decide if fsymbol or 
                                             rsymbol should be investigate */
				  state,  /* loop index                    */
				    pos,  /* position in vector eq_list    */
                                    nos,  /* number of states              */
                                    szc,  /* size of char in bits          */
                                elem[1],  /* position in vector reduction 
                                             code                          */
                                 length,  /* length of the used bitsets in
                                             byte                          */
                                 number,  /* number of reduction code 
                                             elements                      */
			       *fsymbol;  /* For each state a terminal 
                                             symbol, the error token, is 
                                             saved.                        */
     char                          part=  /* if part = TRUE, then the cur- */
                                   FALSE, /* rent code block is a part of 
                                             another state                 */
				  found;  /* used to decide, if a searched
                                             element is found or not       */


     if( extra_info )
	printf("begin of function Build_Error_Automaton( )\n");

     fsymbol = (*quick_data)[10];
     nos = error_out_data->nos;
     szc = sizeof( char ) * BYTE;
     length = (!(nos%szc)) ? (nos/szc) : ((nos/szc)+1);
     help_red_ptr = error_out_data->red_code;
     number = Count_Red_Code( help_red_ptr,extra_info );

     

     if( ((error_out_data->push = (char *) calloc(
		                  length,sizeof( char ) )) == NULL) ||
         ((error_out_data->fsymbol_sem1 = (short *) calloc(
		                                nos,sht )) == NULL) ||
         ((error_out_data->rsymbol_sem1 = (short *) calloc(
		                                nos,sht )) == NULL) ||
         ((error_out_data->fsymbol_sem2 = (short *) calloc(
		                                nos,sht )) == NULL) ||
         ((error_out_data->rsymbol_sem2 = (short *) calloc(
		                                nos,sht )) == NULL) ||
         ((error_out_data->fsymbol_pop = (char *) calloc(
		                     nos,sizeof( char ) )) == NULL) ||
         ((error_out_data->rsymbol_pop = (char *) calloc(
		                     nos,sizeof( char ) )) == NULL) ||
         ((error_out_data->fsymbol_scan = (char *) calloc(
		                  length,sizeof( char ) )) == NULL) ||
         ((error_out_data->rsymbol_scan = (char *) calloc(
		                  length,sizeof( char ) )) == NULL) ||
         ((error_out_data->visited = (char *) calloc(
		                  length,sizeof( char ) )) == NULL) ||
         ((error_out_data->fsymbol_action = (short *) calloc(
		                                nos,sht )) == NULL) ||
         ((error_out_data->rsymbol_action = (short *) calloc(
		                                nos,sht )) == NULL) ||
         ((error_out_data->fsymbol_pcc_list = (pcc_list *) calloc(
		                 nos,sizeof( pcc_list ) )) == NULL) ||
         ((error_out_data->rsymbol_pcc_list = (pcc_list *) calloc(
		                 nos,sizeof( pcc_list ) )) == NULL) ||                     ((error_out_data->print_out = (char*) calloc( 
                                  number,sizeof( char ) )) == NULL) ) 
	Error_Message( _BUILD_ERROR_AUTOMATON,MODULE_ERROR_OUT,
                       NO_SPACE_FOR_VECTOR,ABORT,
                       " error_out_data->error_automaton");

     help_pars_ptr = optim_out_data->parser;
     help_ptr = NULL;
     error_out_data->fsymbol_accept = -1;
     error_out_data->rsymbol_accept = -1;
     for( state=0;state<error_out_data->nos;state++ )
        {
          error_out_data->fsymbol_sem1[state] = -1;
          error_out_data->rsymbol_sem1[state] = -1;
          error_out_data->fsymbol_sem2[state] = -1;
          error_out_data->rsymbol_sem2[state] = -1;
        }

     if( !error_out_data->fsymbol_equal_rsymbol )
        for( state=0;state<error_out_data->nos;state++ )
           if( error_out_data->fsymbol[state] ==
               error_out_data->rsymbol[state]  )
              error_out_data->visited[state/szc] = error_out_data->
                                              visited[state/szc] |
                                              (1<<(state%szc));
     for( state=0;state<error_out_data->nos;state++ )
	{
	  found = FALSE;
	  while( !found )
	     {
	       if( (help_pars_ptr->mark == state) && !part )
		  found = TRUE;
	       else
		  {
		    if( (help_pars_ptr->goto_default == -1) ||
                        (help_pars_ptr->goto_default == -5)  )
		       part = TRUE;
		    else
		       part = FALSE;
		    help_pars_ptr = help_pars_ptr->next;
		  } /* end of else ( if( (help_pars_... ) */
	     } /* end of while( !found ) */


	  if( help_pars_ptr->push )
             error_out_data->push[state/szc] = error_out_data->
                    push[state/szc] | (1<<(state%szc));

	  for( sit=0;sit<((rsymbol[state] != fsymbol[state]) ? 2 : 1);sit++ )
	     {
	       search_ptr = help_pars_ptr;
	       if( sit )
		  {
		    help_ptr = Find_Eq_List_Transition( optim_out_data,
							search_ptr,&pos,
							rsymbol[state],
							extra_info );
		    if( IS_SHRED_NTACT( help_ptr[pos].eq_elem ) )
		       {
			 error_out_data->rsymbol_pop[state]  =
				 help_ptr[pos].action.new_red_sit->pop;

                         if( IS_SEM( help_ptr[pos].action.new_red_sit->
                                     old_sem ) )
                            {
			      error_out_data->rsymbol_sem1[state] =
				   OPERAND( help_ptr[pos].action.new_red_sit->
                                            old_sem );
                              error_out_data->seman_out[OPERAND( help_ptr[pos].
                                 action.new_red_sit->old_sem )] = TRUE;
                            }
                         else
                            error_out_data->rsymbol_sem1[state] = -1;

                         if( IS_SEM( help_ptr[pos].action.new_red_sit->
                                     sem ) )
                            {
			      error_out_data->rsymbol_sem2[state] =
				   OPERAND( help_ptr[pos].action.new_red_sit->
                                            sem );
                              error_out_data->seman_out[OPERAND( help_ptr[pos].
                                 action.new_red_sit->sem )] = TRUE;
                            }
                         else 
                            error_out_data->rsymbol_sem2[state] = -1;

		         if( help_ptr[pos].action.new_red_sit->scan )
                            error_out_data->rsymbol_scan[state/szc] =
                               error_out_data->rsymbol_scan[state/szc]  |
                               (1 << (state%szc));
                         if( IS_REDUCEACT( help_ptr[pos].action.new_red_sit->
                                           sem ) )
                            {
                              help_red_ptr = error_out_data->red_code;
                              help_red_ptr = Find_Red_Code( 
                                             help_red_ptr,
                                             help_ptr[pos].action.
                                                new_red_sit->mark,
				             help_ptr[pos].action.
                                                new_red_sit->state,
				             help_ptr[pos].action.
                                                new_red_sit->kind,
                                             elem,extra_info );
                              error_out_data->print_out[*elem] = 1;
                              error_out_data->rsymbol_action[state] = 
                                    -(*elem);
                            }
                         else
                            {
                              *elem = help_ptr[pos].action.new_red_sit->mark;
                              error_out_data->rsymbol_action[state] = *elem;
                            }
		         if( help_ptr[pos].action.new_red_sit->pcc != NULL )
                            error_out_data->rsymbol_pcc_list[state] = 
                               help_ptr[pos].action.new_red_sit->pcc;
		       } /* end of if( IS_SHRED_NT... */
		    else
		       {
			 if( IS_ACCEPTACT( help_ptr[pos].eq_elem ) )
                            if( IS_REDUCEACT( help_ptr[pos].action.
                                              goto_action ) )
                               {
                                 error_out_data->rsymbol_sem1[state] = 
                                    OPERAND( 
                                       help_ptr[pos].action.goto_action );
                                 error_out_data->rsymbol_scan[state/szc] =
                                    error_out_data->rsymbol_scan[state/szc]  |
                                    (1 << (state%szc));
                                 error_out_data->rsymbol_action[state] = 0;
                                 error_out_data->rsymbol_accept = state;
                                 error_out_data->seman_out[OPERAND( 
                                    help_ptr[pos].action.goto_action )] =
                                             TRUE;
                               } /* end of if( IS_REDUCEACT... */
                            else
                               {
                                 error_out_data->rsymbol_scan[state/szc] =
                                    error_out_data->rsymbol_scan[state/szc]  |
                                    (1 << (state%szc));
                                 error_out_data->rsymbol_sem1[state] = -1;
                                 error_out_data->rsymbol_action[state] = 0;
                                 error_out_data->rsymbol_accept = state;
                               }
			 else
                            {
                              error_out_data->rsymbol_scan[state/szc] =
                                 error_out_data->rsymbol_scan[state/szc]  |
                                 (1 << (state%szc));
                              error_out_data->rsymbol_action[state] =
					    help_ptr[pos].action.goto_action;
                            }
		       } /* end of else ( if( IS_SHRED_NT... ) */
		  } /* end of if( sit ) */
	       else
		  {
		    help_ptr = Find_Eq_List_Transition( optim_out_data,
							search_ptr,&pos,
							fsymbol[state],
							extra_info );
		    if( IS_SHRED_NTACT( help_ptr[pos].eq_elem ) )
		       {
			 error_out_data->fsymbol_pop[state]  =
				 help_ptr[pos].action.new_red_sit->pop;
                         if( IS_SEM( help_ptr[pos].action.new_red_sit->
                                     old_sem ) )
                            {
			      error_out_data->fsymbol_sem1[state] =
				   OPERAND( help_ptr[pos].action.new_red_sit->
                                            old_sem );
                              error_out_data->seman_out[OPERAND( help_ptr[pos].
                                 action.new_red_sit->old_sem )] = TRUE;
                            }
                         else
                            error_out_data->fsymbol_sem1[state] = -1;

                         if( IS_SEM( help_ptr[pos].action.new_red_sit->
                                     sem ) )
                            {
			      error_out_data->fsymbol_sem2[state] =
				   OPERAND( help_ptr[pos].action.new_red_sit->
                                            sem );
                              error_out_data->seman_out[OPERAND( help_ptr[pos].
                                 action.new_red_sit->sem )] = TRUE;
                            }
                         else
                            error_out_data->fsymbol_sem2[state] = -1;

		         if( help_ptr[pos].action.new_red_sit->scan )
                            error_out_data->fsymbol_scan[state/szc] =
                               error_out_data->fsymbol_scan[state/szc]  |
                               (1 << (state%szc));
                         if( IS_REDUCEACT( help_ptr[pos].action.new_red_sit->
                                           sem ) )
                            {
                              help_red_ptr = error_out_data->red_code;
                              help_red_ptr = Find_Red_Code( 
                                             help_red_ptr,
                                             help_ptr[pos].action.
                                               new_red_sit->mark,
				             help_ptr[pos].action.
                                               new_red_sit->state,
				             help_ptr[pos].action.
                                               new_red_sit->kind,
                                             elem,extra_info );
                              error_out_data->print_out[*elem] = 1;
                              error_out_data->fsymbol_action[state] =
                                   -(*elem);
                            }
                         else
                            {
                              *elem = help_ptr[pos].action.new_red_sit->mark;
                              error_out_data->fsymbol_action[state] = *elem;
                            }
		         if( help_ptr[pos].action.new_red_sit->pcc != NULL )
                            {
                              error_out_data->fsymbol_pcc_list[state] = 
                                 help_ptr[pos].action.new_red_sit->pcc;
                            }
		       } /* end of if( IS_SHRED_NT... */
		    else
		       {
			 if( IS_ACCEPTACT( help_ptr[pos].eq_elem ) )
                            if( IS_REDUCEACT( help_ptr[pos].action.
                                              goto_action ) )
                               {
                                 error_out_data->fsymbol_sem1[state] = 
                                   OPERAND( 
                                      help_ptr[pos].action.goto_action );
                                 error_out_data->fsymbol_scan[state/szc] =
                                    error_out_data->fsymbol_scan[state/szc]  |
                                    (1 << (state%szc));
                                 error_out_data->fsymbol_action[state] = 0;
                                 error_out_data->fsymbol_accept = state;
                                 error_out_data->seman_out[OPERAND( 
                                    help_ptr[pos].action.goto_action )] = 
                                          TRUE;
                               } /* end of if( IS_REDUCEACT... */
                            else
                               {
                                 error_out_data->fsymbol_scan[state/szc] =
                                    error_out_data->fsymbol_scan[state/szc]  |
                                    (1 << (state%szc));
                                 error_out_data->fsymbol_sem1[state] = -1;
                                 error_out_data->fsymbol_action[state] = 0;
                                 error_out_data->fsymbol_accept = state;
                               }
			 else
                            {
                              error_out_data->fsymbol_scan[state/szc] =
                                 error_out_data->fsymbol_scan[state/szc]  |
                                 (1 << (state%szc));
                              error_out_data->fsymbol_action[state] =
					    help_ptr[pos].action.goto_action;
                            }
		       } /* end of else ( if( IS_SHRED_NT... ) */
		  } /* end of else ( if( sit ) ) */
	     } /* end of for( sit=0;sit<... */
	} /* end of for( state=0;state... */

     state=0;found=FALSE;
     while( (state<length) && !found )
        if( error_out_data->push[state++] != 0 )
           found = TRUE;
     if( !found )
        {
          free( error_out_data->push );
          error_out_data->push = NULL;
        }


     state=0;found=FALSE;
     while( (state<nos) && !found )
        if( error_out_data->fsymbol_sem1[state++] != -1 )
           found = TRUE;
     if( !found )
        {
          free( error_out_data->fsymbol_sem1 );
          error_out_data->fsymbol_sem1 = NULL;
        }

     state=0;found=FALSE;
     while( (state<nos) && !found )
        if( error_out_data->rsymbol_sem1[state++] != -1 )
           found = TRUE;
     if( !found )
        {
          free( error_out_data->rsymbol_sem1 );
          error_out_data->rsymbol_sem1 = NULL;
        }

     state=0;found=FALSE;
     while( (state<nos) && !found )
        if( error_out_data->fsymbol_sem2[state++] != -1 )
           found = TRUE;
     if( !found )
        {
          free( error_out_data->fsymbol_sem2 );
          error_out_data->fsymbol_sem2 = NULL;
        }

     state=0;found=FALSE;
     while( (state<nos) && !found )
        if( error_out_data->rsymbol_sem2[state++] != -1 )
           found = TRUE;
     if( !found )
        {
          free( error_out_data->rsymbol_sem2 );
          error_out_data->rsymbol_sem2 = NULL;
        }

     state=0;found=FALSE;
     while( (state<nos) && !found )
        if( error_out_data->fsymbol_pop[state++] != 0 )
           found = TRUE;
     if( !found )
        {
          free( error_out_data->fsymbol_pop );
          error_out_data->fsymbol_pop = NULL;
        }

     state=0;found=FALSE;
     while( (state<nos) && !found )
        if( error_out_data->rsymbol_pop[state++] != 0 )
           found = TRUE;
     if( !found )
        {
          free( error_out_data->rsymbol_pop );
          error_out_data->rsymbol_pop = NULL;
        }

     state=0;found=FALSE;
     while( (state<length) && !found )
        if( error_out_data->fsymbol_scan[state++] != 0 )
           found = TRUE;
     if( !found )
        {
          Error_Message(_BUILD_ERROR_AUTOMATON,MODULE_ERROR_OUT,
                        NOT_FIND_ELEMENT,ABORT,
                       " error_out_data->fsymbol_scan[state++]");
          free( error_out_data->fsymbol_scan);
          error_out_data->fsymbol_scan = NULL;
        }

     state=0;found=FALSE;
     while( (state<length) && !found )
        if( error_out_data->rsymbol_scan[state++] != 0 )
           found = TRUE;
     if( !found )
        {
          free( error_out_data->rsymbol_scan);
          error_out_data->rsymbol_scan = NULL;
        }



     state=0;found=FALSE;
     while( (state<nos) && !found )
        if( error_out_data->fsymbol_action[state++] != 0 )
           found = TRUE;
     if( !found )
        {
          Error_Message(_BUILD_ERROR_AUTOMATON,MODULE_ERROR_OUT,
                        NOT_FIND_ELEMENT,ABORT,
                       " error_out_data->fsymbol_action[state++]");
          free( error_out_data->fsymbol_action );
          error_out_data->fsymbol_action = NULL;
        }

     state=0;found=FALSE;
     while( (state<nos) && !found )
        if( error_out_data->rsymbol_action[state++] != 0 )
           found = TRUE;
     if( !found )
        {
          free( error_out_data->rsymbol_action );
          error_out_data->rsymbol_action = NULL;
        }

     state=0;found=FALSE;
     while( (state<nos) && !found )
        if( error_out_data->fsymbol_pcc_list[state++] != NULL )
           found = TRUE;
     if( !found )
        {
          free( error_out_data->fsymbol_pcc_list );
          error_out_data->fsymbol_pcc_list = NULL;
        }

     state=0;found=FALSE;
     while( (state<nos) && !found )
        if( error_out_data->rsymbol_pcc_list[state++] != NULL )
           found = TRUE;
     if( !found )
        {
          free( error_out_data->rsymbol_pcc_list );
          error_out_data->rsymbol_pcc_list = NULL;
        }


     if( extra_info )
	printf("end of function Build_Error_Automaton( )\n");

   } /* end of function Build_Error_Automaton( ) */







static void Det_Rec_Red_Code( print_out,red_elem,red_code_list,extra_info )

   char                     *print_out,  /* all reduction code elements,
                                            used by the error recovery are
                                            marked                         */
                            extra_info;  /* if extra_info == 1, then extra
				            information about begin and end
				            of function is printed out    */
   struct red_out_code       *red_elem,  /* one elem of the reduction code
                                            list                           */
                        *red_code_list;  /* the reduction code list        */



/* This function determines recursivly which reduction code elements are
   used by the already marked reduction code element.                     
*/



   {
     short                        count,  /* loop index                    */
                                elem[1];  /* position in the reduction 
                                             code list                     */
     struct red_out_code  *help_red_ptr;  /* help pointer to reduction
                                             code list                     */

     if( extra_info )
        printf("begin of function Det_Rec_Red_Code()\n");

     for( count=0;count<red_elem->number;count++ )
        {
          if( IS_SHRED_NTACT( red_elem->eq_list[count].eq_elem ) )
             if( IS_REDUCEACT( red_elem->eq_list[count].action.new_red_sit
                               ->sem ) )
                {
                  help_red_ptr = red_code_list;
                  help_red_ptr = Find_Red_Code( help_red_ptr,
                                        red_elem->eq_list[count].action.
                                            new_red_sit->mark,
                                        red_elem->eq_list[count].action.
                                            new_red_sit->state,
                                        red_elem->eq_list[count].action.
                                            new_red_sit->kind,elem,
                                        extra_info );
                  /* set mmark to the new switch - case value */
                  red_elem->eq_list[count].action.new_red_sit->mark  = *elem;
                  red_elem->eq_list[count].action.new_red_sit->state = 0;
                  red_elem->eq_list[count].action.new_red_sit->kind  = 0;
                  if( !print_out[*elem] )
                     {
                       print_out[*elem] = 2;
                       Det_Rec_Red_Code( print_out,
                                         help_red_ptr,
                                         red_code_list,   
                                         extra_info );
                     } /* end of if( !print_out[el... */

             } /* end of if( IS_REDUCEACT(... */
        } /* end of for( count=0;count... */

     if( extra_info )
        printf("end of function Det_Rec_Red_Code()\n");

   } /* end of function Det_Rec_Red_Code() */






static char *Determine_Possible_Red_Code( error_out_data,extra_info )

   struct error_out  *error_out_data;  /* pointer to a structure, which
					  stores all relevant data of the
					  error_code                       */
   char                   extra_info;  /* if extra_info == 1, then extra
				          information about begin and end
				          of function is printed out      */


/* This function determines which reduction code elements used by the 
   error automaton.
*/



   {
     short                          number,  /* number of reduction code 
                                                elements                   */
                                     count;  /* loop index                 */
     struct red_out_code     *help_red_ptr,  /* help pointer to the reduc- */                            *red_code_list;  /* tion code list             */

     if( extra_info )
        printf("begin of function Determine_Possible_Red_Code()\n");

     red_code_list = error_out_data->red_code;
     help_red_ptr = error_out_data->red_code;

     number = Count_Red_Code( red_code_list,extra_info );

     for( count=1;count<number;count++ )
        {
          if( error_out_data->print_out[count] == 1 )
             Det_Rec_Red_Code( error_out_data->print_out,help_red_ptr,
                               red_code_list,extra_info );
          help_red_ptr = help_red_ptr->next;
        } /* end of for( count=0;co... */

     if( extra_info )
        printf("end of function Determine_Possible_Red_Code()\n");

   } /* end of function Determine_Possible_Red_Code() */






struct error_out *Build_Error_Out( quick_data,user_data,optim_out_data,
				   extra_info )


   readtype              *quick_data;  /* interface vector to optimization */
   struct user            *user_data;  /* structure which saves informa-
                                          tion entered by the user         */
   struct optim_out  *optim_out_data;  /* internal interface pointer to a                                              structure which consits of some  
                                          pointer to different code blocks */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out      */


/* This function controls the determination of the complete error 
   recovery. The user could choose between two kind of error recovery :
   (1) stop at the first error and 
   (2) Roehrichs error recovery.
*/



   {
     short                    *rsymbol;  /* For each state a terminal 
                                            symbol, the error token, is 
                                            saved.                         */
     struct error_out  *error_out_data;  /* pointer to a structure, which
					  stores all relevant data of the
					  error_code                       */


     if( extra_info )
	printf("begin of function Build_Error_Out( )\n");

     if( (error_out_data = (struct error_out*) malloc(
			     sizeof( struct error_out ) )) == NULL )
	Error_Message( _BUILD_ERROR_OUT,MODULE_ERROR_OUT,NO_SPACE_FOR_STRUCTURE,
                       ABORT," error_out_data" );

     if( (error_out_data->seman_out = (char*) calloc(
			   *((*quick_data)[5]),sizeof( char ) )) == NULL )
	Error_Message( _BUILD_ERROR_OUT,MODULE_ERROR_OUT,NO_SPACE_FOR_VECTOR,
                       ABORT," error_out_data->seman_out" );

     rsymbol = Build_Rsymbol( quick_data,error_out_data,extra_info );

     Determ_Sem_Para( quick_data,error_out_data,extra_info );

     error_out_data->nos = *((*quick_data)[9]);
     error_out_data->not = *((*quick_data)[0]);
     error_out_data->nop = *((*quick_data)[5]);
     error_out_data->eof = (*quick_data)[2][*((*quick_data)[12])];
     error_out_data->sx_code_list = optim_out_data->sx_code_list;
     error_out_data->red_code = optim_out_data->red_code;
     error_out_data->max_term = optim_out_data->max_term;
     error_out_data->min_term = optim_out_data->min_term;
     error_out_data->seman_list = optim_out_data->seman_list;
     error_out_data->longest_path = optim_out_data->longest_path;
     error_out_data->fsymbol = (*quick_data)[10];
     error_out_data->rsymbol = rsymbol;

     Build_Anchor_Set( quick_data,error_out_data,rsymbol,extra_info );

     Build_Error_Automaton( quick_data,error_out_data,optim_out_data,
			    rsymbol,extra_info );


     Determine_Possible_Red_Code( error_out_data,extra_info );

     if( extra_info )
	printf("end of function Build_Error_Out( )\n");

     return( error_out_data );

   } /* end of function Build_Error_Out( ) */
