/***************************************************************************/
/* filename : build_paths.c                        first edit  : 28.03.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 13.07.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
static char rcsid[] = "$Id: build_paths.c,v 1.1 1992/01/10 14:38:40 cogito Exp $";

/*************************** INCLUDE - FILES *******************************/

typedef short *readtype[];

typedef struct rp *rptype[];

#include<stdio.h>

#include<malloc.h>

#include "over.h"

#include "over_types.h"

#include "determ.h"

#include "high.h"

#include "errors.h"

/****************************** FUNCTIONS **********************************/

static readtype *Build_Reverse_Vertices( quick_data,t_table,extra_info )

   readtype  *quick_data;  /* interface vector to optimization             */
   char          t_table,  /* variable to decide if N - table or T -
			      table optimization is started                */
	      extra_info;  /* if extra_info == 1, then extra information
			      about begin and end of function is printed
			      out                                          */

/* This function builds the reverse representation of the N - or T - table.
   That means, if there is an "edge" from state i to j under symbol s in
   T - table, then there exists an "edge" from j to i under symbol s.
   Because it is possible that there is more than one edge from a state
   under a symbol s you may have another representation of data, as in
   T - table.

   The position, which is fixed by state i and symbol s, contains a link to
   a vector. The first component of the vector stores the length of the
   vector. The other positions in the vector contain the states to which a
   "reverse edge" exist.
   Example :
   In (i,s) you find a link to the following vector :

		+---+---+---+---+
		| 3 | 2 | 4 | 5 |
		+---+---+---+---+

   You can read this information as follows:
   There exist 3 reverse edges from i under symbol s: one to state 2, one to
   state 4 and one to state 5.
*/



   {
     short               nos,   /* number of states         	           */
			 nox,   /* number of terminals or nonterminals     */
		       *xtab,   /* N - table or T - table representation   */
			term,   /* loop index for terminals                */
		       state,   /* loop index for states                   */
		      *st_vc;   /* state vector, which saves the number of
				   reverse edges for state i and a fixed
				   symbol ( terminal or nonterminal )      */

     readtype       *rv_xtab,   /* representation of the reverse T - table
				   or N - table                            */
		     *ctr_vc;   /* control vector, which is used to give
				   rv_ttab or rv_ntab the correct data     */



     if( extra_info )
	printf("begin of Build_Reverse_Vertices()\n");
     nos = *((*quick_data)[9]);
     if( t_table )
	{
	  nox  = *((*quick_data)[0]);
	  xtab = (*quick_data)[1];
	} /* end of if( t_table ) */
     else
	{
	  nox  = *((*quick_data)[3]);
	  xtab = (*quick_data)[4];
	} /* end of else ( if( t_table ) ) */


     if((( rv_xtab = (readtype*) malloc(
			    nox * nos * sizeof( short *))) == NULL ) ||
	(( ctr_vc = (readtype*) malloc( nos * sizeof( short* ))) == NULL) ||
	(( st_vc  = (short*) malloc( nos * sht )) == NULL ) )
	      Error_Message( _BUILD_REVERSE_VERTICES,MODULE_BUILD_PATHS,
                             NO_SPACE_FOR_VECTOR,ABORT," st_vc" );


     for( term=0;term<nox;term++ )
	{ for( state=0;state<nos;state++ )
	     st_vc[state]=0;

	  /* count for each state, how many entry vertices it has */
	  for( state=0;state<nos;state++ )
	     if( (t_table  && (IS_SHIFTACT( xtab[state*nox+term] )))   ||
		 (!t_table && (IS_SHIFT_NTACT( xtab[state*nox+term] ))) )
		   (st_vc[OPERAND( xtab[state*nox+term] )])++;

	  /* allocate storage space for each state and stores the
	     inzident vertices */
	  for( state=0;state<nos;state++ )
	     if( st_vc[state] > 0 )
		{
		  if(( (*rv_xtab)[state*nox+term] = (short*)calloc(
			   st_vc[state]+1,sht )) == NULL )
				Error_Message( _BUILD_REVERSE_VERTICES,
                                               MODULE_BUILD_PATHS,
                                               NO_SPACE_FOR_VECTOR,ABORT,
                                               " rv_xtab" );
		  (*ctr_vc)[state] = (*rv_xtab)[state*nox+term];
		  *((*ctr_vc)[state]) = st_vc[state];
		  ((*ctr_vc)[state])++;
		} /* end of if( st_vc[state... */
	     else (*rv_xtab)[state*nox+term] = NULL;

	  for( state=0;state<nos;state++ )
	     if( (t_table  && (IS_SHIFTACT( xtab[state*nox+term] )))   ||
		 (!t_table && (IS_SHIFT_NTACT( xtab[state*nox+term] ))) )
		   {
		     *((*ctr_vc)[OPERAND( xtab[state*nox+term] )]) = state;
		     ((*ctr_vc)[OPERAND( xtab[state*nox+term] )])++;
		   } /* end of for( state=0;s... */

	} /* end of for( term=0;te... */

     if( extra_info )
	printf("end of Build_Reverse_Vertices()\n");
     return(rv_xtab);

   } /* end of Build_Reverse_Vertices() */






static short *Red_Sit( quick_data,rv_ttab,rv_ntab,red_state,prod_nr,
		       shift_sit,extra_info )

   readtype  *quick_data,  /* interface vector to optimization             */
		*rv_ttab,  /* the reverse T - table ( see function
			      Build_Reverse_Vertices )                     */
		*rv_ntab;  /* the reverse  N - table ( see function
			      Build_Reverse_Vertices )                     */
   short       red_state,  /* the reduction state                          */
		 prod_nr;  /* number of productions which will be reduced  */

   char        shift_sit,  /* if the reduction situation is a shift/reduce
			      situation, then the last symbol of the rhs will
			      be overlooked                                */
   	      extra_info;  /* if extra_info == 1, then extra information
			      about begin and end of function is printed
			      out                                          */






/* This function computes, for a given reduction situation, all origin
   states and the continuation states belong to.
   The data are represented in a vector with the following structure :

   +-------------++--------+---------+--------------+------------
   | # reduction || # push | origin  | continuation | ...........
   |   paths     || states | state 1 |    state 1   | ...........
   +-------------++--------+---------+--------------+------------

   -----+---------+--------------+
   .... | origin  | continuation |
   .... | state n |    state n   |
   -----+---------+--------------+

   In the first position, the number of reduction paths for the given
   reduction situation is stored. Followed by n-tupels ( origin state,
   continuation state ), where n is the number of reduction paths.

   Origin and continuation state are the only relevant pieces of
   information for reduction paths.  After a second computation the
   number of push-states on the reduction paths are interesting too,
   but then we must compute the minimal push-states.  Storage space is
   reserved for this information.  If direct goto determination applied
   here, we wouldn't need to store all origin and continuation states
   because parsing would always go on at the continuation state level
   without visiting an origin state.  Also, all continuation states are
   equal! The modified data structures are described below.
*/


   {
     char         *copy1_vc,  /* these two vectors are used to compute     */
		  *copy2_vc;  /* the origin states                         */

     short             *rhs,  /* contains a sequence of symbols from the
				 right hand side of the production which
				 will be reduced in state                  */

		 rhs_length,  /* length of the right hand side sequence
				 rhs, above                                */
			lhs,  /* equivalent left-hand-side version of
				 rhs                                       */
			nos,  /* number of states                          */
			not,  /* number of terminal symbols                */
			non,  /* number of nonterminal symbols             */
		      state,  /* loop index for states                     */
		      count,  /* stores the number of origin states        */
		    connect,  /* another loop index                        */
		       loop,  /* help variable                             */
		last_symbol,  /* stores the last symbol on rhs             */
		   *red_sit,  /* stores the complete reduction situation   */
		  *help_ptr,  /* help pointer, to build the reduction
				 situation                                 */
		      *ntab;  /* a representation of the N - table         */





     if( extra_info )
	printf("begin of function Red_Sit()\n");
     nos  = *((*quick_data)[9]);
     not  = *((*quick_data)[0]);
     non  = *((*quick_data)[3]);
     ntab = (*quick_data)[4];


     lhs        = (*quick_data)[6][prod_nr];
     rhs        = (*quick_data)[14+prod_nr];
     rhs_length = (*quick_data)[7][prod_nr];

     if( ((copy1_vc = (char*) malloc ( nos*sizeof(char) )) == NULL ) ||
	 ((copy2_vc = (char*) malloc ( nos*sizeof(char) )) == NULL ) )
	     Error_Message( _RED_SIT,MODULE_BUILD_PATHS,NO_SPACE_FOR_VECTOR,
                            ABORT," copy2_vc" );

     for( state=0;state<nos;state++ )
	{
	  copy1_vc[state] = FALSE;
	  copy2_vc[state] = FALSE;
	} /* end of for( state=0;sta... */

     if( shift_sit )
	{
	  last_symbol = LAST_SYMBOL( rhs,rhs_length );
	  rhs_length--;
	} /* end of if( shift_sit ) */
     last_symbol = LAST_SYMBOL( rhs,rhs_length );
     rhs_length--;
     copy1_vc[red_state] = TRUE;

     /* determine all origin states of the current reduction situation */
     while( rhs_length >= 0 )
	{
	  for( state=0;state<nos;state++ )
	     if( copy1_vc[state] )
		{
		  copy1_vc[state] = FALSE;
		  if( last_symbol<0 )
		     help_ptr = (*rv_ntab)[state*non-last_symbol-2];
		  else
		     help_ptr = (*rv_ttab)[state*not+last_symbol];
		  loop = *help_ptr;
		  for( connect=0;connect<loop;connect++ )
		     copy2_vc[*(++help_ptr)] = TRUE;
		} /* end of for( state=0;sta... */
	  for( state=0;state<nos;state++ )
	     {
	       copy1_vc[state] = copy2_vc[state];
	       copy2_vc[state] = FALSE;
	     } /* end of for( state=0;sta... */
	  last_symbol = LAST_SYMBOL( rhs,rhs_length );
	  rhs_length--;
	} /* end of while( last_sym... */
     /* Now in copy1_vc all origin states are registered */
     count = 0;
     for( state=0;state<nos;state++ )
	if( copy1_vc[state] ) count++;
     if( (red_sit = (short*) malloc( (count*2+2)*sht )) == NULL )
	Error_Message( _RED_SIT,MODULE_BUILD_PATHS,NO_SPACE_FOR_VECTOR,ABORT,
                       " red_sit" );
     help_ptr       = red_sit;
     *(help_ptr++)  = count;
     /* determine the corresponding continuation states */
     for( state=0;state<nos;state++ )
	if( copy1_vc[state] )
	   {
	     *(++help_ptr) = state;
	     *(++help_ptr) = GET_CONT_STATE( ntab,state,non,lhs );
	   } /* end of if( copy1_vc[pr... */

     if( extra_info )
	printf("end of function Red_Sit()\n");
     return( red_sit );
   } /* end of function Red_Sit() */





static struct ptrp *Build_Reduce_Paths( quick_data,rv_ttab,rv_ntab,t_table,
					shift,extra_info )

   readtype  *quick_data,  /* interface vector to optimization             */
		*rv_ttab,  /* the reverse T - table ( see function
			      Build_Reverse_Vertices                       */
		*rv_ntab;  /* the reverse N - table ( see function
			      Build_Reverse_Vertices                       */

   char          t_table,  /* variable, to decide, if N - table or T -
			      table optimization is started                */
		  shift,
	      extra_info;  /* if extra_info == 1, then extra information
			      about begin and end of function is printed
			      out                                          */



/* This function computes the relevant data for all reduction paths.
   The relevant data are the origin states and the continuation states
   belong to. The structure is like the following :
   
   +--------------+--------------+---------------+--------------+
   | production 1 | production 2 | ..............| production n |
   +-----+--------+--------------+---------------+--------------+
	 |
   +-----V----+---+      +----------------------------+
   | state a1 | *------->| structure described above, |
   +----------+---+      | see function Red_Sit       |
   | state a2 | *--->..  +----------------------------+
   +----------+---+
   |    .     | . |
   |    .     | . |
   |    .     | . |
   |    .     | . |
   +----------+---+
   | state an | *--->..
   +----------+---+

   You could get information from this structure by visiting a
   production and search the coresponding state, but I prefer this
   structure because it is very seldom that you search a state. In
   practice, you visit state by state, and this structure echos that.
   Only for chain rule elimination in the N - table is this not an efficient
   structure. But, looking at storage space, I think it is the best
   structure.

*/

   {
     char        *prod_vc;  /* Vector to see if there exists a reduce or
			       shift/reduce entry in T- or N - table for
			       state s                                     */

     short *count_prod_vc,  /* Vector to count the number of states in which
				a reduction of production p is possible    */
		     symb,  /* loop index                                  */
		     prod,  /* loop index                                  */
		    state,  /* loop index                                  */
		      nop,  /* number of productions                       */
		      nox,  /* number of terminals or nonterminals         */
		      nos,  /* number of states                            */
		    *xtab;  /* N - table or T - table representation       */

     struct ptrp *red_sit;  /* abstract data structure to store all
			       reduction situations                        */
     rptype	  *ctr_vc;  /* vector to control the abstract data
			       structure                                   */




     if( extra_info )
	printf("begin of Build_Reduce_Paths()\n");
     nop = *((*quick_data)[5]);
     nos = *((*quick_data)[9]);
     if( t_table )
	{
	  nox  = *((*quick_data)[0]);
	  xtab = (*quick_data)[1];
	} /* end of if( t_table ) */
     else
	{
	  nox  = *((*quick_data)[3]);
	  xtab = (*quick_data)[4];
	} /* end of else ( if( t_table ) ) */


     if((( prod_vc       = (char*) malloc(
			     nop*sizeof(char) )) == NULL )     ||
	(( count_prod_vc = (short*) malloc(
			     nop*sizeof(short) )) == NULL )    ||
	(( red_sit       = (struct ptrp*) malloc(
			     nop*sizeof(struct ptrp) )) == NULL) ||
	(( ctr_vc        = (rptype*) malloc(
			     nop*sizeof(struct rp*) )) == NULL) )
	     Error_Message( _BUILD_REDUCE_PATHS,MODULE_BUILD_PATHS,
                            NO_SPACE_FOR_VECTOR,ABORT," ctr_vc" );

     /* initialize the used data structures */
     for( prod=0;prod<nop;prod++ )
	{
	  prod_vc[prod]       = FALSE;
	  count_prod_vc[prod] = 0;
	} /* end of for( prod=0;pro.. */

     /* search in T - or N - table for reduce or shift/reduce entries
	and count for each production, how often it will be reduced */
     for( state=0;state<nos;state++ )
	{
	  for( symb=0;symb<nox;symb++ )
	     {
	       if( (t_table  && !shift &&
			    (IS_REDUCEACT( xtab[state*nox+symb] ))) ||
		   (t_table  && shift &&
			    (IS_SHREDACT( xtab[state*nox+symb] )))  ||
		   (!t_table &&
			    (IS_SHRED_NTACT( xtab[state*nox+symb] ))) )
		     prod_vc[OPERAND( xtab[state*nox+symb] )] = TRUE;
	     }/* end of for( symb=0;sym... */
	  for( prod=0;prod<nop;prod++ )
	     if( prod_vc[prod] )
		{
		  count_prod_vc[prod]++;
		  prod_vc[prod] = FALSE;
		} /* end of for( prod=0;pro... */
	} /* end of for( state=0;st... */
     for(prod=0;prod<nop;prod++)
	{
	  red_sit[prod].number_of_states = count_prod_vc[prod];
	  if( count_prod_vc[prod]>0 )
	     {
	       if( (red_sit[prod].pointer = (struct rp*) malloc(
		       count_prod_vc[prod]*sizeof(struct rp) )) == NULL)
			   Error_Message( _BUILD_REDUCE_PATHS,MODULE_BUILD_PATHS,
                                          NO_SPACE_FOR_VECTOR,ABORT,
                                          " red_sit[prod].pointer");
	     } /* end of if( count_prod_... */
	  else
	     red_sit[prod].pointer = NULL;
	  (*ctr_vc)[prod] = red_sit[prod].pointer;
	} /* end of for(prod=0;prod... */

     /* determine and save the interested information of the
	reduction situations */
     for( state=0;state<nos;state++ )
	{
	  for( symb=0;symb<nox;symb++ )
	     {
	       if( (t_table  && !shift &&
			    (IS_REDUCEACT( xtab[state*nox+symb] ))) ||
		   (t_table  && shift &&
			    (IS_SHREDACT( xtab[state*nox+symb] )))  ||
		   (!t_table &&
			    (IS_SHRED_NTACT( xtab[state*nox+symb] ))) )
		  prod_vc[OPERAND( xtab[state*nox+symb] )] = TRUE;
	     } /* end of for( symb=0;sym... */
	  if( !t_table )
	     shift = TRUE;
	  for( prod=0;prod<nop;prod++ )
	     if( prod_vc[prod] )
		{
		  (*ctr_vc)[prod]->rep.pt_rp = Red_Sit( quick_data,rv_ttab,
							rv_ntab,state,prod,
							shift,extra_info );
		  (*ctr_vc)[prod]->state = state;
		  if( shift )
		     (*ctr_vc)[prod]->state =
			SET_SHIFT_SITUATION( (*ctr_vc)[prod]->state );
		  /* bit number 15 will be set because the reduction
		     situation is an shift/reduce - situation */
		  prod_vc[prod] = FALSE;
		  (*ctr_vc)[prod]++;
		} /* end of for( prod=0;pro... */
	} /* end of for( state=0;st... */

     if( extra_info )
	printf("end of Build_Reduce_Paths()\n");
     return( red_sit );

   } /* end of Build_Reduce_Paths() */




void Build_Paths( quick_data,paths,extra_info )

   readtype        *quick_data;  /* interface vector to optimization       */
   struct inter_high    *paths;  /* internal interface vector between
				    this module and the module for higher
				    optimization techniques                */
   char    	    extra_info;  /* if extra_info == 1, then extra infor-
				    mation about begin and end of func-
				    tion is printed out                    */



/* This is the control function for the module High_Optim. It calls the
   other functions in the correct order and if TESTOPT is set, some
   information will be writen to file High.wrt.
*/


   {


#ifdef TESTOPT
     FILE               *fp;  /* file pointer, used to write information
				 on an external file                       */
     short              nop,  /* number of productions                     */
		       prod,  /* loop index                                */
			crp,  /* loop index                                */
		      state,  /* loop index                                */
		 count_redp,  /* number of reduction paths of one reduction
				 situation                                 */
		      *redp,  /* pointer to the reduction paths of one
				 reduction situation                       */
		state_count;  /* number of reduction situation of one
				 production                                */
     struct rp    *help_ptr;  /* help pointer to read the information out
				    of internal data structure             */

     nop = *((*quick_data)[5]);
#endif

     if( extra_info )
	printf("begin of function Build_Paths()\n");


     paths->rv_ttab = Build_Reverse_Vertices(quick_data,1,extra_info );

     paths->rv_ntab = Build_Reverse_Vertices(quick_data,0,extra_info );

     paths->ttred_paths = Build_Reduce_Paths( quick_data,
					      paths->rv_ttab,
					      paths->rv_ntab,1,0,
					      extra_info );

     paths->ttsred_paths = Build_Reduce_Paths( quick_data,
					       paths->rv_ttab,
					       paths->rv_ntab,1,1,
					       extra_info );

     paths->ntred_paths = Build_Reduce_Paths( quick_data,
					      paths->rv_ttab,
					      paths->rv_ntab,0,1,
					      extra_info );

#ifdef TESTOPT
   fp = fopen("RED_PATHS.wrt","w");

   fprintf(fp,"The T - Table Reduction Paths :\n");
   fprintf(fp,"( Only REDUCE - Situations )\n\n\n");

   for( prod=0;prod<nop;prod++ )
      {
	help_ptr    = paths->ttred_paths[prod].pointer;
	state_count = paths->ttred_paths[prod].number_of_states;
	for( state=0;state<state_count;state++ )
	   {
	     fprintf(fp,"production %-4d, state %-4d :\n\n",
		     prod,OPERAND( help_ptr[state].state ) );
	     redp       = help_ptr[state].rep.pt_rp;
	     count_redp = *redp;
	     for( crp=0;crp<count_redp;crp++ )
		{
		  fprintf(fp,"origin state = %4d ",redp[crp*2+2] );
		  if( IS_SHRED_NTACT( redp[crp*2+3] ) )
		     fprintf(fp,"  continuation state = shift/reduce %-4d\n",
			     OPERAND( redp[crp*2+3] ) );
		  else
		     fprintf(fp,"  continuation state = %-4d\n",
			     OPERAND( redp[crp*2+3] ) );
		} /* end of for( crp=0;crp<... */
	     fprintf(fp,"\n\n");

	   } /* end of for( state=0;st... */
      } /* end of for( prod=0;pro... */
   fprintf(fp,"\n\n\n");


   fprintf(fp,"The T - Table Reduction Paths :\n");
   fprintf(fp,"( Only SHIFT/REDUCE - Situations )\n\n\n");

   for( prod=0;prod<nop;prod++ )
      {
	help_ptr    = paths->ttsred_paths[prod].pointer;
	state_count = paths->ttsred_paths[prod].number_of_states;
	for( state=0;state<state_count;state++ )
	   {
	     fprintf(fp,"production %-4d, state %-4d :\n\n",
		     prod,OPERAND( help_ptr[state].state ) );
	     redp       = help_ptr[state].rep.pt_rp;
	     count_redp = *redp;
	     for( crp=0;crp<count_redp;crp++ )
		{
		  fprintf(fp,"origin state = %4d ",redp[crp*2+2] );
		  if( IS_SHRED_NTACT( redp[crp*2+3] ) )
		     fprintf(fp,"  continuation state = shift/reduce %-4d\n",
			     OPERAND( redp[crp*2+3] ) );
		  else
		     fprintf(fp,"  continuation state = %-4d\n",
			     OPERAND( redp[crp*2+3] ) );
		} /* end of for( crp=0;crp<... */
	     fprintf(fp,"\n\n");

	   } /* end of for( state=0;st... */
      } /* end of for( prod=0;pro... */
   fprintf(fp,"\n\n\n");



   fprintf(fp,"The N - Table Reduction Paths :\n\n\n");
   for( prod=0;prod<nop;prod++ )
      {
	help_ptr    = paths->ntred_paths[prod].pointer;
	state_count = paths->ntred_paths[prod].number_of_states;
	for( state=0;state<state_count;state++ )
	   {
	     fprintf(fp,"production %-4d, state %-4d :\n\n",
		     prod,OPERAND( help_ptr[state].state ) );
	     redp       = help_ptr[state].rep.pt_rp;
	     count_redp = *redp;
	     for( crp=0;crp<count_redp;crp++ )
		{
		  fprintf(fp,"origin state = %4d ",redp[crp*2+2] );
		  if( IS_SHRED_NTACT( redp[crp*2+3] ) )
		     fprintf(fp,"  continuation state = shift/reduce %-4d\n",
			     OPERAND( redp[crp*2+3] ) );
		  else
		     fprintf(fp,"  continuation state = %-4d\n",
			     OPERAND( redp[crp*2+3] ) );
		} /* end of for( crp=0;crp<... */
	     fprintf(fp,"\n\n");
	   } /* end of for( state=0;st... */
      } /* end of for( prod=0;pro... */

   fclose(fp);
#endif
   if( extra_info )
      printf("end of function Build_Paths()\n");

   }    /* end of function Build_Paths() */






