
/* ******************************************************************* *\
*									*
*   Title: 	C library code for C interface with IDL			*
*   Filename:	/usr/softlab/src/lib/wmisc.c				*
*   Author:	Tim Maroney						*
*		Richard Snodgrass <rts@UNC>				*
*		Department of Computer Science				*
*		University of North Carolina				*
*		Chapel Hill, NC  27514					*
*									*
*   Copyright (C) The University of North Carolina, 1985		*
*									*
*   All rights reserved. No part of this software may be sold or	*
*   distributed in any form or by any means without the prior written	*
*   permission of the SoftLab Software Distribution Coordinator.	*
*									*
*   Report problems to	softlab@unc (csnet) or				*
*			softlab!unc@CSNET-RELAY (ARPAnet)		*
*   Direct all inquiries to the SoftLab Software Distribution		*
*	Coordinator, at the above addresses.				*
*									*
*   Function: miscellaneous writing routines				*
*									*
*									*
\* ******************************************************************* */

static char rcsid[] = "$Header: /tmp_mnt/comp/newliga/src/idl/idllib/RCS/wmisc.c,v 1.1 90/03/27 11:11:59 cogito Exp $";

/* ******************************************************************* *\
*   Revision Log:							*
*	$Log:	wmisc.c,v $
 * Revision 1.1  90/03/27  11:11:59  cogito
 * Initial revision
 * 
 * Revision 1.1  87/04/18  13:42:18  shannon
 * Initial revision
 * 
 * Revision 1.2  85/06/20  10:43:14  shannon
 * added sequence and set writing routines for scalar types.
 * 
 * Revision 1.1  85/06/11  10:34:11  shannon
 * Initial revision
 * 
*									*
*   Edit Log:								*
*     May  1984 (maroney) Created.					*
*									*
\* ******************************************************************* */
#include <stdio.h>
#include "global.h"
#include "writer.h"
#define MAXSTRINGLEN 5000
#define TILDE 0176
#define DEL 0177
#define QUOTE '"'

void WError(E)
WErrType E;
{	switch (E) {
	case ErrNullNode:
		IDLout("**Null Node**");
		fprintf(stderr,"Writer Error: null node\n");
		break;
	case ErrPortMode:
		fprintf(stderr,"Writer error: bad port mode\n");
		break;
	case ErrBadClassType:
		IDLout("**Bad Node For Class**");
		fprintf(stderr,"Writer error: bad class type\n");
		break;
	}
}

void WBoolean(b)
Boolean b;
{	if (b)	IDLout("TRUE");
	else	IDLout("FALSE");
}

void WString(S)
register String S;
{	
	char *check_string();

	if (S == NULL) {
	    IDLoutC(DoubleQuote );
	    IDLoutC(DoubleQuote );
	}
	else if (strlen(S)==0) {
	    IDLoutC(DoubleQuote );
	    IDLoutC(DoubleQuote );
	}
	else {
	    IDLoutC(DoubleQuote );
	    S = check_string(S);
	    IDLout(S);
	    IDLoutC(DoubleQuote );
	}
}

/**********************
void WSETBoolean (SB)
register SETBoolean SB;
{	IDLoutC( OpenBrace );
	if (SB.true) {
	    WBoolean(TRUE);
	    if (SB.false) {
		IDLoutC (ListLink);
		WBoolean(FALSE);
	    }
	}
	else if (SB.false) WBoolean(FALSE);
	IDLoutC ( CloseBrace );
}
************************/

char *check_string(S)
String	S;
{

	static char stringbuf[MAXSTRINGLEN];
	register char *	result;
	int len;
	
	if ((len = strlen(S)) >= MAXSTRINGLEN)
	    result = (char *)GetHeap(len + 1);
	else result = stringbuf;

	while (*S != '\0')
	{
	    if(*S <= 037)	  /* character is between '@' and '_' */
	    {
		*result++ = '~';
		*result++ = *S + '@';
	    }
	    else if(*S == TILDE)  
	    	 {
		     *result++ = '~';
		     *result++ = '~';
	    	 }
	    else if(*S == DEL)
		 {
		     *result++ = '~';
		     *result++ = '{';
		 }
	    else if(*S == QUOTE)
	         {
		     *result++ = '"';
		     *result++ = '"';
		 }
	    else *result++ = *S;
	    ++S;
	}

	*result = '\0';

	return(stringbuf);
}
