# $Id: Makefile.cpp,v 1.25 1992/06/01 20:03:54 kadhim Exp $
# Copyright (c) 1991, The Regents of the University of Colorado

SHELL	= /bin/sh

# Default master cache location
DESTDIR	= ELISYS

# Relative pathname for the current directory
DIR	= Tool/clp

CFLAGS		= -I..
PFLAGS		= -w -temp=.
COFLAGS		= -q

TOOLNAME	= clp
ELISRCS		= mk.clp clp.specs clp.gla clp.lido clp.ptg clp.head aux.c aux.h
SUBDIR		= lib
AUX		= clp.tnf clp.dg
SYS		= dfltclp.c clp.err
CMD		= clp_gen.cmd clp_out.cmd
SRCS		= $(ELISRCS) $(SYS) $(AUX) $(CMD)
EXE		= $(TOOLNAME).exe

ODIN		= eli

DERIVEDSRCS	= derivedSrcs
TESTDIR		= test

TIDY		= a.out *.o *.README *.a ELI $(TESTDIR)
CLEAN		= $(TIDY) $(EXE)
CLOBBER		= $(CLEAN) $(DERIVEDSRCS) Makefile

all:	$(EXE) $(AUX) $(SYS) $(CMD)
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for i in $(SUBDIR); do echo; echo Making Tool/clp/$$i; \
		(cd $$i; make NOTEX=$(NOTEX) PFLAGS="$(PFLAGS)" \
			CC="$(CC)"); done

install:
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/clp; \
		rm -f $(DESTDIR)/Tool/clp/$$f; \
		cp $$f $(DESTDIR)/Tool/clp/$$f; \
		chmod 644 $(DESTDIR)/Tool/clp/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/Tool/clp/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for i in $(SYS); do \
		echo install -c -m 644 $$i $(DESTDIR)/Tool/clp; \
		rm -f $(DESTDIR)/Tool/clp/$$i; \
		cp $$i $(DESTDIR)/Tool/clp/$$i; \
		chmod 644 $(DESTDIR)/Tool/clp/$$i; \
	done
	rm -f $(DESTDIR)/Tool/clp/clp.exe
	cp clp.exe $(DESTDIR)/Tool/clp
	chmod 755 $(DESTDIR)/Tool/clp/clp.exe
	-@for i in $(SUBDIR); do \
		if test ! -d $(DESTDIR)/Tool/clp/$$i; \
			then umask 002; mkdir $(DESTDIR)/Tool/clp/$$i; \
			else :; \
			fi; \
		done
	@for i in $(SUBDIR); do echo; echo Install Tool/clp/$$i; \
		(cd $$i; make NOTEX=$(NOTEX) DESTDIR=$(DESTDIR) install); \
		done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp $(DERIVEDSRCS) $(ELISRCS) $(AUX)
	@for i in $(SUBDIR); do echo; echo Making Tool/clp/$$i executable; \
		cd $$i; make executable; cd ..; done

SourceDistr:	$(SRCS)
		-mkdir $(DERIVEDSRCS)
		cp $(ELI)/$(DERIVEDSRCS)/* $(DERIVEDSRCS)
		cd $(DERIVEDSRCS); make clean
		@for i in $(SUBDIR); \
		do \
			echo; echo Source Tool/clp/$$i; mkdir $$i; cd $$i; \
			ln -s $(ELI)/$$i/RCS .; co $(COFLAGS) Makefile.cpp; \
			make -u -f Makefile.cpp ELI=$(ELI)/$$i \
				COFLAGS=$(COFLAGS) SourceDistr;\
			rm RCS; cd ..; \
		done

tidy:
		rm -rf $(TIDY)
		-@for i in $(SUBDIR); \
		do \
			echo; echo Tidying Tool/clp/$$i; cd $$i; \
			make tidy; cd ..; \
		done

clean:
		rm -rf $(CLEAN)
		-cd $(DERIVEDSRCS); make clean
		-@for i in $(SUBDIR); \
		do \
			echo; echo Cleaning Tool/clp/$$i; cd $$i; \
			make clean; cd ..; \
		done

clobber:
		rm -rf $(CLOBBER)
		-cd $(DERIVEDSRCS); make clean
		-@for i in $(SUBDIR); \
		do \
			echo; echo Clobbering Tool/clp/$$i; cd $$i; \
			make clobber; cd ..; \
		done

rcsclean:
		rm -rf $(CLEAN) Makefile
		-cd $(DERIVEDSRCS); make clean
		-rcsclean $(COFLAGS) $(SRCS) Makefile.cpp
		-@for i in $(SUBDIR); \
		do \
			echo; echo Rcscleaning Tool/clp/$$i; cd $$i; \
			make rcsclean; cd ..; \
		done

$(TOOLNAME).exe:	$(DERIVEDSRCS)/Makefile
		cd $(DERIVEDSRCS); make PFLAGS="$(PFLAGS)" CC="$(CC)" $(EXE)
		rm -f $(EXE); ln $(DERIVEDSRCS)/$(EXE) .

$(DERIVEDSRCS):	$(ELISRCS)
		-mkdir $(DERIVEDSRCS)
		-if test ! -d ELI; \
			then $(ODIN) -c $(DESTDIR) -n ELI -q; \
			else :; \
			fi
		$(ODIN) -c ELI <mk.$(TOOLNAME)

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(SRCS)
	-rcs -bOriginal.1 -q Makefile.cpp $(SRCS)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(SRCS)

.PRECIOUS:	$(SRCS)

testSourceDistr:
		rm -rf $(TESTDIR)
		mkdir $(TESTDIR)
		cd $(TESTDIR); ln -s ../RCS .; co Makefile.cpp; \
			make -f Makefile.cpp ELI=`$(PWD)`/.. SourceDistr; \
			rm RCS
