static char RCSid[] = "$Id: cagt_usr_err.c,v 1.14 1992/07/26 23:52:15 waite Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */

/*   The cagt_usr_err module implements an error message facility for CAGT.
 *
 *   Different (machine-specific) user interface modules may be implemented
 *   on top of the basic tool by rewriting those modules prefixed with 
 *   "cagt_usr_" while maintaining the interface specified by the associated
 *   header files. All cagt_usr_ modules must be consistent in the treatment
 *   of user-tool interaction.
 *
 *   Caveat: routines in this module require that external pointer cmd_name
 *   be set to the name of the command used to invoke cagt in order to work.
 */	

#include <stdio.h>
#include <stdlib.h>
#include <varargs.h>
#include "cagt_config.h"
#include "err.h"
#include "support.h"
#include "gram.h"
#include "cagt.h"
#include "cagt_usr.h"
#include "cagt_usr_err.h"



char cagt_msg_text[BUFSIZ];	/* Text of the message to be output */




public void cagt_msg_pr(sys_errno,action)
int sys_errno,action;
/*
 * cagt_msg_pr reports an error or informational message
 *  
 *   cagt_msg_pr(sys_errno,action);
 *
 * entry:
 *	sys_errno) if not 0 then the value of external system
 *		   variable errno after the error occurred.
 *	   action) Specifies the action that should be performed
 *		   after the message is issued. Current values
 *		   of action are:
 *
 *			MSG_RET - Return to caller
 *			MSG_EXIT - Terminate process via exit(3)
 *
 *	   cagt_msg_text contains the message to be written.
 *
 *
 * exit:
 *	An error message is formatted and displayed.
 *	This routine does not return to the caller if action != MSG_RET.
 */
{
    /* Report program defined error */
    (void) fprintf(stderr, "%s: ", cmd_name);
    (void) fprintf(stderr, "%s\n", cagt_msg_text);

    if (sys_errno)
	if (sys_errno <= sys_nerr && sys_errno > 0)
	    (void) fprintf(stderr, "%*s: %s\n", 
			strlen(cmd_name), " ", sys_errlist[sys_errno]);
	else
	    (void) fprintf(stderr, "%*s: %s\n",
			strlen(cmd_name), " ", "unknown system error");

    /* Perform action function */
    switch (action)
	{
	case MSG_RET		: return;
	case MSG_EXIT		: exit(1);
	default: (void) fprintf(stderr,
		"%s: Unknown action parameter in cagt_msg_pr()\n", cmd_name);
	}
}








/* usr_do_errlist_exit - write listing of syntactic errors then exit */
public void usr_do_errlist_exit(error_cnt, input_file, output_file)
int error_cnt;
char *input_file,
     *output_file;
{
    FILE *listf;


    cagt_msg(0, MSG_RET, (cagt_msg_text, msg_arr[-(CAGT_SNTXERR)], error_cnt, input_file))

    /* Open listing file */
    if ((listf = fopen(output_file,"w")) == 0)
        cagt_msg(errno, MSG_EXIT, (cagt_msg_text, msg_arr[-(CAGT_OPNERR)],
           "Error Listing", output_file, "output"))


    (void) fprintf(listf,"Facility:\t\t%s\n",cmd_name);
    (void) fprintf(listf,"Input file:\t\t%s\n",input_file);
    (void) fprintf(listf,"\n\n\n");

    lisedit(input_file,listf,NOTE,FALSE);

    (void) fprintf (listf, "\n\n");
    (void) fprintf (listf, "%d syntactic error(s) in file %s",
		    error_cnt, input_file); 
    (void) fprintf (listf, "\n");

    if (fclose(listf) == EOF)
        cagt_msg(errno, MSG_EXIT, (cagt_msg_text, msg_arr[-(CAGT_CLOSERR)],
           "Listing", output_file))
    else
    	cagt_msg(0, MSG_EXIT, (cagt_msg_text, msg_arr[-(CAGT_LISFMSG)], output_file))

}			/* usr_do_errlist_exit */


