# $Id: Makefile.cpp,v 1.17 1992/05/01 15:11:15 waite Exp $
# Copyright (c) 1991, The Regents of the University of Colorado

SHELL	= /bin/sh

# Default master cache location
DESTDIR	= ELISYS

CFLAGS	= -DSAVE
COFLAGS	= -q

SRC	= adtinit.c csm.c csm.h csmtbl.h idn.c idn.h idntbl.h err.c err.h \
	source.c source.h
OBJ	= adtinit.o csm.o idn.o err.o source.o
AUX	= support.dg
CMD	= csmidnOut.cmd csmidnProd.cmd
EXE	= adtinit.exe
#ifdef hpux
LIBS	= -lBSD
#endif

TIDY	= *.o core a.out 
CLEAN	= $(TIDY) $(EXE)
CLOBBER	= $(CLEAN) Makefile

all:	$(EXE) $(AUX) $(CMD)
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/Tool/adtinit/$$f $(DESTDIR)/Cmd/$$f; \
		done

install:
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/adtinit; \
		rm -f $(DESTDIR)/Tool/adtinit/$$f; \
		cp $$f $(DESTDIR)/Tool/adtinit/$$f; \
		chmod 644 $(DESTDIR)/Tool/adtinit/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/Tool/adtinit/$$f $(DESTDIR)/Cmd/$$f; \
		done
	@for f in $(EXE); do \
		echo install -c -m 755 $$f $(DESTDIR)/Tool/adtinit; \
		rm -f $(DESTDIR)/Tool/adtinit/$$f; \
		cp $$f $(DESTDIR)/Tool/adtinit/$$f; \
		chmod 755 $(DESTDIR)/Tool/adtinit/$$f; \
		done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp $(SRC) $(AUX)

SourceDistr: $(SRC) $(AUX) $(CMD)

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	-rcsclean $(COFLAGS) $(SRC) Makefile.cpp $(AUX) $(CMD)
	rm -rf $(CLEAN) Makefile

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(SRC) $(AUX) $(CMD)
	-rcs -bOriginal.1 -q Makefile.cpp $(SRC) $(AUX) $(CMD)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(SRC) $(AUX) $(CMD)

.PRECIOUS:	$(AUX) $(CMD)

adtinit.exe:	$(OBJ)
	$(CC) -o adtinit.exe $(CFLAGS) $(OBJ) $(LIBS)

adtinit.o:	adtinit.c csm.h idn.h err.h source.h
csm.o:		csmtbl.h csm.h err.h
idn.o:		idntbl.h csm.h idn.h err.h
err.o:		err.h source.h
