/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/PrmFHdr.h"


tp_PrmFHdr	FreePrmFHdr = NIL;
int		num_PrmFHdrs = 0;
int		num_PrmFHdrS = 0;


/* PrmFHdr's are absorbed when used as an argument to a function
 * that returns a PrmFHdr.
 */

tp_PrmFHdr
New_PrmFHdr(FilHdr, Prms)
   tp_FilHdr FilHdr;
   tp_Prms Prms;
{
   tp_PrmFHdr PrmFHdr;

   FORBIDDEN(FilHdr == ERROR || Prms == ERROR);

   /*select*/{
      if (FreePrmFHdr == 0) {
	 PrmFHdr = (tp_PrmFHdr)malloc(sizeof(tps_PrmFHdr));
	 num_PrmFHdrS += 1;
	 PrmFHdr->InUse = FALSE;
      }else{
	 PrmFHdr = FreePrmFHdr;
	 FreePrmFHdr = FreePrmFHdr->Next; };}/*select*/;

   FORBIDDEN(PrmFHdr->InUse);
   num_PrmFHdrs += 1;
   PrmFHdr->InUse = TRUE;
   PrmFHdr->FilHdr = Copy_FilHdr(FilHdr);
   PrmFHdr->Prms = Prms;
   PrmFHdr->Next = NIL;
   return PrmFHdr;
   }/*New_PrmFHdr*/;


Use_PrmFHdr(FilHdrPtr, PrmsPtr, PrmFHdr)
   tp_FilHdr *FilHdrPtr;
   tp_Prms *PrmsPtr;
   tp_PrmFHdr PrmFHdr;
{
   if (PrmFHdr == ERROR) {
      *FilHdrPtr = ERROR;
      *PrmsPtr = ERROR;
      return; }/*if*/;
   *FilHdrPtr = PrmFHdr->FilHdr;
   *PrmsPtr = PrmFHdr->Prms;
   Rls_PrmFHdr(PrmFHdr);
   }/*Use_PrmFHdr*/;


Ret_PrmFHdr(PrmFHdr)
   tp_PrmFHdr PrmFHdr;
{
   FORBIDDEN(PrmFHdr == ERROR);
   Ret_FilHdr(PrmFHdr->FilHdr);
   Rls_PrmFHdr(PrmFHdr);
   }/*Ret_PrmFHdr*/;


Rls_PrmFHdr(PrmFHdr)
   tp_PrmFHdr PrmFHdr;
{
   FORBIDDEN(PrmFHdr == ERROR);
   PrmFHdr->Next = FreePrmFHdr;
   FORBIDDEN(!PrmFHdr->InUse);
   PrmFHdr->InUse = FALSE;
   num_PrmFHdrs -= 1;
   FreePrmFHdr = PrmFHdr;
   }/*Rls_PrmFHdr*/;


boolean
PrmFHdrs_InUse()
{
   return (num_PrmFHdrs != 0);
   }/*PrmFHdrs_InUse*/;

