/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/NodTyp_.h"
#include "inc/ParseKind_.h"
#include "inc/Signal_.h"
#include "inc/Str.h"


char **EnvP;

/* ARGSUSED */

main(argc, argv, envp)
   int argc;
   char **argv, **envp;
{
   boolean IsTTY;
   tp_Signal Signal = NIL;
   tp_Str Str;
   tps_Str StrBuf;

   EnvP = envp;
   Init_Timing();
   Init_Sigs();
   IsTTY = GetIsTTY();
   Init_IO();
   Init_Err();
   Init_Env();
   Init_Log();
   Init_History();
   Init_Vars();

   Read_DrvGrf();
   Init_FilHdrs();
   Init_FilInps();
   Init_FilElms();
   Init_Prms();
   Init_Info();
   Init_FilHdrTree();
   Init_CWD();
   Init_Check();
   Init_Sentinel();
   if (IsTTY) {
      Writeln(StdOutFD, Banner);
      Do_OdinRC(); }/*if*/;
   Signal = NIL;
   while (Signal == NIL || IsTTY) {
      Update_Sentinel(&Signal);
      if (Signal != NIL && !IsTTY) {
	 goto done; }/*if*/;
      Clear_InfoInUse();
      Unlock_Info(&Signal);
      if (Signal != NIL) {
	 if (!IsTTY) {
	    Set_InfoInUse();
	    goto done; }/*if*/;
	 while (Signal) {
	    Unlock_Info(&Signal); }/*while*/; }/*if*/;
      if (IsTTY) Write(StdOutFD, "-> ");
      Str = ReadLine(StrBuf, StdInFD);
      Lock_Info(&Signal);
      Set_InfoInUse();
      if (Str == NIL || (Signal != NIL && !IsTTY)) {
	 goto done; }/*if*/;
      CommandInterpreter(&Signal, Str); }/*while*/;
done:;
   if (IsTTY) Writeln(StdOutFD, "");
   Do_Export();
   CleanUp();
   if (ShowTimes) ShowOdinTime();
   if (Signal != NIL) {
      exit(100+Signal); }/*if*/;
   exit(0);
   }/*main*/;


CommandInterpreter(SignalPtr, Str)
   tp_Signal *SignalPtr;
   tp_Str Str;
{
   tp_Nod Root;

   *SignalPtr = NIL;

   Root = Parse(CMD_PARSE, Str);
   if (Root == ERROR) {
      Writeln(StdOutFD, "Type ? for help.");
      *SignalPtr = SIGNAL_ParseError;
      return; }/*if*/;

   switch (Nod_NodTyp(Root)) {
      case NULLCD: {
	 break;}/*case*/;
      case HLPSUM: {
	 HelpSummary(SignalPtr);
	 break;}/*case*/;
      case HLPTOP: {
	 Help(Root);
	 break;}/*case*/;
      case HLPBAS: {
	 Print_SrcFilTyps();
	 break;}/*case*/;
      case HOSTWD: {
	 AddHistEntry(Str);
	 HostCommand(SignalPtr, Root);
	 break;}/*case*/;
      case CMDFIL: {
	 AddHistEntry(Str);
	 CommandFile(SignalPtr, Root, FALSE);
	 break;}/*case*/;
      case SNCMDF: {
	 AddHistEntry(Str);
	 CommandFile(SignalPtr, Root, TRUE);
	 break;}/*case*/;
      case DISPLY: {
	 AddHistEntry(Str);
	 Display(SignalPtr, Root);
	 break;}/*case*/;
      case COPY: {
	 AddHistEntry(Str);
	 Copy(SignalPtr, Root);
	 break;}/*case*/;
      case EDIT: {
	 AddHistEntry(Str);
	 Edit(SignalPtr, Root);
	 break;}/*case*/;
      case UTILTY: {
	 AddHistEntry(Str);
	 Utility(Root);
	 break;}/*case*/;
      case HLPVRS: {
	 ShowVars();
	 break;}/*case*/;
      case HLPVAR: {
	 HelpVar(Root);
	 break;}/*case*/;
      case VARVAL: {
	 ShowVar(Root);
	 break;}/*case*/;
      case VARSET: {
	 AddHistEntry(Str);
	 SetVar(Root);
	 break;}/*case*/;
      case HISFIL: {
	 PrintHistory();
	 break;}/*case*/;
      case INHSFL: {
	 CopyToHistory(SignalPtr, Root);
	 break;}/*case*/;
      case EDHSFL: {
	 EditHistory();
	 break;}/*case*/;
      case HISTRY: {
	 DoHistEntry(Root);
	 break;}/*case*/;
      case EDHIST: {
	 EditHistEntry(Root);
	 break;}/*case*/;
      default: {
	 SystemError(SystemErrorFD(), "Illegal command type");
	 };}/*switch*/;
   Ret_Nod(Root);
   Compact();
   }/*CommandInterpreter*/;


