/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/


#include <ctype.h>
#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/HomSpc.h"
#include "inc/Inputs.h"
#include "inc/NodTyp_.h"
#include "inc/Outputs.h"
#include "inc/ParseKind_.h"
#include "inc/RunSpc.h"
#include "inc/Str.h"


boolean
Has_Macro(Str)
   tp_Str Str;
{
   while (*Str) {
      if (Str[0] == '(' && Str[1] == '|') {
	 return TRUE; }/*if*/;
      Str += 1; }/*while*/;
   return FALSE;
   }/*Has_Macro*/;


Expand_MacroLine(OutStr, RefFilDsc, Str, RunSpc, Tool, PrmFTLst, OutTyps)
   tp_Str OutStr;
   tp_FilDsc RefFilDsc;
   tp_Str Str;
   tp_RunSpc RunSpc;
   tp_Tool Tool;
   tp_PrmFTLst PrmFTLst;
   tp_OutTyps OutTyps;
{
   int i, j, k;
   tps_Str MacroStr;

   i = 0; j = 0;
   while (Str[i] != 0) {
      /*select*/{
	 if (Str[i] == '(' && Str[i+1] == '|') {
	    i += 2;
	    /*select*/{
	       if (i > 2 && Str[i-3] == '\\') {
		  if (OutStr) {
		     OutStr[j-1] = '('; OutStr[j] = '|';
		     j += 1; }/*if*/;
	       }else{
		  k = 0;
		  while (!(Str[i] == 0 || (Str[i] == '|' && Str[i+1] == ')'))) {
		     if (Str[i] == '\\' && Str[i+1] != 0) i += 1;
		     MacroStr[k] = Str[i];
		     i += 1; k += 1; }/*while*/;
		  MacroStr[k] = 0;
		  if (Str[i] == 0) {
		     SystemError(SystemErrorFD(), "Unterminated macro in:\n%s\n", Str);
		     if (OutStr) (void)strcpy(OutStr, "** Bad_Macro Line **");
		     return; }/*if*/;
		  i += 2;
		  /*select*/{
		     if (OutStr) {
		        Expand_Macro(&OutStr[j], RefFilDsc, MacroStr,
				     RunSpc, Tool, PrmFTLst, OutTyps);
		        j = strlen(OutStr);
		     }else{
			Expand_Macro((tp_Str)NIL, RefFilDsc, MacroStr,
				     RunSpc, Tool, PrmFTLst, OutTyps);
			};}/*select*/; };}/*select*/;
	 }else{
	    if (OutStr) {
	       OutStr[j] = Str[i];
	       j += 1; }/*if*/;
	    i += 1; };}/*select*/; }/*while*/;
   if (OutStr) OutStr[j] = 0;
   }/*Expand_MacroLine*/;


/*private*/ boolean
Is_HomSpc_Match(DrvInpNod, HomSpc)
   tp_Nod DrvInpNod;
   tp_HomSpc HomSpc;
{
   tp_Nod Nod, PrmValNod;

   for (Nod = Nod_Son(1, DrvInpNod);
	Nod != NIL && HomSpc != NIL;
	Nod = Nod_Brother(Nod), HomSpc = HomSpc->Next) {
      switch (Nod_NodTyp(Nod)) {
	 case MOPARM: {
	    if (HomSpc->PrmFT
		!= FTName_FilTyp(Sym_Str(Nod_Sym(Nod_Son(1, Nod))))) {
	       return FALSE; }/*if*/;
	    break;}/*case*/;
	 case MOPRVL: {
	    if (HomSpc->PrmFT
		!= FTName_FilTyp(Sym_Str(Nod_Sym(Nod_Son(1, Nod))))) {
	       return FALSE; }/*if*/;
	    PrmValNod = Nod_Son(2, Nod);
	    /*select*/{
	       if (Nod_NodTyp(PrmValNod) == MACDIN) {
		  if (!Is_HomSpc_Match(PrmValNod, HomSpc->HomSpc)) {
		     return FALSE; }/*if*/;
	       }else{
		  if (strcmp(HomSpc->PrmVal,
			     Sym_Str(Nod_Sym(PrmValNod))) != 0) {
		     return FALSE; }/*if*/; };}/*select*/;
	    break;}/*case*/;
	 case MOHODR: {
	    if (!HomSpc->HomoFlag) {
	       return FALSE; }/*if*/;
	    if (HomSpc->FilTyp
		!= FTName_FilTyp(Sym_Str(Nod_Sym(Nod_Son(1, Nod))))) {
	       return FALSE; }/*if*/;
	    break;}/*case*/;
	 case MODERV: {
	    if (HomSpc->HomoFlag) {
	       return FALSE; }/*if*/;
	    if (HomSpc->FilTyp
		!= FTName_FilTyp(Sym_Str(Nod_Sym(Nod_Son(1, Nod))))) {
	       return FALSE; }/*if*/;
	    break;}/*case*/;
	 default: {
	    FatalError("unknown NodTyp"); };}/*switch*/; }/*for*/;
   return (HomSpc == NIL && Nod == NIL);
   }/*Is_HomSpc_Match*/;


/*private*/int
Get_InpNum(Nod, Tool)
   tp_Nod Nod;
   tp_Tool Tool;
{
   tp_InpEdg InpEdg;
   int i;

   for (InpEdg = Tool_InpEdg(Tool), i=0;
	InpEdg != NIL;
	InpEdg = InpEdg_Next(InpEdg), i+=1) {
      /*select*/{
	 if (Nod_NodTyp(Nod) == MACDIN) {
	    if (Is_HomSpc_Match(Nod, InpEdg_HomSpc(InpEdg))) {
	       return i; }/*if*/;
	 }else{
	    if (InpEdg_HomSpc(InpEdg) == NIL
		&& (FTName_FilTyp(Sym_Str(Nod_Sym(Nod)))
		    == InpEdg_FilTyp(InpEdg))) {
	       return i; }/*if*/; };}/*select*/; }/*for*/;
   return -1;
   }/*Get_InpNum*/;


/*private*/ tp_FilTyp
Nod_PrmFT(Nod, PrmFTLst)
   tp_Nod Nod;
   tp_PrmFTLst PrmFTLst;
{
   tp_FilTyp FilTyp;

   if (Nod_NodTyp(Nod) != WORD) {
      return (tp_FilTyp)NIL; }/*if*/;
   FilTyp = FTName_FilTyp(Sym_Str(Nod_Sym(Nod)));
   if (FilTyp == NIL || !In_PrmFTLst(FilTyp, PrmFTLst)) {
      return (tp_FilTyp)NIL; }/*if*/;
   return FilTyp;
   }/*Nod_PrmFT*/;


Expand_Macro(OutStr, RefFilDsc, MacroStr, RunSpc, Tool, PrmFTLst, OutTyps)
   tp_Str OutStr;
   tp_FilDsc RefFilDsc;
   tp_Str MacroStr;
   tp_RunSpc RunSpc;
   tp_Tool Tool;
   tp_PrmFTLst PrmFTLst;
   tp_OutTyps OutTyps;
{
   tp_Nod Root, MacroNod;
   tp_PrmFHdr PrmFHdr;
   tp_FilHdr FilHdr, DirFilHdr;
   tp_Prms Prms;
   int i;
   tp_FilTyp FilTyp;
   tp_Str InpTypStr, OutTypStr;

   Root = Parse(MACRO_PARSE, MacroStr);
   if (Root == NIL) {
      SystemError(SystemErrorFD(), "Syntax error in macro <%s>.\n", MacroStr);
      goto done; }/*if*/;
   switch (Nod_NodTyp(Root)) {
      case MACINP: {
	 if (RunSpc == NIL) {
	    SystemError(SystemErrorFD(), "Error in <%s> :\n", MacroStr);
	    SystemError(SystemErrorFD(), "Input macros only allowed in command scripts.\n");
	    goto done; }/*if*/;
	 MacroNod = Nod_Son(1, Root);
	 if (Nod_NodTyp(MacroNod) == WORD) {
	    InpTypStr = Sym_Str(Nod_Sym(MacroNod));
	    if (strcmp(InpTypStr, "RUNDIR") == 0) {
	       if (OutStr) {
		  (void)strcpy(OutStr, RunDirName); }/*if*/;
	       goto done; }/*if*/;
	    if (strcmp(InpTypStr, "CURDIR") == 0) {
	       if (OutStr) {
		  DirFilHdr = FilHdr_SrcDirFilHdr(Copy_FilHdr(RunSpc->FilHdr));
		  FilHdr_HostFN(OutStr, DirFilHdr);
		  Ret_FilHdr(DirFilHdr); }/*if*/;
	       goto done; }/*if*/;
	    if (strcmp(InpTypStr, "HOOK") == 0) {
	       if (OutStr) {
		  (void)strcpy(OutStr, HookFileName); }/*if*/;
	       goto done; }/*if*/;
	    if (strcmp(InpTypStr, "*") == 0) {
	       if (OutStr) {
		  (void)strcpy(OutStr, "");
		  for (i=0; i<RunSpc->NumInps; i++) {
		     if (i > 0) (void)strcat(OutStr, " ");
		     RunSpc->InpUsed[i] = TRUE;
		     FilHdr_DataFileName(Tail(OutStr), RunSpc->InpFilHdrs[i]);
		     }/*for*/; }/*if*/;
	       goto done; }/*if*/; }/*if*/;
	 i = Get_InpNum(MacroNod, Tool);
	 if (i >= 0) {
	    if (OutStr != NIL) {
	       FilHdr_DataFileName(OutStr, RunSpc->InpFilHdrs[i]);
	       RunSpc->InpUsed[i] = TRUE; }/*if*/;
	    goto done; }/*if*/;
	 FilTyp = Nod_PrmFT(MacroNod, PrmFTLst);
	 if (FilTyp != NIL) {
	    if (OutStr != NIL) {
	       Get_PrmFileName(OutStr, FilTyp_FTName(FilTyp)); }/*if*/;
	    goto done; }/*if*/;
	 FORBIDDEN(OutStr != NIL);
	 SystemError(SystemErrorFD(), "Unknown input macro <%s>", MacroStr);
	 FilHdr_Error(" in <%s>.\n", RunSpc->FilHdr);
	 break;}/*case*/;
      case MACNIN: {
	 if (RunSpc == NIL) {
	    SystemError(SystemErrorFD(), "Error in <%s> :\n", MacroStr);
	    SystemError(SystemErrorFD(), "Input macros only allowed in command scripts.\n");
	    goto done; }/*if*/;
	 MacroNod = Nod_Son(1, Root);
	 i = Get_InpNum(MacroNod, Tool);
	 if (i >= 0) {
	    if (OutStr != NIL) {
	       Get_LinkedInputDirName(OutStr, i);
	       RunSpc->InpDir[i] = TRUE; }/*if*/;
	    goto done; }/*if*/;
	 FilTyp = Nod_PrmFT(MacroNod, PrmFTLst);
	 if (FilTyp != NIL) {
	    if (OutStr != NIL) {
	       Get_LinkedPrmInputDirName(OutStr, FilTyp_FTName(FilTyp));
	       SetFilTyp_Mark(FilTyp); }/*if*/;
	    goto done; }/*if*/;
	 FORBIDDEN(OutStr != NIL);
	 SystemError(SystemErrorFD(), "Unknown input macro <%s>", MacroStr);
	 FilHdr_Error(" in <%s>.\n", RunSpc->FilHdr);
	 break;}/*case*/;
      case MACOUT: {
	 if (RunSpc == NIL) {
	    SystemError(SystemErrorFD(), "Error in <%s> :\n", MacroStr);
	    SystemError(SystemErrorFD(), "Output macros only allowed in command scripts.\n");
	    goto done; }/*if*/;
	 OutTypStr = Sym_Str(Nod_Sym(Nod_Son(1, Root)));
	 if (strcmp(OutTypStr, "ERROR") == 0) {
	    if (OutStr) {
	       (void)strcpy(OutStr, ErrorFN); }/*if*/;
	    goto done; }/*if*/;
	 if (strcmp(OutTypStr, "WARNING") == 0) {
	    if (OutStr) {
	       (void)strcpy(OutStr, WarningFN); }/*if*/;
	    goto done; }/*if*/;
	 if (strcmp(OutTypStr, "*") == 0) {
	    if (OutStr) {
	       (void)strcpy(OutStr, "");
	       for (i=0; i<RunSpc->NumOuts; i++) {
		  if (i > 0) (void)strcat(OutStr, " ");
		  /*select*/{
		     if (IsDrvDir_FilTyp(OutTyps[i])) {
			I_WorkDirFileName(Tail(OutStr), i);
		     }else{
			I_WorkFileName(Tail(OutStr), i);
			};}/*select*/; }/*for*/; }/*if*/;
	    goto done; }/*if*/;
	 FilTyp = FTName_FilTyp(OutTypStr);
	 if (FilTyp != ERROR) {
	    for (i=0; i<RunSpc->NumOuts; i++) {
	       if (FilTyp == OutTyps[i]) {
		  ;/*select*/{
		     if (OutStr == NIL) {
		     }else if (IsDrvDir_FilTyp(FilTyp)) {
			I_WorkDirFileName(OutStr, i);
		     }else{
			I_WorkFileName(OutStr, i); };}/*select*/;
		  goto done; }/*if*/; }/*for*/; }/*if*/;
	 FORBIDDEN(OutStr != NIL);
	 SystemError(SystemErrorFD(), "Unknown output macro <%s>", MacroStr);
	 FilHdr_Error(" in <%s>.\n", RunSpc->FilHdr);
	 break;}/*case*/;
      default: {
	 PrmFHdr = Nod_PrmFHdr(Root);
	 Use_PrmFHdr(&FilHdr, &Prms, PrmFHdr);
	 if (FilHdr == ERROR) {
	    if (OutStr) (void)strcpy(OutStr, MacroStr);
	    SystemError(SystemErrorFD(), "Invalid Odin macro: <%s>.\n", MacroStr);
	    goto done; }/*if*/;
	 if (OutStr) FilHdr_DataFileName(OutStr, FilHdr);
	 if (RefFilDsc) Writeln(RefFilDsc, MacroStr);
	 Ret_FilHdr(FilHdr); };}/*switch*/;
done:;
   Ret_Nod(Root);
   }/*Expand_Macro*/;


