/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"


int			HelpLevel = 1;


HelpSummary(SignalPtr)
   tp_Signal *SignalPtr;
{
   tps_FileName HelpToolName;

   FilHdr_DataFileName(HelpToolName, OdinDirFilHdr);
   (void)strcat(HelpToolName, "/Tool/info.exe");
   if (Exists(HelpToolName)) {
      Unlock_Info(SignalPtr);
      if (*SignalPtr != NIL) {
	 return; }/*if*/;
      (void)system(HelpToolName);
      Lock_Info(SignalPtr);
      return; }/*if*/;

   *SignalPtr = NIL;
   Writeln(StdOutFD, "Topics:");
   Writeln(StdOutFD, "    ? Syntax");
   Writeln(StdOutFD, "    ? Help");
   Writeln(StdOutFD, "    ? Quit");
   Writeln(StdOutFD, "    ? Display");
   Writeln(StdOutFD, "    ? Copy");
   Writeln(StdOutFD, "    ? Edit");
   Writeln(StdOutFD, "    ? Utility");
   Writeln(StdOutFD, "    ? Script");
   Writeln(StdOutFD, "    ? HostCommand");
   Writeln(StdOutFD, "    ? Macro");
   Writeln(StdOutFD, "    ? Variables");
   Writeln(StdOutFD, "    ? History");
   Writeln(StdOutFD, "    ? OdinFileName");
   Writeln(StdOutFD, "    ? HostFileName");
   Writeln(StdOutFD, "    ? Operation");
   Writeln(StdOutFD, "    ? Parameter");
   Writeln(StdOutFD, "    ? ParameterType");
   Writeln(StdOutFD, "    ? ParameterValue");
   Writeln(StdOutFD, "    ? FileType");
   Writeln(StdOutFD, "    ? InputType");
   }/*HelpSummary*/;


Help(Nod)
   tp_Nod Nod;
{
   tp_Str TopicStr;

   TopicStr = Sym_Str(Nod_Sym(Nod_Son(1, Nod)));
   /*select*/{
      if (strcasecmp(TopicStr, "help") == 0) {
	 Writeln(StdOutFD, "    ?");
	 Writeln(StdOutFD, "    ? Topic");
	 Writeln(StdOutFD, "    OdinFileName: ?");
	 Writeln(StdOutFD, "    OdinFileName + ?");
	 Writeln(StdOutFD, "    OdinFileName + ?: FileType");
      }else if (strcasecmp(TopicStr, "quit") == 0) {
	 Writeln(StdOutFD, "    Control-D");
      }else if (strcasecmp(TopicStr, "display") == 0) {
	 Writeln(StdOutFD, "    OdinFileName");
      }else if (strcasecmp(TopicStr, "copy") == 0) {
	 Writeln(StdOutFD, "    OdinFileName > OdinFileName");
      }else if (strcasecmp(TopicStr, "edit") == 0) {
	 Writeln(StdOutFD, "    OdinFileName Editor");
      }else if (strcasecmp(TopicStr, "editor") == 0) {
	 Writeln(StdOutFD, "    >");
	 Writeln(StdOutFD, "    > % HOST_CMD");
      }else if (strcasecmp(TopicStr, "utility") == 0) {
	 Writeln(StdOutFD, "    OdinFileName '>' ':' test");
	 Writeln(StdOutFD, "    OdinFileName '>' ':' touch");
	 Writeln(StdOutFD, "    OdinFileName '>' ':' validate");
	 Writeln(StdOutFD, "    OdinFileName '>' ':' name");
	 Writeln(StdOutFD, "    OdinFileName '>' ':' inputs");
	 Writeln(StdOutFD, "    OdinFileName '>' ':' outputs");
	 Writeln(StdOutFD, "    OdinFileName '>' ':' elements");
	 Writeln(StdOutFD, "    OdinFileName '>' ':' element-of");
      }else if (strcasecmp(TopicStr, "script") == 0) {
	 Writeln(StdOutFD, "    < OdinFileName");
	 Writeln(StdOutFD, "    <| OdinFileName");
      }else if (strcasecmp(TopicStr, "hostcommand") == 0) {
	 Writeln(StdOutFD, "    % MACRO_HOST_CMD");
      }else if (strcasecmp(TopicStr, "macro") == 0) {
	 Writeln(StdOutFD, "    (| OdinFileName |)");
      }else if (strcasecmp(TopicStr, "variables") == 0) {
	 Writeln(StdOutFD, "    VARIABLE = VALUE");
	 Writeln(StdOutFD, "    VARIABLE =");
	 Writeln(StdOutFD, "    VARIABLE = ?");
	 Writeln(StdOutFD, "    ? =");
      }else if (strcasecmp(TopicStr, "history") == 0) {
	 Writeln(StdOutFD, "    !");
	 Writeln(StdOutFD, "    ! Editor");
	 Writeln(StdOutFD, "    ! HISTORY_ENTRY");
	 Writeln(StdOutFD, "    ! HISTORY_ENTRY Editor");
      }else if (strcasecmp(TopicStr, "odinfilename") == 0) {
	 Writeln(StdOutFD, "    HostFileName [Operation]... ");
      }else if (strcasecmp(TopicStr, "hostfilename") == 0) {
	 Writeln(StdOutFD, "    user_file.InputType");
	 Writeln(StdOutFD, "    $/Sentinel");
	 Writeln(StdOutFD, "    $/Cmd/user.cmd");
	 Writeln(StdOutFD, "    $/Tool/user_tool");
      }else if (strcasecmp(TopicStr, "operation") == 0) {
	 Writeln(StdOutFD, "    + Parameter");
	 Writeln(StdOutFD, "    : FileType");
	 Writeln(StdOutFD, "    / KEY");
      }else if (strcasecmp(TopicStr, "parameter") == 0) {
	 Writeln(StdOutFD, "    ParameterType [= ParameterValue]");
      }else if (strcasecmp(TopicStr, "parametervalue") == 0) {
	 Writeln(StdOutFD, "    NAME");
	 Writeln(StdOutFD, "    'STRING'");
	 Writeln(StdOutFD, "    ( OdinFileName )");
      }else if (strcasecmp(TopicStr, "parametertype") == 0) {
	 Writeln(StdOutFD, "    Use a help command of the form");
	 Writeln(StdOutFD, "       OdinFileName + ?");
	 Writeln(StdOutFD, "    or");
	 Writeln(StdOutFD, "       OdinFileName + ?: FileType");
	 Writeln(StdOutFD, "    to determine appropriate ParameterTypes");
      }else if (strcasecmp(TopicStr, "filetype") == 0) {
	 Writeln(StdOutFD, "    Use a help command of the form");
	 Writeln(StdOutFD, "       OdinFileName: ?");
	 Writeln(StdOutFD, "    to determine appropriate FileTypes");
      }else if (strcasecmp(TopicStr, "inputtype") == 0) {
	 Writeln(StdOutFD, "    Use a help command of the form");
	 Writeln(StdOutFD, "       ?:");
	 Writeln(StdOutFD, "    to determine appropriate InputTypes");
      }else if (strcasecmp(TopicStr, "order") == 0) {
	 PrintOrder();
      }else if (strcasecmp(TopicStr, "syntax") == 0) {
	 Writeln(StdOutFD, "    [a] is optionally a");
	 Writeln(StdOutFD, "    [a]... is zero or more a's");
      }else{
	 Writeln(StdOutFD, "** No help on that topic **");
	 };}/*select*/;
   }/*Help*/;


Set_HelpLevel(NewLevel)
   int NewLevel;
{
   if (NewLevel < 1 || NewLevel > 2) {
      Writeln(StdOutFD, "** Help Level must be between 1 and 2 **");
      return; }/*if*/;
   HelpLevel = NewLevel;
   }/*Set_HelpLevel*/;


