/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/FilTyp.h"
#include "inc/FTClass_.h"
#include "inc/InpKind_.h"
#include "inc/Str.h"
#include "inc/TClass_.h"


extern int		num_FilTypS;
extern tp_FilTyp	FilTypS;


tp_Desc			DfltDesc = ".";


tp_FilTyp
FTName_FilTyp(FTName)
   tp_FTName FTName;
{
   int i;
   tp_FilTyp FilTyp;

   for (i=0; i<num_FilTypS; i++) {
      FilTyp = &FilTypS[i];
      if (strcmp(FTName, FilTyp->FTName) == 0) {
	 return FilTyp; }/*if*/; }/*for*/;
   return ERROR;
   }/*FTName_FilTyp*/;


/*private*/ boolean
IsDflt_Desc(Desc)
   tp_Desc Desc;
{
   return (strcmp(Desc, DfltDesc) == 0);
   }/*IsDflt_Desc*/;


int
FilTyp_I(FilTyp)
   tp_FilTyp FilTyp;
{
   FORBIDDEN(FilTyp == ERROR);
   return FilTyp->IFilTyp;
   }/*FilTyp_I*/;


boolean
IsSource_FilTyp(FilTyp)
   tp_FilTyp FilTyp;
{
   FORBIDDEN(FilTyp == ERROR);
   return IsSource_Tool(FilTyp->Tool);
   }/*IsSource_FilTyp*/;


IsParameter_FilTyp(FilTyp)
   tp_FilTyp FilTyp;
{
   FORBIDDEN(FilTyp == ERROR);
   return IsParameter_Tool(FilTyp->Tool);
   }/*IsParameter_FilTyp*/;


boolean
IsStructMem_FilTyp(FilTyp)
   tp_FilTyp FilTyp;
{
   FORBIDDEN(FilTyp == ERROR);
   return (Tool_TClass(FilTyp->Tool) == TC_StructMem);
   }/*IsStructMem_FilTyp*/;


boolean
IsGrouping_FilTyp(FilTyp)
   tp_FilTyp FilTyp;
{
   tp_TClass TClass;

   TClass = Tool_TClass(FilTyp->Tool);
   return (TClass == TC_Union || TClass == TC_Collect
	   || TClass == TC_Name || TClass == TC_Names
	   || TClass == TC_ExpandHooks);
   }/*IsGrouping_FilTyp*/;


boolean
IsSaved_FilTyp(FilTyp)
   tp_FilTyp FilTyp;
{
   FORBIDDEN(FilTyp == ERROR);
   return TRUE;
   }/*IsSaved_FilTyp*/;


Split_Key(Ident, FilTypPtr, Key)
   tp_Ident Ident;
   tp_FilTyp *FilTypPtr;
   tp_Key Key;
{
   tp_FilTyp FilTyp;
   int Length, i;

   FORBIDDEN(Key == ERROR);
   (void)strcpy(Ident, Key);
   Length = strlen(Ident);
   for (i=1; i<Length; i++) {
      if (Ident[i-1] == '.' || Ident[i-1] == ',') {
	 FilTyp = FTName_FilTyp(&Ident[i]);
	 if (FilTyp != ERROR && IsSource_FilTyp(FilTyp)) {
	    /* used to be IsAtmc_FilTyp */
	    Ident[i] = 0;
	    *FilTypPtr = FilTyp;
	    return; }/*if*/; }/*if*/; }/*for*/;
   *FilTypPtr = NullFilTyp;
   }/*Split_Key*/;


boolean
IsErrOK(FilTyp)
   tp_FilTyp FilTyp;
{
   return (IsStructMem_FilTyp(FilTyp)
	   && InpEdg_InpKind(Tool_InpEdg(FilTyp_Tool(FilTyp))) == IK_ErrOK);
   }/*IsErrOK*/;


SetFilHdr_DrvMarks(FilHdr)
   tp_FilHdr FilHdr;
{
   SetFilHdr_Marks(FilHdr, FALSE);
   }/*SetFilHdr_DrvMarks*/;


SetFilHdr_PrmFTMarks(FilHdr)
   tp_FilHdr FilHdr;
{
   SetFilHdr_Marks(FilHdr, TRUE);
   }/*SetFilHdr_PrmFTMarks*/;


SetFilHdr_Marks(FilHdr, PrmFTFlag)
   tp_FilHdr FilHdr;
   boolean PrmFTFlag;
{
   tp_FilTyp FilTyp;
   tp_DrvPth DrvPth;
   tp_FilHdr GenericFilHdr;

   FilTyp = FilHdr_FilTyp(FilHdr);
   if (IsHook_FilTyp(FilTyp)) {
      return; }/*if*/;
   SetFilTyp_Marks(FilTyp, PrmFTFlag);
   SetCastEdg_Marks(FilTyp->CastEdg, PrmFTFlag);
   /*select*/{
      if (IsStructure(FilHdr)) {
	 SetFilTyp_Marks(DfltCpsFilTyp, PrmFTFlag);
      }else if (IsCompound(FilHdr)) {
	 SetFilTyp_Marks(DfltCpdFilTyp, PrmFTFlag);
      }else{
	 SetFilTyp_Marks(DfltAtmFilTyp, PrmFTFlag); };}/*select*/;
   SetFilTyp_Marks(DfltAnyFilTyp, PrmFTFlag);
   DrvPth = Get_DrvPth(FilHdr, GenericFilTyp);
   if (DrvPth != ERROR) {
      GenericFilHdr = Do_DrvPth(Copy_FilHdr(FilHdr), DfltPrms, DfltPrms, DrvPth);
      Ret_DrvPth(DrvPth);
      SetFilHdr_Marks(GenericFilHdr, PrmFTFlag);
      Ret_FilHdr(GenericFilHdr); }/*if*/;
   }/*SetFilHdr_Marks*/;


SetFilTyp_Marks(FilTyp, PrmFTFlag)
   tp_FilTyp FilTyp;
   boolean PrmFTFlag;
{
   int i;
   tp_FilTyp TmpFilTyp;

   if (FilTyp->Reach) return;
   FilTyp->Reach = TRUE;
   SetDrvEdg_Marks(FilTyp->DrvEdg, PrmFTFlag);
   SetEqvEdg_Marks(FilTyp->EqvEdg, PrmFTFlag) ;
   if (CanImHo_FilTyp(FilTyp)) SetFilTyp_Marks(FilTyp->ElmFilTyp, PrmFTFlag);
   if (FilTyp == DfltAllFilTyp) {
      for (i=0; i<num_FilTypS; i++) {
	 TmpFilTyp = &FilTypS[i];
	 if (!IsImplicit_FilTyp(TmpFilTyp)) {
	    SetFilTyp_Marks(TmpFilTyp, PrmFTFlag); }/*for*/; }/*if*/; }/*if*/;
   }/*SetFilTyp_Marks*/;


boolean
FilTyp_Mark(FilTyp)
   tp_FilTyp FilTyp;
{
   return FilTyp->Mark;
   }/*FilTyp_Mark*/;


SetFilTyp_Mark(FilTyp)
   tp_FilTyp FilTyp;
{
   FilTyp->Mark = TRUE;
   }/*SetFilTyp_Mark*/;


ClearFilTyp_Mark(FilTyp)
   tp_FilTyp FilTyp;
{
   FilTyp->Mark = FALSE;
   }/*SetFilTyp_Mark*/;


Print_SrcFilTyps()
{
   int i;
   tp_FilTyp FilTyp;

   Writeln(StdOutFD, "   Possible Base Types:");
   for (i=0; i<num_FilTypS; i++) {
      FilTyp = &FilTypS[i];
      if (IsSource_FilTyp(FilTyp) && !IsDflt_Desc(FilTyp->Desc)
       && HelpLevel >= FilTyp->HelpLevel) {
	 Print_FilTyp(FilTyp); }/*if*/; }/*for*/;
   }/*Print_SrcFilTyps*/;


Print_MarkedFilTyps(FilHdr)
   tp_FilHdr FilHdr;
{
   int i;
   tp_FilTyp IFFilTyp, FilTyp;
   boolean Any;

   Write(StdOutFD, "   Possible Derivations from File of Type \"");
   IFFilTyp = FilHdr_FilTyp(FilHdr);
   Write(StdOutFD, IFFilTyp->FTName);
   Writeln(StdOutFD, "\" :");
   Any = FALSE;
   for (i=0; i<num_FilTypS; i++) {
      FilTyp = &FilTypS[i];
      if (FilTyp->Mark && !IsDflt_Desc(FilTyp->Desc)) {
	 if (HelpLevel >= FilTyp->HelpLevel) {
	    Any = TRUE;
	    Print_FilTyp(FilTyp); }/*if*/; }/*if*/;
      FilTyp->Reach = FALSE; 
      FilTyp->Mark = FALSE; }/*for*/;
   if (!Any) Writeln(StdOutFD, "(none)");
   }/*Print_MarkedFilTyps*/;


Print_MarkedPrmFTs()
{
   int i;
   tp_FilTyp FilTyp;
   boolean Any;

   Writeln(StdOutFD, "   Possible Parameters :");
   Any = FALSE;
   for (i=0; i<num_FilTypS; i++) {
      FilTyp = &FilTypS[i];
      if (FilTyp->Mark && !IsDflt_Desc(FilTyp->Desc)) {
	 if (HelpLevel >= FilTyp->HelpLevel) {
	    Any = TRUE;
	    Print_FilTyp(FilTyp); }/*if*/; }/*if*/;
      FilTyp->Reach = FALSE; 
      FilTyp->Mark = FALSE; }/*for*/;
   if (!Any) Writeln(StdOutFD, "(none)");
   }/*Print_MarkedPrmFTs*/;


Print_FilTyp(FilTyp)
   tp_FilTyp FilTyp;
{
   tps_Str Msg;

   (void)strcpy(Msg, FilTyp->FTName);
   (void)strcat(Msg, " ...............");
   (void)strcpy(&Msg[15], " ");
   (void)strcat(Msg, FilTyp->Desc);
   Writeln(StdOutFD, Msg);
   }/*Print_FilTyp*/;


tp_FilTyp
Nod_FilTyp(DrvTyp_Nod)
   tp_Nod DrvTyp_Nod;
{
   tp_Str Str;
   tp_FilTyp FilTyp;

   Str = Sym_Str(Nod_Sym(DrvTyp_Nod));
   FilTyp = FTName_FilTyp(Str);
   if (FilTyp == ERROR) SystemError(SystemErrorFD(), "No file type, <%s>.\n", Str);
   return FilTyp;
   }/*Nod_FilTyp*/;


