/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/FilInp.h"
#include "inc/FKind_.h"
#include "inc/HomSpc.h"
#include "inc/InpInf.h"
#include "inc/InpKind_.h"
#include "inc/Inputs.h"
#include "inc/Parm.h"
#include "inc/Str.h"


int		num_FilInpS = 0;

#define		MAX_HashFilInpS 512
tp_FilInp	HashFilInpS [MAX_HashFilInpS];

tps_FilInp _UsedFilInp;
tp_FilInp		UsedFilInp = &_UsedFilInp;
tps_FilInp _FreeFilInp;
tp_FilInp		FreeFilInp = &_FreeFilInp;
tp_FilInp		ModFilInp = NIL;


Init_FilInps()
{
   UsedFilInp->PrevFree = UsedFilInp;
   UsedFilInp->NextFree = UsedFilInp;

   FreeFilInp->PrevFree = FreeFilInp;
   FreeFilInp->NextFree = FreeFilInp;
   }/*Init_FilInps*/;


int
LocInp_HashVal(LocInp)
   tp_LocInp LocInp;
{
   return (LocInp / sizeof(tps_FilInp)) % MAX_HashFilInpS;
   }/*LocInp_HashVal*/;


Transfer_FilInp(FilInp, FilInpList)
   tp_FilInp FilInp, FilInpList;
{
   FilInp->PrevFree->NextFree = FilInp->NextFree;
   FilInp->NextFree->PrevFree = FilInp->PrevFree;
   FilInp->PrevFree = FilInpList->PrevFree;
   FilInp->NextFree = FilInpList;
   FilInp->PrevFree->NextFree = FilInp;
   FilInp->NextFree->PrevFree = FilInp;
   }/*Transfer_FilInp*/;


/*private*/ tp_FilInp
Copy_FilInp(FilInp)
   tp_FilInp FilInp;
{
   if (FilInp == ERROR) return ERROR;
   if (FilInp->Cnt == 0) {
      Transfer_FilInp(FilInp, UsedFilInp); }/*if*/;
   FilInp->Cnt += 1;
   return FilInp;
   }/*Copy_FilInp*/;


Ret_FilInp(FilInp)
   tp_FilInp FilInp;
{
   if (FilInp == ERROR) return;
   FilInp->Cnt -= 1;
   FORBIDDEN(FilInp->Cnt < 0);
   }/*Ret_FilInp*/;


Free_FilInps()
{
   tp_FilInp FilInp, NextFilInp;

   NextFilInp = UsedFilInp->NextFree;
   while (NextFilInp != UsedFilInp) {
      FilInp = NextFilInp;
      NextFilInp = NextFilInp->NextFree;
      if (FilInp->Cnt == 0) {
	 Transfer_FilInp(FilInp, FreeFilInp); }/*if*/; }/*while*/;
   }/*Free_FilInps*/;


/*private*/ tp_FilInp
New_FilInp(LocInp)
   tp_LocInp LocInp;
{
   tp_FilInp FilInp;
   tp_InpInf InpInf;
   int HashVal;

   FilInp = FreeFilInp->NextFree;
   /*select*/{
      if (FilInp == FreeFilInp) {
	 FilInp = (tp_FilInp)malloc(sizeof(tps_FilInp));
	 num_FilInpS += 1;
	 InpInf = &(FilInp->InpInf);
	 InpInf->LocHdr = 0;
	 InpInf->BackLink = 0;
	 InpInf->Link = 0;
	 InpInf->InpKind = 0;
	 InpInf->OutLocHdr = 0;
	 InpInf->Next = 0;
	 
	 FilInp->LocInp = 0;
	 FilInp->Cnt = 0;
	 FilInp->Modified = FALSE;
	 FilInp->PrevFree = FreeFilInp->PrevFree;
	 FilInp->NextFree = FreeFilInp;
	 FilInp->PrevFree->NextFree = FilInp;
	 FilInp->NextFree->PrevFree = FilInp;
      }else if (FilInp->LocInp != 0) {
	 FORBIDDEN(FilInp->Cnt != 0);
	 if (FilInp->Modified) WriteFilInps();
	 FORBIDDEN(FilInp->Modified);
	 UnHash_FilInp(FilInp); };}/*select*/;
   FilInp->LocInp = LocInp;

   HashVal = LocInp_HashVal(LocInp);
   FilInp->NextHash = HashFilInpS[HashVal];
   HashFilInpS[HashVal] = FilInp;
   return Copy_FilInp(FilInp);
   }/*New_FilInp*/;


/*private*/ tp_FilInp
Lookup_FilInp(LocInp)
   tp_LocInp LocInp;
{
   tp_FilInp FilInp;

   FilInp = HashFilInpS[LocInp_HashVal(LocInp)];
   while (FilInp != 0) {
      if (FilInp->LocInp == LocInp) {
	 return Copy_FilInp(FilInp); }/*if*/;
      FilInp = FilInp->NextHash; }/*while*/;
   return ERROR;
   }/*Lookup_FilInp*/;


tp_FilInp
LocInp_FilInp(LocInp)
   tp_LocInp LocInp;
{
   tp_FilInp FilInp;
   tp_InpInf InpInf;

   FORBIDDEN(LocInp == ERROR);

   FilInp = Lookup_FilInp(LocInp);
   if (FilInp != ERROR) {
      return FilInp; }/*if*/;

   FilInp = New_FilInp(LocInp);
   InpInf = &(FilInp->InpInf);
   ReadInpInf(InpInf, LocInp);
   return FilInp;
   }/*LocInp_FilInp*/;


UnHash_FilInp(FilInp)
   tp_FilInp FilInp;
{
   int HashVal;
   tp_FilInp PrevFilInp;

   HashVal = LocInp_HashVal(FilInp->LocInp);
   FilInp->LocInp = 0;
   PrevFilInp = HashFilInpS[HashVal];
   if (PrevFilInp == FilInp) {
      HashFilInpS[HashVal] = FilInp->NextHash;
      return; }/*if*/;
   FORBIDDEN(PrevFilInp == 0);
   while (PrevFilInp->NextHash != FilInp) {
      PrevFilInp = PrevFilInp->NextHash;
      FORBIDDEN(PrevFilInp == 0); }/*while*/;
   PrevFilInp->NextHash = FilInp->NextHash;
   }/*UnHash_FilInp*/;


SetFilInpModified(FilInp)
   tp_FilInp FilInp;
{
   if (FilInp->Modified) return;
   FilInp->Modified = TRUE;
   FilInp->NextMod = ModFilInp;
   ModFilInp = FilInp;
   }/*SetFilInpModified*/;


WriteFilInps()
{
   while (ModFilInp != NIL) {
      FORBIDDEN(!ModFilInp->Modified);
      ModFilInp->Modified = FALSE;
      WriteFilInp(ModFilInp);
      ModFilInp = ModFilInp->NextMod; }/*while*/;
   }/*WriteFilInps*/;


WriteFilInp(FilInp)
   tp_FilInp FilInp;
{
   WriteInpInf(&(FilInp->InpInf), FilInp->LocInp);
   }/*WriteFilInp*/;


Update_FilInps()
{
   tp_FilInp FilInp;

   FORBIDDEN(ModFilInp != NIL);
   Free_FilInps();
   FilInp = UsedFilInp->NextFree;
   while (FilInp != UsedFilInp) {
      ReadInpInf(&FilInp->InpInf, FilInp->LocInp);
      FilInp = FilInp->NextFree; }/*while*/;
   FilInp = FreeFilInp->NextFree;
   while (FilInp != FreeFilInp) {
      if (FilInp->LocInp != 0) UnHash_FilInp(FilInp);
      FilInp = FilInp->NextFree; }/*while*/;
   }/*Update_FilInps*/;


/*private*/ tp_LocInp
Alloc_InpInf()
{
   return (tp_LocInp) Alloc(sizeof(tps_InpInf));
   }/*Alloc_InpInf*/;


boolean
FilInps_InUse()
{
   tp_FilInp FilInp;

   Free_FilInps();
   FilInp = UsedFilInp->NextFree;
   while (FilInp != UsedFilInp) {
      Write(StdOutFD, "LocInp=");
      WriteInt(StdOutFD, (int)FilInp->LocInp);
      Write(StdOutFD, ", Cnt=");
      WriteInt(StdOutFD, FilInp->Cnt);
      Writeln(StdOutFD, "");
      FilInp = FilInp->NextFree; }/*while*/;
   return (UsedFilInp->NextFree != UsedFilInp);
   }/*FilInps_InUse*/;


tp_LocHdr
FilInp_LocHdr(FilInp)
   tp_FilInp FilInp;
{
   return FilInp->InpInf.LocHdr;
   }/*FilInp_FilHdr*/;


tp_FilHdr
FilInp_FilHdr(FilInp)
   tp_FilInp FilInp;
{
   tp_FilHdr FilHdr;

   FilHdr = LocHdr_FilHdr(FilInp->InpInf.LocHdr);
   return FilHdr;
   }/*FilInp_FilHdr*/;


tp_LocHdr
FilInp_OutLocHdr(FilInp)
   tp_FilInp FilInp;
{
   return FilInp->InpInf.OutLocHdr;
   }/*FilInp_OutLocHdr*/;


tp_InpKind
FilInp_InpKind(FilInp)
   tp_FilInp FilInp;
{
   return FilInp->InpInf.InpKind;
   }/*FilInp_InpKind*/;


tp_LocInp
FilInp_Next(FilInp)
   tp_FilInp FilInp;
{
   return FilInp->InpInf.Next;
   }/*FilInp_Next*/;


tp_LocInp
FilInp_Link(FilInp)
   tp_FilInp FilInp;
{
   return FilInp->InpInf.Link;
   }/*FilInp_Link*/;


Link_LocInp(LocInp, FilHdr)
   tp_LocInp LocInp;
   tp_FilHdr FilHdr;
{
   tp_FilInp FilInp, RiteFilInp, LeftFilInp;
   tp_InpInf InpInf;
   tp_LocInp RiteLocInp, LeftLocInp;

   RiteLocInp = FilHdr_InpLink(FilHdr);
   /*select*/{
      if (RiteLocInp == 0) {
	 Set_InpLink(FilHdr, LocInp);
	 LeftLocInp = LocInp;
	 RiteLocInp = LocInp;
      }else{
	 RiteFilInp = LocInp_FilInp(RiteLocInp);
	 FORBIDDEN(RiteFilInp->InpInf.LocHdr != FilHdr_LocHdr(FilHdr));
	 LeftLocInp = RiteFilInp->InpInf.BackLink;
	 RiteFilInp->InpInf.BackLink = LocInp;
	 SetFilInpModified(RiteFilInp);
	 Ret_FilInp(RiteFilInp);

	 LeftFilInp = LocInp_FilInp(LeftLocInp);
	 LeftFilInp->InpInf.Link = LocInp;
	 SetFilInpModified(LeftFilInp);
	 Ret_FilInp(LeftFilInp); };}/*select*/;

   FilInp = LocInp_FilInp(LocInp);
   InpInf = &(FilInp->InpInf);
   FORBIDDEN(InpInf->LocHdr != ERROR);
   FORBIDDEN(InpInf->BackLink != 0 || InpInf->Link != 0);
   InpInf->LocHdr = FilHdr_LocHdr(FilHdr);
   InpInf->BackLink = LeftLocInp;
   InpInf->Link = RiteLocInp;
   SetFilInpModified(FilInp);
   Ret_FilInp(FilInp);
   }/*Link_LocInp*/;


Unlink_LocInp(LocInp)
   tp_LocInp LocInp;
{
   tp_FilInp FilInp, LeftFilInp, RiteFilInp;
   tp_InpInf InpInf;
   tp_FilHdr FilHdr;
   tp_LocHdr LocHdr;
   tp_LocInp LeftLocInp, RiteLocInp;

   FilInp = LocInp_FilInp(LocInp);
   InpInf = &(FilInp->InpInf);
   LocHdr = InpInf->LocHdr;
   LeftLocInp = InpInf->BackLink;
   RiteLocInp = InpInf->Link;
   InpInf->LocHdr = ERROR;
   InpInf->BackLink = 0;
   InpInf->Link = 0;
   SetFilInpModified(FilInp);
   Ret_FilInp(FilInp);
   FORBIDDEN(LeftLocInp == 0 || RiteLocInp == 0 || LocHdr == ERROR);

   FilHdr = LocHdr_FilHdr(LocHdr);
   /*select*/{
      if (LeftLocInp == LocInp) {
	 FORBIDDEN(RiteLocInp != LocInp);
	 Set_InpLink(FilHdr, (tp_LocInp)0);
      }else{
	 if (FilHdr_InpLink(FilHdr) == LocInp) {
	    Set_InpLink(FilHdr, LeftLocInp); }/*if*/;

	 LeftFilInp = LocInp_FilInp(LeftLocInp);
	 LeftFilInp->InpInf.Link = RiteLocInp;
	 SetFilInpModified(LeftFilInp);
	 Ret_FilInp(LeftFilInp);

	 RiteFilInp = LocInp_FilInp(RiteLocInp);
	 RiteFilInp->InpInf.BackLink = LeftLocInp;
	 SetFilInpModified(RiteFilInp);
	 Ret_FilInp(RiteFilInp); };}/*select*/;

   Ret_FilHdr(FilHdr);
   }/*Unlink_LocInp*/;


tp_LocInp
Make_LocInp(FilHdr, InpKind, OutFilHdr)
   tp_FilHdr FilHdr;
   tp_InpKind InpKind;
   tp_FilHdr OutFilHdr;
{
   tp_FilInp FilInp;
   tp_InpInf InpInf;
   tp_LocInp LocInp;

   FORBIDDEN(FilHdr == ERROR || InpKind == ERROR || OutFilHdr == ERROR);

   LocInp = Alloc_InpInf();
   FilInp = New_FilInp(LocInp);
   InpInf = &(FilInp->InpInf);
   InpInf->LocHdr = ERROR;
   InpInf->BackLink = 0;
   InpInf->Link = 0;
   InpInf->InpKind = InpKind;
   if ((InpKind_IsTrans(InpKind) || InpKind_IsTransName(InpKind))
       && !IsOdinRef(FilHdr)) {
      InpInf->InpKind = IK_Simple; }/*if*/;
   InpInf->OutLocHdr = FilHdr_LocHdr(OutFilHdr);
   InpInf->Next = 0;
   SetFilInpModified(FilInp);
   Ret_FilInp(FilInp);

   Link_LocInp(LocInp, FilHdr);

   return LocInp;
   }/*Make_LocInp*/;


Chain_LocInps(FirstLocInpPtr, LastLocInpPtr, LocInp)
   tp_LocInp *FirstLocInpPtr, *LastLocInpPtr;
   tp_LocInp LocInp;
{
   tp_FilInp PrvFilInp;

   FORBIDDEN(LocInp == 0);
   if (*FirstLocInpPtr == 0) {
      FORBIDDEN(*LastLocInpPtr != 0);
      *FirstLocInpPtr = LocInp;
      *LastLocInpPtr = LocInp;
      return; }/*if*/;
   PrvFilInp = LocInp_FilInp(*LastLocInpPtr);
   PrvFilInp->InpInf.Next = LocInp;
   SetFilInpModified(PrvFilInp);
   Ret_FilInp(PrvFilInp);
   *LastLocInpPtr = LocInp;
   }/*Chain_LocInps*/;


tp_FilHdr
Do_HomSpc(BaseFilHdr, Prms, HomSpc)
   tp_FilHdr BaseFilHdr;
   tp_Prms Prms;
   tp_HomSpc HomSpc;
{
   tp_FilHdr FilHdr;
   tp_Prms PrecPrms, InpPrms;
   tps_Parm _Parm; tp_Parm Parm = &_Parm;
   tp_FilHdr PrmValFilHdr, ElmFilHdr;

   FilHdr = Copy_FilHdr(BaseFilHdr);
   PrecPrms = DfltPrms;
   InpPrms = Prms;
   while (HomSpc != 0) {
      /*select*/{
	 if (HomSpc->PrmFT == ERROR) {
	    FilHdr = (HomSpc->HomoFlag
		      ? FilHdr_HomoFilHdr(FilHdr, InpPrms, HomSpc->FilTyp)
		      : Do_Deriv(FilHdr, InpPrms, PrecPrms, HomSpc->FilTyp));
	    PrecPrms = DfltPrms;
	    InpPrms = Prms;
	 }else if (HomSpc->HomSpc != NIL) {
	    PrmValFilHdr = Do_HomSpc(Copy_FilHdr(BaseFilHdr),
				     Prms, HomSpc->HomSpc);
	    FORBIDDEN(PrmValFilHdr == ERROR);
	    PrecPrms = Union_Parm
	       (PrecPrms, PrmFTFile_Parm
		(Parm, HomSpc->PrmFT, PrmValFilHdr, DfltPrms));
	    InpPrms = Union_Prms(InpPrms, PrecPrms);
	    Ret_FilHdr(PrmValFilHdr);
	 }else if (HomSpc->PrmVal != NIL) {
	    PrecPrms = Union_Parm
	       (PrecPrms, PrmFTVal_Parm
		(Parm, HomSpc->PrmFT, Sym_Str(Str_Sym(HomSpc->PrmVal))));
	    InpPrms = Union_Prms(InpPrms, PrecPrms);
	 }else{
	    PrecPrms = Union_Parm
	       (PrecPrms, PrmFT_Parm(Parm, HomSpc->PrmFT));
	    InpPrms = Union_Prms(InpPrms, PrecPrms); };}/*select*/;
      HomSpc = HomSpc->Next; }/*while*/;
   if (PrecPrms != DfltPrms) {
      ElmFilHdr = Copy_FilHdr(FilHdr);
      FilHdr = Get_Drv(FilHdr, FK_InpPntr, CmdRefFilTyp, DfltPrms, DfltIdent);
      Set_LocElm(FilHdr, Make_LocElm(ElmFilHdr, PrecPrms, FilHdr));
      Ret_FilHdr(ElmFilHdr); }/*if*/;
   Ret_FilHdr(BaseFilHdr);
   return FilHdr;
   }/*Do_HomSpc*/;


tp_LocInp
Get_LocInp(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_LocInp FirstLocInp, LastLocInp, LocInp;
   tp_FilHdr BaseFilHdr, InpFilHdr;
   tp_Prms Prms;
   tp_FilTyp InpTyp;
   tp_InpEdg InpEdg;
   tps_FileName CmdFileName;
   tp_HomSpc HomSpc;

   BaseFilHdr = FilHdr_BaseFilHdr(Copy_FilHdr(FilHdr));
   Prms = FilHdr_Prms(FilHdr);
   
   FirstLocInp = 0; LastLocInp = 0;

   switch (FilHdr_FKind(FilHdr)) {
      case FK_Src: case FK_Link: {
	 FatalError("No inputs for source objects");
	 break;}/*case*/;
      case FK_User: {
	 for (InpEdg = Tool_InpEdg(FilTyp_Tool(FilHdr_FilTyp(FilHdr)));
	      InpEdg != NIL;
	      InpEdg = InpEdg_Next(InpEdg)) {
	    InpTyp = InpEdg_FilTyp(InpEdg);
	    if (InpTyp != NoInputFilTyp) {
	       HomSpc = InpEdg_HomSpc(InpEdg);
	       /*select*/{
		  if (HomSpc != NIL) {
		     InpFilHdr = Do_HomSpc(Copy_FilHdr(BaseFilHdr),
					   Prms, HomSpc);
		  }else{
		     InpFilHdr = Do_Deriv(Copy_FilHdr(BaseFilHdr),
					  Prms, DfltPrms, InpTyp);
		     };}/*select*/;
	       LocInp = Make_LocInp(InpFilHdr, InpEdg_InpKind(InpEdg), FilHdr);
	       Ret_FilHdr(InpFilHdr);
	       Chain_LocInps(&FirstLocInp, &LastLocInp, LocInp);
	       }/*if*/; }/*for*/;
	 if (!IsSystem_Tool(FilHdr_Tool(FilHdr))) {
	    Get_CmdFileName(CmdFileName, FilTyp_FTName(FilHdr_FilTyp(FilHdr)));
	    InpFilHdr = Get_Drv(HostFN_FilHdr(CmdFileName),
				FK_User, CmdRefFilTyp, DfltPrms, DfltIdent);
	    LocInp = Make_LocInp(InpFilHdr, IK_Trans, FilHdr);
	    Ret_FilHdr(InpFilHdr);
	    Chain_LocInps(&FirstLocInp, &LastLocInp, LocInp); }/*if*/;
	 if (IsSentinel_Tool(FilHdr_Tool(FilHdr))) {
	    LocInp = Make_LocInp(SentinelFilHdr, IK_Trans, FilHdr);
	    Chain_LocInps(&FirstLocInp, &LastLocInp, LocInp); }/*if*/;
	 break;}/*case*/;
      case FK_DrvDirElm: case FK_Homo: case FK_ImHo: case FK_DirElms: {
	 LocInp = Make_LocInp(BaseFilHdr, IK_Simple, FilHdr);
	 Chain_LocInps(&FirstLocInp, &LastLocInp, LocInp);
	 break;}/*case*/;
      case FK_PntrHo: {
	 LocInp = Make_LocInp(BaseFilHdr, IK_Pntr, FilHdr);
	 Chain_LocInps(&FirstLocInp, &LastLocInp, LocInp);
	 break;}/*case*/;
      case FK_InpPntr: case FK_Instance: {
	 break;}/*case*/;
      case FK_RplPntr: {
	 FatalError("unexpected File Class");
	 break;}/*case*/;
      default: {
	 FatalError("Bad FKind"); };}/*switch*/;
   Ret_FilHdr(BaseFilHdr);
   Chain_PrmsLocInp(&FirstLocInp, &LastLocInp, Prms, FilHdr);
   return FirstLocInp;
   }/*Get_LocInp*/;
   

