/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/FilHdr.h"
#include "inc/Str.h"


Set_Size(FilHdr, Size)
   tp_FilHdr FilHdr;
   int Size;
{
   FORBIDDEN(FilHdr == ERROR || Size < 0);
   if (Size != FilHdr->HdrInf.Size) {
      CurSize += Size - FilHdr->HdrInf.Size;
      FilHdr->HdrInf.Size = Size;
      MakeNewest(FilHdr);
      SetModified(FilHdr); }/*if*/;
   }/*Set_Size*/;


Set_MaxSize(Size)
   int Size;
{
   MaxSize = Size;
   Compact();
   }/*Set_MaxSize*/;


Set_HogSize(Size)
   int Size;
{
   HogSize = Size;
/* could clean out Hog list */
   }/*Set_HogSize*/;


Compact()
{
   tp_LocHdr LocHdr;
   tp_FilHdr FilHdr;

   if (CurSize <= MaxSize || OtherInfoUsers()) {
      return; }/*if*/;

   LocHdr = HogFilHdr->HdrInf.Newer;
   while (LocHdr != HogLocHdr && CurSize > MaxSize) {
      FilHdr = LocHdr_FilHdr(LocHdr);
      LocHdr = FilHdr->HdrInf.Newer;
      Delete_Data(FilHdr);
      Ret_FilHdr(FilHdr); }/*while*/;
   LocHdr = RootFilHdr->HdrInf.Newer;
   while (CurSize > MaxSize) {
      FilHdr = LocHdr_FilHdr(LocHdr);
      FORBIDDEN(FilHdr == RootFilHdr);
      LocHdr = FilHdr->HdrInf.Newer;
      Delete_Data(FilHdr);
      Ret_FilHdr(FilHdr); }/*while*/;
   }/*Compact*/;


Delete_Data(FilHdr)
   tp_FilHdr FilHdr;
{
   tps_FileName DataFileName;

   if (LogLevel >= 5) Do_Log("Deleting", FilHdr);
   FilHdr_DataFileName(DataFileName, FilHdr);
   FORBIDDEN(!Exists(DataFileName));
   Remove(DataFileName);

   Set_Size(FilHdr, 0);
   FilHdr->HdrInf.Purged = TRUE;
   SetModified(FilHdr);
   Broadcast_TransPurged(FilHdr);
   }/*Delete_Data*/;


Broadcast_TransPurged(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_LocElm FirstCmpdLocElm, CmpdLocElm;
   tp_FilElm CmpdFilElm;
   tp_FilHdr CmpdFilHdr;

   CmpdLocElm = FirstCmpdLocElm = FilHdr_ElmLink(FilHdr);
   while (CmpdLocElm != NIL) {
      CmpdFilElm = LocElm_FilElm(CmpdLocElm);
      CmpdFilHdr = FilElm_CmpdFilHdr(CmpdFilElm);
      if (!CmpdFilHdr->HdrInf.TransPurged) {
	 CmpdFilHdr->HdrInf.TransPurged = TRUE;
	 SetModified(CmpdFilHdr);
	 Broadcast_TransPurged(CmpdFilHdr); }/*if*/;
      Ret_FilHdr(CmpdFilHdr);
      CmpdLocElm = FilElm_Link(CmpdFilElm);
      if (CmpdLocElm == FirstCmpdLocElm) CmpdLocElm = NIL;
      Ret_FilElm(CmpdFilElm); }/*while*/;
   }/*Broadcast_TransPurged*/;


PrintOrder()
{
   tp_FilHdr FilHdr;
   tps_Str OdinName;

   FilHdr = LocHdr_FilHdr(RootFilHdr->HdrInf.Older);
   while (FilHdr != RootFilHdr) {
      FilHdr_OdinName(OdinName, FilHdr);
      Write(StdOutFD, OdinName);
      Write(StdOutFD, "\t - ");
      WriteInt(StdOutFD, FilHdr->HdrInf.Size);
      Writeln(StdOutFD, "");
      Ret_FilHdr(FilHdr);
      FilHdr = LocHdr_FilHdr(FilHdr->HdrInf.Older); }/*while*/;
   Ret_FilHdr(FilHdr);
   }/*PrintOrder*/;


