/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include <stdio.h>
#include "inc/GMC.h"
#include "inc/FilTyp.h"
#include "inc/Tool.h"
#include "inc/CastEdg.h"
#include "inc/DG_Version.h"
#include "inc/DrvEdg.h"
#include "inc/EqvEdg.h"
#include "inc/MemEdg.h"
#include "inc/InpEdg.h"
#include "inc/PrmFTLst.h"
#include "inc/Filename.h"
#include "inc/HomSpc.h"
#include "inc/Str.h"

extern int	DG_VersionCheck;
extern int	num_FilTypS;
extern tps_FilTyp _FilTypS [];
extern int	num_ToolS;
extern tps_Tool _ToolS [];
extern int	num_InpEdgS;
extern tps_InpEdg _InpEdgS [];
extern int	num_MemEdgS;
extern tps_MemEdg _MemEdgS [];
extern int	num_EqvEdgS;
extern tps_EqvEdg _EqvEdgS [];
extern int	num_CastEdgS;
extern tps_CastEdg _CastEdgS [];
extern int	num_DrvEdgS;
extern tps_DrvEdg _DrvEdgS [];
extern int	num_PrmFTLstS;
extern tps_PrmFTLst _PrmFTLstS [];
extern int	num_HomSpcS;
extern tps_HomSpc _HomSpcS [];


tp_Str		Banner;
tp_FilTyp	FilTypS = _FilTypS;
tp_Tool		ToolS = _ToolS;
tp_InpEdg	InpEdgS = _InpEdgS;
tp_MemEdg	MemEdgS = _MemEdgS;
tp_EqvEdg	EqvEdgS = _EqvEdgS;
tp_CastEdg	CastEdgS = _CastEdgS;
tp_DrvEdg	DrvEdgS = _DrvEdgS;
tp_PrmFTLst	PrmFTLstS = _PrmFTLstS;
tp_HomSpc	HomSpcS = _HomSpcS;


tp_FilTyp
IFilTyp_FilTyp(i) int i; {return &FilTypS[i];};

/*private*/ tp_FilTyp
I_FilTyp(i)
   int i;
{
   if (i < 0 || i >= num_FilTypS) return 0;
   return &FilTypS[i];
   }/*I_FilTyp*/;


/*private*/ tp_Tool
I_Tool(i)
   int i;
{
   if (i == -1) return 0;
   return &ToolS[i];
   }/*I_Tool*/;


/*private*/ tp_InpEdg
I_InpEdg(i)
   int i;
{
   if (i == -1) return 0;
   return &InpEdgS[i];
   }/*I_InpEdg*/;


/*private*/ tp_MemEdg
I_MemEdg(i)
   int i;
{
   if (i == -1) return 0;
   return &MemEdgS[i];
   }/*I_MemEdg*/;


/*private*/ tp_EqvEdg
I_EqvEdg(i)
   int i;
{
   if (i == -1) return 0;
   return &EqvEdgS[i];
   }/*I_EqvEdg*/;


/*private*/ tp_CastEdg
I_CastEdg(i)
   int i;
{
   if (i == -1) return 0;
   return &CastEdgS[i];
   }/*I_CastEdg*/;


/*private*/ tp_DrvEdg
I_DrvEdg(i)
   int i;
{
   if (i == -1) return 0;
   return &DrvEdgS[i];
   }/*I_DrvEdg*/;


/*private*/ tp_PrmFTLst
I_PrmFTLst(i)
   int i;
{
   if (i == -1) return 0;
   return &PrmFTLstS[i];
   }/*I_PrmFTLst*/;


/*private*/ tp_HomSpc
I_HomSpc(i)
   int i;
{
   if (i == -1) return 0;
   return &HomSpcS[i];
   }/*I_HomSpc*/;


Read_FilTyps(DrvGrfFILE)
   FILE * DrvGrfFILE;
{
   int i, count;
   int iFilTyp, iTool;
   int iMemEdg, iEqvEdg, iCastEdg, iDrvEdg;
   int iPrmFTLst;
   tp_FilTyp FilTyp;
   tps_Str FTNameStr, DescStr;

   for (i=0; i<num_FilTypS; i++) {
      FilTyp = I_FilTyp(i);
      FilTyp->IFilTyp = i;
      count = fscanf(DrvGrfFILE,
       "%d %s %[^\1]\1 %d %d %d %d %d %d %d %d\n",
       &FilTyp->FTClass, FTNameStr, DescStr, &FilTyp->HelpLevel,
       &iTool, &iMemEdg, &iFilTyp, &iEqvEdg, &iCastEdg, &iDrvEdg,
       &iPrmFTLst);
      FORBIDDEN(count != 11);
      FilTyp->FTName = Malloc_Str(FTNameStr);
      FilTyp->Desc = Malloc_Str(DescStr);
      FilTyp->Tool = I_Tool(iTool);
      FilTyp->MemEdg = I_MemEdg(iMemEdg); 
      FilTyp->ElmFilTyp = I_FilTyp(iFilTyp);
      FilTyp->EqvEdg = I_EqvEdg(iEqvEdg); 
      FilTyp->CastEdg = I_CastEdg(iCastEdg);
      FilTyp->DrvEdg = I_DrvEdg(iDrvEdg);
      FilTyp->ImHoPrmFTLst = I_PrmFTLst(iPrmFTLst);
      FilTyp->Reach = FALSE;
      FilTyp->Mark = FALSE;
      FilTyp->Pos = NIL;
      }/*for*/;

   count = fscanf(DrvGrfFILE, "%d\n", &iFilTyp);
   FORBIDDEN(count != 1);
   GenericFilTyp = I_FilTyp(iFilTyp);

   count = fscanf(DrvGrfFILE, "%d\n", &iFilTyp);
   FORBIDDEN(count != 1);
   NullFilTyp = I_FilTyp(iFilTyp);

   count = fscanf(DrvGrfFILE, "%d\n", &iFilTyp);
   FORBIDDEN(count != 1);
   DfltCpsFilTyp = I_FilTyp(iFilTyp);

   count = fscanf(DrvGrfFILE, "%d\n", &iFilTyp);
   FORBIDDEN(count != 1);
   DfltCpdFilTyp = I_FilTyp(iFilTyp);

   count = fscanf(DrvGrfFILE, "%d\n", &iFilTyp);
   FORBIDDEN(count != 1);
   DfltAtmFilTyp = I_FilTyp(iFilTyp);

   count = fscanf(DrvGrfFILE, "%d\n", &iFilTyp);
   FORBIDDEN(count != 1);
   DfltAnyFilTyp = I_FilTyp(iFilTyp);

   count = fscanf(DrvGrfFILE, "%d\n", &iFilTyp);
   FORBIDDEN(count != 1);
   DfltAllFilTyp = I_FilTyp(iFilTyp);

   count = fscanf(DrvGrfFILE, "%d\n", &iFilTyp);
   FORBIDDEN(count != 1);
   NoInputFilTyp = I_FilTyp(iFilTyp);

   count = fscanf(DrvGrfFILE, "%d\n", &iFilTyp);
   FORBIDDEN(count != 1);
   CmdRefFilTyp = I_FilTyp(iFilTyp);

   count = fscanf(DrvGrfFILE, "%d\n", &iFilTyp);
   FORBIDDEN(count != 1);
   CompoundFilTyp = I_FilTyp(iFilTyp);

   count = fscanf(DrvGrfFILE, "%d\n", &iFilTyp);
   FORBIDDEN(count != 1);
   CheckFilTyp = I_FilTyp(iFilTyp);

   count = fscanf(DrvGrfFILE, "%d\n", &iFilTyp);
   FORBIDDEN(count != 1);
   ErrorFilTyp = I_FilTyp(iFilTyp);

   count = fscanf(DrvGrfFILE, "%d\n", &iFilTyp);
   FORBIDDEN(count != 1);
   ViewFilTyp = I_FilTyp(iFilTyp);

   }/*Read_FilTyps*/;


Read_Tools(DrvGrfFILE)
   FILE *DrvGrfFILE;
{
   int i, count;
   int iTool, iInpEdg, iPrmFTLst;
   tp_Tool Tool;

   for (i=0; i<num_ToolS; i++) {
      Tool = I_Tool(i);
      count = fscanf(DrvGrfFILE, "%d %d %d\n",
       &Tool->TClass, &iInpEdg, &iPrmFTLst);
      FORBIDDEN(count != 3);
      Tool->InpEdg = I_InpEdg(iInpEdg);
      Tool->PrmFTLst = I_PrmFTLst(iPrmFTLst);
      }/*for*/;

   count = fscanf(DrvGrfFILE, "%d\n", &iTool);
   FORBIDDEN(count != 1);
   DrvDirElmTool = I_Tool(iTool);

   count = fscanf(DrvGrfFILE, "%d\n", &iTool);
   FORBIDDEN(count != 1);
   HomoTool = I_Tool(iTool);

   count = fscanf(DrvGrfFILE, "%d\n", &iTool);
   FORBIDDEN(count != 1);
   ImHoTool = I_Tool(iTool);

   count = fscanf(DrvGrfFILE, "%d\n", &iTool);
   FORBIDDEN(count != 1);
   DirElmsTool = I_Tool(iTool);

   count = fscanf(DrvGrfFILE, "%d\n", &iTool);
   FORBIDDEN(count != 1);
   InternalPntrTool = I_Tool(iTool);
   }/*Read_Tools*/;


Read_Edgs(DrvGrfFILE)
   FILE * DrvGrfFILE;
{
   int i, count;
   tp_InpEdg InpEdg;
   tp_MemEdg MemEdg;
   tp_EqvEdg EqvEdg;
   tp_CastEdg CastEdg;
   tp_DrvEdg DrvEdg;
   int iFilTyp, iHomSpc, iNext, iPrmFTLst;

   for (i=0; i<num_InpEdgS; i++) {
      InpEdg = I_InpEdg(i);
      count = fscanf(DrvGrfFILE, "%d %d %d %d\n",
       &iFilTyp, &iHomSpc, &InpEdg->InpKind, &iNext);
      FORBIDDEN(count != 4);
      InpEdg->FilTyp = I_FilTyp(iFilTyp);
      InpEdg->HomSpc = I_HomSpc(iHomSpc);
      InpEdg->Next = I_InpEdg(iNext);
      }/*for*/;

   for (i=0; i<num_MemEdgS; i++) {
      MemEdg = I_MemEdg(i);
      count = fscanf(DrvGrfFILE, "%d %d\n", &iFilTyp, &iNext);
      FORBIDDEN(count != 2);
      MemEdg->FilTyp = I_FilTyp(iFilTyp);
      MemEdg->Next = I_MemEdg(iNext);
      }/*for*/;

   for (i=0; i<num_EqvEdgS; i++) {
      EqvEdg = I_EqvEdg(i);
      count = fscanf(DrvGrfFILE, "%d %d\n", &iFilTyp, &iNext);
      FORBIDDEN(count != 2);
      EqvEdg->FilTyp = I_FilTyp(iFilTyp);
      EqvEdg->Next = I_EqvEdg(iNext);
      }/*for*/;

   for (i=0; i<num_CastEdgS; i++) {
      CastEdg = I_CastEdg(i);
      count = fscanf(DrvGrfFILE, "%d %d\n", &iFilTyp, &iNext);
      FORBIDDEN(count != 2);
      CastEdg->FilTyp = I_FilTyp(iFilTyp);
      CastEdg->Next = I_CastEdg(iNext);
      }/*for*/;

   for (i=0; i<num_DrvEdgS; i++) {
      DrvEdg = I_DrvEdg(i);
      count = fscanf(DrvGrfFILE, "%d %d %d\n", &iFilTyp, &iPrmFTLst, &iNext);
      FORBIDDEN(count != 3);
      DrvEdg->FilTyp = I_FilTyp(iFilTyp);
      DrvEdg->PrmFTLst = I_PrmFTLst(iPrmFTLst);
      DrvEdg->Next = I_DrvEdg(iNext);
      }/*for*/;

   }/*Read_Edgs*/;


Read_PrmFTLsts(DrvGrfFILE)
   FILE * DrvGrfFILE;
{
   int i, count;
   int iPrmFT, iNext, iPrmFTLst;
   tp_PrmFTLst PrmFTLst;

   for (i=0; i<num_PrmFTLstS; i++) {
      PrmFTLst = I_PrmFTLst(i);
      count = fscanf(DrvGrfFILE, "%d %d\n", &iPrmFT, &iNext);
      FORBIDDEN(count != 2);
      PrmFTLst->PrmFT = I_FilTyp(iPrmFT);
      PrmFTLst->Next = I_PrmFTLst(iNext);
      }/*for*/;

   count = fscanf(DrvGrfFILE, "%d\n", &iPrmFTLst);
   FORBIDDEN(count != 1);
   AllPrmFTLst = I_PrmFTLst(iPrmFTLst);
   }/*Read_PrmFTLsts*/;


Read_HomSpcs(DrvGrfFILE)
   FILE * DrvGrfFILE;
{
   int count, i;
   int iFilTyp, iPrmFT, iHomSpc, iNext;
   tp_HomSpc HomSpc;
   tps_Str PrmVal;

   for (i=0; i<num_HomSpcS; i++) {
      HomSpc = &HomSpcS[i];
      count = fscanf(DrvGrfFILE, "%d %d %d %[^\1]\1 %d %d\n",
       &HomSpc->HomoFlag, &iFilTyp, &iPrmFT, PrmVal, &iHomSpc, &iNext);
      FORBIDDEN(count != 6);
      HomSpc->FilTyp = I_FilTyp(iFilTyp);
      HomSpc->PrmFT = I_FilTyp(iPrmFT);
      /*select*/{
	 if (PrmVal[0] == '\2') {
	    HomSpc->PrmVal = NIL;
	 }else{
	    HomSpc->PrmVal = Malloc_Str(PrmVal); };}/*select*/;
      HomSpc->HomSpc = I_HomSpc(iHomSpc);
      HomSpc->Next = I_HomSpc(iNext); }/*for*/;
   }/*Read_HomSpcs*/;


#ifdef __STDC__
#define BUILD(x) x##S = (tp_##x)malloc((unsigned)(num_##x##S * sizeof(tps_##x)))
#else
#define BUILD(x) x/**/S = (tp_/**/x)malloc((unsigned)(num_/**/x/**/S * sizeof(tps_/**/x)))
#endif

Read_DrvGrf()
{
   tps_Str BannerBuf;
   tps_FileName	DGFileName;
   tp_FilDsc DrvGrfFD;
   int count;

   FORBIDDEN(DG_VersionCheck != DG_Version);
   Get_DGFileName(DGFileName);
   if (!Exists(DGFileName)) {
      return; }/*if*/;
   DrvGrfFD = FileName_RFilDsc(DGFileName);
   FORBIDDEN(DrvGrfFD == ERROR);

   count = fscanf((FILE*)DrvGrfFD, "%d\n", &DG_VersionCheck);
   FORBIDDEN(count != 1);
   if (DG_VersionCheck != DG_Version) {
      SystemError(SystemErrorFD(), "Error: incompatible local.dg.tab file.\n");
      exit(1); }/*if*/;
   count = fscanf((FILE*)DrvGrfFD, "%[^\1]\1 %d %d %d %d %d %d %d %d %d\n",
		  BannerBuf, &num_FilTypS, &num_ToolS,
		  &num_InpEdgS, &num_MemEdgS, &num_EqvEdgS, &num_CastEdgS,
		  &num_DrvEdgS, &num_PrmFTLstS, &num_HomSpcS);
   FORBIDDEN(count != 10);
   Banner = Malloc_Str(strcat(BannerBuf, " (local)"));
   BUILD(FilTyp); BUILD(Tool);
   BUILD(InpEdg); BUILD(MemEdg); BUILD(EqvEdg); BUILD(CastEdg); BUILD(DrvEdg);
   BUILD(PrmFTLst); BUILD(HomSpc);

   Read_FilTyps((FILE *)DrvGrfFD);
   Read_Tools((FILE *)DrvGrfFD);
   Read_Edgs((FILE *)DrvGrfFD);
   Read_PrmFTLsts((FILE *)DrvGrfFD);
   Read_HomSpcs((FILE *)DrvGrfFD);

   Close(DrvGrfFD);
   }/*Read_DrvGrf*/;


