/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include <sys/types.h>
#include <sys/dir.h>
#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/Flag_.h"
#include "inc/Str.h"

/* For HP brain damage */
#ifndef NULL
#define NULL (char *)0
#endif

tp_FilDsc
OpenDir(FileName)
   tp_FileName FileName;
{
   static char *cd = ".", *pd = "..";
   tp_FilDsc FilDsc;
   tps_Str Str;
   boolean End;

   FilDsc = (tp_FilDsc)opendir(FileName);
/* skip over "." and ".." - this probably should be done by ReadDir */
   ReadDir(Str, &End, FilDsc);
   FORBIDDEN(strcmp(Str, cd) != 0);
   ReadDir(Str, &End, FilDsc);
   FORBIDDEN(strcmp(Str, pd) != 0);
   return FilDsc;
   }/*OpenDir*/;


CloseDir(FilDsc)
   tp_FilDsc FilDsc;
{
   FORBIDDEN(FilDsc == 0);
   (void)closedir((DIR *)FilDsc);
   }/*CloseDir*/;


ReadDir(Str, EndPtr, FilDsc)
   tp_Str Str;
   boolean *EndPtr;
   tp_FilDsc FilDsc;
{
#ifdef _AIX
   struct dirent *dp;
#else
   struct direct *dp;
#endif

   FORBIDDEN(FilDsc == 0);
   dp = readdir((DIR *)FilDsc);
   if (dp == NULL) {
      *EndPtr = TRUE;
      return; }/*if*/;
   (void)strncpy(Str, dp->d_name, (int)dp->d_namlen);
   Str[dp->d_namlen] = 0;
   *EndPtr = FALSE;
   }/*ReadDir*/;


ClearDir(DirName)
   tp_FileName DirName;
{
   tp_FilDsc FilDsc;
   tps_Str Str;
   boolean End;
   tps_FileName FileName;

   FORBIDDEN(DirName == 0);
   FilDsc = OpenDir(DirName);
   ReadDir(Str, &End, FilDsc);
   while (!End) {
      (void)sprintf(FileName, "%s/%s", DirName, Str);
      Remove(FileName);
      ReadDir(Str, &End, FilDsc); }/*while*/;
   CloseDir(FilDsc);
   }/*ClearDir*/;


ClearDirDirs(DirDirName)
   tp_FileName DirDirName;
{
   tps_FileName DirName;
   tp_FilDsc FilDsc;
   tps_Str Str;
   boolean End;

   FilDsc = OpenDir(DirDirName);
   ReadDir(Str, &End, FilDsc);
   while (!End) {
      (void)sprintf(DirName, "%s/%s", DirDirName, Str);
      ClearDir(DirName);
      RemoveDir(DirName);
      ReadDir(Str, &End, FilDsc); }/*while*/;
   CloseDir(FilDsc);
   }/*ClearDirDirs*/;


LinkCmpdFile_int(DirName, FilHdr)
   tp_FileName DirName;
   tp_FilHdr FilHdr;
{
   tp_LocElm LocElm;
   tp_FilElm FilElm;
   tps_FileName DataFileName, FileName;
   tp_FilHdr ElmFilHdr;
   tps_Str StrBuf;
   boolean Abort;

   if (FilHdr_Flag(FilHdr, FLAG_Link)) {
      return; }/*if*/;
   Set_Flag(FilHdr, FLAG_Link);

   if (!IsOdinRef(FilHdr)) {
      FilHdr_DataFileName(DataFileName, FilHdr);
      (void)sprintf(FileName, "%s/%s", DirName, FilHdr_Label(StrBuf, FilHdr));
      Link(FileName, DataFileName, &Abort);
      if (Abort) {
	 SystemError(SystemErrorFD(), "Could not link input data for tool.\n"); }/*if*/;
      return; }/*if*/;

   LocElm = FilHdr_LocElm(FilHdr);
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      FORBIDDEN(ElmFilHdr == ERROR);
      LinkCmpdFile_int(DirName, ElmFilHdr);
      Ret_FilHdr(ElmFilHdr);
      LocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm); }/*while*/;
   }/*LinkCmpdFile_int*/;


LinkCmpdFile(DirName, FilHdr)
   tp_FileName DirName;
   tp_FilHdr FilHdr;
{
   LinkCmpdFile_int(DirName, FilHdr);
   Clr_ElmFlags(FilHdr, FLAG_Link);
   }/*LinkCmpdFile*/;



