/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Status_.h"
#include "inc/Str.h"
#include "inc/Filename.h"
#include "inc/FilElm.h"
#include "inc/FilInp.h"
#include "inc/HdrInf.h"


tp_FilDsc		DebugFD = NIL;

boolean			DebugTag = FALSE;
boolean			DebugLocElm = FALSE;


Set_Debug(DebugName)
   tp_Str DebugName;
{
   tps_FileName DebugFileName;

   if (DebugFD == NIL) {
      Get_DebugFileName(DebugFileName);
      DebugFD = FileName_AFilDsc(DebugFileName); }/*if*/;
   /*select*/{
      if (strcmp(DebugName, "Tag") == 0) {
	 DebugTag = TRUE;
      }else if (strcmp(DebugName, "LocElm") == 0) {
	 DebugLocElm = TRUE;
      }else{
	 Writeln(StdOutFD, "** Tag or LocElm ?"); };}/*select*/;
   }/*Set_Debug*/;


Debug_Alloc_ElmInf(LocElm, FreeLocElm)
   tp_LocElm LocElm, FreeLocElm;
{
   Unwind(DebugFD);
   WriteInt(DebugFD, (int)LocElm);
   Write(DebugFD, " re-allocated, new Free = ");
   WriteInt(DebugFD, (int)FreeLocElm);
   Writeln(DebugFD, "");
   Flush(DebugFD);
   }/*Debug_Alloc_ElmInf*/;


Debug_Ret_ElmInf(LocElm)
   tp_LocElm LocElm;
{
   Unwind(DebugFD);
   WriteInt(DebugFD, (int)LocElm);
   Write(DebugFD, " de-allocated");
   Writeln(DebugFD, "");
   Flush(DebugFD);
   }/*Debug_Ret_ElmInf*/;


Validate_LocElm(FilHdr, LocElm)
   tp_FilHdr FilHdr;
   tp_LocElm LocElm;
{
   tp_LocHdr LocHdr;
   tp_LocElm TmpLocElm;
   tp_FilElm FilElm;

   LocHdr = FilHdr_LocHdr(FilHdr);
   TmpLocElm = LocElm;
   while (TmpLocElm != 0) {
      FilElm = LocElm_FilElm(TmpLocElm);
      if (FilElm_CmpdLocHdr(FilElm) != LocHdr) {
	 Print_OdinName(LocHdr);
	 Print_OdinName(FilElm_CmpdLocHdr(FilElm));
	 FatalError("*** FilHdr != LocElm->CmpdFilHdr ***"); }/*if*/;
      TmpLocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm); }/*while*/;
   }/*Validate_LocElm*/;


Utility(Root)
   tp_Nod Root;
{
   tp_PrmFHdr PrmFHdr;
   tp_FilHdr FilHdr;
   tp_Prms Prms;
   tp_LocHdr LocHdr;
   tp_Str Cmd, Str;
   tps_Str StrBuf;
   tp_Signal Signal;

   Cmd = Sym_Str(Nod_Sym(Nod_Son(2, Root)));

   if (strlen(Cmd) == 2) {
      Str = Sym_Str(Nod_Sym(Nod_Son(1, Root)));
      LocHdr = atoi(Str);
      if (LocHdr <= 0) {
	 SystemError(SystemErrorFD(), "<%s> seen where a number was expected.\n", Str);
	 return; }/*if*/;
      /*select*/{
	 if (strcmp(Cmd, "EO") == 0) {
	    Print_ElmLink(LocHdr);
	 }else if (strcmp(Cmd, "EL") == 0) {
	    Print_LocElm(LocHdr);
	 }else if (strcmp(Cmd, "IN") == 0) {
	    Print_LocInp(LocHdr);
	 }else if (strcmp(Cmd, "LN") == 0) {
	    FilHdr = LocHdr_FilHdr(LocHdr);
	    FilHdr_VerboseOdinName(StrBuf, FilHdr);
	    Writeln(StdOutFD, StrBuf);
	    Ret_FilHdr(FilHdr);
	 }else if (strcmp(Cmd, "NA") == 0) {
	    FilHdr = LocHdr_FilHdr(LocHdr);
	    FilHdr_OdinName(StrBuf, FilHdr);
	    Writeln(StdOutFD, StrBuf);
	    Ret_FilHdr(FilHdr);
	 }else if (strcmp(Cmd, "OU") == 0) {
	    Print_InpLink(LocHdr);
	 }else if (strcmp(Cmd, "TE") == 0) {
	    FilHdr = LocHdr_FilHdr(LocHdr);
	    if (IsSource(FilHdr)) Test_SrcFilHdr(&Signal, FilHdr, TRUE);
	    Ret_FilHdr(FilHdr);
	 }else if (strcmp(Cmd, "TO") == 0) {
	    FilHdr = LocHdr_FilHdr(LocHdr);
	    Increment_CurrentDate();
	    Set_ModDate(FilHdr);
	    Broadcast(FilHdr);
	    Ret_FilHdr(FilHdr);
	 }else if (strcmp(Cmd, "VA") == 0) {
	    FilHdr = LocHdr_FilHdr(LocHdr);
	    Set_Status(FilHdr, STAT_OK);
	    Ret_FilHdr(FilHdr);
	 }else{
	    SystemError(SystemErrorFD(), "Unknown utility <%s>.\n", Cmd); };}/*select*/;
      return; }/*if*/;

   PrmFHdr = Nod_PrmFHdr(Nod_Son(1, Root));
   Use_PrmFHdr(&FilHdr, &Prms, PrmFHdr);
   if (FilHdr == ERROR) {
      return; }/*if*/;
   LocHdr = FilHdr_LocHdr(FilHdr);
     
   /*select*/{
      if (strcmp(Cmd, "element-of") == 0) {
	 Print_ElmLink(LocHdr);
      }else if (strcmp(Cmd, "elements") == 0) {
	 Print_LocElm(LocHdr);
      }else if (strcmp(Cmd, "inputs") == 0) {
	 Print_LocInp(LocHdr);
      }else if (strcmp(Cmd, "name") == 0) {
	 Print_OdinName(LocHdr);
      }else if (strcmp(Cmd, "outputs") == 0) {
	 Print_InpLink(LocHdr);
      }else if (strcmp(Cmd, "test") == 0) {
         if (IsSource(FilHdr)) Test_SrcFilHdr(&Signal, FilHdr, TRUE);
      }else if (strcmp(Cmd, "touch") == 0) {
	 Increment_CurrentDate();
	 Set_ModDate(FilHdr);
	 Broadcast(FilHdr);
      }else if (strcmp(Cmd, "validate") == 0) {
         Set_Status(FilHdr, STAT_OK);
      }else{
	 SystemError(SystemErrorFD(), "Unknown utility <%s>.\n", Cmd);
	 };}/*select*/;
   ReportStatus(FilHdr);
   Ret_FilHdr(FilHdr);
   }/*Utility*/;


Print_OdinName(LocHdr)
   tp_LocHdr LocHdr;
{
   tp_FilHdr FilHdr;
   tps_Str OdinName;

   FilHdr = LocHdr_FilHdr(LocHdr);
   FilHdr_OdinName(OdinName, FilHdr);
   WriteInt(StdOutFD, (int)LocHdr);
   Write(StdOutFD, "\t- ");
   Writeln(StdOutFD, OdinName);
   Ret_FilHdr(FilHdr);
   }/*Print_OdinName*/;


Print_ElmLink(LocHdr)
   tp_LocHdr LocHdr;
{
   tp_FilHdr FilHdr;
   tp_LocElm LocElmLink, FirstElmLink, NxtLocElmLink;
   tp_FilElm FilElmLink;

   FilHdr = LocHdr_FilHdr(LocHdr);
   LocElmLink = FilHdr_ElmLink(FilHdr);
   FirstElmLink = LocElmLink;
   NxtLocElmLink = 0;
   while (NxtLocElmLink != FirstElmLink) {
      FilElmLink = LocElm_FilElm(LocElmLink);
      Print_OdinName(FilElm_CmpdLocHdr(FilElmLink));
      if (FilElmLink->ElmInf.LocHdr != LocHdr) {
	 Write(StdOutFD, "*** Elm = ");
	 Print_OdinName(FilElmLink->ElmInf.LocHdr); }/*if*/;;
      NxtLocElmLink = FilElm_Link(FilElmLink);
      Ret_FilElm(FilElmLink);
      LocElmLink = NxtLocElmLink; }/*while*/;
   Ret_FilHdr(FilHdr);
   }/*Print_ElmLink*/;


Print_LocElm(LocHdr)
   tp_LocHdr LocHdr;
{
   tp_FilHdr FilHdr;
   tp_LocElm LocElm;
   tp_FilElm FilElm;
   tp_Prms Prms;
   tps_Str PrmsStr;

   FilHdr = LocHdr_FilHdr(LocHdr);
   if (!IsRef(FilHdr)) {
      FORBIDDEN(FilHdr_LocElm(FilHdr) != NIL);
      Writeln(StdOutFD, "Not a compound or pointer file.");
      Ret_FilHdr(FilHdr);
      return; }/*if*/;
   if (!IsUpToDate(FilHdr)) {
      Writeln(StdOutFD, "** Warning : element list is not up-to-date. **");
      }/*if*/;
   LocElm = FilHdr_LocElm(FilHdr);
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      Print_OdinName(FilElm->ElmInf.LocHdr);
      if (FilElm_CmpdLocHdr(FilElm) != LocHdr) {
	 Write(StdOutFD, "*** Cmpd = ");
	 Print_OdinName(FilElm_CmpdLocHdr(FilElm)); }/*if*/;
      Prms = FilElm_Prms(FilElm);
      if (Prms != DfltPrms) {
	 Write(StdOutFD, "\t\t");
	 Prms_Str(PrmsStr, Prms);
	 Writeln(StdOutFD, PrmsStr); }/*if*/;
      LocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm); }/*while*/;
   Ret_FilHdr(FilHdr);
   }/*Print_LocElm*/;


Print_InpLink(LocHdr)
   tp_LocHdr LocHdr;
{
   tp_FilHdr FilHdr;
   tp_LocInp LocInpLink, FirstInpLink, NxtLocInpLink;
   tp_FilInp FilInpLink;

   FilHdr = LocHdr_FilHdr(LocHdr);
   LocInpLink = FilHdr_InpLink(FilHdr);
   FirstInpLink = LocInpLink;
   NxtLocInpLink = 0;
   while (NxtLocInpLink != FirstInpLink) {
      FilInpLink = LocInp_FilInp(LocInpLink);
      Print_OdinName(FilInp_OutLocHdr(FilInpLink));
      if (FilInpLink->InpInf.LocHdr != LocHdr) {
	 Write(StdOutFD, "*** Inp = ");
	 Print_OdinName(FilInpLink->InpInf.LocHdr); }/*if*/;;
      NxtLocInpLink = FilInp_Link(FilInpLink);
      Ret_FilInp(FilInpLink);
      LocInpLink = NxtLocInpLink; }/*while*/;
   Ret_FilHdr(FilHdr);
   }/*Print_InpLink*/;


Print_LocInp(LocHdr)
   tp_LocHdr LocHdr;
{
   tp_FilHdr FilHdr;
   tp_LocInp LocInp;
   tp_FilInp FilInp;

   FilHdr = LocHdr_FilHdr(LocHdr);
   LocInp = FilHdr_LocInp(FilHdr);
   while (LocInp != 0) {
      FilInp = LocInp_FilInp(LocInp);
      Print_OdinName(FilInp->InpInf.LocHdr);
      if (FilInp_OutLocHdr(FilInp) != LocHdr) {
	 Write(StdOutFD, "*** Out = ");
	 Print_OdinName(FilInp_OutLocHdr(FilInp)); }/*if*/;
      LocInp = FilInp_Next(FilInp);
      Ret_FilInp(FilInp); }/*while*/;
   Ret_FilHdr(FilHdr);
   }/*Print_LocInp*/;


