/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/DPType_.h"
#include "inc/FKind_.h"
#include "inc/NodTyp_.h"
#include "inc/Parm.h"
#include "inc/Str.h"


tp_DrvPth
Get_DrvPth(FilHdr, ToFilTyp)
   tp_FilHdr FilHdr;
   tp_FilTyp ToFilTyp;
{
   tp_DrvPth DrvPth, GenericDrvPth;
   boolean IsGeneric;
   tp_FilHdr GenericFilHdr;

   if (FilHdr == ERROR || ToFilTyp == ERROR) return ERROR;

   if (IsHook_FilTyp(FilHdr_FilTyp(FilHdr))) {
      return ERROR; }/*if*/;

   Do_Search(&DrvPth, &IsGeneric,
	     FilHdr_FKind(FilHdr), FilHdr_FilTyp(FilHdr), ToFilTyp);

   if (IsGeneric) {
      GenericFilHdr = Copy_FilHdr(FilHdr);
      GenericDrvPth = DrvPth;
      while (IsGeneric) {
	 GenericFilHdr = Do_DrvPth(GenericFilHdr, DfltPrms, DfltPrms, GenericDrvPth);
	 if (FilHdr_FilTyp(GenericFilHdr) != ToFilTyp) {
	    Do_Search(&GenericDrvPth, &IsGeneric, FilHdr_FKind(GenericFilHdr),
		      FilHdr_FilTyp(GenericFilHdr), ToFilTyp);
	    AppendDrvPth(&DrvPth, GenericDrvPth); }/*if*/; }/*while*/;
      Ret_FilHdr(GenericFilHdr);
      if (GenericDrvPth == NIL) {
	 Ret_DrvPth(DrvPth);
	 DrvPth = NIL; }/*if*/; }/*if*/;
   return DrvPth;
   }/*Get_DrvPth*/;


tp_PrmFTLst
DrvPth_PrmFTLst(DrvPth)
   tp_DrvPth DrvPth;
{
   tp_DrvEdg DrvEdg;

   DrvEdg = DrvPth_DrvEdg(DrvPth);
   if (DrvEdg != NIL) {
      return DrvEdg_PrmFTLst(DrvEdg); }/*if*/;
   if (DrvPth_FKind(DrvPth) == FK_ImHo) {
      return FilTyp_ImHoPrmFTLst(DrvPth_FilTyp(DrvPth)); }/*if*/;
   return (tp_PrmFTLst)NIL;
   }/*DrvPth_PrmFTLst*/;


tp_DrvPth
Find_GroupingDrvPthElm(DrvPth)
   tp_DrvPth DrvPth;
{
   tp_DrvPth DrvPthElm, GroupingDrvPthElm;

   DrvPthElm = DrvPth;
   GroupingDrvPthElm = NIL;
   while (DrvPthElm != NIL) {
      if (DrvPth_DPType(DrvPthElm) == DPT_Drv) {
	 GroupingDrvPthElm = DrvPthElm;
	 if (!IsGrouping_FilTyp(DrvPth_FilTyp(DrvPthElm))) {
	    GroupingDrvPthElm = NIL; }/*if*/; }/*if*/;
      DrvPthElm = DrvPth_Next(DrvPthElm); }/*while*/;
   return GroupingDrvPthElm;
   }/*Find_GroupingDrvPthElm*/;


tp_FilHdr
Do_DrvPth(FilHdr, InhPrms, PrecPrms, DrvPth)
   tp_FilHdr FilHdr;
   tp_Prms InhPrms, PrecPrms;
   tp_DrvPth DrvPth;
{
   tp_DrvPth DrvPthElm, GroupingDrvPthElm;
   tp_FilTyp FilTyp;
   tp_FKind FKind;
   tp_Prms Prms, DrvPrms;
   tp_PrmFTLst PrmFTLst;
   tps_FileName CmdFileName;
   boolean NoInput_Flag=FALSE;

   FORBIDDEN(DrvPth == ERROR);
   if (FilHdr == ERROR || InhPrms == ERROR || PrecPrms == ERROR) {
      Ret_FilHdr(FilHdr);
      return ERROR; }/*if*/;

   Prms = Union_Prms(InhPrms, PrecPrms);
   GroupingDrvPthElm = NIL;
   if (PrecPrms != DfltPrms) {
      GroupingDrvPthElm = Find_GroupingDrvPthElm(DrvPth); }/*if*/;
   DrvPthElm = DrvPth;
   while (DrvPthElm != 0) {
      switch (DrvPth_DPType(DrvPthElm)) {
	 case DPT_Drv: {
	    FilTyp = DrvPth_FilTyp(DrvPthElm);
	    FKind = DrvPth_FKind(DrvPthElm);
	    PrmFTLst = DrvPth_PrmFTLst(DrvPthElm);
	    DrvPrms = Strip_Prms(Prms, PrmFTLst);
	    if (DrvPthElm == GroupingDrvPthElm) {
	       DrvPrms = Union_Prms(DrvPrms, PrecPrms); }/*if*/;
	    if (NoInput_Flag) {
	       FORBIDDEN(FilHdr != ERROR);
	       Get_CmdFileName(CmdFileName, FilTyp_FTName(FilTyp));
	       FilHdr = HostFN_FilHdr(CmdFileName);
	       NoInput_Flag = FALSE; }/*if*/;
	    FilHdr = Get_Drv(FilHdr, FKind, FilTyp, DrvPrms, DfltIdent);
	    break;}/*case*/;
	 case DPT_Eqv: {
	    if (DrvPth_FilTyp(DrvPthElm) == NoInputFilTyp) {
	       Ret_FilHdr(FilHdr);
	       FilHdr = ERROR;
	       NoInput_Flag = TRUE; }/*if*/; break;}/*case*/; }/*switch*/;
      DrvPthElm = DrvPth_Next(DrvPthElm); }/*while*/;
   return FilHdr;
   }/*Do_DrvPth*/;


tp_FilHdr
Do_Deriv(FilHdr, InhPrms, PrecPrms, ToFilTyp)
   tp_FilHdr FilHdr;
   tp_Prms InhPrms, PrecPrms;
   tp_FilTyp ToFilTyp;
{
   tp_DrvPth DrvPth;
   tps_Str PrmsStr;

   if (FilHdr == ERROR || InhPrms == ERROR || ToFilTyp == ERROR) {
      Ret_FilHdr(FilHdr);
      return ERROR; }/*if*/;

   if (FilHdr_FilTyp(FilHdr) == ToFilTyp) {
      if (PrecPrms != DfltPrms) {
	 Prms_Str(PrmsStr, PrecPrms);
	 SystemError(SystemErrorFD(), "Parameter <%s > lost.\n", PrmsStr);
	 Ret_FilHdr(FilHdr);
	 return ERROR; }/*if*/;
      return FilHdr; }/*if*/;

   DrvPth = Get_DrvPth(FilHdr, ToFilTyp);
   if (DrvPth == ERROR) {
      SystemError(SystemErrorFD(), "Cannot derive to <%s>\n", FilTyp_FTName(ToFilTyp));
      Ret_FilHdr(FilHdr);
      return ERROR; }/*if*/;
   FilHdr = Do_DrvPth(FilHdr, InhPrms, PrecPrms, DrvPth);
   Ret_DrvPth(DrvPth);

   return FilHdr;
   }/*Do_Deriv*/;


tp_FilHdr
Do_Key(FilHdr, Key)
   tp_FilHdr FilHdr;
   tp_Key Key;
{
   tp_FKind FKind;
   tp_FilTyp FilTyp;
   tps_Str IdentBuf;

   if (FilHdr == ERROR || Key == ERROR) {
      Ret_FilHdr(FilHdr);
      return ERROR; }/*if*/;

   if (IsDirElms(FilHdr)) FilHdr = FilHdr_Head(FilHdr);

   if (FilHdr == CacheDirFilHdr) {
      if (strlen(Key) == 1) {
	 return FilHdr; }/*if*/;
      Ret_FilHdr(FilHdr);
      return CacheFileName_FilHdr(Key); }/*if*/;

   if (!(IsSource(FilHdr) || IsDrvDir(FilHdr))) {
      FilHdr_Error("Cannot select from <%s>.\n", FilHdr);
      Ret_FilHdr(FilHdr);
      return ERROR; }/*if*/;

   /*select*/{
      if (strcmp(Key, ".") == 0) {
      }else if (strcmp(Key, "..") == 0) {
	 if (FilHdr == RootFilHdr) {
	    SystemError(SystemErrorFD(), "Cannot apply .. to the file system root.\n");
	    Ret_FilHdr(FilHdr);
	    return ERROR; }/*if*/;
	 if (!IsSource(FilHdr)) {
	    FilHdr_Error("Cannot apply .. to <%s> : must be a source directory.\n", FilHdr);
	    Ret_FilHdr(FilHdr);
	    return ERROR; }/*if*/;
	 FilHdr = FilHdr_Head(FilHdr);
      }else{
	 Split_Key(IdentBuf, &FilTyp, Key);
	 FKind = (IsSource(FilHdr) ? FK_Src : FK_DrvDirElm);
	 FilHdr = Get_Drv(FilHdr, FKind, FilTyp, DfltPrms, IdentBuf);
	 };}/*select*/;

   return FilHdr;
   }/*Do_Key*/;


/*private*/ tp_PrmFHdr
Do_DerivNod(PrmFHdr, OprLst_Nod)
   tp_PrmFHdr PrmFHdr;
   tp_Nod OprLst_Nod;
{
   tp_FilHdr FilHdr;
   tp_Prms Prms;
   tps_Parm _Parm; tp_Parm Parm = &_Parm;
   tp_Nod Opr_Nod, Prm_Nod, Elm_Nod;
   int i;
   tp_NodTyp NodTyp;
   tp_FilTyp FilTyp;
   tp_DrvPth DrvPth, DrvPthElm;
   tp_PrmFTLst PrmFTLst;

   if (PrmFHdr == ERROR || OprLst_Nod == ERROR) {
      if (PrmFHdr != ERROR) Ret_PrmFHdr(PrmFHdr);
      return ERROR; }/*if*/;

   Use_PrmFHdr(&FilHdr, &Prms, PrmFHdr);
   PrmFHdr = ERROR;

   for (i=1; i<=Nod_NumSons(OprLst_Nod); i++) {
      Opr_Nod = Nod_Son(i, OprLst_Nod);
      NodTyp = Nod_NodTyp(Opr_Nod);
      switch (NodTyp) {
	 case PRMHLP: {
	    SetFilHdr_PrmFTMarks(FilHdr);
	    Print_MarkedPrmFTs();
	    goto done;
	    break;}/*case*/;
	 case PRDHLP: {
	    FilTyp = Nod_FilTyp(Nod_Son(1, Opr_Nod));
	    if (FilTyp == ERROR) {
	       goto done; }/*if*/;
	    DrvPth = Get_DrvPth(FilHdr, FilTyp);
	    if (DrvPth == ERROR) {
	       SystemError(SystemErrorFD(), "Cannot derive to <%s>\n", FilTyp_FTName(FilTyp));
	       goto done; }/*if*/;
	    DrvPthElm = DrvPth;
	    while (DrvPthElm != 0) {
	       if (DrvPth_DPType(DrvPthElm) == DPT_Drv) {
		  PrmFTLst = DrvPth_PrmFTLst(DrvPthElm);
		  SetPrmFTLst_Marks(PrmFTLst); }/*if*/;
	       DrvPthElm = DrvPth_Next(DrvPthElm); }/*while*/;
	    Ret_DrvPth(DrvPth);
	    Print_MarkedPrmFTs();
	    goto done;
	    break;}/*case*/;
	 case DRVHLP: {
	    SetFilHdr_DrvMarks(FilHdr);
	    Print_MarkedFilTyps(FilHdr);
	    goto done;
	    break;}/*case*/;
	 case PRMOPR: {
	    Prm_Nod = Nod_Son(1, Opr_Nod);
	    Prms = Union_Parm(Prms, PrmNod_Parm(Parm, Prm_Nod));
	    if (Prms == ERROR) {
	       goto done; }/*if*/;
	    break;}/*case*/;
	 case DRVOPR: {
	    FilTyp = Nod_FilTyp(Nod_Son(1, Opr_Nod));
	    FilHdr = Do_Deriv(FilHdr, Prms, Prms, FilTyp);
	    Prms = DfltPrms;
	    if (FilHdr == ERROR) {
	       goto done; }/*if*/;
	    break;}/*case*/;
	 case HODOPR: {
	    if (!IsCompound(FilHdr)) {
	       FilHdr_Error("Cannot apply :: to <%s> - must be compound.\n",
			    FilHdr);
	       goto done; }/*if*/;
	    FilTyp = Nod_FilTyp(Nod_Son(1, Opr_Nod));
	    FilHdr = FilHdr_HomoFilHdr(FilHdr, Prms, FilTyp);
	    Prms = DfltPrms;
	    if (FilHdr == ERROR) {
	       goto done; }/*if*/;
	    break;}/*case*/;
	 case ELMOPR: {
	    Elm_Nod = Nod_Son(1, Opr_Nod);
	    Prms = DfltPrms;
	    FilHdr = Do_Key(FilHdr, Sym_Str(Nod_Sym(Elm_Nod)));
	    if (FilHdr == ERROR) {
	       goto done; }/*if*/;
	    break;}/*case*/;
	 case DIROPR: {
	    Prms = DfltPrms;
	    if (!IsDirElms(FilHdr)) {
	       if (!IsSource(FilHdr)) {
		  FilHdr_Error("Trailing slashes cannot appear after <%s>.\n", FilHdr);
		  goto done; }/*if*/;
	       FilHdr = FilHdr_DirElmsFilHdr(FilHdr);
	       if (FilHdr == ERROR) {
		  goto done; }/*if*/; }/*if*/;
	    break;}/*case*/;
	 default: {
	    fatal_err("bad operator node type"); };}/*switch*/;
      }/*for*/;

   PrmFHdr = New_PrmFHdr(FilHdr, Prms);

done:
   Ret_FilHdr(FilHdr);
   return PrmFHdr;
   }/*Do_DerivNod*/;


tp_PrmFHdr
Nod_PrmFHdr(Nod)
   tp_Nod Nod;
{
   tp_Str Key;
   tp_Nod Root_Nod, OprLst_Nod;
   tp_FilHdr FilHdr;
   tp_PrmFHdr PrmFHdr;

   if (Nod == ERROR) return ERROR;

   Root_Nod = Nod;
   OprLst_Nod = 0;
   if (Nod_NodTyp(Nod) == DRVFIL) {
      Root_Nod = Nod_Son(1, Nod);
      OprLst_Nod = Nod_Son(2, Nod); }/*if*/;
   
   /*select*/{
      if (Nod_NodTyp(Root_Nod) == ABSFIL) {
	 FilHdr = Do_Key(LocHdr_FilHdr(RootLocHdr),
			 Sym_Str(Nod_Sym(Nod_Son(1, Root_Nod))));
      }else{
	 Key = Sym_Str(Nod_Sym(Root_Nod));
	 /*select*/{
	    if (strcmp(Key, "$") == 0) {
	       FilHdr = Copy_FilHdr(OdinDirFilHdr);
	    }else{
	       FilHdr = Do_Key(Top_CWDFilHdr(), Key);
	       };}/*select*/; };}/*select*/;
   if (FilHdr == ERROR) {
      return ERROR; }/*if*/;

   PrmFHdr = New_PrmFHdr(FilHdr, DfltPrms);
   Ret_FilHdr(FilHdr);

   if (OprLst_Nod != 0) PrmFHdr = Do_DerivNod(PrmFHdr, OprLst_Nod);
   return PrmFHdr;
   }/*Nod_PrmFHdr*/;


tp_FilHdr
FilHdr_ViewFilHdr(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_DrvPth DrvPth;

   if (FilHdr == ERROR) return ERROR;

   DrvPth = Get_DrvPth(FilHdr, ViewFilTyp);
   if (DrvPth == ERROR) {
      return FilHdr; }/*if*/;
   FilHdr = Do_DrvPth(FilHdr, DfltPrms, DfltPrms, DrvPth);
   Ret_DrvPth(DrvPth);

   return FilHdr;
   }/*FilHdr_ViewFilHdr*/;


tp_FilHdr
FilHdr_AtmFilHdr(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr == ERROR) return ERROR;

   if (IsAtmc(FilHdr)) {
      return FilHdr; }/*if*/;

   return FilHdr_ViewFilHdr(FilHdr);
   }/*FilHdr_AtmFilHdr*/;


