# $Id$
# Skeleton for Tool Makefile
# Copyright 1992, The Regents of the University of Colorado

# The following make macros should be defined in order to use this skeleton:
# DIR=pathname of this directory relative to the Eli directory
# SRC=distributed files needed during execution of Eli
# AUX=distributed files and directories not needed during execution of Eli
# CMD=command files needed during execution of Eli
# EXE=executable files needed during execution of Eli
# TIDY=files generated during construction not needed during execution of Eli
# CLEAN=files generated during construction needed during execution of Eli

SHELL	= /bin/sh

TIDY	= core a.out *.o *~
CLEAN	= $(TIDY) $(EXE)

all:	$(SRC) $(CMD) $(EXE)
	@-if test '$(CMD)' != ''; then for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
		done; fi

install:
	@-if test '$(SRC) $(CMD)' != ''; then for f in $(SRC) $(CMD); do \
		echo install -m 644 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 644 $(DESTDIR)/$(DIR)/$$f; \
		done; fi
	@for f in $(EXE); do \
		echo install -m 755 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 755 $(DESTDIR)/$(DIR)/$$f; \
		done
	@-if test '$(CMD)' != ''; then for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
		done; fi

executable:
	rm -rf $(TIDY) $(AUX) Makefile

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(TIDY) $(CLEAN)

