#!/bin/sh
# $Id: info.sh,v 1.7 1992/05/03 16:32:20 tony Exp $
# Copyright (c) 1990, The Regents of the University of Colorado

DATA=$ODIN/Tool
PROG=$ODIN/Tool/texinfo

bg=1
dict="-d $DATA/info:$DATA/examples:$DATA"
libd="-l $DATA"

while test $# -gt 0 && test `expr substr $1 1 1` = '-'
do
	case `expr substr $1 1 2`
	in
	-d)	shift; dict="-d $1";;
	-f)	bg=0;;
	-l)	shift; libd="-l $1";;
	-n)	shift; node="-n $1";;
	*)	break;;
	esac
	shift
done

if test "$WINDOW_PARENT" != ''
then
  if test $bg = 1
  then
    $PROG/infotool -Wp 474 58 -Wl "Eli System Documentation Browser" \
         $dict $libd $node $* &
  else
    $PROG/infotool -Wp 474 58 -Wl "Eli System Documentation Browser" \
         $dict $libd $node $*
  fi
elif test "$DISPLAY" != ''
then
  if test -x $PROG/xinfotool
  then
    XPROG="$PROG/xinfotool $dict"
  else
    XPROG="xterm -e $PROG/infoReader"
    # This is needed because the -d option doesn't get through xterm.
    INFO_DIRECTORY_PATHS=`echo $dict | sed -e 's/^-d //'`
    export INFO_DIRECTORY_PATHS
  fi
  if test $bg = 1
  then
    $XPROG $libd $node $* &
  else
    $XPROG $libd $node $*
  fi
else  
    exec $PROG/infoReader $dict $libd $node $*
fi
exit 0
