static char RCSid[] = "$Id: hypermsg.c,v 1.8 1992/05/26 20:27:34 kadhim Exp $";
/* Copyright (c) 1991, The Regents of the University of Colorado */

#include <stdio.h>
#include <string.h>

static FILE *fd;		/* File containing errors */
static char FileName[BUFSIZ];	/* Name of the file */
static int Present;		/* Current line in the file */
static int AtEOF;		/* End-of-input flag */

InitFile(name)
char *name;
{
   if (name == NULL || *name == '\0') {
      (void)fprintf(stderr, "hypermsg: Null error file name\n");
      exit(1);
   }
   if ((fd = fopen(name,"r")) == NULL) {
      (void)fprintf(stderr, "hypermsg: Cannot open file %s\n", name);
      exit(1);
   }
   Present = 0;
   AtEOF = 0;
}

GetLine(line)
int line;
{
   char Text[BUFSIZ];

   while (Present < line) {
      if (AtEOF) {
         (void)puts("Error report beyond end-of-file");
         return;
      }
      Present++;
      if (fgets(Text, BUFSIZ, fd) == NULL) {
         AtEOF = 1;
         (void)strcpy(Text, "(end-of-file)\n");
      }
      if (Present == line) { 
	 char *p;

         (void)printf("%6d |", Present);
	 for (p = Text; *p; p++) {
	    if (*p == '@' || *p == '{' || *p == '}') putchar('@');
	    putchar(*p);
         }
      }
   }
}

MarkColumn(column)
int column;
{
   int s = column+7;

   if (column == 0) return;
   while (s--) (void)putchar(' ');
   (void)puts("^");
}

typedef struct filenode {	/* File node description */
   char *name;			   /* name of the file */
   int node;			   /* node linkage (0 => top) */
   struct filenode *next;	   /* next node description */
} FileNode;

static FileNode *FileList	/* List of file nodes */
	= (FileNode *)NULL;

/**/
void
InitNodes(name)
char *name;
/* Set up the node descriptions for files containing reports
 *    On entry-
 *       name=name of the report file
 **/
{
   char FileName[BUFSIZ], *malloc();
   int NodeNumber = 0;
   FileNode *p, *q;
   FILE *fd;

   if ((fd = fopen(name,"r")) == NULL) {
      (void)fprintf(stderr, "hypermsg: Cannot open file %s\n", name);
      exit(1);
   }

   p = FileList;
   while (fscanf(fd, "%s%*[^\n]", FileName) != EOF) {
      if (p && strcmp(FileName, p->name) == 0) continue;

      q = (FileNode *)malloc(sizeof(FileNode));
      if (p) p->next = q; else FileList = q;

      q->name = malloc((unsigned)(strlen(FileName)+1));
      (void)strcpy(q->name, FileName);
      q->node = ++NodeNumber; q->next = (FileNode *)NULL;

      p = q;
      }

   (void)fclose(fd);

   (void)puts("@menu");
   for (p = FileList; p; p = p->next) {
      (void)printf("* F%d:: ", p->node);
      if (strcmp(p->name, ".")) (void)printf("Messages for %s\n", p->name);
      else (void)printf("General messages\n");
   }
   (void)puts("@end menu");
}

/**/
void
PrintNode(name)
char *name;
/* Output a texinfo node description if necessary
 *    On entry-
 *       name=name of the file corresponding to the new node
 **/
{
   FileNode *p;

   for (p = FileList; p; p = p->next) {
      if (strcmp(name, p->name)) continue;
      (void)printf("@node F%d, ", p->node);
      if (p->next) (void)printf("F%d, ", p->node + 1);
      else (void)printf(", ");
      if (p->node == 1) (void)printf("top, top");
      else (void)printf("F%d, top", p->node - 1);

      if (strcmp(name, "."))
         (void)printf(", Edit\nMessages for %s:\n@menu\n", p->name);
      else if (FileList->next)
         (void)printf(", Edit\nGeneral messages:\n@menu\n");
      else
         (void)printf("\nGeneral messages:\n@menu\n");
   }
}

/**/
EndNode(name)
char *name;
/* Terminate the current node
 *    On entry-
 *       name=name of the file corresponding to the current node
 **/
{
   FileNode *p;

   if (*name) {
      (void)puts("@end menu");
      if (strcmp(name,"."))
         (void)printf("@egfiles .\n%s\n@end egfiles\n", name);
      else if (FileList->next) {
         (void)printf("@egfiles .\n");
         for (p = FileList->next; p; p = p->next)
            (void)printf("%s\n", p->name);
         (void)printf("@end egfiles\n");
      }
   }
}

main(argc, argv)
int argc; char **argv;
{
   char *p, NewFile[BUFSIZ], Message[BUFSIZ];
   int ErrorNumber, line, column;
   FILE *fd;

   if (argc != 2) {
      (void)fprintf(stderr, "Usage: %s ReportFile\n", argv[0]);
      exit(1);
   }

   InitNodes(argv[1]);

   if ((fd = fopen(argv[1],"r")) == NULL) {
      (void)fprintf(stderr, "hypermsg: Cannot open file %s\n", argv[1]);
      exit(1);
   }

   FileName[0] = '\0';

   while (fscanf(fd, "%s%d%d", NewFile, &line, &column) != EOF) {
      if (strcmp(FileName,NewFile)) {

         EndNode(FileName);

         (void)strcpy(FileName,NewFile);
         ErrorNumber = 1;

         PrintNode(FileName);
         if (strcmp(FileName,".")) InitFile(FileName);
      }

      if (strcmp(FileName,".")) {GetLine(line); MarkColumn(column);}
      (void)fgets(Message, BUFSIZ, fd);
      for (p = Message; *p == ' '; p++) ;
      if (*p == ':') (void)printf("* %d", ErrorNumber++);
      else p = Message;
      while (*p) {
         if (*p == '@' || *p == '{' || *p == '}') putchar('@');
         putchar(*p++);
      }

   }

   EndNode(FileName);
}
